/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.annotation;

import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.ClassUtils;

public final class OutputConverter<T> {
    private static final Map<Class<?>, OutputConverter<?>> byResult = new HashMap();
    private static final OutputConverter<Value> VALUE = new OutputConverter(Function.identity());
    private final Function<T, Value> converter;

    private OutputConverter(Function<T, Value> converter) {
        this.converter = converter;
    }

    public static <T> OutputConverter<T> get(Class<T> returnType) {
        if (Value.class.isAssignableFrom(returnType)) {
            return VALUE;
        }
        returnType = ClassUtils.primitiveToWrapper(returnType);
        return Objects.requireNonNull(byResult.get(returnType), "Unregistered output type: " + String.valueOf(returnType) + ". Register in OutputConverter");
    }

    public Value convert(@Nullable T input) {
        return input == null ? Value.NULL : this.converter.apply(input);
    }

    public static <T> void register(Class<T> inputType, Function<T, Value> converter) {
        OutputConverter<T> instance = new OutputConverter<T>(converter);
        if (byResult.containsKey(inputType)) {
            throw new IllegalArgumentException(String.valueOf(inputType) + " already has a registered OutputConverter");
        }
        byResult.put(inputType, instance);
    }

    @Deprecated
    public static <T> void registerToValue(Class<T> inputType, Function<T, Value> converter) {
        OutputConverter.register(inputType, converter);
    }

    static {
        OutputConverter.register(Void.TYPE, v -> Value.NULL);
        OutputConverter.register(Boolean.class, BooleanValue::of);
        OutputConverter.register(Integer.class, NumericValue::new);
        OutputConverter.register(Double.class, NumericValue::of);
        OutputConverter.register(Float.class, NumericValue::of);
        OutputConverter.register(Long.class, NumericValue::new);
        OutputConverter.register(String.class, StringValue::new);
        OutputConverter.register(Entity.class, EntityValue::new);
        OutputConverter.register(Component.class, FormattedTextValue::new);
        OutputConverter.register(Tag.class, NBTSerializableValue::new);
        OutputConverter.register(BlockPos.class, ValueConversions::of);
        OutputConverter.register(Vec3.class, ValueConversions::of);
        OutputConverter.register(ItemStack.class, ValueConversions::of);
        OutputConverter.register(ResourceLocation.class, ValueConversions::of);
        OutputConverter.register(GlobalPos.class, ValueConversions::of);
    }
}

