/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Module;
import carpet.script.argument.FunctionArgument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.InputValidator;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SingleItemRecipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class Inventories {
    public static void apply(Expression expression) {
        expression.addContextFunction("stack_limit", 1, (c, t, lv) -> new NumericValue(NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), ((CarpetContext)c).registryAccess()).m_120979_().m_41459_()));
        expression.addContextFunction("item_category", -1, (c, t, lv) -> {
            c.host.issueDeprecation("item_category in 1.19.3+");
            return Value.NULL;
        });
        expression.addContextFunction("item_list", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry items = cc.registry(Registries.f_256913_);
            if (lv.isEmpty()) {
                return ListValue.wrap(items.m_6566_().stream().map(ValueConversions::of));
            }
            String tag = ((Value)lv.get(0)).getString();
            Optional itemTag = items.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)InputValidator.identifierOf(tag)));
            return itemTag.isEmpty() ? Value.NULL : ListValue.wrap(((HolderSet.Named)itemTag.get()).m_203614_().map(b -> items.m_7981_((Object)((Item)b.m_203334_()))).filter(Objects::nonNull).map(ValueConversions::of));
        });
        expression.addContextFunction("item_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.f_256913_);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.m_203613_().map(ValueConversions::of));
            }
            Item item = NBTSerializableValue.parseItem(((Value)lv.get(0)).getString(), cc.registryAccess()).m_120979_();
            if (lv.size() == 1) {
                return ListValue.wrap(blocks.m_203612_().filter(e -> ((HolderSet.Named)e.getSecond()).m_203614_().anyMatch(h -> h.m_203334_() == item)).map(e -> ValueConversions.of((TagKey)e.getFirst())));
            }
            String tag = ((Value)lv.get(1)).getString();
            Optional tagSet = blocks.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)InputValidator.identifierOf(tag)));
            return tagSet.isEmpty() ? Value.NULL : BooleanValue.of(((HolderSet.Named)tagSet.get()).m_203614_().anyMatch(h -> h.m_203334_() == item));
        });
        expression.addContextFunction("recipe_data", -1, (c, t, lv) -> {
            List<Recipe<?>> recipes;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 1) {
                throw new InternalExpressionException("'recipe_data' requires at least one argument");
            }
            String recipeName = ((Value)lv.get(0)).getString();
            RecipeType type = RecipeType.f_44107_;
            if (lv.size() > 1) {
                String recipeType = ((Value)lv.get(1)).getString();
                type = (RecipeType)cc.registry(Registries.f_256954_).m_7745_(InputValidator.identifierOf(recipeType));
                if (type == null) {
                    throw new InternalExpressionException("Unknown recipe type: " + recipeType);
                }
            }
            if ((recipes = Vanilla.RecipeManager_getAllMatching(cc.server().m_129894_(), type, InputValidator.identifierOf(recipeName), cc.registryAccess())).isEmpty()) {
                return Value.NULL;
            }
            ArrayList<Value> recipesOutput = new ArrayList<Value>();
            RegistryAccess regs = cc.registryAccess();
            for (Recipe<?> recipe : recipes) {
                ListValue recipeSpec;
                ItemStack result = recipe.m_8043_(regs);
                ArrayList<Value> ingredientValue = new ArrayList<Value>();
                recipe.m_7527_().forEach(ingredient -> {
                    List<Collection<ItemStack>> stacks = Vanilla.Ingredient_getRecipeStacks(ingredient);
                    if (stacks.isEmpty()) {
                        ingredientValue.add(Value.NULL);
                    } else {
                        ArrayList<Value> alternatives = new ArrayList<Value>();
                        stacks.forEach(col -> col.stream().map(is -> ValueConversions.of(is, regs)).forEach(alternatives::add));
                        ingredientValue.add(ListValue.wrap(alternatives));
                    }
                });
                if (recipe instanceof ShapedRecipe) {
                    ShapedRecipe shapedRecipe = (ShapedRecipe)recipe;
                    recipeSpec = ListValue.of(new StringValue("shaped"), new NumericValue(shapedRecipe.m_44220_()), new NumericValue(shapedRecipe.m_44221_()));
                } else if (recipe instanceof ShapelessRecipe) {
                    recipeSpec = ListValue.of(new StringValue("shapeless"));
                } else if (recipe instanceof AbstractCookingRecipe) {
                    AbstractCookingRecipe abstractCookingRecipe = (AbstractCookingRecipe)recipe;
                    recipeSpec = ListValue.of(new StringValue("smelting"), new NumericValue(abstractCookingRecipe.m_43753_()), new NumericValue(abstractCookingRecipe.m_43750_()));
                } else {
                    recipeSpec = recipe instanceof SingleItemRecipe ? ListValue.of(new StringValue("cutting")) : (recipe instanceof CustomRecipe ? ListValue.of(new StringValue("special")) : ListValue.of(new StringValue("custom")));
                }
                recipesOutput.add(ListValue.of(ValueConversions.of(result, regs), ListValue.wrap(ingredientValue), recipeSpec));
            }
            return ListValue.wrap(recipesOutput);
        });
        expression.addContextFunction("crafting_remaining_item", 1, (c, t, v) -> {
            String itemStr = ((Value)v.get(0)).getString();
            ResourceLocation id = InputValidator.identifierOf(itemStr);
            Registry registry = ((CarpetContext)c).registry(Registries.f_256913_);
            Item item = (Item)registry.m_6612_(id).orElseThrow(() -> new ThrowStatement(itemStr, Throwables.UNKNOWN_ITEM));
            Item reminder = item.m_41469_();
            return reminder == null ? Value.NULL : NBTSerializableValue.nameFromRegistryId(registry.m_7981_((Object)reminder));
        });
        expression.addContextFunction("inventory_size", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : new NumericValue(inventoryLocator.inventory().m_6643_());
        });
        expression.addContextFunction("inventory_has_items", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            return inventoryLocator == null ? Value.NULL : BooleanValue.of(!inventoryLocator.inventory().m_7983_());
        });
        expression.addContextFunction("inventory_get", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            RegistryAccess regs = cc.registryAccess();
            if (lv.size() == inventoryLocator.offset()) {
                ArrayList<Value> fullInventory = new ArrayList<Value>();
                int maxi = inventoryLocator.inventory().m_6643_();
                for (int i = 0; i < maxi; ++i) {
                    fullInventory.add(ValueConversions.of(inventoryLocator.inventory().m_8020_(i), regs));
                }
                return ListValue.wrap(fullInventory);
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            return (slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().m_6643_() ? Value.NULL : ValueConversions.of(inventoryLocator.inventory().m_8020_(slot), regs);
        });
        expression.addContextFunction("inventory_set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() < inventoryLocator.offset() + 2) {
                throw new InternalExpressionException("'inventory_set' requires at least slot number and new stack size, and optional new item");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().m_6643_()) {
                return Value.NULL;
            }
            int count = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            RegistryAccess regs = cc.registryAccess();
            if (count == 0) {
                ItemStack removedStack = inventoryLocator.inventory().m_8016_(slot);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return ValueConversions.of(removedStack, regs);
            }
            if (lv.size() < inventoryLocator.offset() + 3) {
                ItemStack previousStack = inventoryLocator.inventory().m_8020_(slot);
                ItemStack newStack = previousStack.m_41777_();
                newStack.m_41764_(count);
                inventoryLocator.inventory().m_6836_(slot, newStack);
                Inventories.syncPlayerInventory(inventoryLocator, slot);
                return ValueConversions.of(previousStack, regs);
            }
            CompoundTag nbt = null;
            if (lv.size() > inventoryLocator.offset() + 3) {
                Value nbtValue = (Value)lv.get(inventoryLocator.offset() + 3);
                if (nbtValue instanceof NBTSerializableValue) {
                    NBTSerializableValue nbtsv = (NBTSerializableValue)nbtValue;
                    nbt = nbtsv.getCompoundTag();
                } else if (!nbtValue.isNull()) {
                    nbt = new NBTSerializableValue(nbtValue.getString()).getCompoundTag();
                }
            }
            ItemInput newitem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset() + 2)).getString(), nbt, cc.registryAccess());
            ItemStack previousStack = inventoryLocator.inventory().m_8020_(slot);
            try {
                inventoryLocator.inventory().m_6836_(slot, newitem.m_120980_(count, false));
                Inventories.syncPlayerInventory(inventoryLocator, slot);
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            return ValueConversions.of(previousStack, regs);
        });
        expression.addContextFunction("inventory_find", -1, (c, t, lv) -> {
            Value secondArg;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            ItemInput itemArg = null;
            if (lv.size() > inventoryLocator.offset() && !(secondArg = (Value)lv.get(inventoryLocator.offset())).isNull()) {
                itemArg = NBTSerializableValue.parseItem(secondArg.getString(), cc.registryAccess());
            }
            int startIndex = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                startIndex = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            int maxi = inventoryLocator.inventory().m_6643_();
            for (int i = startIndex = NBTSerializableValue.validateSlot(startIndex, inventoryLocator.inventory()); i < maxi; ++i) {
                ItemStack stack = inventoryLocator.inventory().m_8020_(i);
                if ((itemArg != null || !stack.m_41619_()) && (itemArg == null || !itemArg.m_120979_().equals(stack.m_41720_()))) continue;
                return new NumericValue(i);
            }
            return Value.NULL;
        });
        expression.addContextFunction("inventory_remove", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() <= inventoryLocator.offset()) {
                throw new InternalExpressionException("'inventory_remove' requires at least an item to be removed");
            }
            ItemInput searchItem = NBTSerializableValue.parseItem(((Value)lv.get(inventoryLocator.offset())).getString(), cc.registryAccess());
            int amount = 1;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount == 1 && !inventoryLocator.inventory().m_18949_(Set.of(searchItem.m_120979_())) || inventoryLocator.inventory().m_18947_(searchItem.m_120979_()) < amount) {
                return Value.FALSE;
            }
            int maxi = inventoryLocator.inventory().m_6643_();
            for (int i = 0; i < maxi; ++i) {
                ItemStack stack = inventoryLocator.inventory().m_8020_(i);
                if (stack.m_41619_() || !stack.m_41720_().equals(searchItem.m_120979_())) continue;
                int left = stack.m_41613_() - amount;
                if (left > 0) {
                    stack.m_41764_(left);
                    inventoryLocator.inventory().m_6836_(i, stack);
                    Inventories.syncPlayerInventory(inventoryLocator, i);
                    return Value.TRUE;
                }
                inventoryLocator.inventory().m_8016_(i);
                Inventories.syncPlayerInventory(inventoryLocator, i);
                amount -= stack.m_41613_();
            }
            if (amount > 0) {
                throw new InternalExpressionException("Something bad happened - cannot pull all items from inventory");
            }
            return Value.TRUE;
        });
        expression.addContextFunction("drop_item", -1, (c, t, lv) -> {
            ItemEntity item;
            ItemStack droppedStack;
            CarpetContext cc = (CarpetContext)c;
            NBTSerializableValue.InventoryLocator inventoryLocator = NBTSerializableValue.locateInventory(cc, lv, 0);
            if (inventoryLocator == null) {
                return Value.NULL;
            }
            if (lv.size() == inventoryLocator.offset()) {
                throw new InternalExpressionException("Slot number is required for inventory_drop");
            }
            int slot = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset())).getLong();
            if ((slot = NBTSerializableValue.validateSlot(slot, inventoryLocator.inventory())) == inventoryLocator.inventory().m_6643_()) {
                return Value.NULL;
            }
            int amount = 0;
            if (lv.size() > inventoryLocator.offset() + 1) {
                amount = (int)NumericValue.asNumber((Value)lv.get(inventoryLocator.offset() + 1)).getLong();
            }
            if (amount < 0) {
                throw new InternalExpressionException("Cannot throw negative number of items");
            }
            ItemStack stack = inventoryLocator.inventory().m_8020_(slot);
            if (stack == null || stack.m_41619_()) {
                return Value.ZERO;
            }
            if (amount == 0) {
                amount = stack.m_41613_();
            }
            if ((droppedStack = inventoryLocator.inventory().m_7407_(slot, amount)).m_41619_()) {
                return Value.ZERO;
            }
            Object owner = inventoryLocator.owner();
            if (owner instanceof Player) {
                Player player = (Player)owner;
                item = player.m_7197_(droppedStack, false, true);
                if (item == null) {
                    return Value.ZERO;
                }
            } else if (owner instanceof LivingEntity) {
                LivingEntity livingEntity = (LivingEntity)owner;
                double dropY = livingEntity.m_20186_() - (double)0.3f + (double)livingEntity.m_20192_();
                item = new ItemEntity(livingEntity.m_9236_(), livingEntity.m_20185_(), dropY, livingEntity.m_20189_(), droppedStack);
                Vec3 vec3d = livingEntity.m_20252_(1.0f).m_82541_().m_82490_(0.3);
                item.m_20256_(vec3d);
                item.m_32060_();
                cc.level().m_7967_((Entity)item);
            } else {
                Vec3 point = Vec3.m_82512_((Vec3i)inventoryLocator.position());
                item = new ItemEntity((Level)cc.level(), point.f_82479_, point.f_82480_, point.f_82481_, droppedStack);
                item.m_32060_();
                cc.level().m_7967_((Entity)item);
            }
            return new NumericValue(item.m_32055_().m_41613_());
        });
        expression.addContextFunction("create_screen", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'create_screen' requires at least three arguments");
            }
            Value playerValue = (Value)lv.get(0);
            ServerPlayer player = EntityValue.getPlayerByValue(((CarpetContext)c).server(), playerValue);
            if (player == null) {
                throw new InternalExpressionException("'create_screen' requires a valid online player as the first argument.");
            }
            String type = ((Value)lv.get(1)).getString();
            Component name = FormattedTextValue.getTextByValue((Value)lv.get(2));
            FunctionValue function = null;
            if (lv.size() > 3) {
                function = FunctionArgument.findIn((Context)c, (Module)expression.module, (List<Value>)lv, (int)3, (boolean)true, (boolean)false).function;
            }
            return new ScreenValue(player, type, name, function, (Context)c);
        });
        expression.addContextFunction("close_screen", 1, (c, t, lv) -> {
            Value value = (Value)lv.get(0);
            if (!(value instanceof ScreenValue)) {
                throw new InternalExpressionException("'close_screen' requires a screen value as the first argument.");
            }
            ScreenValue screenValue = (ScreenValue)value;
            if (!screenValue.isOpen()) {
                return Value.FALSE;
            }
            screenValue.close();
            return Value.TRUE;
        });
        expression.addContextFunction("screen_property", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'screen_property' requires at least a screen and a property name");
            }
            Object patt23225$temp = lv.get(0);
            if (!(patt23225$temp instanceof ScreenValue)) {
                throw new InternalExpressionException("'screen_property' requires a screen value as the first argument");
            }
            ScreenValue screenValue = (ScreenValue)patt23225$temp;
            String propertyName = ((Value)lv.get(1)).getString();
            return lv.size() >= 3 ? screenValue.modifyProperty(propertyName, lv.subList(2, lv.size())) : screenValue.queryProperty(propertyName);
        });
    }

    private static void syncPlayerInventory(NBTSerializableValue.InventoryLocator inventory, int slot) {
        Object object = inventory.owner();
        if (object instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)object;
            if (!inventory.isEnder() && !(inventory.inventory() instanceof ScreenValue.ScreenHandlerInventory)) {
                player.f_8906_.m_9829_((Packet)new ClientboundContainerSetSlotPacket(-2, 0, slot, inventory.inventory().m_8020_(slot)));
            }
        }
    }
}

