/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.BiomeInfo;
import carpet.script.utils.Colors;
import carpet.script.utils.FeatureGenerator;
import carpet.script.utils.InputValidator;
import carpet.script.utils.WorldTools;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.tuple.Pair;

public class WorldAccess {
    private static final Map<String, Direction> DIRECTION_MAP = Arrays.stream(Direction.values()).collect(Collectors.toMap(Direction::m_122433_, Function.identity()));
    private static final Map<String, TicketType<?>> ticketTypes;
    private static FallingBlockEntity DUMMY_ENTITY;
    public static final Function<Pair<ServerLevel, String>, DensityFunction> stupidWorldgenNoiseCacheGetter;

    private static Value booleanStateTest(Context c, String name, List<Value> params, BiPredicate<BlockState, BlockPos> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            return BooleanValue.of(test.test(bv.getBlockState(), bv.getPos()));
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return BooleanValue.of(test.test(block.getBlockState(), block.getPos()));
    }

    private static Value stateStringQuery(Context c, String name, List<Value> params, BiFunction<BlockState, BlockPos, String> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            return StringValue.of(test.apply(bv.getBlockState(), bv.getPos()));
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return StringValue.of(test.apply(block.getBlockState(), block.getPos()));
    }

    private static Value genericStateTest(Context c, String name, List<Value> params, Fluff.TriFunction<BlockState, BlockPos, Level, Value> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            try {
                return test.apply(bv.getBlockState(), bv.getPos(), (Level)cc.level());
            }
            catch (NullPointerException ignored) {
                throw new InternalExpressionException("'" + name + "' function requires a block that is positioned in the world");
            }
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return test.apply(block.getBlockState(), block.getPos(), (Level)cc.level());
    }

    private static <T extends Comparable<T>> BlockState setProperty(Property<T> property, String name, String value, BlockState bs) {
        Optional optional = property.m_6215_(value);
        if (optional.isEmpty()) {
            throw new InternalExpressionException(value + " is not a valid value for property " + name);
        }
        return (BlockState)bs.m_61124_(property, (Comparable)optional.get());
    }

    private static void nullCheck(Value v, String name) {
        if (v.isNull()) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private static float numberGetOrThrow(Value v) {
        double num = v.readDoubleNumber();
        if (Double.isNaN(num)) {
            throw new IllegalArgumentException(v.getString() + " needs to be a numeric value");
        }
        return (float)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void theBooYah(ServerLevel level) {
        ServerLevel serverLevel = level;
        synchronized (serverLevel) {
            level.m_7726_().m_255415_().m_254958_();
        }
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("block", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            BlockValue retval = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0, (boolean)true).block;
            retval.getBlockState();
            retval.getData();
            return retval;
        });
        expression.addContextFunction("block_data", -1, (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            return NBTSerializableValue.of((Tag)BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0, (boolean)true).block.getData());
        });
        expression.addContextFunction("poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            BlockPos pos = locator.block.getPos();
            PoiManager store = cc.level().m_8904_();
            Registry poiReg = cc.registry(Registries.f_256805_);
            if (lv.size() == locator.offset) {
                Optional foo = store.m_27177_(pos);
                if (foo.isEmpty()) {
                    return Value.NULL;
                }
                PoiType poiType = (PoiType)((Holder)foo.get()).m_203334_();
                PoiRecord poi = store.m_27181_(type -> type.m_203334_() == poiType, pos, 1, PoiManager.Occupancy.ANY).filter(p -> p.m_27257_().equals((Object)pos)).findFirst().orElse(null);
                return poi == null ? Value.NULL : ListValue.of(ValueConversions.of(poiReg.m_7981_((Object)((PoiType)poi.m_218018_().m_203334_()))), new NumericValue(poiType.f_27326_() - Vanilla.PoiRecord_getFreeTickets(poi)));
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset)).getInt();
            if (radius < 0) {
                return ListValue.of(new Value[0]);
            }
            Predicate<Holder> condition = p -> true;
            PoiManager.Occupancy status = PoiManager.Occupancy.ANY;
            boolean inColumn = false;
            if (locator.offset + 1 < lv.size()) {
                String poiType = ((Value)lv.get(locator.offset + 1)).getString().toLowerCase(Locale.ROOT);
                if (!"any".equals(poiType)) {
                    PoiType type2 = (PoiType)poiReg.m_6612_(InputValidator.identifierOf(poiType)).orElseThrow(() -> new ThrowStatement(poiType, Throwables.UNKNOWN_POI));
                    condition = tt -> tt.m_203334_() == type2;
                }
                if (locator.offset + 2 < lv.size()) {
                    String statusString = ((Value)lv.get(locator.offset + 2)).getString().toLowerCase(Locale.ROOT);
                    if ("occupied".equals(statusString)) {
                        status = PoiManager.Occupancy.IS_OCCUPIED;
                    } else if ("available".equals(statusString)) {
                        status = PoiManager.Occupancy.HAS_SPACE;
                    } else if (!"any".equals(statusString)) {
                        throw new InternalExpressionException("Incorrect POI occupation status " + String.valueOf(status) + " use `any`, `occupied` or `available`");
                    }
                    if (locator.offset + 3 < lv.size()) {
                        inColumn = ((Value)lv.get(locator.offset + 3)).getBoolean();
                    }
                }
            }
            Stream pois = inColumn ? store.m_27166_(condition, pos, radius, status) : store.m_27181_(condition, pos, radius, status);
            return ListValue.wrap(pois.sorted(Comparator.comparingDouble(p -> p.m_27257_().m_123331_((Vec3i)pos))).map(p -> ListValue.of(ValueConversions.of(poiReg.m_7981_((Object)((PoiType)p.m_218018_().m_203334_()))), new NumericValue(((PoiType)p.m_218018_().m_203334_()).f_27326_() - Vanilla.PoiRecord_getFreeTickets(p)), ValueConversions.of(p.m_27257_()))));
        });
        expression.addContextFunction("set_poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'set_poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            BlockPos pos = locator.block.getPos();
            if (lv.size() < locator.offset) {
                throw new InternalExpressionException("'set_poi' requires the new poi type or null, after position argument");
            }
            Value poi = (Value)lv.get(locator.offset);
            PoiManager store = cc.level().m_8904_();
            if (poi.isNull()) {
                if (store.m_27177_(pos).isEmpty()) {
                    return Value.FALSE;
                }
                store.m_27079_(pos);
                return Value.TRUE;
            }
            String poiTypeString = poi.getString().toLowerCase(Locale.ROOT);
            ResourceLocation resource = InputValidator.identifierOf(poiTypeString);
            Registry poiReg = cc.registry(Registries.f_256805_);
            PoiType type = (PoiType)poiReg.m_6612_(resource).orElseThrow(() -> new ThrowStatement(poiTypeString, Throwables.UNKNOWN_POI));
            Holder.Reference holder = poiReg.m_246971_(ResourceKey.m_135785_((ResourceKey)Registries.f_256805_, (ResourceLocation)resource));
            int occupancy = 0;
            if (locator.offset + 1 < lv.size() && (occupancy = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong()) < 0) {
                throw new InternalExpressionException("Occupancy cannot be negative");
            }
            if (store.m_27177_(pos).isPresent()) {
                store.m_27079_(pos);
            }
            store.m_217919_(pos, (Holder)holder);
            if (occupancy > 0) {
                int finalO = occupancy;
                store.m_27166_(tt -> tt.m_203334_() == type, pos, 1, PoiManager.Occupancy.ANY).filter(p -> p.m_27257_().equals((Object)pos)).findFirst().ifPresent(p -> {
                    for (int i = 0; i < finalO; ++i) {
                        Vanilla.PoiRecord_callAcquireTicket(p);
                    }
                });
            }
            return Value.TRUE;
        });
        expression.addContextFunction("weather", -1, (c, t, lv) -> {
            ServerLevel world = ((CarpetContext)c).level();
            if (lv.isEmpty()) {
                return new StringValue(world.m_46470_() ? "thunder" : (world.m_46471_() ? "rain" : "clear"));
            }
            Value weather = (Value)lv.get(0);
            ServerLevelData worldProperties = Vanilla.ServerLevel_getWorldProperties(world);
            if (lv.size() == 1) {
                return new NumericValue(switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear" -> worldProperties.m_6537_();
                    case "rain" -> {
                        if (world.m_46471_()) {
                            yield worldProperties.m_6531_();
                        }
                        yield 0L;
                    }
                    case "thunder" -> {
                        if (world.m_46470_()) {
                            yield worldProperties.m_6558_();
                        }
                        yield 0L;
                    }
                    default -> throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                });
            }
            if (lv.size() == 2) {
                int ticks = NumericValue.asNumber((Value)lv.get(1), "tick_time in 'weather'").getInt();
                switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear": {
                        world.m_8606_(ticks, 0, false, false);
                        break;
                    }
                    case "rain": {
                        world.m_8606_(0, ticks, true, false);
                        break;
                    }
                    case "thunder": {
                        world.m_8606_(0, ticks, true, true);
                        break;
                    }
                    default: {
                        throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                    }
                }
                return NumericValue.of(ticks);
            }
            throw new InternalExpressionException("'weather' requires 0, 1 or 2 arguments");
        });
        expression.addUnaryFunction("pos", v -> {
            if (v instanceof BlockValue) {
                BlockValue bv = (BlockValue)v;
                BlockPos pos = bv.getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Cannot fetch position of an unrealized block");
                }
                return ValueConversions.of(pos);
            }
            if (v instanceof EntityValue) {
                EntityValue ev = (EntityValue)v;
                Entity e = ev.getEntity();
                if (e == null) {
                    throw new InternalExpressionException("Null entity");
                }
                return ValueConversions.of(e.m_20182_());
            }
            throw new InternalExpressionException("'pos' works only with a block or an entity type");
        });
        expression.addContextFunction("pos_offset", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = locator.block.getPos();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'pos_offset' needs at least position, and direction");
            }
            String directionString = ((Value)lv.get(locator.offset)).getString();
            Direction dir = DIRECTION_MAP.get(directionString);
            if (dir == null) {
                throw new InternalExpressionException("Unknown direction: " + directionString);
            }
            int howMuch = 1;
            if (lv.size() > locator.offset + 1) {
                howMuch = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong();
            }
            return ValueConversions.of(pos.m_5484_(dir, howMuch));
        });
        expression.addContextFunction("solid", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "solid", lv, (s, p, w) -> BooleanValue.of(s.m_60796_((BlockGetter)w, p))));
        expression.addContextFunction("air", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "air", lv, (s, p) -> s.m_60795_()));
        expression.addContextFunction("liquid", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "liquid", lv, (s, p) -> !s.m_60819_().m_76178_()));
        expression.addContextFunction("flammable", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "flammable", lv, (s, p) -> s.m_278200_()));
        expression.addContextFunction("transparent", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "transparent", lv, (s, p) -> !s.m_280296_()));
        expression.addContextFunction("emitted_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "emitted_light", lv, (s, p, w) -> new NumericValue(s.m_60791_())));
        expression.addContextFunction("light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "light", lv, (s, p, w) -> new NumericValue(Math.max(w.m_45517_(LightLayer.BLOCK, p), w.m_45517_(LightLayer.SKY, p)))));
        expression.addContextFunction("block_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "block_light", lv, (s, p, w) -> new NumericValue(w.m_45517_(LightLayer.BLOCK, p))));
        expression.addContextFunction("sky_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "sky_light", lv, (s, p, w) -> new NumericValue(w.m_45517_(LightLayer.SKY, p))));
        expression.addContextFunction("effective_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "effective_light", lv, (s, p, w) -> new NumericValue(w.m_46803_(p))));
        expression.addContextFunction("see_sky", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "see_sky", lv, (s, p, w) -> BooleanValue.of(w.m_45527_(p))));
        expression.addContextFunction("brightness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "brightness", lv, (s, p, w) -> new NumericValue(w.m_220417_(p))));
        expression.addContextFunction("hardness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "hardness", lv, (s, p, w) -> new NumericValue(s.m_60800_((BlockGetter)w, p))));
        expression.addContextFunction("blast_resistance", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "blast_resistance", lv, (s, p, w) -> new NumericValue(s.m_60734_().m_7325_())));
        expression.addContextFunction("in_slime_chunk", -1, (c, t, lv) -> {
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            ChunkPos chunkPos = new ChunkPos(pos);
            return BooleanValue.of(WorldgenRandom.m_224681_((int)chunkPos.f_45578_, (int)chunkPos.f_45579_, (long)((CarpetContext)c).level().m_7328_(), (long)987234911L).m_188503_(10) == 0);
        });
        expression.addContextFunction("top", -1, (c, t, lv) -> {
            String type;
            Heightmap.Types htype = switch (type = ((Value)lv.get(0)).getString().toLowerCase(Locale.ROOT)) {
                case "motion" -> Heightmap.Types.MOTION_BLOCKING;
                case "terrain" -> Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
                case "ocean_floor" -> Heightmap.Types.OCEAN_FLOOR;
                case "surface" -> Heightmap.Types.WORLD_SURFACE;
                default -> throw new InternalExpressionException("Unknown heightmap type: " + type);
            };
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 1);
            BlockPos pos = locator.block.getPos();
            int x = pos.m_123341_();
            int z = pos.m_123343_();
            return new NumericValue(((CarpetContext)c).level().m_6325_(x >> 4, z >> 4).m_5885_(htype, x & 0xF, z & 0xF) + 1);
        });
        expression.addContextFunction("loaded", -1, (c, t, lv) -> BooleanValue.of(((CarpetContext)c).level().m_46805_(BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos())));
        expression.addContextFunction("loaded_ep", -1, (c, t, lv) -> {
            c.host.issueDeprecation("loaded_ep(...)");
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            return BooleanValue.of(((CarpetContext)c).level().m_143340_(pos));
        });
        expression.addContextFunction("loaded_status", -1, (c, t, lv) -> {
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            LevelChunk chunk = ((CarpetContext)c).level().m_7726_().m_62227_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, false);
            return chunk == null ? Value.ZERO : new NumericValue(chunk.m_287138_().ordinal());
        });
        expression.addContextFunction("is_chunk_generated", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = locator.block.getPos();
            boolean force = false;
            if (lv.size() > locator.offset) {
                force = ((Value)lv.get(locator.offset)).getBoolean();
            }
            return BooleanValue.of(WorldTools.canHasChunk(((CarpetContext)c).level(), new ChunkPos(pos), null, force));
        });
        expression.addContextFunction("generation_status", -1, (c, t, lv) -> {
            ChunkAccess chunk;
            BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = blockArgument.block.getPos();
            boolean forceLoad = false;
            if (lv.size() > blockArgument.offset) {
                forceLoad = ((Value)lv.get(blockArgument.offset)).getBoolean();
            }
            return (chunk = ((CarpetContext)c).level().m_6522_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62314_, forceLoad)) == null ? Value.NULL : ValueConversions.of(BuiltInRegistries.f_256940_.m_7981_((Object)chunk.m_6415_()));
        });
        expression.addContextFunction("chunk_tickets", -1, (c, t, lv) -> {
            ServerLevel world = ((CarpetContext)c).level();
            DistanceManager foo = world.m_7726_().f_8325_.m_143145_();
            Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> levelTickets = Vanilla.ChunkTicketManager_getTicketsByPosition(foo);
            ArrayList<Value> res = new ArrayList<Value>();
            if (lv.isEmpty()) {
                LongIterator longIterator = levelTickets.keySet().iterator();
                while (longIterator.hasNext()) {
                    long key = (Long)longIterator.next();
                    ChunkPos chpos = new ChunkPos(key);
                    for (Ticket ticket : (SortedArraySet)levelTickets.get(key)) {
                        res.add(ListValue.of(new StringValue(ticket.m_9428_().toString()), new NumericValue(33 - ticket.m_9433_()), new NumericValue(chpos.f_45578_), new NumericValue(chpos.f_45579_)));
                    }
                }
            } else {
                BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
                BlockPos pos = blockArgument.block.getPos();
                SortedArraySet tickets = (SortedArraySet)levelTickets.get(new ChunkPos(pos).m_45588_());
                if (tickets != null) {
                    for (Ticket ticket : tickets) {
                        res.add(ListValue.of(new StringValue(ticket.m_9428_().toString()), new NumericValue(33 - ticket.m_9433_())));
                    }
                }
            }
            res.sort(Comparator.comparing(e -> ((ListValue)e).getItems().get(1)).reversed());
            return ListValue.wrap(res);
        });
        expression.addContextFunction("suffocates", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "suffocates", lv, (s, p, w) -> BooleanValue.of(s.m_60828_((BlockGetter)w, p))));
        expression.addContextFunction("power", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "power", lv, (s, p, w) -> new NumericValue(w.m_277086_(p))));
        expression.addContextFunction("ticks_randomly", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "ticks_randomly", lv, (s, p) -> s.m_60823_()));
        expression.addContextFunction("update", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "update", lv, (s, p) -> {
            ((CarpetContext)c).level().m_46586_(p, s.m_60734_(), p);
            return true;
        }));
        expression.addContextFunction("block_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "block_tick", lv, (s, p) -> {
            ServerLevel w = ((CarpetContext)c).level();
            s.m_222972_(w, p, w.f_46441_);
            return true;
        }));
        expression.addContextFunction("random_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "random_tick", lv, (s, p) -> {
            ServerLevel w = ((CarpetContext)c).level();
            if (s.m_60823_() || s.m_60819_().m_76187_()) {
                s.m_222972_(w, p, w.f_46441_);
            }
            return true;
        }));
        expression.addLazyFunction("without_updates", 1, (c, t, lv) -> {
            if (Carpet.getImpendingFillSkipUpdates().get().booleanValue()) {
                return (LazyValue)lv.get(0);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).server().m_18709_(() -> {
                ThreadLocal<Boolean> skipUpdates = Carpet.getImpendingFillSkipUpdates();
                boolean previous = skipUpdates.get();
                try {
                    skipUpdates.set(true);
                    result[0] = ((LazyValue)lv.get(0)).evalValue((Context)c, (Context.Type)((Object)t));
                }
                finally {
                    skipUpdates.set(previous);
                }
            });
            return (cc, tt) -> result[0];
        });
        expression.addContextFunction("set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            BlockArgument targetLocator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument sourceLocator = BlockArgument.findIn(cc, lv, targetLocator.offset, true);
            BlockState sourceBlockState = sourceLocator.block.getBlockState();
            BlockState targetBlockState = world.m_8055_(targetLocator.block.getPos());
            CompoundTag data = null;
            if (lv.size() > sourceLocator.offset) {
                List<Object> args = new ArrayList<Value>();
                int m = lv.size();
                for (int i = sourceLocator.offset; i < m; ++i) {
                    args.add((Value)lv.get(i));
                }
                Object patt33787$temp = args.get(0);
                if (patt33787$temp instanceof ListValue) {
                    Value patt33926$temp;
                    ListValue list = (ListValue)patt33787$temp;
                    if (args.size() == 2 && (patt33926$temp = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                        nbtsv = (NBTSerializableValue)patt33926$temp;
                        data = nbtsv.getCompoundTag();
                    }
                    args = list.getItems();
                } else {
                    Value patt34922$temp;
                    Object patt34169$temp = args.get(0);
                    if (patt34169$temp instanceof MapValue) {
                        Value patt34306$temp;
                        MapValue map = (MapValue)patt34169$temp;
                        if (args.size() == 2 && (patt34306$temp = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                            nbtsv = (NBTSerializableValue)patt34306$temp;
                            data = nbtsv.getCompoundTag();
                        }
                        Map<Value, Value> state = map.getMap();
                        ArrayList mapargs = new ArrayList();
                        state.forEach((k, v) -> {
                            mapargs.add(k);
                            mapargs.add(v);
                        });
                        args = mapargs;
                    } else if ((args.size() & 1) == 1 && (patt34922$temp = NBTSerializableValue.fromValue((Value)args.get(args.size() - 1))) instanceof NBTSerializableValue) {
                        nbtsv = (NBTSerializableValue)patt34922$temp;
                        data = nbtsv.getCompoundTag();
                    }
                }
                StateDefinition states = sourceBlockState.m_60734_().m_49965_();
                for (int i = 0; i < args.size() - 1; i += 2) {
                    String paramString = ((Value)args.get(i)).getString();
                    Property property = states.m_61081_(paramString);
                    if (property == null) {
                        throw new InternalExpressionException("Property " + paramString + " doesn't apply to " + sourceLocator.block.getString());
                    }
                    String paramValue = ((Value)args.get(i + 1)).getString();
                    sourceBlockState = WorldAccess.setProperty(property, paramString, paramValue, sourceBlockState);
                }
            }
            if (data == null) {
                data = sourceLocator.block.getData();
            }
            CompoundTag finalData = data;
            if (sourceBlockState == targetBlockState && data == null) {
                return Value.FALSE;
            }
            BlockState finalSourceBlockState = sourceBlockState;
            BlockPos targetPos = targetLocator.block.getPos();
            Boolean[] result = new Boolean[]{true};
            cc.server().m_18709_(() -> {
                BlockEntity be;
                Clearable.m_18908_((Object)world.m_7702_(targetPos));
                boolean success = world.m_7731_(targetPos, finalSourceBlockState, 2);
                if (finalData != null && (be = world.m_7702_(targetPos)) != null) {
                    CompoundTag destTag = finalData.m_6426_();
                    destTag.m_128405_("x", targetPos.m_123341_());
                    destTag.m_128405_("y", targetPos.m_123342_());
                    destTag.m_128405_("z", targetPos.m_123343_());
                    be.m_142466_(destTag);
                    be.m_6596_();
                    success = true;
                }
                result[0] = success;
            });
            return result[0] == false ? Value.FALSE : new BlockValue(finalSourceBlockState, world, targetLocator.block.getPos());
        });
        expression.addContextFunction("destroy", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockState state = locator.block.getBlockState();
            if (state.m_60795_()) {
                return Value.FALSE;
            }
            BlockPos where = locator.block.getPos();
            BlockEntity be = world.m_7702_(where);
            long how = 0L;
            Item item = Items.f_42390_;
            boolean playerBreak = false;
            if (lv.size() > locator.offset) {
                Value val = (Value)lv.get(locator.offset);
                if (val instanceof NumericValue) {
                    NumericValue number = (NumericValue)val;
                    how = number.getLong();
                } else {
                    playerBreak = true;
                    String itemString = val.getString();
                    item = (Item)cc.registry(Registries.f_256913_).m_6612_(InputValidator.identifierOf(itemString)).orElseThrow(() -> new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM));
                }
            }
            CompoundTag tag = null;
            if (lv.size() > locator.offset + 1) {
                if (!playerBreak) {
                    throw new InternalExpressionException("tag is not necessary with 'destroy' with no item");
                }
                Value tagValue = (Value)lv.get(locator.offset + 1);
                if (!tagValue.isNull()) {
                    CompoundTag compoundTag;
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        compoundTag = nbtsv.getCompoundTag();
                    } else {
                        compoundTag = NBTSerializableValue.parseStringOrFail(tagValue.getString()).getCompoundTag();
                    }
                    tag = compoundTag;
                }
            }
            ItemStack tool = new ItemStack((ItemLike)item, 1);
            if (tag != null) {
                tool.m_41751_(tag);
            }
            if (playerBreak && (double)state.m_60800_((BlockGetter)world, where) < 0.0) {
                return Value.FALSE;
            }
            boolean removed = world.m_7471_(where, false);
            if (!removed) {
                return Value.FALSE;
            }
            world.m_5898_(null, 2001, where, Block.m_49956_((BlockState)state));
            boolean toolBroke = false;
            boolean dropLoot = true;
            if (playerBreak) {
                boolean isUsingEffectiveTool = !state.m_60834_() || tool.m_41735_(state);
                float hardness = state.m_60800_((BlockGetter)world, where);
                int damageAmount = 0;
                if (item instanceof DiggerItem && (double)hardness > 0.0 || item instanceof ShearsItem) {
                    damageAmount = 1;
                } else if (item instanceof TridentItem || item instanceof SwordItem) {
                    damageAmount = 2;
                }
                boolean bl = toolBroke = damageAmount > 0 && tool.m_220157_(damageAmount, world.m_213780_(), null);
                if (!isUsingEffectiveTool) {
                    dropLoot = false;
                }
            }
            if (dropLoot) {
                if (how < 0L || tag != null && EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44985_, (ItemStack)tool) > 0) {
                    Block.m_49840_((Level)world, (BlockPos)where, (ItemStack)new ItemStack((ItemLike)state.m_60734_()));
                } else {
                    if (how > 0L) {
                        tool.m_41663_(Enchantments.f_44987_, (int)how);
                    }
                    if (DUMMY_ENTITY == null) {
                        DUMMY_ENTITY = new FallingBlockEntity(EntityType.f_20450_, null);
                    }
                    Block.m_49881_((BlockState)state, (Level)world, (BlockPos)where, (BlockEntity)be, (Entity)DUMMY_ENTITY, (ItemStack)tool);
                }
            }
            if (!playerBreak) {
                return Value.TRUE;
            }
            if (toolBroke) {
                return Value.NULL;
            }
            CompoundTag outtag = tool.m_41783_();
            return outtag == null ? Value.TRUE : new NBTSerializableValue(() -> WorldAccess.lambda$apply$74((Tag)outtag));
        });
        expression.addContextFunction("harvest", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'harvest' takes at least 2 parameters: entity and block, or position, to harvest");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            Value entityValue = (Value)lv.get(0);
            if (!(entityValue instanceof EntityValue)) {
                return Value.FALSE;
            }
            EntityValue ev = (EntityValue)entityValue;
            Entity e = ev.getEntity();
            if (!(e instanceof ServerPlayer)) {
                return Value.FALSE;
            }
            ServerPlayer player = (ServerPlayer)e;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 1);
            BlockPos where = locator.block.getPos();
            BlockState state = locator.block.getBlockState();
            Block block = state.m_60734_();
            boolean success = false;
            if (block != Blocks.f_50752_ && block != Blocks.f_50375_ || !player.f_8941_.m_9294_()) {
                success = player.f_8941_.m_9280_(where);
            }
            if (success) {
                world.m_5898_(null, 2001, where, Block.m_49956_((BlockState)state));
            }
            return BooleanValue.of(success);
        });
        expression.addContextFunction("create_explosion", -1, (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'create_explosion' requires at least a position to explode");
            }
            CarpetContext cc = (CarpetContext)c;
            float powah = 4.0f;
            Explosion.BlockInteraction mode = Explosion.BlockInteraction.DESTROY;
            boolean createFire = false;
            Entity source = null;
            LivingEntity attacker = null;
            Vector3Argument location = Vector3Argument.findIn(lv, 0, false, true);
            Vec3 pos = location.vec;
            if (lv.size() > location.offset) {
                powah = NumericValue.asNumber((Value)lv.get(location.offset), "explosion power").getFloat();
                if (powah < 0.0f) {
                    throw new InternalExpressionException("Explosion power cannot be negative");
                }
                if (lv.size() > location.offset + 1) {
                    String strval = ((Value)lv.get(location.offset + 1)).getString();
                    try {
                        mode = Explosion.BlockInteraction.valueOf((String)strval.toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ile) {
                        throw new InternalExpressionException("Illegal explosions block behaviour: " + strval);
                    }
                    if (lv.size() > location.offset + 2) {
                        createFire = ((Value)lv.get(location.offset + 2)).getBoolean();
                        if (lv.size() > location.offset + 3) {
                            EntityValue ev;
                            Value enVal = (Value)lv.get(location.offset + 3);
                            if (!enVal.isNull()) {
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fourth parameter of the explosion has to be an entity, not " + enVal.getTypeString());
                                ev = (EntityValue)enVal;
                                source = ev.getEntity();
                            }
                            if (lv.size() > location.offset + 4 && !(enVal = (Value)lv.get(location.offset + 4)).isNull()) {
                                LivingEntity le;
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fifth parameter of the explosion has to be a living entity, not " + enVal.getTypeString());
                                ev = (EntityValue)enVal;
                                Entity attackingEntity = ev.getEntity();
                                if (!(attackingEntity instanceof LivingEntity)) throw new InternalExpressionException("Attacking entity needs to be a living thing, " + ValueConversions.of(cc.registry(Registries.f_256939_).m_7981_((Object)attackingEntity.m_6095_())).getString() + " ain't it.");
                                attacker = le = (LivingEntity)attackingEntity;
                            }
                        }
                    }
                }
            }
            final LivingEntity theAttacker = attacker;
            float thePowah = powah;
            Explosion explosion = new Explosion((Level)cc.level(), source, null, null, pos.f_82479_, pos.f_82480_, pos.f_82481_, powah, createFire, mode){

                @Nullable
                public LivingEntity m_252906_() {
                    return theAttacker;
                }
            };
            explosion.m_46061_();
            explosion.m_46075_(false);
            if (mode == Explosion.BlockInteraction.KEEP) {
                explosion.m_46080_();
            }
            cc.level().m_6907_().forEach(spe -> {
                if (spe.m_20238_(pos) < 4096.0) {
                    spe.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, thePowah, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(spe)));
                }
            });
            return Value.TRUE;
        });
        expression.addContextFunction("place_item", -1, (c, t, lv) -> {
            BlockValue.PlacementContext ctx;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'place_item' takes at least 2 parameters: item and block, or position, to place onto");
            }
            CarpetContext cc = (CarpetContext)c;
            String itemString = ((Value)lv.get(0)).getString();
            Vector3Argument locator = Vector3Argument.findIn(lv, 1);
            ItemInput stackArg = NBTSerializableValue.parseItem(itemString, cc.registryAccess());
            BlockPos where = BlockPos.m_274446_((Position)locator.vec);
            String facing = lv.size() > locator.offset ? ((Value)lv.get(locator.offset)).getString() : (stackArg.m_120979_() != Items.f_42487_ ? "up" : "north");
            boolean sneakPlace = false;
            if (lv.size() > locator.offset + 1) {
                sneakPlace = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            try {
                ctx = BlockValue.PlacementContext.from((Level)cc.level(), where, facing, sneakPlace, stackArg.m_120980_(1, false));
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException(e.getMessage());
            }
            Item patt49886$temp = stackArg.m_120979_();
            if (!(patt49886$temp instanceof BlockItem)) {
                InteractionResult useResult = ctx.m_43722_().m_41661_((UseOnContext)ctx);
                if (useResult == InteractionResult.CONSUME || useResult == InteractionResult.SUCCESS) {
                    return Value.TRUE;
                }
            } else {
                Level level;
                BlockItem blockItem = (BlockItem)patt49886$temp;
                if (!ctx.m_7059_()) {
                    return Value.FALSE;
                }
                BlockState placementState = blockItem.m_40614_().m_5573_((BlockPlaceContext)ctx);
                if (placementState != null && placementState.m_60710_((LevelReader)(level = ctx.m_43725_()), where)) {
                    level.m_7731_(where, placementState, 2);
                    SoundType blockSoundGroup = placementState.m_60827_();
                    level.m_5594_(null, where, blockSoundGroup.m_56777_(), SoundSource.BLOCKS, (blockSoundGroup.m_56773_() + 1.0f) / 2.0f, blockSoundGroup.m_56774_() * 0.8f);
                    return Value.TRUE;
                }
            }
            return Value.FALSE;
        });
        expression.addContextFunction("blocks_movement", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "blocks_movement", lv, (s, p) -> !s.m_60647_((BlockGetter)((CarpetContext)c).level(), p, PathComputationType.LAND)));
        expression.addContextFunction("block_sound", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "block_sound", lv, (s, p) -> Colors.soundName.get(s.m_60827_())));
        expression.addContextFunction("material", -1, (c, t, lv) -> {
            c.host.issueDeprecation("material(...)");
            return StringValue.of("unknown");
        });
        expression.addContextFunction("map_colour", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "map_colour", lv, (s, p) -> Colors.mapColourName.get(s.m_284242_((BlockGetter)((CarpetContext)c).level(), p))));
        expression.addContextFunction("property", -1, (c, t, lv) -> {
            c.host.issueDeprecation("property(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockState state = locator.block.getBlockState();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'property' requires to specify a property to query");
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            StateDefinition states = state.m_60734_().m_49965_();
            Property property = states.m_61081_(tag);
            return property == null ? Value.NULL : new StringValue(state.m_61143_(property).toString().toLowerCase(Locale.ROOT));
        });
        expression.addContextFunction("block_properties", -1, (c, t, lv) -> {
            c.host.issueDeprecation("block_properties(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockState state = locator.block.getBlockState();
            StateDefinition states = state.m_60734_().m_49965_();
            return ListValue.wrap(states.m_61092_().stream().map(p -> new StringValue(p.m_61708_())));
        });
        expression.addContextFunction("block_state", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0, true);
            BlockState state = locator.block.getBlockState();
            StateDefinition states = state.m_60734_().m_49965_();
            if (locator.offset == lv.size()) {
                HashMap<Value, Value> properties = new HashMap<Value, Value>();
                for (Property p : states.m_61092_()) {
                    properties.put(StringValue.of(p.m_61708_()), ValueConversions.fromProperty(state, p));
                }
                return MapValue.wrap(properties);
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            Property property = states.m_61081_(tag);
            return property == null ? Value.NULL : ValueConversions.fromProperty(state, property);
        });
        expression.addContextFunction("block_list", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.f_256747_);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.m_6566_().stream().map(ValueConversions::of));
            }
            ResourceLocation tag = InputValidator.identifierOf(((Value)lv.get(0)).getString());
            Optional tagset = blocks.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)tag));
            return tagset.isEmpty() ? Value.NULL : ListValue.wrap(((HolderSet.Named)tagset.get()).m_203614_().map(b -> ValueConversions.of(blocks.m_7981_((Object)((Block)b.m_203334_())))));
        });
        expression.addContextFunction("block_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.f_256747_);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.m_203613_().map(ValueConversions::of));
            }
            BlockArgument blockLocator = BlockArgument.findIn(cc, lv, 0, true);
            if (blockLocator.offset == lv.size()) {
                Block target = blockLocator.block.getBlockState().m_60734_();
                return ListValue.wrap(blocks.m_203612_().filter(e -> ((HolderSet.Named)e.getSecond()).m_203614_().anyMatch(h -> h.m_203334_() == target)).map(e -> ValueConversions.of((TagKey)e.getFirst())));
            }
            String tag = ((Value)lv.get(blockLocator.offset)).getString();
            Optional tagSet = blocks.m_203431_(TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)InputValidator.identifierOf(tag)));
            return tagSet.isEmpty() ? Value.NULL : BooleanValue.of(blockLocator.block.getBlockState().m_204341_((HolderSet)tagSet.get()));
        });
        expression.addContextFunction("biome", -1, (c, t, lv) -> {
            Biome biome;
            Object patt56904$temp;
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            if (lv.isEmpty()) {
                return ListValue.wrap(world.m_9598_().m_175515_(Registries.f_256952_).m_6566_().stream().map(ValueConversions::of));
            }
            BiomeSource biomeSource = world.m_7726_().m_8481_().m_62218_();
            if (lv.size() == 1 && (patt56904$temp = lv.get(0)) instanceof MapValue) {
                MapValue map = (MapValue)patt56904$temp;
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    MultiNoiseBiomeSource mnbs = (MultiNoiseBiomeSource)biomeSource;
                    Value temperature = map.get(new StringValue("temperature"));
                    WorldAccess.nullCheck(temperature, "temperature");
                    Value humidity = map.get(new StringValue("humidity"));
                    WorldAccess.nullCheck(humidity, "humidity");
                    Value continentalness = map.get(new StringValue("continentalness"));
                    WorldAccess.nullCheck(continentalness, "continentalness");
                    Value erosion = map.get(new StringValue("erosion"));
                    WorldAccess.nullCheck(erosion, "erosion");
                    Value depth = map.get(new StringValue("depth"));
                    WorldAccess.nullCheck(depth, "depth");
                    Value weirdness = map.get(new StringValue("weirdness"));
                    WorldAccess.nullCheck(weirdness, "weirdness");
                    Climate.TargetPoint point = new Climate.TargetPoint(Climate.m_186779_((float)WorldAccess.numberGetOrThrow(temperature)), Climate.m_186779_((float)WorldAccess.numberGetOrThrow(humidity)), Climate.m_186779_((float)WorldAccess.numberGetOrThrow(continentalness)), Climate.m_186779_((float)WorldAccess.numberGetOrThrow(erosion)), Climate.m_186779_((float)WorldAccess.numberGetOrThrow(depth)), Climate.m_186779_((float)WorldAccess.numberGetOrThrow(weirdness)));
                    Biome biome2 = (Biome)mnbs.m_204269_(point).m_203334_();
                    ResourceLocation biomeId = cc.registry(Registries.f_256952_).m_7981_((Object)biome2);
                    return NBTSerializableValue.nameFromRegistryId(biomeId);
                }
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false, false, true);
            if (locator.replacement != null) {
                biome = (Biome)world.m_9598_().m_175515_(Registries.f_256952_).m_7745_(InputValidator.identifierOf(locator.replacement));
                if (biome == null) {
                    throw new ThrowStatement(locator.replacement, Throwables.UNKNOWN_BIOME);
                }
            } else {
                biome = (Biome)world.m_204166_(locator.block.getPos()).m_203334_();
            }
            if (locator.offset == lv.size()) {
                ResourceLocation biomeId = cc.registry(Registries.f_256952_).m_7981_((Object)biome);
                return NBTSerializableValue.nameFromRegistryId(biomeId);
            }
            String biomeFeature = ((Value)lv.get(locator.offset)).getString();
            BiFunction<ServerLevel, Biome, Value> featureProvider = BiomeInfo.biomeFeatures.get(biomeFeature);
            if (featureProvider == null) {
                throw new InternalExpressionException("Unknown biome feature: " + biomeFeature);
            }
            return featureProvider.apply(world, biome);
        });
        expression.addContextFunction("set_biome", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_biome' needs a biome name as an argument");
            }
            String biomeName = ((Value)lv.get(locator.offset)).getString();
            Holder biome = (Holder)cc.registry(Registries.f_256952_).m_203636_(ResourceKey.m_135785_((ResourceKey)Registries.f_256952_, (ResourceLocation)InputValidator.identifierOf(biomeName))).orElseThrow(() -> new ThrowStatement(biomeName, Throwables.UNKNOWN_BIOME));
            boolean doImmediateUpdate = true;
            if (lv.size() > locator.offset + 1) {
                doImmediateUpdate = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            ChunkAccess chunk = world.m_46865_(pos);
            int biomeX = QuartPos.m_175400_((int)pos.m_123341_());
            int biomeY = QuartPos.m_175400_((int)pos.m_123342_());
            int biomeZ = QuartPos.m_175400_((int)pos.m_123343_());
            try {
                int i = QuartPos.m_175400_((int)chunk.m_141937_());
                int j = i + QuartPos.m_175400_((int)chunk.m_141928_()) - 1;
                int k = Mth.m_14045_((int)biomeY, (int)i, (int)j);
                int l = chunk.m_151564_(QuartPos.m_175402_((int)k));
                ((PalettedContainer)chunk.m_183278_(l).m_187996_()).m_156470_(biomeX & 3, k & 3, biomeZ & 3, (Object)biome);
            }
            catch (Throwable var8) {
                return Value.FALSE;
            }
            if (doImmediateUpdate) {
                WorldTools.forceChunkUpdate(pos, world);
            }
            chunk.m_8092_(true);
            return Value.TRUE;
        });
        expression.addContextFunction("reload_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockPos pos = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0).block.getPos();
            ServerLevel world = cc.level();
            cc.server().m_18709_(() -> WorldTools.forceChunkUpdate(pos, world));
            return Value.TRUE;
        });
        expression.addContextFunction("structure_references", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            Map references = world.m_46819_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62316_).m_62769_();
            Registry reg = cc.registry(Registries.f_256944_);
            if (lv.size() == locator.offset) {
                return ListValue.wrap(references.entrySet().stream().filter(e -> e.getValue() != null && !((LongSet)e.getValue()).isEmpty()).map(e -> NBTSerializableValue.nameFromRegistryId(reg.m_7981_((Object)((Structure)e.getKey())))));
            }
            String simpleStructureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            Structure structureName = (Structure)reg.m_7745_(InputValidator.identifierOf(simpleStructureName));
            if (structureName == null) {
                return Value.NULL;
            }
            LongSet structureReferences = (LongSet)references.get(structureName);
            if (structureReferences == null || structureReferences.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            return ListValue.wrap(structureReferences.longStream().mapToObj(l -> ListValue.of(new NumericValue(16L * (long)ChunkPos.m_45592_((long)l)), Value.ZERO, new NumericValue(16L * (long)ChunkPos.m_45602_((long)l)))));
        });
        expression.addContextFunction("structure_eligibility", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            WorldAccess.theBooYah(world);
            BlockPos pos = locator.block.getPos();
            ArrayList<Structure> structure = new ArrayList<Structure>();
            boolean needSize = false;
            boolean singleOutput = false;
            Registry reg = cc.registry(Registries.f_256944_);
            if (lv.size() > locator.offset) {
                Value requested = (Value)lv.get(locator.offset);
                if (!requested.isNull()) {
                    String reqString = requested.getString();
                    ResourceLocation id = InputValidator.identifierOf(reqString);
                    Structure requestedStructure = (Structure)reg.m_7745_(id);
                    if (requestedStructure != null) {
                        singleOutput = true;
                        structure.add(requestedStructure);
                    } else {
                        StructureType sss = (StructureType)cc.registry(Registries.f_256938_).m_7745_(id);
                        reg.m_6579_().stream().filter(e -> ((Structure)e.getValue()).m_213658_() == sss).forEach(e -> structure.add((Structure)e.getValue()));
                    }
                    if (structure.isEmpty()) {
                        throw new ThrowStatement(reqString, Throwables.UNKNOWN_STRUCTURE);
                    }
                } else {
                    structure.addAll(reg.m_6579_().stream().map(Map.Entry::getValue).toList());
                }
                if (lv.size() > locator.offset + 1) {
                    needSize = ((Value)lv.get(locator.offset + 1)).getBoolean();
                }
            } else {
                structure.addAll(reg.m_6579_().stream().map(Map.Entry::getValue).toList());
            }
            if (singleOutput) {
                StructureStart start = FeatureGenerator.shouldStructureStartAt(world, pos, (Structure)structure.get(0), needSize);
                return start == null ? Value.NULL : (!needSize ? Value.TRUE : ValueConversions.of(start, cc.registryAccess()));
            }
            HashMap<Value, Value> ret = new HashMap<Value, Value>();
            for (Structure str : structure) {
                StructureStart start;
                try {
                    start = FeatureGenerator.shouldStructureStartAt(world, pos, str, needSize);
                }
                catch (NullPointerException npe) {
                    CarpetScriptServer.LOG.error("Failed to detect structure: " + String.valueOf(reg.m_7981_((Object)str)));
                    start = null;
                }
                if (start == null) continue;
                Value key = NBTSerializableValue.nameFromRegistryId(reg.m_7981_((Object)str));
                ret.put(key, !needSize ? Value.NULL : ValueConversions.of(start, cc.registryAccess()));
            }
            return MapValue.wrap(ret);
        });
        expression.addContextFunction("structures", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            Map structures = world.m_46819_(pos.m_123341_() >> 4, pos.m_123343_() >> 4, ChunkStatus.f_62315_).m_6633_();
            Registry reg = cc.registry(Registries.f_256944_);
            if (lv.size() == locator.offset) {
                HashMap<Value, Value> structureList = new HashMap<Value, Value>();
                for (Map.Entry entry : structures.entrySet()) {
                    StructureStart start = (StructureStart)entry.getValue();
                    if (start == StructureStart.f_73561_) continue;
                    BoundingBox box = start.m_73601_();
                    structureList.put(NBTSerializableValue.nameFromRegistryId(reg.m_7981_((Object)((Structure)entry.getKey()))), ValueConversions.of(box));
                }
                return MapValue.wrap(structureList);
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            return ValueConversions.of((StructureStart)structures.get(reg.m_7745_(InputValidator.identifierOf(structureName))), cc.registryAccess());
        });
        expression.addContextFunction("set_structure", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_structure requires at least position and a structure name");
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            Structure configuredStructure = FeatureGenerator.resolveConfiguredStructure(structureName, world, pos);
            if (configuredStructure == null) {
                throw new ThrowStatement(structureName, Throwables.UNKNOWN_STRUCTURE);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).server().m_18709_(() -> {
                Map structures = world.m_46865_(pos).m_6633_();
                if (lv.size() == locator.offset + 1) {
                    boolean res = FeatureGenerator.plopGrid(configuredStructure, ((CarpetContext)c).level(), locator.block.getPos());
                    result[0] = res ? Value.TRUE : Value.FALSE;
                    return;
                }
                Value newValue = (Value)lv.get(locator.offset + 1);
                if (newValue.isNull()) {
                    if (!structures.containsKey(configuredStructure)) {
                        return;
                    }
                    StructureStart start = (StructureStart)structures.get(configuredStructure);
                    ChunkPos structureChunkPos = start.m_163625_();
                    BoundingBox box = start.m_73601_();
                    for (int chx = box.m_162395_() / 16; chx <= box.m_162399_() / 16; ++chx) {
                        for (int chz = box.m_162398_() / 16; chz <= box.m_162401_() / 16; ++chz) {
                            ChunkPos chpos = new ChunkPos(chx, chz);
                            Map references = world.m_46865_(chpos.m_45615_()).m_62769_();
                            if (!references.containsKey(configuredStructure) || references.get(configuredStructure) == null) continue;
                            ((LongSet)references.get(configuredStructure)).remove(structureChunkPos.m_45588_());
                        }
                    }
                    structures.remove(configuredStructure);
                    result[0] = Value.TRUE;
                }
            });
            return result[0];
        });
        expression.addContextFunction("reset_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ArrayList<ChunkPos> requestedChunks = new ArrayList<ChunkPos>();
            if (lv.size() == 1) {
                Value first = (Value)lv.get(0);
                if (first instanceof ListValue) {
                    ListValue list = (ListValue)first;
                    List<Value> listVal = list.getItems();
                    BlockArgument locator = BlockArgument.findIn(cc, listVal, 0);
                    requestedChunks.add(new ChunkPos(locator.block.getPos()));
                    while (listVal.size() > locator.offset) {
                        locator = BlockArgument.findIn(cc, listVal, locator.offset);
                        requestedChunks.add(new ChunkPos(locator.block.getPos()));
                    }
                } else {
                    BlockArgument locator = BlockArgument.findIn(cc, Collections.singletonList(first), 0);
                    requestedChunks.add(new ChunkPos(locator.block.getPos()));
                }
            } else {
                BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
                ChunkPos from = new ChunkPos(locator.block.getPos());
                if (lv.size() > locator.offset) {
                    locator = BlockArgument.findIn(cc, lv, locator.offset);
                    ChunkPos to = new ChunkPos(locator.block.getPos());
                    int xmax = Math.max(from.f_45578_, to.f_45578_);
                    int zmax = Math.max(from.f_45579_, to.f_45579_);
                    for (int x = Math.min(from.f_45578_, to.f_45578_); x <= xmax; ++x) {
                        for (int z = Math.min(from.f_45579_, to.f_45579_); z <= zmax; ++z) {
                            requestedChunks.add(new ChunkPos(x, z));
                        }
                    }
                } else {
                    requestedChunks.add(from);
                }
            }
            ServerLevel world = cc.level();
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).server().m_18709_(() -> {
                Map<String, Integer> report = Vanilla.ChunkMap_regenerateChunkRegion(world.m_7726_().f_8325_, requestedChunks);
                result[0] = MapValue.wrap(report.entrySet().stream().collect(Collectors.toMap(e -> new StringValue((String)e.getKey()), e -> new NumericValue(((Integer)e.getValue()).intValue()))));
            });
            return result[0];
        });
        expression.addContextFunction("inhabited_time", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            return new NumericValue(cc.level().m_46865_(pos).m_6319_());
        });
        expression.addContextFunction("spawn_potential", -1, (c, t, lv) -> {
            NaturalSpawner.SpawnState charger;
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            double requiredCharge = 1.0;
            if (lv.size() > locator.offset) {
                requiredCharge = NumericValue.asNumber((Value)lv.get(locator.offset)).getDouble();
            }
            return (charger = cc.level().m_7726_().m_8485_()) == null ? Value.NULL : new NumericValue(Vanilla.SpawnState_getPotentialCalculator(charger).m_47195_(pos, requiredCharge));
        });
        expression.addContextFunction("add_chunk_ticket", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            if (lv.size() != locator.offset + 2) {
                throw new InternalExpressionException("'add_chunk_ticket' requires block position, ticket type and radius");
            }
            String type = ((Value)lv.get(locator.offset)).getString();
            TicketType<?> ticket = ticketTypes.get(type.toLowerCase(Locale.ROOT));
            if (ticket == null) {
                throw new InternalExpressionException("Unknown ticket type: " + type);
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getInt();
            if (radius < 1 || radius > 32) {
                throw new InternalExpressionException("Ticket radius should be between 1 and 32 chunks");
            }
            ChunkPos target = new ChunkPos(pos);
            if (ticket == TicketType.f_9447_) {
                cc.level().m_7726_().m_8387_(TicketType.f_9447_, target, radius, (Object)pos);
            } else if (ticket == TicketType.f_9448_) {
                cc.level().m_7726_().m_8387_(TicketType.f_9448_, target, radius, (Object)1);
            } else {
                cc.level().m_7726_().m_8387_(TicketType.f_9449_, target, radius, (Object)target);
            }
            return new NumericValue(ticket.m_9469_());
        });
        expression.addContextFunction("sample_noise", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                return ListValue.wrap(cc.registry(Registries.f_257040_).m_6566_().stream().map(ValueConversions::of));
            }
            ServerLevel level = cc.level();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            String[] densityFunctionQueries = (String[])lv.stream().skip(locator.offset).map(Value::getString).toArray(String[]::new);
            if (densityFunctionQueries.length == 0) {
                return ListValue.wrap(cc.registry(Registries.f_257040_).m_6566_().stream().map(ValueConversions::of));
            }
            NoiseRouter router = level.m_7726_().m_214994_().m_224578_();
            return densityFunctionQueries.length == 1 ? NumericValue.of(WorldAccess.sampleNoise(router, level, densityFunctionQueries[0], pos)) : ListValue.wrap(Arrays.stream(densityFunctionQueries).map(s -> NumericValue.of(WorldAccess.sampleNoise(router, level, s, pos))));
        });
    }

    public static double sampleNoise(NoiseRouter router, ServerLevel level, String what, BlockPos pos) {
        DensityFunction densityFunction = switch (what) {
            case "barrier_noise" -> router.f_209378_();
            case "fluid_level_floodedness_noise" -> router.f_209379_();
            case "fluid_level_spread_noise" -> router.f_209380_();
            case "lava_noise" -> router.f_209381_();
            case "temperature" -> router.f_209384_();
            case "vegetation" -> router.f_224392_();
            case "continents" -> router.f_209386_();
            case "erosion" -> router.f_209387_();
            case "depth" -> router.f_209388_();
            case "ridges" -> router.f_209389_();
            case "initial_density_without_jaggedness" -> router.f_209390_();
            case "final_density" -> router.f_209391_();
            case "vein_toggle" -> router.f_209392_();
            case "vein_ridged" -> router.f_209393_();
            case "vein_gap" -> router.f_209394_();
            default -> stupidWorldgenNoiseCacheGetter.apply((Pair<ServerLevel, String>)Pair.of((Object)level, (Object)what));
        };
        return densityFunction.m_207386_((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.m_123341_(), pos.m_123342_(), pos.m_123343_()));
    }

    private static /* synthetic */ Tag lambda$apply$74(Tag outtag) {
        return outtag;
    }

    static {
        DIRECTION_MAP.put("y", Direction.UP);
        DIRECTION_MAP.put("z", Direction.SOUTH);
        DIRECTION_MAP.put("x", Direction.EAST);
        ticketTypes = Map.of("portal", TicketType.f_9447_, "teleport", TicketType.f_9448_, "unknown", TicketType.f_9449_);
        DUMMY_ENTITY = null;
        stupidWorldgenNoiseCacheGetter = Util.m_143827_(pair -> {
            ServerLevel level = (ServerLevel)pair.getKey();
            String densityFunctionQuery = (String)pair.getValue();
            ChunkGenerator generator = level.m_7726_().m_8481_();
            if (generator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)generator;
                Registry densityFunctionRegistry = level.m_9598_().m_175515_(Registries.f_257040_);
                NoiseRouter router = ((NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_()).f_209353_();
                DensityFunction densityFunction = switch (densityFunctionQuery) {
                    case "barrier_noise" -> router.f_209378_();
                    case "fluid_level_floodedness_noise" -> router.f_209379_();
                    case "fluid_level_spread_noise" -> router.f_209380_();
                    case "lava_noise" -> router.f_209381_();
                    case "temperature" -> router.f_209384_();
                    case "vegetation" -> router.f_224392_();
                    case "continents" -> router.f_209386_();
                    case "erosion" -> router.f_209387_();
                    case "depth" -> router.f_209388_();
                    case "ridges" -> router.f_209389_();
                    case "initial_density_without_jaggedness" -> router.f_209390_();
                    case "final_density" -> router.f_209391_();
                    case "vein_toggle" -> router.f_209392_();
                    case "vein_ridged" -> router.f_209393_();
                    case "vein_gap" -> router.f_209394_();
                    default -> {
                        DensityFunction result = (DensityFunction)densityFunctionRegistry.m_7745_(InputValidator.identifierOf(densityFunctionQuery));
                        if (result == null) {
                            throw new InternalExpressionException("Density function '" + densityFunctionQuery + "' is not defined in the registies.");
                        }
                        yield result;
                    }
                };
                RandomState randomState = RandomState.m_255302_((NoiseGeneratorSettings)((NoiseGeneratorSettings)noiseBasedChunkGenerator.m_224341_().m_203334_()), (HolderGetter)level.m_9598_().m_255025_(Registries.f_256865_), (long)level.m_7328_());
                DensityFunction.Visitor visitor = Vanilla.RandomState_getVisitor(randomState);
                return densityFunction.m_207456_(visitor);
            }
            return DensityFunctions.m_208263_();
        });
    }
}

