/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.argument;

import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Module;
import carpet.script.ScriptHost;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.value.MapValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.ReportedException;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtAccounter;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagTypes;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FileArgument {
    public final String resource;
    public final Type type;
    public final String zipContainer;
    public final boolean isFolder;
    public final boolean isShared;
    public final Reason reason;
    private FileSystem zfs;
    private Path zipPath;
    private final ScriptHost host;
    public static final Object writeIOSync = new Object();

    public void close() {
        if (this.zfs != null && this.zfs.isOpen()) {
            try {
                this.zfs.close();
            }
            catch (IOException e) {
                throw new InternalExpressionException("Unable to close zip container: " + this.zipContainer);
            }
            this.zfs = null;
        }
    }

    public FileArgument(@Nullable String resource, Type type, @Nullable String zipContainer, boolean isFolder, boolean isShared, Reason reason, ScriptHost host) {
        this.resource = resource;
        this.type = type;
        this.zipContainer = zipContainer;
        this.isFolder = isFolder;
        this.isShared = isShared;
        this.reason = reason;
        this.zfs = null;
        this.zipPath = null;
        this.host = host;
    }

    public String toString() {
        return "path: " + this.resource + " zip: " + this.zipContainer + " type: " + this.type.id + " folder: " + this.isFolder + " shared: " + this.isShared + " reason: " + String.valueOf((Object)this.reason);
    }

    public static FileArgument from(Context context, List<Value> lv, boolean isFolder, Reason reason) {
        if (lv.size() < 2) {
            throw new InternalExpressionException("File functions require path and type as first two arguments");
        }
        String origtype = lv.get(1).getString().toLowerCase(Locale.ROOT);
        boolean shared = origtype.startsWith("shared_");
        String typeString = shared ? origtype.substring(7) : origtype;
        Type type = Type.of.get(typeString);
        if (type == null) {
            throw new InternalExpressionException("Unsupported file type: " + origtype);
        }
        Pair<String, String> resource = FileArgument.recognizeResource(lv.get(0).getString(), isFolder, type);
        if (type == Type.FOLDER && !isFolder) {
            throw new InternalExpressionException("Folder types are no supported for this IO function");
        }
        return new FileArgument((String)resource.getLeft(), type, (String)resource.getRight(), isFolder, shared, reason, context.host);
    }

    public static FileArgument resourceFromPath(ScriptHost host, String path, Reason reason, boolean shared) {
        Pair<String, String> resource = FileArgument.recognizeResource(path, false, Type.ANY);
        return new FileArgument((String)resource.getLeft(), Type.ANY, (String)resource.getRight(), false, shared, reason, host);
    }

    public static Pair<String, String> recognizeResource(String origfile, boolean isFolder, Type type) {
        String[] pathElements = origfile.split("[/\\\\]+");
        ArrayList<String> path = new ArrayList<String>();
        String zipPath = null;
        for (int i = 0; i < pathElements.length; ++i) {
            boolean isZip;
            Object token = pathElements[i];
            boolean bl = isZip = ((String)token).endsWith(".zip") && (isFolder || i < pathElements.length - 1);
            if (zipPath != null && isZip) {
                throw new InternalExpressionException((String)token + " indicates zip access in an already zipped location " + zipPath);
            }
            if (isZip) {
                token = ((String)token).substring(0, ((String)token).length() - 4);
            }
            Object object = token = type == Type.ANY && i == pathElements.length - 1 ? ((String)token).replaceAll("[^A-Za-z0-9\\-+_.]", "") : ((String)token).replaceAll("[^A-Za-z0-9\\-+_]", "");
            if (((String)token).isEmpty()) continue;
            if (isZip) {
                token = (String)token + ".zip";
            }
            path.add((String)token);
            if (!isZip) continue;
            zipPath = String.join((CharSequence)"/", path);
            path.clear();
        }
        if (path.isEmpty() && !isFolder) {
            throw new InternalExpressionException("Cannot use " + origfile + " as resource name: indicated path is empty" + (String)(zipPath == null ? "" : " in zip container " + zipPath));
        }
        return Pair.of((Object)String.join((CharSequence)"/", path), zipPath);
    }

    private Path resolve(String suffix) {
        return this.host.resolveScriptFile(suffix);
    }

    @Nullable
    private Path toPath(@Nullable Module module) {
        if (!this.isShared && module == null) {
            return null;
        }
        if (this.zipContainer == null) {
            return this.resolve(this.getDescriptor(module, this.resource) + (this.isFolder ? "" : this.type.extension));
        }
        if (this.zfs == null) {
            HashMap<String, String> env = new HashMap<String, String>();
            if (this.reason == Reason.CREATE) {
                env.put("create", "true");
            }
            this.zipPath = this.resolve(this.getDescriptor(module, this.zipContainer));
            if (!Files.exists(this.zipPath, new LinkOption[0]) && this.reason != Reason.CREATE) {
                return null;
            }
            try {
                if (!Files.exists(this.zipPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(this.zipPath.getParent(), new FileAttribute[0]);
                }
                this.zfs = FileSystems.newFileSystem(URI.create("jar:" + String.valueOf(this.zipPath.toUri())), env);
            }
            catch (IOException | FileSystemNotFoundException e) {
                CarpetScriptServer.LOG.warn("Exception when opening zip file", (Throwable)e);
                throw new ThrowStatement("Unable to open zip file: " + this.zipContainer, Throwables.IO_EXCEPTION);
            }
        }
        return this.zfs.getPath(this.resource + (this.isFolder ? "/" : this.type.extension), new String[0]);
    }

    @Nullable
    private Path moduleRootPath(@Nullable Module module) {
        return !this.isShared && module == null ? null : this.resolve((String)(this.isShared ? "shared" : module.name() + ".data"));
    }

    public String getDisplayPath() {
        return (this.isShared ? "shared/" : "") + (String)(this.zipContainer != null ? this.zipContainer + "/" : "") + this.resource + this.type.extension;
    }

    private String getDescriptor(@Nullable Module module, @Nullable String res) {
        if (this.isShared) {
            return res.isEmpty() ? "shared" : "shared/" + res;
        }
        if (module != null) {
            return module.name() + ".data" + (String)(res == null || res.isEmpty() ? "" : "/" + res);
        }
        throw new InternalExpressionException("Invalid file descriptor: " + res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean findPathAndApply(Module module, Consumer<Path> action) {
        try {
            Object object = writeIOSync;
            synchronized (object) {
                Path dataFile;
                block8: {
                    dataFile = this.toPath(module);
                    if (dataFile != null) break block8;
                    boolean bl = false;
                    return bl;
                }
                this.createPaths(dataFile);
                action.accept(dataFile);
            }
        }
        finally {
            this.close();
        }
        return true;
    }

    @Nullable
    public Stream<Path> listFiles(Module module) {
        Path dir = this.toPath(module);
        if (dir == null || !Files.exists(dir, new LinkOption[0])) {
            return null;
        }
        String ext = this.type.extension;
        try {
            return Files.list(dir).filter(path -> this.type == Type.FOLDER ? Files.isDirectory(path, new LinkOption[0]) : Files.isRegularFile(path, new LinkOption[0]) && path.toString().endsWith(ext));
        }
        catch (IOException ignored) {
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Stream<String> listFolder(Module module) {
        Stream<String> stream;
        Stream strings;
        try (Stream<Path> result = this.listFiles(module);){
            Object object = writeIOSync;
            synchronized (object) {
                if (result == null) {
                    Stream<String> stream2 = null;
                    return stream2;
                }
                Path rootPath = this.moduleRootPath(module);
                if (rootPath == null) {
                    Stream<String> stream3 = null;
                    return stream3;
                }
                String zipComponent = this.zipContainer != null ? rootPath.relativize(this.zipPath).toString() : null;
                strings = this.zipContainer == null ? result.map(p -> rootPath.relativize((Path)p).toString().replaceAll("[\\\\/]+", "/")).toList().stream() : result.map(p -> (zipComponent + "/" + p.toString()).replaceAll("[\\\\/]+", "/")).toList().stream();
            }
        }
        finally {
            this.close();
        }
        if (this.type == Type.FOLDER) {
            stream = strings.map(s -> s.endsWith("/") ? s.substring(0, s.length() - 1) : s);
            return stream;
        }
        stream = strings.map(FilenameUtils::removeExtension);
        return stream;
    }

    private void createPaths(Path file) {
        try {
            if (!(this.zipContainer != null && file.getParent() == null || Files.exists(file.getParent(), new LinkOption[0]) || Files.createDirectories(file.getParent(), new FileAttribute[0]) != null)) {
                throw new IOException();
            }
        }
        catch (IOException e) {
            CarpetScriptServer.LOG.warn("IOException when creating paths", (Throwable)e);
            throw new ThrowStatement("Unable to create paths for " + String.valueOf(file), Throwables.IO_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean appendToTextFile(Module module, List<String> message) {
        try {
            Object object = writeIOSync;
            synchronized (object) {
                Path dataFile;
                block16: {
                    dataFile = this.toPath(module);
                    if (dataFile != null) break block16;
                    boolean bl = false;
                    return bl;
                }
                this.createPaths(dataFile);
                OutputStream out = Files.newOutputStream(dataFile, StandardOpenOption.APPEND, StandardOpenOption.CREATE);
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8));){
                    for (String line : message) {
                        writer.append(line);
                        if (this.type != Type.TEXT) continue;
                        writer.newLine();
                    }
                }
            }
        }
        catch (IOException e) {
            CarpetScriptServer.LOG.warn("IOException when appending to text file", (Throwable)e);
            throw new ThrowStatement("Error when writing to the file: " + String.valueOf(e), Throwables.IO_EXCEPTION);
        }
        finally {
            this.close();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public Tag getNbtData(Module module) {
        Tag tag;
        Path dataFile;
        try {
            Object object = writeIOSync;
            synchronized (object) {
                dataFile = this.toPath(module);
                if (dataFile == null || !Files.exists(dataFile, new LinkOption[0])) {
                    Tag tag2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.close();
                    return tag2;
                }
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        {
            tag = FileArgument.readTag(dataFile);
        }
        this.close();
        return tag;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public static Tag readTag(Path path) {
        try {
            return NbtIo.m_128939_((InputStream)Files.newInputStream(path, new OpenOption[0]));
        }
        catch (IOException e) {
            if (!Files.exists(path, new LinkOption[0])) {
                return null;
            }
            try (DataInputStream in = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                CompoundTag compoundTag = NbtIo.m_128928_((DataInput)in);
                return compoundTag;
            }
            catch (IOException ioException) {
                try (DataInputStream dataInputStream = new DataInputStream(new BufferedInputStream(Files.newInputStream(path, new OpenOption[0])));){
                    byte b = dataInputStream.readByte();
                    if (b == 0) {
                        Tag tag = null;
                        return tag;
                    }
                    dataInputStream.readUTF();
                    Tag tag = TagTypes.m_129397_((int)b).m_7300_((DataInput)dataInputStream, 0, NbtAccounter.f_128917_);
                    return tag;
                }
                catch (IOException secondIO) {
                    CarpetScriptServer.LOG.warn("IOException when trying to read nbt file, something may have gone wrong with the fs", (Throwable)e);
                    CarpetScriptServer.LOG.warn("", (Throwable)ioException);
                    CarpetScriptServer.LOG.warn("", (Throwable)secondIO);
                    throw new ThrowStatement("Not a valid NBT tag in " + String.valueOf(path), Throwables.NBT_ERROR);
                }
            }
        }
        catch (ReportedException e) {
            throw new ThrowStatement("Error when reading NBT file " + String.valueOf(path), Throwables.NBT_ERROR);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean saveNbtData(Module module, Tag tag) {
        boolean bl;
        boolean bl2;
        Path dataFile;
        try {
            Object object = writeIOSync;
            synchronized (object) {
                dataFile = this.toPath(module);
                if (dataFile == null) {
                    boolean bl3 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var3_3
                    this.close();
                    return bl3;
                }
                this.createPaths(dataFile);
                bl2 = this.zipContainer != null;
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        {
            bl = FileArgument.writeTagDisk(tag, dataFile, bl2);
        }
        this.close();
        return bl;
    }

    public static boolean writeTagDisk(Tag tag, Path path, boolean zipped) {
        Path original = path;
        try {
            if (!zipped) {
                path = path.getParent().resolve(String.valueOf(path.getFileName()) + "_tmp");
                Files.deleteIfExists(path);
            }
            if (tag instanceof CompoundTag) {
                CompoundTag cTag = (CompoundTag)tag;
                NbtIo.m_128947_((CompoundTag)cTag, (OutputStream)Files.newOutputStream(path, new OpenOption[0]));
            } else {
                try (DataOutputStream dataOutputStream = new DataOutputStream(Files.newOutputStream(path, new OpenOption[0]));){
                    dataOutputStream.writeByte(tag.m_7060_());
                    if (tag.m_7060_() != 0) {
                        dataOutputStream.writeUTF("");
                        tag.m_6434_((DataOutput)dataOutputStream);
                    }
                }
            }
            if (!zipped) {
                Files.deleteIfExists(original);
                Files.move(path, original, new CopyOption[0]);
            }
            return true;
        }
        catch (IOException e) {
            CarpetScriptServer.LOG.warn("IO Exception when writing nbt file", (Throwable)e);
            throw new ThrowStatement("Unable to write tag to " + String.valueOf(original), Throwables.IO_EXCEPTION);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean dropExistingFile(Module module) {
        try {
            boolean bl;
            Object object = writeIOSync;
            synchronized (object) {
                Path dataFile = this.toPath(module);
                if (dataFile == null) {
                    boolean bl2 = false;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.close();
                    return bl2;
                }
                bl = Files.deleteIfExists(dataFile);
            }
            this.close();
            return bl;
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        {
            catch (IOException e) {
                CarpetScriptServer.LOG.warn("IOException when removing file", (Throwable)e);
                throw new ThrowStatement("Error while removing file: " + this.getDisplayPath(), Throwables.IO_EXCEPTION);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public List<String> listFile(Module module) {
        List<String> list;
        Path dataFile;
        try {
            Object object = writeIOSync;
            synchronized (object) {
                dataFile = this.toPath(module);
                if (dataFile == null) {
                    List<String> list2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 5, 8] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.close();
                    return list2;
                }
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        {
            if (!Files.exists(dataFile, new LinkOption[0])) {
                List<String> list3 = null;
                // MONITOREXIT @DISABLED, blocks:[5, 7] lbl16 : MonitorExitStatement: MONITOREXIT : var2_2
                this.close();
                return list3;
            }
            list = FileArgument.listFileContent(dataFile);
        }
        this.close();
        return list;
    }

    public static List<String> listFileContent(Path filePath) {
        ArrayList<String> arrayList;
        block9: {
            BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
            try {
                String line;
                ArrayList<String> result = new ArrayList<String>();
                while ((line = reader.readLine()) != null) {
                    result.add(line.replaceAll("[\n\r]+", ""));
                }
                arrayList = result;
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    CarpetScriptServer.LOG.warn("IOException when reading text file", (Throwable)e);
                    throw new ThrowStatement("Failed to read text file " + String.valueOf(filePath), Throwables.IO_EXCEPTION);
                }
            }
            reader.close();
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Nullable
    public JsonElement readJsonFile(Module module) {
        JsonElement jsonElement;
        Path dataFile;
        try {
            Object object = writeIOSync;
            synchronized (object) {
                dataFile = this.toPath(module);
                if (dataFile == null || !Files.exists(dataFile, new LinkOption[0])) {
                    JsonElement jsonElement2 = null;
                    // MONITOREXIT @DISABLED, blocks:[0, 4, 6] lbl7 : MonitorExitStatement: MONITOREXIT : var2_2
                    this.close();
                    return jsonElement2;
                }
            }
        }
        catch (Throwable throwable) {
            this.close();
            throw throwable;
        }
        {
            jsonElement = FileArgument.readJsonContent(dataFile);
        }
        this.close();
        return jsonElement;
    }

    public static JsonElement readJsonContent(Path filePath) {
        JsonElement jsonElement;
        block10: {
            BufferedReader reader = Files.newBufferedReader(filePath, StandardCharsets.UTF_8);
            try {
                jsonElement = JsonParser.parseReader((Reader)reader);
                if (reader == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (JsonParseException e) {
                    Throwable exc = e;
                    if (e.getCause() != null) {
                        exc = e.getCause();
                    }
                    throw new ThrowStatement(MapValue.wrap(Map.of(StringValue.of("error"), StringValue.of(exc.getMessage()), StringValue.of("path"), StringValue.of(filePath.toString()))), Throwables.JSON_ERROR);
                }
                catch (IOException e) {
                    CarpetScriptServer.LOG.warn("IOException when reading JSON file", (Throwable)e);
                    throw new ThrowStatement("Failed to read json file content " + String.valueOf(filePath), Throwables.IO_EXCEPTION);
                }
            }
            reader.close();
        }
        return jsonElement;
    }

    public static enum Type {
        RAW("raw", ".txt"),
        TEXT("text", ".txt"),
        NBT("nbt", ".nbt"),
        JSON("json", ".json"),
        FOLDER("folder", ""),
        ANY("any", "");

        private final String id;
        private final String extension;
        private static final Map<String, Type> of;

        private Type(String id, String extension) {
            this.id = id;
            this.extension = extension;
        }

        static {
            of = Arrays.stream(Type.values()).collect(Collectors.toMap(t -> t.id, t -> t));
        }
    }

    public static enum Reason {
        READ,
        CREATE,
        DELETE;

    }
}

