/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import java.util.function.Supplier;
import javax.annotation.Nullable;

public class GlocalFlag
extends ThreadLocal<Boolean> {
    private final boolean initial;

    public GlocalFlag(boolean initial) {
        this.initial = initial;
    }

    @Override
    public Boolean initialValue() {
        return this.initial;
    }

    public <T> T getWhileDisabled(Supplier<T> action) {
        return this.whileValueReturn(!this.initial, action);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T whileValueReturn(boolean what, Supplier<T> action) {
        T result;
        boolean previous;
        GlocalFlag glocalFlag = this;
        synchronized (glocalFlag) {
            previous = (Boolean)this.get();
            this.set(what);
        }
        try {
            result = action.get();
        }
        finally {
            this.set(previous);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public <T> T runIfEnabled(Supplier<T> action) {
        T result;
        GlocalFlag glocalFlag = this;
        synchronized (glocalFlag) {
            if ((Boolean)this.get() != this.initial) {
                return null;
            }
            this.set(!this.initial);
        }
        try {
            result = action.get();
        }
        finally {
            this.set(this.initial);
        }
        return result;
    }
}

