/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.utils.PerlinNoiseSampler;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import java.util.Map;
import java.util.Random;
import net.minecraft.util.Mth;

public class SimplexNoiseSampler
extends PerlinNoiseSampler {
    private static final double sqrt3 = Math.sqrt(3.0);
    private static final double SKEW_FACTOR_2D;
    private static final double UNSKEW_FACTOR_2D;
    public static SimplexNoiseSampler instance;
    public static Map<Long, SimplexNoiseSampler> samplers;

    public static SimplexNoiseSampler getSimplex(long aLong) {
        if (samplers.size() > 256) {
            samplers.clear();
        }
        return samplers.computeIfAbsent(aLong, seed -> new SimplexNoiseSampler(new Random((long)seed)));
    }

    public SimplexNoiseSampler(Random random) {
        super(random);
    }

    private double grad(int hash, double x, double y, double z, double d) {
        double g;
        double e = d - x * x - y * y - z * z;
        if (e < 0.0) {
            g = 0.0;
        } else {
            e *= e;
            g = e * e * PerlinNoiseSampler.dot3d(PerlinNoiseSampler.gradients3d[hash], x, y, z);
        }
        return g;
    }

    @Override
    public double sample2d(double x, double y) {
        int o;
        int n;
        double g;
        double k;
        int j;
        double e;
        double d;
        int i;
        double f;
        double h;
        if ((h = (x /= 2.0) - (f = (double)(i = Mth.m_14107_((double)(x + (d = (x + (y /= 2.0)) * SKEW_FACTOR_2D)))) - (e = (double)(i + (j = Mth.m_14107_((double)(y + d)))) * UNSKEW_FACTOR_2D))) > (k = y - (g = (double)j - e))) {
            n = 1;
            o = 0;
        } else {
            n = 0;
            o = 1;
        }
        double p = h - (double)n + UNSKEW_FACTOR_2D;
        double q = k - (double)o + UNSKEW_FACTOR_2D;
        double r = h - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        double s = k - 1.0 + 2.0 * UNSKEW_FACTOR_2D;
        int t = i & 0xFF;
        int u = j & 0xFF;
        int v = this.getGradient(t + this.getGradient(u)) % 12;
        int w = this.getGradient(t + n + this.getGradient(u + o)) % 12;
        int z = this.getGradient(t + 1 + this.getGradient(u + 1)) % 12;
        double aa = this.grad(v, h, k, 0.0, 0.5);
        double ab = this.grad(w, p, q, 0.0, 0.5);
        double ac = this.grad(z, r, s, 0.0, 0.5);
        return 35.0 * (aa + ab + ac) + 0.5;
    }

    @Override
    public double sample3d(double d, double e, double f) {
        int bc;
        int ad;
        int ac;
        int ab;
        int aa;
        int z;
        double h = ((d /= 2.0) + (e /= 2.0) + (f /= 2.0)) * 0.3333333333333333;
        int i = Mth.m_14107_((double)(d + h));
        int j = Mth.m_14107_((double)(e + h));
        int k = Mth.m_14107_((double)(f + h));
        double m = (double)(i + j + k) * 0.16666666666666666;
        double n = (double)i - m;
        double o = (double)j - m;
        double p = (double)k - m;
        double q = d - n;
        double r = e - o;
        double s = f - p;
        if (q >= r) {
            if (r >= s) {
                z = 1;
                aa = 0;
                ab = 0;
                ac = 1;
                ad = 1;
                bc = 0;
            } else if (q >= s) {
                z = 1;
                aa = 0;
                ab = 0;
                ac = 1;
                ad = 0;
                bc = 1;
            } else {
                z = 0;
                aa = 0;
                ab = 1;
                ac = 1;
                ad = 0;
                bc = 1;
            }
        } else if (r < s) {
            z = 0;
            aa = 0;
            ab = 1;
            ac = 0;
            ad = 1;
            bc = 1;
        } else if (q < s) {
            z = 0;
            aa = 1;
            ab = 0;
            ac = 0;
            ad = 1;
            bc = 1;
        } else {
            z = 0;
            aa = 1;
            ab = 0;
            ac = 1;
            ad = 1;
            bc = 0;
        }
        double bd = q - (double)z + 0.16666666666666666;
        double be = r - (double)aa + 0.16666666666666666;
        double bf = s - (double)ab + 0.16666666666666666;
        double bg = q - (double)ac + 0.3333333333333333;
        double bh = r - (double)ad + 0.3333333333333333;
        double bi = s - (double)bc + 0.3333333333333333;
        double bj = q - 1.0 + 0.5;
        double bk = r - 1.0 + 0.5;
        double bl = s - 1.0 + 0.5;
        int bm = i & 0xFF;
        int bn = j & 0xFF;
        int bo = k & 0xFF;
        int bp = this.getGradient(bm + this.getGradient(bn + this.getGradient(bo))) % 12;
        int bq = this.getGradient(bm + z + this.getGradient(bn + aa + this.getGradient(bo + ab))) % 12;
        int br = this.getGradient(bm + ac + this.getGradient(bn + ad + this.getGradient(bo + bc))) % 12;
        int bs = this.getGradient(bm + 1 + this.getGradient(bn + 1 + this.getGradient(bo + 1))) % 12;
        double bt = this.grad(bp, q, r, s, 0.6);
        double bu = this.grad(bq, bd, be, bf, 0.6);
        double bv = this.grad(br, bg, bh, bi, 0.6);
        double bw = this.grad(bs, bj, bk, bl, 0.6);
        return 16.0 * (bt + bu + bv + bw) + 0.5;
    }

    static {
        instance = new SimplexNoiseSampler(new Random(0L));
        samplers = new Long2ObjectOpenHashMap();
        SKEW_FACTOR_2D = 0.5 * (sqrt3 - 1.0);
        UNSKEW_FACTOR_2D = (3.0 - sqrt3) / 6.0;
    }
}

