/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import com.mojang.brigadier.ResultConsumer;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SnoopyCommandSource
extends CommandSourceStack {
    private final CommandSource output;
    private final Vec3 position;
    private final ServerLevel world;
    private final int level;
    private final String simpleName;
    private final Component name;
    private final MinecraftServer server;
    private final Entity entity;
    private final ResultConsumer<CommandSourceStack> resultConsumer;
    private final EntityAnchorArgument.Anchor entityAnchor;
    private final Vec2 rotation;
    private final Component[] error;
    private final List<Component> chatOutput;
    private final CommandSigningContext signingContext;

    public SnoopyCommandSource(CommandSourceStack original, Component[] error, List<Component> chatOutput) {
        super(CommandSource.f_80164_, original.m_81371_(), original.m_81376_(), original.m_81372_(), Vanilla.MinecraftServer_getRunPermissionLevel(original.m_81377_()), original.m_81368_(), original.m_81357_(), original.m_81377_(), original.m_81373_(), false, (ctx, succ, res) -> {}, EntityAnchorArgument.Anchor.FEET, CommandSigningContext.f_242494_, TaskChainer.m_247687_((Executor)original.m_81377_()), i -> {});
        this.output = CommandSource.f_80164_;
        this.position = original.m_81371_();
        this.world = original.m_81372_();
        this.level = Vanilla.MinecraftServer_getRunPermissionLevel(original.m_81377_());
        this.simpleName = original.m_81368_();
        this.name = original.m_81357_();
        this.server = original.m_81377_();
        this.entity = original.m_81373_();
        this.resultConsumer = (ctx, succ, res) -> {};
        this.entityAnchor = original.m_81378_();
        this.rotation = original.m_81376_();
        this.error = error;
        this.chatOutput = chatOutput;
        this.signingContext = original.m_230898_();
    }

    public SnoopyCommandSource(ServerPlayer player, Component[] error, List<Component> output) {
        super((CommandSource)player, player.m_20182_(), player.m_20155_(), (level = player.m_9236_()) instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null, player.f_8924_.m_129944_(player.m_36316_()), player.m_7755_().getString(), player.m_5446_(), player.m_9236_().m_7654_(), (Entity)player);
        ServerLevel serverLevel;
        Level level;
        this.output = player;
        this.position = player.m_20182_();
        level = player.m_9236_();
        this.world = level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
        this.level = player.f_8924_.m_129944_(player.m_36316_());
        this.simpleName = player.m_7755_().getString();
        this.name = player.m_5446_();
        this.server = player.m_9236_().m_7654_();
        this.entity = player;
        this.resultConsumer = (ctx, succ, res) -> {};
        this.entityAnchor = EntityAnchorArgument.Anchor.FEET;
        this.rotation = player.m_20155_();
        this.error = error;
        this.chatOutput = output;
        this.signingContext = CommandSigningContext.f_242494_;
    }

    private SnoopyCommandSource(CommandSource output, Vec3 pos, Vec2 rot, ServerLevel world, int level, String simpleName, Component name, MinecraftServer server, @Nullable Entity entity, ResultConsumer<CommandSourceStack> consumer, EntityAnchorArgument.Anchor entityAnchor, CommandSigningContext context, Component[] error, List<Component> chatOutput) {
        super(output, pos, rot, world, level, simpleName, name, server, entity, false, consumer, entityAnchor, context, TaskChainer.m_247687_((Executor)server), i -> {});
        this.output = output;
        this.position = pos;
        this.rotation = rot;
        this.world = world;
        this.level = level;
        this.simpleName = simpleName;
        this.name = name;
        this.server = server;
        this.entity = entity;
        this.resultConsumer = consumer;
        this.entityAnchor = entityAnchor;
        this.error = error;
        this.chatOutput = chatOutput;
        this.signingContext = context;
    }

    public CommandSourceStack m_81329_(Entity entity) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, entity.m_7755_().getString(), entity.m_5446_(), this.server, entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81348_(Vec3 position) {
        return new SnoopyCommandSource(this.output, position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81346_(Vec2 rotation) {
        return new SnoopyCommandSource(this.output, this.position, rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81334_(ResultConsumer<CommandSourceStack> consumer) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, consumer, this.entityAnchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81336_(ResultConsumer<CommandSourceStack> consumer, BinaryOperator<ResultConsumer<CommandSourceStack>> binaryOperator) {
        ResultConsumer resultConsumer = (ResultConsumer)binaryOperator.apply(this.resultConsumer, consumer);
        return this.m_81334_((ResultConsumer<CommandSourceStack>)resultConsumer);
    }

    public CommandSourceStack m_81325_(int level) {
        return this;
    }

    public CommandSourceStack m_81358_(int level) {
        return this;
    }

    public CommandSourceStack m_81350_(EntityAnchorArgument.Anchor anchor) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, anchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_230893_(CommandSigningContext commandSigningContext) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, commandSigningContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81327_(ServerLevel world) {
        double d = DimensionType.m_63908_((DimensionType)this.world.m_6042_(), (DimensionType)world.m_6042_());
        Vec3 position = new Vec3(this.position.f_82479_ * d, this.position.f_82480_, this.position.f_82481_ * d);
        return new SnoopyCommandSource(this.output, position, this.rotation, world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.error, this.chatOutput);
    }

    public CommandSourceStack m_81364_(Vec3 position) {
        Vec3 vec3d = this.entityAnchor.m_90379_((CommandSourceStack)this);
        double d = position.f_82479_ - vec3d.f_82479_;
        double e = position.f_82480_ - vec3d.f_82480_;
        double f = position.f_82481_ - vec3d.f_82481_;
        double g = Math.sqrt(d * d + f * f);
        float h = Mth.m_14177_((float)((float)(-(Mth.m_14136_((double)e, (double)g) * 57.2957763671875))));
        float i = Mth.m_14177_((float)((float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f));
        return this.m_81346_(new Vec2(h, i));
    }

    public void m_81352_(Component message) {
        this.error[0] = message;
    }

    public void m_288197_(Supplier<Component> message, boolean broadcastToOps) {
        this.chatOutput.add(message.get());
    }
}

