/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.storage.RegionFile;

public class WorldTools {
    public static boolean canHasChunk(ServerLevel world, ChunkPos chpos, @Nullable Map<String, RegionFile> regionCache, boolean deepcheck) {
        if (world.m_6522_(chpos.f_45578_, chpos.f_45579_, ChunkStatus.f_62315_, false) != null) {
            return true;
        }
        String currentRegionName = "r." + chpos.m_45610_() + "." + chpos.m_45612_() + ".mca";
        if (regionCache != null && regionCache.containsKey(currentRegionName)) {
            RegionFile region = regionCache.get(currentRegionName);
            if (region == null) {
                return false;
            }
            return region.m_63682_(chpos);
        }
        Path regionsFolder = Vanilla.MinecraftServer_storageSource(world.m_7654_()).m_197394_(world.m_46472_()).resolve("region");
        Path regionPath = regionsFolder.resolve(currentRegionName);
        if (!regionPath.toFile().exists()) {
            if (regionCache != null) {
                regionCache.put(currentRegionName, null);
            }
            return false;
        }
        if (!deepcheck) {
            return true;
        }
        try {
            RegionFile region = new RegionFile(regionPath, regionsFolder, true);
            if (regionCache != null) {
                regionCache.put(currentRegionName, region);
            }
            return region.m_63682_(chpos);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static void forceChunkUpdate(BlockPos pos, ServerLevel world) {
        List players;
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk worldChunk = world.m_7726_().m_62227_(chunkPos.f_45578_, chunkPos.f_45579_, false);
        if (worldChunk != null && !(players = world.m_7726_().f_8325_.m_183262_(chunkPos, false)).isEmpty()) {
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(worldChunk, world.m_5518_(), null, null);
            players.forEach(p -> p.f_8906_.m_9829_((Packet)packet));
        }
    }
}

