/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.blocks.BlockStateParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockValue
extends Value {
    private BlockState blockState;
    private final BlockPos pos;
    private final ServerLevel world;
    private CompoundTag data;
    public static final BlockValue NONE = new BlockValue(Blocks.f_50016_.m_49966_(), null, BlockPos.f_121853_, null);
    private static final Map<String, BlockValue> bvCache = new HashMap<String, BlockValue>();

    public static BlockValue fromCoords(CarpetContext c, int x, int y, int z) {
        BlockPos pos = BlockValue.locateBlockPos(c, x, y, z);
        return new BlockValue(null, c.level(), pos);
    }

    public static BlockValue fromString(String str, ServerLevel level) {
        try {
            BlockValue bv = bvCache.get(str);
            if (bv != null) {
                return bv;
            }
            BlockStateParser.BlockResult foo = BlockStateParser.m_234691_((HolderLookup)level.m_9598_().m_255025_(Registries.f_256747_), (StringReader)new StringReader(str), (boolean)true);
            if (foo.f_234748_() != null) {
                CompoundTag bd = foo.f_234750_();
                if (bd == null) {
                    bd = new CompoundTag();
                }
                bv = new BlockValue(foo.f_234748_(), level, null, bd);
                if (bvCache.size() > 10000) {
                    bvCache.clear();
                }
                bvCache.put(str, bv);
                return bv;
            }
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        throw new ThrowStatement(str, Throwables.UNKNOWN_BLOCK);
    }

    public static BlockPos locateBlockPos(CarpetContext c, int xpos, int ypos, int zpos) {
        BlockPos pos = c.origin();
        return new BlockPos(pos.m_123341_() + xpos, pos.m_123342_() + ypos, pos.m_123343_() + zpos);
    }

    public BlockState getBlockState() {
        if (this.blockState != null) {
            return this.blockState;
        }
        if (this.pos != null) {
            this.blockState = this.world.m_8055_(this.pos);
            return this.blockState;
        }
        throw new InternalExpressionException("Attempted to fetch block state without world or stored block state");
    }

    public static BlockEntity getBlockEntity(Level level, BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return serverLevel.m_7654_().m_18695_() ? serverLevel.m_7702_(pos) : serverLevel.m_46745_(pos).m_5685_(pos, LevelChunk.EntityCreationType.IMMEDIATE);
        }
        return null;
    }

    public CompoundTag getData() {
        if (this.data != null) {
            return this.data.m_128456_() ? null : this.data;
        }
        if (this.pos != null) {
            BlockEntity be = BlockValue.getBlockEntity((Level)this.world, this.pos);
            if (be == null) {
                this.data = new CompoundTag();
                return null;
            }
            this.data = be.m_187482_();
            return this.data;
        }
        return null;
    }

    public BlockValue(BlockState state, ServerLevel world, BlockPos position) {
        this.world = world;
        this.blockState = state;
        this.pos = position;
        this.data = null;
    }

    public BlockValue(BlockState state) {
        this.world = null;
        this.blockState = state;
        this.pos = null;
        this.data = null;
    }

    public BlockValue(ServerLevel world, BlockPos position) {
        this.world = world;
        this.blockState = null;
        this.pos = position;
        this.data = null;
    }

    public BlockValue(BlockState state, CompoundTag nbt) {
        this.world = null;
        this.blockState = state;
        this.pos = null;
        this.data = nbt;
    }

    public BlockValue(BlockState state, ServerLevel world, CompoundTag nbt) {
        this.world = world;
        this.blockState = state;
        this.pos = null;
        this.data = nbt;
    }

    private BlockValue(@Nullable BlockState state, @Nullable ServerLevel world, @Nullable BlockPos position, @Nullable CompoundTag nbt) {
        this.world = world;
        this.blockState = state;
        this.pos = position;
        this.data = nbt;
    }

    @Override
    public String getString() {
        Registry blockRegistry = this.world.m_9598_().m_175515_(Registries.f_256747_);
        return NBTSerializableValue.nameFromResource(blockRegistry.m_7981_((Object)this.getBlockState().m_60734_()));
    }

    @Override
    public boolean getBoolean() {
        return !this.getBlockState().m_60795_();
    }

    @Override
    public String getTypeString() {
        return "block";
    }

    public Value clone() {
        return new BlockValue(this.blockState, this.world, this.pos, this.data);
    }

    @Override
    public int hashCode() {
        return this.pos != null ? GlobalPos.m_122643_((ResourceKey)this.world.m_46472_(), (BlockPos)this.pos).hashCode() : ("b" + this.getString()).hashCode();
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public Level getWorld() {
        return this.world;
    }

    @Override
    public Tag toTag(boolean force) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        CompoundTag tag = new CompoundTag();
        CompoundTag state = new CompoundTag();
        BlockState s = this.getBlockState();
        state.m_128365_("Name", (Tag)StringTag.m_129297_((String)this.world.m_9598_().m_175515_(Registries.f_256747_).m_7981_((Object)s.m_60734_()).toString()));
        Collection properties = s.m_61147_();
        if (!properties.isEmpty()) {
            CompoundTag props = new CompoundTag();
            for (Property p : properties) {
                props.m_128365_(p.m_61708_(), (Tag)StringTag.m_129297_((String)s.m_61143_(p).toString().toLowerCase(Locale.ROOT)));
            }
            state.m_128365_("Properties", (Tag)props);
        }
        tag.m_128365_("BlockState", (Tag)state);
        CompoundTag dataTag = this.getData();
        if (dataTag != null) {
            tag.m_128365_("TileEntityData", (Tag)dataTag);
        }
        return tag;
    }

    public static class PlacementContext
    extends BlockPlaceContext {
        private final Direction facing;
        private final boolean sneakPlace;

        public static PlacementContext from(Level world, BlockPos pos, String direction, boolean sneakPlace, ItemStack itemStack) {
            SpecificDirection dir = SpecificDirection.DIRECTION_MAP.get(direction);
            if (dir == null) {
                throw new InternalExpressionException("unknown block placement direction: " + direction);
            }
            BlockHitResult hitres = new BlockHitResult(Vec3.m_82528_((Vec3i)pos).m_82549_(dir.hitOffset), dir.facing, pos, false);
            return new PlacementContext(world, dir.facing, sneakPlace, itemStack, hitres);
        }

        private PlacementContext(Level world_1, Direction direction_1, boolean sneakPlace, ItemStack itemStack_1, BlockHitResult hitres) {
            super(world_1, null, InteractionHand.MAIN_HAND, itemStack_1, hitres);
            this.facing = direction_1;
            this.sneakPlace = sneakPlace;
        }

        public BlockPos m_8083_() {
            boolean prevcanReplaceExisting = this.f_43628_;
            this.f_43628_ = true;
            BlockPos ret = super.m_8083_();
            this.f_43628_ = prevcanReplaceExisting;
            return ret;
        }

        public Direction m_7820_() {
            return this.facing.m_122424_();
        }

        public Direction[] m_6232_() {
            Direction[] directionArray;
            switch (this.facing) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DOWN: {
                    Direction[] directionArray2 = new Direction[6];
                    directionArray2[0] = Direction.DOWN;
                    directionArray2[1] = Direction.NORTH;
                    directionArray2[2] = Direction.EAST;
                    directionArray2[3] = Direction.SOUTH;
                    directionArray2[4] = Direction.WEST;
                    directionArray = directionArray2;
                    directionArray2[5] = Direction.UP;
                    break;
                }
                case UP: {
                    Direction[] directionArray3 = new Direction[6];
                    directionArray3[0] = Direction.DOWN;
                    directionArray3[1] = Direction.UP;
                    directionArray3[2] = Direction.NORTH;
                    directionArray3[3] = Direction.EAST;
                    directionArray3[4] = Direction.SOUTH;
                    directionArray = directionArray3;
                    directionArray3[5] = Direction.WEST;
                    break;
                }
                case NORTH: {
                    Direction[] directionArray4 = new Direction[6];
                    directionArray4[0] = Direction.DOWN;
                    directionArray4[1] = Direction.NORTH;
                    directionArray4[2] = Direction.EAST;
                    directionArray4[3] = Direction.WEST;
                    directionArray4[4] = Direction.UP;
                    directionArray = directionArray4;
                    directionArray4[5] = Direction.SOUTH;
                    break;
                }
                case SOUTH: {
                    Direction[] directionArray5 = new Direction[6];
                    directionArray5[0] = Direction.DOWN;
                    directionArray5[1] = Direction.SOUTH;
                    directionArray5[2] = Direction.EAST;
                    directionArray5[3] = Direction.WEST;
                    directionArray5[4] = Direction.UP;
                    directionArray = directionArray5;
                    directionArray5[5] = Direction.NORTH;
                    break;
                }
                case WEST: {
                    Direction[] directionArray6 = new Direction[6];
                    directionArray6[0] = Direction.DOWN;
                    directionArray6[1] = Direction.WEST;
                    directionArray6[2] = Direction.SOUTH;
                    directionArray6[3] = Direction.UP;
                    directionArray6[4] = Direction.NORTH;
                    directionArray = directionArray6;
                    directionArray6[5] = Direction.EAST;
                    break;
                }
                case EAST: {
                    Direction[] directionArray7 = new Direction[6];
                    directionArray7[0] = Direction.DOWN;
                    directionArray7[1] = Direction.EAST;
                    directionArray7[2] = Direction.SOUTH;
                    directionArray7[3] = Direction.UP;
                    directionArray7[4] = Direction.NORTH;
                    directionArray = directionArray7;
                    directionArray7[5] = Direction.WEST;
                }
            }
            return directionArray;
        }

        public Direction m_8125_() {
            return this.facing.m_122434_() == Direction.Axis.Y ? Direction.NORTH : this.facing;
        }

        public Direction m_151260_() {
            return this.facing.m_122434_() == Direction.Axis.Y ? this.facing : Direction.UP;
        }

        public boolean m_7078_() {
            return this.sneakPlace;
        }

        public float m_7074_() {
            return this.facing.m_122416_() * 90;
        }
    }

    public static enum SpecificDirection {
        UP("up", 0.5, 0.0, 0.5, Direction.UP),
        UPNORTH("up-north", 0.5, 0.0, 0.4, Direction.UP),
        UPSOUTH("up-south", 0.5, 0.0, 0.6, Direction.UP),
        UPEAST("up-east", 0.6, 0.0, 0.5, Direction.UP),
        UPWEST("up-west", 0.4, 0.0, 0.5, Direction.UP),
        DOWN("down", 0.5, 1.0, 0.5, Direction.DOWN),
        DOWNNORTH("down-north", 0.5, 1.0, 0.4, Direction.DOWN),
        DOWNSOUTH("down-south", 0.5, 1.0, 0.6, Direction.DOWN),
        DOWNEAST("down-east", 0.6, 1.0, 0.5, Direction.DOWN),
        DOWNWEST("down-west", 0.4, 1.0, 0.5, Direction.DOWN),
        NORTH("north", 0.5, 0.4, 1.0, Direction.NORTH),
        SOUTH("south", 0.5, 0.4, 0.0, Direction.SOUTH),
        EAST("east", 0.0, 0.4, 0.5, Direction.EAST),
        WEST("west", 1.0, 0.4, 0.5, Direction.WEST),
        NORTHUP("north-up", 0.5, 0.6, 1.0, Direction.NORTH),
        SOUTHUP("south-up", 0.5, 0.6, 0.0, Direction.SOUTH),
        EASTUP("east-up", 0.0, 0.6, 0.5, Direction.EAST),
        WESTUP("west-up", 1.0, 0.6, 0.5, Direction.WEST);

        public final String name;
        public final Vec3 hitOffset;
        public final Direction facing;
        private static final Map<String, SpecificDirection> DIRECTION_MAP;

        private SpecificDirection(String name, double hitx, double hity, double hitz, Direction blockFacing) {
            this.name = name;
            this.hitOffset = new Vec3(hitx, hity, hitz);
            this.facing = blockFacing;
        }

        private String getName() {
            return this.name;
        }

        static {
            DIRECTION_MAP = Arrays.stream(SpecificDirection.values()).collect(Collectors.toMap(SpecificDirection::getName, d -> d));
        }
    }
}

