/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetScriptHost;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.exception.IntegrityException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.InvalidCallbackException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.OptionalInt;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.AbstractFurnaceMenu;
import net.minecraft.world.inventory.AnvilMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.BlastFurnaceMenu;
import net.minecraft.world.inventory.BrewingStandMenu;
import net.minecraft.world.inventory.CartographyTableMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.FurnaceMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.HopperMenu;
import net.minecraft.world.inventory.LecternMenu;
import net.minecraft.world.inventory.LoomMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.MerchantMenu;
import net.minecraft.world.inventory.ShulkerBoxMenu;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.SmithingMenu;
import net.minecraft.world.inventory.SmokerMenu;
import net.minecraft.world.inventory.StonecutterMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;

public class ScreenValue
extends Value {
    private AbstractContainerMenu screenHandler;
    private ScreenHandlerInventory inventory;
    private final Component name;
    private final String typestring;
    private final FunctionValue callback;
    private final String hostname;
    private final ServerPlayer player;
    private final CarpetScriptServer scriptServer;
    public static Map<String, ScarpetScreenHandlerFactory> screenHandlerFactories = new HashMap<String, ScarpetScreenHandlerFactory>();

    public ScreenValue(ServerPlayer player, String type, Component name, @Nullable FunctionValue callback, Context c) {
        this.name = name;
        this.typestring = type.toLowerCase();
        if (callback != null) {
            callback.checkArgs(4);
        }
        this.callback = callback;
        this.hostname = c.host.getName();
        this.scriptServer = (CarpetScriptServer)c.host.scriptServer();
        this.player = player;
        MenuProvider factory = this.createScreenHandlerFactory();
        if (factory == null) {
            throw new ThrowStatement(type, Throwables.UNKNOWN_SCREEN);
        }
        this.openScreen(factory);
        this.inventory = new ScreenHandlerInventory(this.screenHandler);
    }

    private MenuProvider createScreenHandlerFactory() {
        if (!screenHandlerFactories.containsKey(this.typestring)) {
            return null;
        }
        return new SimpleMenuProvider((i, playerInventory, playerEntity) -> {
            AbstractContainerMenu screen = screenHandlerFactories.get(this.typestring).create(i, playerInventory);
            this.addListenerCallback(screen);
            this.screenHandler = screen;
            return screen;
        }, this.name);
    }

    private void openScreen(MenuProvider factory) {
        if (this.player == null) {
            return;
        }
        OptionalInt optionalSyncId = this.player.m_5893_(factory);
        if (optionalSyncId.isPresent() && this.player.f_36096_.f_38840_ == optionalSyncId.getAsInt()) {
            this.screenHandler = this.player.f_36096_;
        }
    }

    public void close() {
        if (this.player.f_36096_ != this.player.f_36095_) {
            this.inventory = null;
            this.player.f_36096_ = this.player.f_36095_;
            this.player.m_6915_();
            this.screenHandler = null;
        }
    }

    public boolean isOpen() {
        if (this.screenHandler == null) {
            return false;
        }
        if (this.player.f_36096_.f_38840_ == this.screenHandler.f_38840_) {
            return true;
        }
        this.screenHandler = null;
        return false;
    }

    private boolean callListener(ServerPlayer player, String action, Map<Value, Value> data) {
        Value playerValue = EntityValue.of((Entity)player);
        Value actionValue = StringValue.of(action);
        MapValue dataValue = MapValue.wrap(data);
        List<Value> args = Arrays.asList(this, playerValue, actionValue, dataValue);
        CarpetScriptHost appHost = this.scriptServer.getAppHostByName(this.hostname);
        if (appHost == null) {
            this.close();
            this.screenHandler = null;
            return false;
        }
        int runPermissionLevel = Vanilla.MinecraftServer_getRunPermissionLevel(player.f_8924_);
        CommandSourceStack source = player.m_20203_().m_81325_(runPermissionLevel);
        CarpetScriptHost executingHost = appHost.retrieveForExecution(source, player);
        try {
            Value cancelValue = executingHost.callUDF(source, this.callback, args);
            return cancelValue.getString().equals("cancel");
        }
        catch (IntegrityException | InvalidCallbackException | NullPointerException error) {
            CarpetScriptServer.LOG.error("Got exception when running screen event call ", (Throwable)error);
            return false;
        }
    }

    private void addListenerCallback(AbstractContainerMenu screenHandler) {
        if (this.callback == null) {
            return;
        }
        screenHandler.m_38893_((ContainerListener)new ScarpetScreenHandlerListener(){

            @Override
            public boolean onSlotClick(ServerPlayer player, ClickType actionType, int slot, int button) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("slot"), slot == -999 ? Value.NULL : NumericValue.of(slot));
                if (actionType == ClickType.QUICK_CRAFT) {
                    data.put(StringValue.of("quick_craft_stage"), NumericValue.of(AbstractContainerMenu.m_38947_((int)button)));
                    button = AbstractContainerMenu.m_38928_((int)button);
                }
                data.put(StringValue.of("button"), NumericValue.of(button));
                return ScreenValue.this.callListener(player, ScreenValue.actionTypeToString(actionType), data);
            }

            @Override
            public boolean onButtonClick(ServerPlayer player, int button) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("button"), NumericValue.of(button));
                return ScreenValue.this.callListener(player, "button", data);
            }

            @Override
            public void onClose(ServerPlayer player) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                ScreenValue.this.callListener(player, "close", data);
            }

            @Override
            public boolean onSelectRecipe(ServerPlayer player, Recipe<?> recipe, boolean craftAll) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("recipe"), StringValue.of(recipe.m_6423_().toString()));
                data.put(StringValue.of("craft_all"), BooleanValue.of(craftAll));
                return ScreenValue.this.callListener(player, "select_recipe", data);
            }

            public void m_7934_(AbstractContainerMenu handler, int slotId, ItemStack stack) {
                HashMap<Value, Value> data = new HashMap<Value, Value>();
                data.put(StringValue.of("slot"), NumericValue.of(slotId));
                data.put(StringValue.of("stack"), ValueConversions.of(stack, ScreenValue.this.player.m_9236_().m_9598_()));
                ScreenValue.this.callListener(ScreenValue.this.player, "slot_update", data);
            }

            public void m_142153_(AbstractContainerMenu handler, int property, int value) {
            }
        });
    }

    private DataSlot getPropertyForType(Class<? extends AbstractContainerMenu> screenHandlerClass, String requiredType, int propertyIndex, String propertyName) {
        if (screenHandlerClass.isInstance(this.screenHandler)) {
            return Vanilla.AbstractContainerMenu_getDataSlot(this.screenHandler, propertyIndex);
        }
        if (!this.isOpen()) {
            throw new InternalExpressionException("Screen property cannot be accessed, because the screen is already closed");
        }
        throw new InternalExpressionException("Screen property " + propertyName + " expected a " + requiredType + " screen.");
    }

    private DataSlot getProperty(String propertyName) {
        return switch (propertyName) {
            case "fuel_progress" -> this.getPropertyForType(AbstractFurnaceMenu.class, "furnace", 0, propertyName);
            case "max_fuel_progress" -> this.getPropertyForType(AbstractFurnaceMenu.class, "furnace", 1, propertyName);
            case "cook_progress" -> this.getPropertyForType(AbstractFurnaceMenu.class, "furnace", 2, propertyName);
            case "max_cook_progress" -> this.getPropertyForType(AbstractFurnaceMenu.class, "furnace", 3, propertyName);
            case "level_cost" -> this.getPropertyForType(AnvilMenu.class, "anvil", 0, propertyName);
            case "page" -> this.getPropertyForType(LecternMenu.class, "lectern", 0, propertyName);
            case "beacon_level" -> this.getPropertyForType(BeaconMenu.class, "beacon", 0, propertyName);
            case "primary_effect" -> this.getPropertyForType(BeaconMenu.class, "beacon", 1, propertyName);
            case "secondary_effect" -> this.getPropertyForType(BeaconMenu.class, "beacon", 2, propertyName);
            case "brew_time" -> this.getPropertyForType(BrewingStandMenu.class, "brewing_stand", 0, propertyName);
            case "brewing_fuel" -> this.getPropertyForType(BrewingStandMenu.class, "brewing_stand", 1, propertyName);
            case "enchantment_power_1" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 0, propertyName);
            case "enchantment_power_2" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 1, propertyName);
            case "enchantment_power_3" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 2, propertyName);
            case "enchantment_seed" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 3, propertyName);
            case "enchantment_id_1" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 4, propertyName);
            case "enchantment_id_2" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 5, propertyName);
            case "enchantment_id_3" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 6, propertyName);
            case "enchantment_level_1" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 7, propertyName);
            case "enchantment_level_2" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 8, propertyName);
            case "enchantment_level_3" -> this.getPropertyForType(EnchantmentMenu.class, "enchantment", 9, propertyName);
            case "banner_pattern" -> this.getPropertyForType(LoomMenu.class, "loom", 0, propertyName);
            case "stonecutter_recipe" -> this.getPropertyForType(StonecutterMenu.class, "stonecutter", 0, propertyName);
            default -> throw new InternalExpressionException("Invalid screen property: " + propertyName);
        };
    }

    public Value queryProperty(String propertyName) {
        if (propertyName.equals("name")) {
            return FormattedTextValue.of(this.name);
        }
        if (propertyName.equals("open")) {
            return BooleanValue.of(this.isOpen());
        }
        DataSlot property = this.getProperty(propertyName);
        return NumericValue.of(property.m_6501_());
    }

    public Value modifyProperty(String propertyName, List<Value> lv) {
        DataSlot property = this.getProperty(propertyName);
        int intValue = NumericValue.asNumber(lv.get(0)).getInt();
        property.m_6422_(intValue);
        this.screenHandler.m_150429_();
        return Value.TRUE;
    }

    public ServerPlayer getPlayer() {
        return this.player;
    }

    public Container getInventory() {
        return this.inventory;
    }

    @Override
    public String getString() {
        return this.typestring + "_screen";
    }

    @Override
    public boolean getBoolean() {
        return this.isOpen();
    }

    @Override
    public String getTypeString() {
        return "screen";
    }

    @Override
    public Tag toTag(boolean force) {
        if (this.screenHandler == null) {
            return Value.NULL.toTag(true);
        }
        ListTag nbtList = new ListTag();
        for (int i = 0; i < this.screenHandler.f_38839_.size(); ++i) {
            ItemStack itemStack = this.screenHandler.m_38853_(i).m_7993_();
            nbtList.add((Object)itemStack.m_41739_(new CompoundTag()));
        }
        return nbtList;
    }

    private static String actionTypeToString(ClickType actionType) {
        return switch (actionType) {
            default -> throw new IncompatibleClassChangeError();
            case ClickType.PICKUP -> "pickup";
            case ClickType.QUICK_MOVE -> "quick_move";
            case ClickType.SWAP -> "swap";
            case ClickType.CLONE -> "clone";
            case ClickType.THROW -> "throw";
            case ClickType.QUICK_CRAFT -> "quick_craft";
            case ClickType.PICKUP_ALL -> "pickup_all";
        };
    }

    static {
        screenHandlerFactories.put("anvil", AnvilMenu::new);
        screenHandlerFactories.put("beacon", BeaconMenu::new);
        screenHandlerFactories.put("blast_furnace", BlastFurnaceMenu::new);
        screenHandlerFactories.put("brewing_stand", (syncId, playerInventory) -> new BrewingStandMenu(syncId, playerInventory, (Container)new SimpleContainer(5), (ContainerData)new SimpleContainerData(2)));
        screenHandlerFactories.put("cartography_table", CartographyTableMenu::new);
        screenHandlerFactories.put("crafting", CraftingMenu::new);
        screenHandlerFactories.put("enchantment", EnchantmentMenu::new);
        screenHandlerFactories.put("furnace", FurnaceMenu::new);
        screenHandlerFactories.put("generic_3x3", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39963_, syncId, playerInventory, (Container)new SimpleContainer(9), 1));
        screenHandlerFactories.put("generic_9x1", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39957_, syncId, playerInventory, (Container)new SimpleContainer(9), 1));
        screenHandlerFactories.put("generic_9x2", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39958_, syncId, playerInventory, (Container)new SimpleContainer(18), 2));
        screenHandlerFactories.put("generic_9x3", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39959_, syncId, playerInventory, (Container)new SimpleContainer(27), 3));
        screenHandlerFactories.put("generic_9x4", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39960_, syncId, playerInventory, (Container)new SimpleContainer(36), 4));
        screenHandlerFactories.put("generic_9x5", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39961_, syncId, playerInventory, (Container)new SimpleContainer(45), 5));
        screenHandlerFactories.put("generic_9x6", (syncId, playerInventory) -> new ChestMenu(MenuType.f_39962_, syncId, playerInventory, (Container)new SimpleContainer(54), 6));
        screenHandlerFactories.put("grindstone", GrindstoneMenu::new);
        screenHandlerFactories.put("hopper", HopperMenu::new);
        screenHandlerFactories.put("lectern", (syncId, playerInventory) -> new LecternMenu(syncId, (Container)new SimpleContainer(1), (ContainerData)new SimpleContainerData(1)));
        screenHandlerFactories.put("loom", LoomMenu::new);
        screenHandlerFactories.put("merchant", MerchantMenu::new);
        screenHandlerFactories.put("shulker_box", (syncId, playerInventory) -> new ShulkerBoxMenu(syncId, playerInventory, (Container)new SimpleContainer(27)));
        screenHandlerFactories.put("smithing", SmithingMenu::new);
        screenHandlerFactories.put("smoker", SmokerMenu::new);
        screenHandlerFactories.put("stonecutter", StonecutterMenu::new);
    }

    public static class ScreenHandlerInventory
    implements Container {
        protected AbstractContainerMenu screenHandler;

        public ScreenHandlerInventory(AbstractContainerMenu screenHandler) {
            this.screenHandler = screenHandler;
        }

        public int m_6643_() {
            return this.screenHandler.f_38839_.size() + 1;
        }

        public boolean m_7983_() {
            for (Slot slot : this.screenHandler.f_38839_) {
                if (!slot.m_6657_() || slot.m_7993_().m_41619_()) continue;
                return false;
            }
            return this.screenHandler.m_142621_().m_41619_();
        }

        public ItemStack m_8020_(int slot) {
            if (slot == this.m_6643_() - 1) {
                return this.screenHandler.m_142621_();
            }
            return slot >= -1 && slot < this.m_6643_() ? ((Slot)this.screenHandler.f_38839_.get(slot)).m_7993_() : ItemStack.f_41583_;
        }

        public ItemStack m_7407_(int slot, int amount) {
            ItemStack itemStack = slot == this.m_6643_() - 1 ? this.screenHandler.m_142621_().m_41620_(amount) : ScreenHandlerInventory.splitStack((List<Slot>)this.screenHandler.f_38839_, slot, amount);
            if (!itemStack.m_41619_()) {
                this.m_6596_();
            }
            return itemStack;
        }

        public ItemStack m_8016_(int slot) {
            ItemStack itemStack = slot == this.m_6643_() - 1 ? this.screenHandler.m_142621_() : ((Slot)this.screenHandler.f_38839_.get(slot)).m_7993_();
            if (itemStack.m_41619_()) {
                return ItemStack.f_41583_;
            }
            if (slot == this.m_6643_() - 1) {
                this.screenHandler.m_142503_(ItemStack.f_41583_);
            } else {
                ((Slot)this.screenHandler.f_38839_.get(slot)).m_5852_(ItemStack.f_41583_);
            }
            return itemStack;
        }

        public void m_6836_(int slot, ItemStack stack) {
            if (slot == this.m_6643_() - 1) {
                this.screenHandler.m_142503_(stack);
            } else {
                ((Slot)this.screenHandler.f_38839_.get(slot)).m_5852_(stack);
            }
            if (!stack.m_41619_() && stack.m_41613_() > this.m_6893_()) {
                stack.m_41764_(this.m_6893_());
            }
            this.m_6596_();
        }

        public void m_6596_() {
        }

        public boolean m_6542_(Player player) {
            return true;
        }

        public void m_6211_() {
            for (Slot slot : this.screenHandler.f_38839_) {
                slot.m_5852_(ItemStack.f_41583_);
            }
            this.screenHandler.m_142503_(ItemStack.f_41583_);
            this.m_6596_();
        }

        public static ItemStack splitStack(List<Slot> slots, int slot, int amount) {
            return slot >= 0 && slot < slots.size() && !slots.get(slot).m_7993_().m_41619_() && amount > 0 ? slots.get(slot).m_7993_().m_41620_(amount) : ItemStack.f_41583_;
        }
    }

    protected static interface ScarpetScreenHandlerFactory {
        public AbstractContainerMenu create(int var1, Inventory var2);
    }

    public static interface ScarpetScreenHandlerListener
    extends ContainerListener {
        public boolean onSlotClick(ServerPlayer var1, ClickType var2, int var3, int var4);

        public boolean onButtonClick(ServerPlayer var1, int var2);

        public void onClose(ServerPlayer var1);

        public boolean onSelectRecipe(ServerPlayer var1, Recipe<?> var2, boolean var3);
    }
}

