/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.Colors;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.behavior.PositionTracker;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.pattern.BlockInWorld;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.StructurePiece;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.scores.Objective;
import net.minecraft.world.scores.criteria.ObjectiveCriteria;

public class ValueConversions {
    private static final Int2ObjectMap<SlotParam> slotIdsToSlotParams = new Int2ObjectOpenHashMap<SlotParam>(){
        {
            int n;
            for (n = 0; n < 54; ++n) {
                this.put(n, new SlotParam(null, n));
            }
            for (n = 0; n < 27; ++n) {
                this.put(200 + n, new SlotParam("enderchest", n));
            }
            for (n = 0; n < 8; ++n) {
                this.put(300 + n, new SlotParam(null, n));
            }
            for (n = 0; n < 15; ++n) {
                this.put(500 + n, new SlotParam(null, n + 2));
            }
            this.put(98, new SlotParam("equipment", 0));
            this.put(99, new SlotParam("equipment", 5));
            for (n = 0; n < 4; ++n) {
                this.put(100 + n, new SlotParam("equipment", n + 1));
            }
            this.put(400, new SlotParam(null, 0));
            this.put(401, new SlotParam(null, 1));
        }
    };

    public static Value of(BlockPos pos) {
        return ListValue.of(new NumericValue(pos.m_123341_()), new NumericValue(pos.m_123342_()), new NumericValue(pos.m_123343_()));
    }

    public static Value of(Vec3 vec) {
        return ListValue.of(new NumericValue(vec.f_82479_), new NumericValue(vec.f_82480_), new NumericValue(vec.f_82481_));
    }

    public static Value of(ColumnPos cpos) {
        return ListValue.of(new NumericValue(cpos.f_140723_()), new NumericValue(cpos.f_140724_()));
    }

    public static Value of(ServerLevel world) {
        return ValueConversions.of(world.m_46472_().m_135782_());
    }

    public static Value of(MapColor color) {
        return ListValue.of(StringValue.of(Colors.mapColourName.get(color)), ValueConversions.ofRGB(color.f_283871_));
    }

    public static <T extends Number> Value of(MinMaxBounds<T> range) {
        return ListValue.of(NumericValue.of(range.m_55305_()), NumericValue.of(range.m_55326_()));
    }

    @Deprecated
    public static Value of(ItemStack stack) {
        return stack == null || stack.m_41619_() ? Value.NULL : ListValue.of(ValueConversions.of(BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_())), new NumericValue(stack.m_41613_()), NBTSerializableValue.fromStack(stack));
    }

    public static Value of(ItemStack stack, RegistryAccess regs) {
        return stack == null || stack.m_41619_() ? Value.NULL : ListValue.of(ValueConversions.of(regs.m_175515_(Registries.f_256913_).m_7981_((Object)stack.m_41720_())), new NumericValue(stack.m_41613_()), NBTSerializableValue.fromStack(stack));
    }

    public static Value of(Objective objective) {
        return ListValue.of(StringValue.of(objective.m_83320_()), StringValue.of(objective.m_83321_().m_83620_()));
    }

    public static Value of(ObjectiveCriteria criteria) {
        return ListValue.of(StringValue.of(criteria.m_83620_()), BooleanValue.of(criteria.m_83621_()));
    }

    public static Value of(ParticleOptions particle) {
        String repr = particle.m_5942_();
        return StringValue.of(repr.startsWith("minecraft:") ? repr.substring(10) : repr);
    }

    public static Value ofRGB(int value) {
        return new NumericValue(value * 256 + 255);
    }

    public static Level dimFromValue(Value dimensionValue, MinecraftServer server) {
        String dimString;
        if (dimensionValue instanceof EntityValue) {
            return ((EntityValue)dimensionValue).getEntity().m_20193_();
        }
        if (dimensionValue instanceof BlockValue) {
            BlockValue bv = (BlockValue)dimensionValue;
            if (bv.getWorld() != null) {
                return bv.getWorld();
            }
            throw new InternalExpressionException("dimension argument accepts only world-localized block arguments");
        }
        return switch (dimString = dimensionValue.getString().toLowerCase(Locale.ROOT)) {
            case "nether", "the_nether" -> server.m_129880_(Level.f_46429_);
            case "end", "the_end" -> server.m_129880_(Level.f_46430_);
            case "overworld", "over_world" -> server.m_129880_(Level.f_46428_);
            default -> {
                ResourceKey dim = null;
                ResourceLocation id = new ResourceLocation(dimString);
                for (ResourceKey world : server.m_129784_()) {
                    if (!id.equals((Object)world.m_135782_())) continue;
                    dim = world;
                    break;
                }
                if (dim == null) {
                    throw new ThrowStatement(dimString, Throwables.UNKNOWN_DIMENSION);
                }
                yield server.m_129880_(dim);
            }
        };
    }

    public static Value of(ResourceKey<?> dim) {
        return ValueConversions.of(dim.m_135782_());
    }

    public static Value of(TagKey<?> tagKey) {
        return ValueConversions.of(tagKey.f_203868_());
    }

    public static Value of(@Nullable ResourceLocation id) {
        if (id == null) {
            return Value.NULL;
        }
        return new StringValue(ValueConversions.simplify(id));
    }

    public static String simplify(ResourceLocation id) {
        if (id == null) {
            return "";
        }
        if (id.m_135827_().equals("minecraft")) {
            return id.m_135815_();
        }
        return id.toString();
    }

    public static Value of(GlobalPos pos) {
        return ListValue.of(ValueConversions.of(pos.m_122640_()), ValueConversions.of(pos.m_122646_()));
    }

    public static Value fromPath(ServerLevel world, Path path) {
        ArrayList<Value> nodes = new ArrayList<Value>();
        int len = path.m_77398_();
        for (int i = 0; i < len; ++i) {
            Node node = path.m_77375_(i);
            nodes.add(ListValue.of(new BlockValue(null, world, node.m_77288_()), new StringValue(node.f_77282_.name().toLowerCase(Locale.ROOT)), new NumericValue(node.f_77281_), BooleanValue.of(node.f_77279_)));
        }
        return ListValue.wrap(nodes);
    }

    public static Value fromTimedMemory(Entity e, long expiry, Object v) {
        Value ret = ValueConversions.fromEntityMemory(e, v);
        return ret.isNull() || expiry == Long.MAX_VALUE ? ret : ListValue.of(ret, new NumericValue(expiry));
    }

    private static Value fromEntityMemory(Entity e, Object v) {
        if (v instanceof GlobalPos) {
            GlobalPos pos = (GlobalPos)v;
            return ValueConversions.of(pos);
        }
        if (v instanceof Entity) {
            Entity entity2 = (Entity)v;
            return new EntityValue(entity2);
        }
        if (v instanceof BlockPos) {
            BlockPos pos = (BlockPos)v;
            return new BlockValue(null, (ServerLevel)e.m_20193_(), pos);
        }
        if (v instanceof Number) {
            Number number = (Number)((Object)v);
            return new NumericValue(number.doubleValue());
        }
        if (v instanceof Boolean) {
            Boolean bool = (Boolean)((Object)v);
            return BooleanValue.of(bool);
        }
        if (v instanceof UUID) {
            UUID uuid = (UUID)((Object)v);
            return ValueConversions.ofUUID((ServerLevel)e.m_20193_(), uuid);
        }
        if (v instanceof DamageSource) {
            DamageSource source = (DamageSource)v;
            return ListValue.of(new StringValue(source.m_19385_()), source.m_7639_() == null ? Value.NULL : new EntityValue(source.m_7639_()));
        }
        if (v instanceof Path) {
            Path path = (Path)v;
            return ValueConversions.fromPath((ServerLevel)e.m_20193_(), path);
        }
        if (v instanceof PositionTracker) {
            PositionTracker tracker = (PositionTracker)v;
            return new BlockValue(null, (ServerLevel)e.m_20193_(), tracker.m_6675_());
        }
        if (v instanceof WalkTarget) {
            WalkTarget target = (WalkTarget)v;
            return ListValue.of(new BlockValue(null, (ServerLevel)e.m_20193_(), target.m_26420_().m_6675_()), new NumericValue(target.m_26421_()), new NumericValue(target.m_26422_()));
        }
        if (v instanceof NearestVisibleLivingEntities) {
            NearestVisibleLivingEntities nvle = (NearestVisibleLivingEntities)v;
            v = StreamSupport.stream(nvle.m_186123_(entity -> true).spliterator(), false).toList();
        }
        if (v instanceof Set) {
            Set set = (Set)((Object)v);
            v = new ArrayList(set);
        }
        if (v instanceof List) {
            List l = v;
            if (l.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            Object el = l.get(0);
            if (el instanceof Entity) {
                Entity entity3 = (Entity)el;
                return ListValue.wrap(l.stream().map(o -> new EntityValue(entity3)));
            }
            if (el instanceof GlobalPos) {
                GlobalPos pos = (GlobalPos)el;
                return ListValue.wrap(l.stream().map(o -> ValueConversions.of(pos)));
            }
        }
        return Value.NULL;
    }

    private static Value ofUUID(ServerLevel entityWorld, UUID uuid) {
        Entity current = entityWorld.m_8791_(uuid);
        return ListValue.of(current == null ? Value.NULL : new EntityValue(current), new StringValue(uuid.toString()));
    }

    public static Value of(AABB box) {
        return ListValue.of(ListValue.fromTriple(box.f_82288_, box.f_82289_, box.f_82290_), ListValue.fromTriple(box.f_82291_, box.f_82292_, box.f_82293_));
    }

    public static Value of(BoundingBox box) {
        return ListValue.of(ListValue.fromTriple(box.m_162395_(), box.m_162396_(), box.m_162398_()), ListValue.fromTriple(box.m_162399_(), box.m_162400_(), box.m_162401_()));
    }

    public static Value of(StructureStart structure, RegistryAccess regs) {
        if (structure == null || structure == StructureStart.f_73561_) {
            return Value.NULL;
        }
        BoundingBox boundingBox = structure.m_73601_();
        if (boundingBox.m_162399_() < boundingBox.m_162395_() || boundingBox.m_162400_() < boundingBox.m_162396_() || boundingBox.m_162401_() < boundingBox.m_162398_()) {
            return Value.NULL;
        }
        HashMap<Value, Value> ret = new HashMap<Value, Value>();
        ret.put(new StringValue("box"), ValueConversions.of(boundingBox));
        ArrayList<Value> pieces = new ArrayList<Value>();
        for (StructurePiece piece : structure.m_73602_()) {
            BoundingBox box = piece.m_73547_();
            if (box.m_162399_() < box.m_162395_() || box.m_162400_() < box.m_162396_() || box.m_162401_() < box.m_162398_()) continue;
            pieces.add(ListValue.of(NBTSerializableValue.nameFromRegistryId(regs.m_175515_(Registries.f_256786_).m_7981_((Object)piece.m_210000_())), piece.m_73549_() == null ? Value.NULL : new StringValue(piece.m_73549_().m_122433_()), ListValue.fromTriple(box.m_162395_(), box.m_162396_(), box.m_162398_()), ListValue.fromTriple(box.m_162399_(), box.m_162400_(), box.m_162401_())));
        }
        ret.put(new StringValue("pieces"), ListValue.wrap(pieces));
        return MapValue.wrap(ret);
    }

    public static Value fromProperty(BlockState state, Property<?> p) {
        Comparable object = state.m_61143_(p);
        if (object instanceof Boolean || object instanceof Number) {
            return StringValue.of(object.toString());
        }
        if (object instanceof StringRepresentable) {
            StringRepresentable stringRepresentable = (StringRepresentable)object;
            return StringValue.of(stringRepresentable.m_7912_());
        }
        throw new InternalExpressionException("Unknown property type: " + p.m_61708_());
    }

    public static Value ofVanillaSlotResult(int itemSlot) {
        SlotParam ret = (SlotParam)slotIdsToSlotParams.get(itemSlot);
        return ret == null ? ListValue.of(Value.NULL, new NumericValue(itemSlot)) : ret.build();
    }

    public static Value ofBlockPredicate(RegistryAccess registryAccess, Predicate<BlockInWorld> blockPredicate) {
        Vanilla.BlockPredicatePayload payload = Vanilla.BlockPredicatePayload.of(blockPredicate);
        Registry blocks = registryAccess.m_175515_(Registries.f_256747_);
        return ListValue.of(payload.state() == null ? Value.NULL : ValueConversions.of(blocks.m_7981_((Object)payload.state().m_60734_())), payload.tagKey() == null ? Value.NULL : ValueConversions.of(((HolderSet.Named)blocks.m_203431_(payload.tagKey()).get()).m_205839_()), MapValue.wrap(payload.properties()), payload.tag() == null ? Value.NULL : new NBTSerializableValue((Tag)payload.tag()));
    }

    public static ItemStack getItemStackFromValue(Value value, boolean withCount, RegistryAccess regs) {
        String name;
        if (value.isNull()) {
            return ItemStack.f_41583_;
        }
        int count = 1;
        CompoundTag nbtTag = null;
        if (value instanceof ListValue) {
            Value nbtValue;
            ListValue list = (ListValue)value;
            if (list.length() != 3) {
                throw new ThrowStatement("item definition from list of size " + list.length(), Throwables.UNKNOWN_ITEM);
            }
            List<Value> items = list.getItems();
            name = items.get(0).getString();
            if (withCount) {
                count = NumericValue.asNumber(items.get(1)).getInt();
            }
            if (!(nbtValue = items.get(2)).isNull()) {
                nbtTag = ((NBTSerializableValue)NBTSerializableValue.fromValue(nbtValue)).getCompoundTag();
            }
        } else {
            name = value.getString();
        }
        ItemInput itemInput = NBTSerializableValue.parseItem(name, nbtTag, regs);
        try {
            return itemInput.m_120980_(count, false);
        }
        catch (CommandSyntaxException cse) {
            if (!withCount) {
                throw new IllegalStateException("Unexpected exception while creating item stack of " + name + ". All items should be able to stack to one", cse);
            }
            throw new ThrowStatement(count + " stack size of " + name, Throwables.UNKNOWN_ITEM);
        }
    }

    public static Value guess(ServerLevel serverWorld, Object o) {
        if (o == null) {
            return Value.NULL;
        }
        if (o instanceof List) {
            List list = (List)o;
            return ListValue.wrap(list.stream().map(oo -> ValueConversions.guess(serverWorld, oo)));
        }
        if (o instanceof BlockPos) {
            BlockPos pos = (BlockPos)o;
            return new BlockValue(null, serverWorld, pos);
        }
        if (o instanceof Entity) {
            Entity e = (Entity)o;
            return EntityValue.of(e);
        }
        if (o instanceof Vec3) {
            Vec3 vec3 = (Vec3)o;
            return ValueConversions.of(vec3);
        }
        if (o instanceof Vec3i) {
            Vec3i vec3i = (Vec3i)o;
            return ValueConversions.of(new BlockPos(vec3i));
        }
        if (o instanceof AABB) {
            AABB aabb = (AABB)o;
            return ValueConversions.of(aabb);
        }
        if (o instanceof BoundingBox) {
            BoundingBox bb = (BoundingBox)o;
            return ValueConversions.of(bb);
        }
        if (o instanceof ItemStack) {
            ItemStack itemStack = (ItemStack)o;
            return ValueConversions.of(itemStack, serverWorld.m_9598_());
        }
        if (o instanceof Boolean) {
            Boolean bool = (Boolean)o;
            return BooleanValue.of(bool);
        }
        if (o instanceof Number) {
            Number number = (Number)o;
            return NumericValue.of(number);
        }
        if (o instanceof ResourceLocation) {
            ResourceLocation resourceLocation = (ResourceLocation)o;
            return ValueConversions.of(resourceLocation);
        }
        return StringValue.of(o.toString());
    }

    record SlotParam(String type, int id) {
        public ListValue build() {
            return ListValue.of(StringValue.of(this.type), new NumericValue(this.id));
        }
    }
}

