/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;

public class MobAI {
    private static Map<EntityType<?>, Set<TrackingType>> aiTrackers = new HashMap();

    public static void resetTrackers() {
        aiTrackers.clear();
    }

    public static boolean isTracking(Entity e, TrackingType type) {
        if (e.m_20193_().m_5776_()) {
            return false;
        }
        Set<TrackingType> currentTrackers = aiTrackers.get(e.m_6095_());
        if (currentTrackers == null) {
            return false;
        }
        return currentTrackers.contains((Object)type);
    }

    public static void clearTracking(MinecraftServer server, EntityType<? extends Entity> etype) {
        aiTrackers.remove(etype);
        for (ServerLevel world : server.m_129785_()) {
            for (Entity e : world.m_143280_(etype, Entity::m_8077_)) {
                e.m_20340_(false);
                e.m_6593_(null);
            }
        }
    }

    public static void startTracking(EntityType<?> e, TrackingType type) {
        aiTrackers.putIfAbsent(e, Sets.newHashSet());
        aiTrackers.get(e).add(type);
    }

    public static List<String> availbleTypes(CommandSourceStack source) {
        HashSet types = new HashSet();
        for (TrackingType type : TrackingType.values()) {
            types.addAll(type.types);
        }
        return types.stream().map(t -> source.m_5894_().m_175515_(Registries.f_256939_).m_7981_(t).m_135815_()).collect(Collectors.toList());
    }

    public static List<String> availableFor(EntityType<?> entityType) {
        HashSet<TrackingType> availableOptions = new HashSet<TrackingType>();
        for (TrackingType type : TrackingType.values()) {
            if (!type.types.contains(entityType)) continue;
            availableOptions.add(type);
        }
        return availableOptions.stream().map(t -> t.name().toLowerCase()).collect(Collectors.toList());
    }

    public static enum TrackingType {
        IRON_GOLEM_SPAWNING(Set.of(EntityType.f_20492_)),
        BREEDING(Set.of(EntityType.f_20492_));

        public final Set<EntityType<?>> types;

        private TrackingType(Set<EntityType<?>> applicableTypes) {
            this.types = applicableTypes;
        }
    }
}

