/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.SectionPos;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.random.WeightedEntry;
import net.minecraft.util.random.WeightedRandomList;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.levelgen.structure.BuiltinStructures;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureSpawnOverride;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import org.apache.commons.lang3.tuple.Pair;

public class SpawnOverrides {
    private static final Map<Pair<MobCategory, ResourceKey<Structure>>, Pair<BooleanSupplier, StructureSpawnOverride>> carpetOverrides = new HashMap<Pair<MobCategory, ResourceKey<Structure>>, Pair<BooleanSupplier, StructureSpawnOverride>>();

    public static void addOverride(BooleanSupplier when, MobCategory cat, ResourceKey<Structure> poo, StructureSpawnOverride.BoundingBoxType type, WeightedRandomList<MobSpawnSettings.SpawnerData> spawns) {
        carpetOverrides.put((Pair<MobCategory, ResourceKey<Structure>>)Pair.of((Object)cat, poo), (Pair<BooleanSupplier, StructureSpawnOverride>)Pair.of((Object)when, (Object)new StructureSpawnOverride(type, spawns)));
    }

    public static WeightedRandomList<MobSpawnSettings.SpawnerData> test(StructureManager structureFeatureManager, LongSet foo, MobCategory cat, Structure confExisting, BlockPos where) {
        ResourceLocation resource = structureFeatureManager.m_220521_().m_175515_(Registries.f_256944_).m_7981_((Object)confExisting);
        ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registries.f_256944_, (ResourceLocation)resource);
        Pair<BooleanSupplier, StructureSpawnOverride> spawnData = carpetOverrides.get(Pair.of((Object)cat, (Object)key));
        if (spawnData == null || !((BooleanSupplier)spawnData.getKey()).getAsBoolean()) {
            return null;
        }
        StructureSpawnOverride override = (StructureSpawnOverride)spawnData.getRight();
        if (override.f_210043_() == StructureSpawnOverride.BoundingBoxType.STRUCTURE) {
            if (structureFeatureManager.m_220494_(where, confExisting).m_73603_()) {
                return override.f_210044_();
            }
        } else {
            ArrayList starts = new ArrayList(1);
            structureFeatureManager.m_220480_(confExisting, foo, starts::add);
            for (StructureStart start : starts) {
                if (start == null || !start.m_73603_() || !structureFeatureManager.m_220497_(where, start)) continue;
                return override.f_210044_();
            }
        }
        return null;
    }

    public static boolean isStructureAtPosition(ServerLevel level, ResourceKey<Structure> structureKey, BlockPos pos) {
        Structure fortressFeature = (Structure)level.m_9598_().m_175515_(Registries.f_256944_).m_6246_(structureKey);
        if (fortressFeature == null) {
            return false;
        }
        return level.m_215010_().m_220494_(pos, fortressFeature).m_73603_();
    }

    public static List<StructureStart> startsForFeature(ServerLevel level, SectionPos sectionPos, StructureType<?> structure) {
        Map allrefs = level.m_46819_(sectionPos.m_123170_(), sectionPos.m_123222_(), ChunkStatus.f_62316_).m_62769_();
        ArrayList<StructureStart> result = new ArrayList<StructureStart>();
        for (Map.Entry entry : allrefs.entrySet()) {
            Structure existing = (Structure)entry.getKey();
            if (existing.m_213658_() != structure) continue;
            level.m_215010_().m_220480_(existing, (LongSet)entry.getValue(), result::add);
        }
        return result;
    }

    static {
        SpawnOverrides.addOverride(() -> CarpetSettings.huskSpawningInTemples, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.f_209850_, StructureSpawnOverride.BoundingBoxType.STRUCTURE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20458_, 1, 1, 1)}));
        SpawnOverrides.addOverride(() -> CarpetSettings.shulkerSpawningInEndCities, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.f_209861_, StructureSpawnOverride.BoundingBoxType.PIECE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20521_, 10, 4, 4)}));
        SpawnOverrides.addOverride(() -> CarpetSettings.piglinsSpawningInBastions, MobCategory.MONSTER, (ResourceKey<Structure>)BuiltinStructures.f_209863_, StructureSpawnOverride.BoundingBoxType.PIECE, (WeightedRandomList<MobSpawnSettings.SpawnerData>)WeightedRandomList.m_146330_((WeightedEntry[])new MobSpawnSettings.SpawnerData[]{new MobSpawnSettings.SpawnerData(EntityType.f_20512_, 5, 1, 2), new MobSpawnSettings.SpawnerData(EntityType.f_20511_, 10, 2, 4), new MobSpawnSettings.SpawnerData(EntityType.f_20456_, 2, 1, 2)}));
    }
}

