/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.utils.EvictingQueue;
import carpet.utils.Messenger;
import carpet.utils.WoolTool;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2LongMap;
import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.animal.Ocelot;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.StructureManager;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.structure.structures.NetherFortressStructure;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;

public class SpawnReporter {
    public static boolean mock_spawns = false;
    public static Long track_spawns = 0L;
    public static final HashMap<ResourceKey<Level>, Integer> chunkCounts = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Object2LongMap<EntityType<?>>> spawn_stats = new HashMap();
    public static double mobcap_exponent = 0.0;
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_attempts = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> overall_spawn_ticks = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_ticks_full = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_ticks_fail = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_ticks_succ = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_ticks_spawns = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, Long> spawn_cap_count = new HashMap();
    public static final HashMap<Pair<ResourceKey<Level>, MobCategory>, EvictingQueue<Pair<EntityType<?>, BlockPos>>> spawned_mobs = new HashMap();
    public static final HashMap<MobCategory, Integer> spawn_tries = new HashMap();
    public static BlockPos lower_spawning_limit = null;
    public static BlockPos upper_spawning_limit = null;
    public static HashMap<MobCategory, Long> local_spawns = null;
    public static HashSet<MobCategory> first_chunk_marker = null;
    public static final int MAGIC_NUMBER;

    public static void registerSpawn(Mob mob, MobCategory cat, BlockPos pos) {
        if (lower_spawning_limit != null && (lower_spawning_limit.m_123341_() > pos.m_123341_() || pos.m_123341_() > upper_spawning_limit.m_123341_() || lower_spawning_limit.m_123342_() > pos.m_123342_() || pos.m_123342_() > upper_spawning_limit.m_123342_() || lower_spawning_limit.m_123343_() > pos.m_123343_() || pos.m_123343_() > upper_spawning_limit.m_123343_())) {
            return;
        }
        Pair key = Pair.of((Object)mob.m_9236_().m_46472_(), (Object)cat);
        long count = spawn_stats.get(key).getOrDefault((Object)mob.m_6095_(), 0L);
        spawn_stats.get(key).put((Object)mob.m_6095_(), count + 1L);
        spawned_mobs.get(key).put(Pair.of((Object)mob.m_6095_(), (Object)pos));
        if (!local_spawns.containsKey(cat)) {
            CarpetSettings.LOG.error("Rogue spawn detected for category " + cat.m_21607_() + " for mob " + mob.m_6095_().m_20676_().getString() + ". If you see this message let carpet peeps know about it on github issues.");
            local_spawns.put(cat, 0L);
        }
        local_spawns.put(cat, local_spawns.get(cat) + 1L);
    }

    public static List<Component> printMobcapsForDimension(ServerLevel world, boolean multiline) {
        ResourceKey dim = world.m_46472_();
        String name = dim.m_135782_().m_135815_();
        ArrayList<Component> lst = new ArrayList<Component>();
        if (multiline) {
            lst.add(Messenger.s(String.format("Mobcaps for %s:", name)));
        }
        NaturalSpawner.SpawnState lastSpawner = world.m_7726_().m_8485_();
        Object2IntMap dimCounts = lastSpawner.m_47148_();
        int chunkcount = chunkCounts.getOrDefault(dim, -1);
        if (dimCounts == null || chunkcount < 0) {
            lst.add(Messenger.c("g   --UNAVAILABLE--"));
            return lst;
        }
        ArrayList<Object> shortCodes = new ArrayList<Object>();
        for (MobCategory enumcreaturetype : MobCategory.values()) {
            int cur = dimCounts.getOrDefault((Object)enumcreaturetype, -1);
            int max = (int)((double)chunkcount * ((double)enumcreaturetype.m_21608_() / (double)MAGIC_NUMBER));
            String color = Messenger.heatmap_color(cur, max);
            String mobColor = Messenger.creatureTypeColor(enumcreaturetype);
            if (multiline) {
                int rounds = spawn_tries.get(enumcreaturetype);
                lst.add(Messenger.c(String.format("w   %s: ", enumcreaturetype.m_21607_()), cur < 0 ? "g -" : color + " " + cur, "g  / ", mobColor + " " + max, rounds == 1 ? "w " : String.format("gi  (%d rounds/tick)", spawn_tries.get(enumcreaturetype))));
                continue;
            }
            shortCodes.add(color + " " + String.valueOf(cur < 0 ? "-" : Integer.valueOf(cur)));
            shortCodes.add("g /");
            shortCodes.add(mobColor + " " + max);
            shortCodes.add("g ,");
        }
        if (!multiline) {
            if (shortCodes.size() > 0) {
                shortCodes.remove(shortCodes.size() - 1);
                lst.add(Messenger.c(shortCodes.toArray(new Object[0])));
            } else {
                lst.add(Messenger.c("g   --UNAVAILABLE--"));
            }
        }
        return lst;
    }

    public static List<Component> recent_spawns(Level world, MobCategory creature_type) {
        ArrayList<Component> lst = new ArrayList<Component>();
        if (track_spawns == 0L) {
            lst.add(Messenger.s("Spawn tracking not started"));
            return lst;
        }
        String type_code = creature_type.m_21607_();
        lst.add(Messenger.s(String.format("Recent %s spawns:", type_code)));
        for (Pair pair : spawned_mobs.get(Pair.of((Object)world.m_46472_(), (Object)creature_type)).keySet()) {
            lst.add(Messenger.c("w  - ", Messenger.tp("wb", (BlockPos)pair.getRight()), String.format("w : %s", ((EntityType)pair.getLeft()).m_20676_().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Nothing spawned yet, sorry."));
        }
        return lst;
    }

    public static List<Component> show_mobcaps(BlockPos pos, ServerLevel worldIn) {
        DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.m_7495_());
        if (under == null) {
            if (track_spawns > 0L) {
                return SpawnReporter.tracking_report((Level)worldIn);
            }
            return SpawnReporter.printMobcapsForDimension(worldIn, true);
        }
        MobCategory creature_type = SpawnReporter.get_type_code_from_wool_code(under);
        if (creature_type != null) {
            if (track_spawns > 0L) {
                return SpawnReporter.recent_spawns((Level)worldIn, creature_type);
            }
            return SpawnReporter.printEntitiesByType(creature_type, (Level)worldIn, true);
        }
        if (track_spawns > 0L) {
            return SpawnReporter.tracking_report((Level)worldIn);
        }
        return SpawnReporter.printMobcapsForDimension(worldIn, true);
    }

    public static MobCategory get_type_code_from_wool_code(DyeColor color) {
        return switch (color) {
            case DyeColor.RED -> MobCategory.MONSTER;
            case DyeColor.GREEN -> MobCategory.CREATURE;
            case DyeColor.BLUE -> MobCategory.WATER_CREATURE;
            case DyeColor.BROWN -> MobCategory.AMBIENT;
            case DyeColor.CYAN -> MobCategory.WATER_AMBIENT;
            default -> null;
        };
    }

    public static List<Component> printEntitiesByType(MobCategory cat, Level worldIn, boolean all) {
        ArrayList<Component> lst = new ArrayList<Component>();
        lst.add(Messenger.s(String.format("Loaded entities for %s class:", cat)));
        for (Entity entity : ((ServerLevel)worldIn).m_143280_(EntityTypeTest.m_156916_(Entity.class), e -> e.m_6095_().m_20674_() == cat)) {
            boolean persistent;
            boolean bl = persistent = entity instanceof Mob && (((Mob)entity).m_21532_() || ((Mob)entity).m_8023_());
            if (!all && persistent) continue;
            EntityType type = entity.m_6095_();
            BlockPos pos = entity.m_20183_();
            lst.add(Messenger.c("w  - ", Messenger.tp(persistent ? "gb" : "wb", pos), String.format(persistent ? "g : %s" : "w : %s", type.m_20676_().getString())));
        }
        if (lst.size() == 1) {
            lst.add(Messenger.s(" - Empty."));
        }
        return lst;
    }

    public static void initialize_mocking() {
        mock_spawns = true;
    }

    public static void stop_mocking() {
        mock_spawns = false;
    }

    public static void reset_spawn_stats(MinecraftServer server, boolean full) {
        spawn_stats.clear();
        spawned_mobs.clear();
        for (MobCategory enumcreaturetype : MobCategory.values()) {
            if (full) {
                spawn_tries.put(enumcreaturetype, 1);
            }
            if (server == null) continue;
            for (ResourceKey dim : server.m_129784_()) {
                Pair key = Pair.of((Object)dim, (Object)enumcreaturetype);
                overall_spawn_ticks.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_attempts.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_ticks_full.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_ticks_fail.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_ticks_succ.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_ticks_spawns.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_cap_count.put((Pair<ResourceKey<Level>, MobCategory>)key, 0L);
                spawn_stats.put((Pair<ResourceKey<Level>, MobCategory>)key, (Object2LongMap<EntityType<?>>)new Object2LongOpenHashMap());
                spawned_mobs.put((Pair<ResourceKey<Level>, MobCategory>)key, new EvictingQueue());
            }
        }
        track_spawns = 0L;
    }

    private static String getWorldCode(ResourceKey<Level> world) {
        if (world == Level.f_46428_) {
            return "";
        }
        return "(" + world.m_135782_().m_135815_().toUpperCase(Locale.ROOT).replace("THE_", "").charAt(0) + ")";
    }

    public static List<Component> tracking_report(Level worldIn) {
        ArrayList<Component> report = new ArrayList<Component>();
        if (track_spawns == 0L) {
            report.add(Messenger.c("w Spawn tracking disabled, type '", "wi /spawn tracking start", "/spawn tracking start", "w ' to enable"));
            return report;
        }
        long duration = (long)worldIn.m_7654_().m_129921_() - track_spawns;
        report.add(Messenger.c("bw --------------------"));
        String simulated = mock_spawns ? "[SIMULATED] " : "";
        String location = lower_spawning_limit != null ? String.format("[in (%d, %d, %d)x(%d, %d, %d)]", lower_spawning_limit.m_123341_(), lower_spawning_limit.m_123342_(), lower_spawning_limit.m_123343_(), upper_spawning_limit.m_123341_(), upper_spawning_limit.m_123342_(), upper_spawning_limit.m_123343_()) : "";
        report.add(Messenger.s(String.format("%sSpawn statistics %s: for %.1f min", simulated, location, (double)duration / 72000.0 * 60.0)));
        for (MobCategory enumcreaturetype : MobCategory.values()) {
            for (ResourceKey dim : worldIn.m_7654_().m_129784_()) {
                Pair code = Pair.of((Object)dim, (Object)enumcreaturetype);
                if (spawn_ticks_spawns.get(code) <= 0L) continue;
                double hours = (double)overall_spawn_ticks.get(code).longValue() / 72000.0;
                report.add(Messenger.s(String.format(" > %s%s (%.1f min), %.1f m/t, %%{%.1fF %.1f- %.1f+}; %.2f s/att", enumcreaturetype.m_21607_().substring(0, 3), SpawnReporter.getWorldCode((ResourceKey<Level>)dim), 60.0 * hours, 1.0 * (double)spawn_cap_count.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_full.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_fail.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 100.0 * (double)spawn_ticks_succ.get(code).longValue() / (double)spawn_attempts.get(code).longValue(), 1.0 * (double)spawn_ticks_spawns.get(code).longValue() / (double)(spawn_ticks_fail.get(code) + spawn_ticks_succ.get(code)))));
                for (EntityType type : spawn_stats.get(code).keySet()) {
                    report.add(Messenger.s(String.format("   - %s: %d spawns, %d per hour", type.m_20676_().getString(), spawn_stats.get(code).getLong((Object)type), 72000L * spawn_stats.get(code).getLong((Object)type) / duration)));
                }
            }
        }
        return report;
    }

    public static void killEntity(LivingEntity entity) {
        if (entity.m_20159_()) {
            entity.m_20202_().m_146870_();
        }
        if (entity.m_20160_()) {
            for (Entity e : entity.m_20197_()) {
                e.m_146870_();
            }
        }
        if (entity instanceof Ocelot) {
            for (Entity e : entity.m_20193_().m_45933_((Entity)entity, entity.m_20191_())) {
                e.m_146870_();
            }
        }
        entity.m_146870_();
    }

    private static List<MobSpawnSettings.SpawnerData> getSpawnEntries(ServerLevel serverLevel, StructureManager structureManager, ChunkGenerator chunkGenerator, MobCategory mobCategory, BlockPos blockPos, @Nullable Holder<Biome> holder) {
        return NaturalSpawner.m_220455_((BlockPos)blockPos, (ServerLevel)serverLevel, (MobCategory)mobCategory, (StructureManager)structureManager) ? NetherFortressStructure.f_228517_.m_146338_() : chunkGenerator.m_223133_(holder != null ? holder : serverLevel.m_204166_(blockPos), structureManager, mobCategory, blockPos).m_146338_();
    }

    public static List<Component> report(BlockPos pos, ServerLevel worldIn) {
        ArrayList<Component> rep = new ArrayList<Component>();
        int x = pos.m_123341_();
        int y = pos.m_123342_();
        int z = pos.m_123343_();
        ChunkAccess chunk = worldIn.m_46865_(pos);
        int lc = chunk.m_5885_(Heightmap.Types.WORLD_SURFACE, x, z) + 1;
        String where = String.format(y >= lc ? "%d blocks above it." : "%d blocks below it.", Mth.m_14040_((int)(y - lc)));
        if (y == lc) {
            where = "right at it.";
        }
        rep.add(Messenger.s(String.format("Maximum spawn Y value for (%+d, %+d) is %d. You are " + where, x, z, lc)));
        rep.add(Messenger.s("Spawns:"));
        for (MobCategory enumcreaturetype : MobCategory.values()) {
            String type_code = String.format("%s", enumcreaturetype).substring(0, 3);
            List<MobSpawnSettings.SpawnerData> lst = SpawnReporter.getSpawnEntries(worldIn, worldIn.m_215010_(), worldIn.m_7726_().m_8481_(), enumcreaturetype, pos, (Holder<Biome>)worldIn.m_204166_(pos));
            if (lst == null || lst.isEmpty()) continue;
            for (MobSpawnSettings.SpawnerData spawnEntry : lst) {
                Mob mob;
                if (SpawnPlacements.m_21752_((EntityType)spawnEntry.f_48404_) == null) continue;
                boolean canspawn = NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)spawnEntry.f_48404_), (LevelReader)worldIn, (BlockPos)pos, (EntityType)spawnEntry.f_48404_);
                int will_spawn = -1;
                try {
                    mob = (Mob)spawnEntry.f_48404_.m_20615_((Level)worldIn);
                }
                catch (Exception exception) {
                    CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)exception);
                    return rep;
                }
                boolean fits_true = false;
                boolean fits_false = false;
                if (canspawn) {
                    will_spawn = 0;
                    for (int attempt = 0; attempt < 50; ++attempt) {
                        boolean fits;
                        float f = (float)x + 0.5f;
                        float f1 = (float)z + 0.5f;
                        mob.m_7678_((double)f, (double)y, (double)f1, worldIn.f_46441_.m_188501_() * 360.0f, 0.0f);
                        boolean fits1 = worldIn.m_45786_((Entity)mob);
                        EntityType etype = mob.m_6095_();
                        for (int i = 0; i < 20; ++i) {
                            if (!SpawnPlacements.m_217074_((EntityType)etype, (ServerLevelAccessor)worldIn, (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)pos, (RandomSource)worldIn.f_46441_) || !NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.m_21752_((EntityType)etype), (LevelReader)worldIn, (BlockPos)pos, (EntityType)etype) || !mob.m_5545_((LevelAccessor)worldIn, MobSpawnType.NATURAL)) continue;
                            if (etype == EntityType.f_20505_) {
                                BlockState blockState = worldIn.m_8055_(pos.m_7495_());
                                if (pos.m_123342_() < worldIn.m_5736_() || !blockState.m_60713_(Blocks.f_50440_) && !blockState.m_204336_(BlockTags.f_13035_)) continue;
                            }
                            ++will_spawn;
                        }
                        mob.m_6518_((ServerLevelAccessor)worldIn, worldIn.m_6436_(mob.m_20183_()), MobSpawnType.NATURAL, null, null);
                        boolean bl = fits = fits1 && worldIn.m_45786_((Entity)mob);
                        if (fits) {
                            fits_true = true;
                        } else {
                            fits_false = true;
                        }
                        SpawnReporter.killEntity((LivingEntity)mob);
                        try {
                            mob = (Mob)spawnEntry.f_48404_.m_20615_((Level)worldIn);
                            continue;
                        }
                        catch (Exception exception) {
                            CarpetSettings.LOG.warn("Exception while creating mob for spawn reporter", (Throwable)exception);
                            return rep;
                        }
                    }
                }
                String creature_name = mob.m_6095_().m_20676_().getString();
                String pack_size = String.format("%d", mob.m_5792_());
                int weight = spawnEntry.m_142631_().m_146281_();
                if (canspawn) {
                    String c = fits_true && will_spawn > 0 ? "e" : "gi";
                    rep.add(Messenger.c(String.format("%s %s: %s (%d:%d-%d/%d), can: ", c, type_code, creature_name, weight, spawnEntry.f_48405_, spawnEntry.f_48406_, mob.m_5792_()), "l YES", c + " , fit: ", fits_true && fits_false ? "y YES and NO" : (fits_true ? "l YES" : "r NO"), c + " , will: ", (will_spawn > 0 ? "l " : "r ") + Math.round((double)will_spawn) / 10L + "%"));
                } else {
                    rep.add(Messenger.c(String.format("gi %s: %s (%d:%d-%d/%d), can: ", type_code, creature_name, weight, spawnEntry.f_48405_, spawnEntry.f_48406_, mob.m_5792_()), "n NO"));
                }
                SpawnReporter.killEntity((LivingEntity)mob);
            }
        }
        return rep;
    }

    static {
        SpawnReporter.reset_spawn_stats(null, true);
        MAGIC_NUMBER = (int)Math.pow(17.0, 2.0);
    }
}

