/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.BlockInfo;
import carpet.utils.DistanceCalculator;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WoolTool {
    private static final Map<Block, DyeColor> WOOL_BLOCK_TO_DYE = Map.ofEntries(Map.entry(Blocks.f_50041_, DyeColor.WHITE), Map.entry(Blocks.f_50042_, DyeColor.ORANGE), Map.entry(Blocks.f_50096_, DyeColor.MAGENTA), Map.entry(Blocks.f_50097_, DyeColor.LIGHT_BLUE), Map.entry(Blocks.f_50098_, DyeColor.YELLOW), Map.entry(Blocks.f_50099_, DyeColor.LIME), Map.entry(Blocks.f_50100_, DyeColor.PINK), Map.entry(Blocks.f_50101_, DyeColor.GRAY), Map.entry(Blocks.f_50102_, DyeColor.LIGHT_GRAY), Map.entry(Blocks.f_50103_, DyeColor.CYAN), Map.entry(Blocks.f_50104_, DyeColor.PURPLE), Map.entry(Blocks.f_50105_, DyeColor.BLUE), Map.entry(Blocks.f_50106_, DyeColor.BROWN), Map.entry(Blocks.f_50107_, DyeColor.GREEN), Map.entry(Blocks.f_50108_, DyeColor.RED), Map.entry(Blocks.f_50109_, DyeColor.BLACK));

    public static void carpetPlacedAction(DyeColor color, Player placer, BlockPos pos, ServerLevel worldIn) {
        if (!CarpetSettings.carpets) {
            return;
        }
        switch (color) {
            case PINK: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.report(pos, worldIn));
                break;
            }
            case BLACK: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.show_mobcaps(pos, worldIn));
                break;
            }
            case BROWN: {
                if ("false".equals(CarpetSettings.commandDistance)) break;
                CommandSourceStack source = placer.m_20203_();
                if (!DistanceCalculator.hasStartingPoint(source) || placer.m_6144_()) {
                    DistanceCalculator.setStart(source, Vec3.m_82528_((Vec3i)pos));
                    break;
                }
                DistanceCalculator.setEnd(source, Vec3.m_82528_((Vec3i)pos));
                break;
            }
            case GRAY: {
                if ("false".equals(CarpetSettings.commandInfo)) break;
                Messenger.send(placer, BlockInfo.blockInfo(pos.m_7495_(), worldIn));
                break;
            }
            case GREEN: {
                if (!CarpetSettings.hopperCounters) break;
                DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.m_7495_());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                Messenger.send(placer, counter.format(worldIn.m_7654_(), false, false));
                break;
            }
            case RED: {
                if (!CarpetSettings.hopperCounters) break;
                DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.m_7495_());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                counter.reset(placer.m_20194_());
                ArrayList<Component> res = new ArrayList<Component>();
                res.add(Messenger.s(String.format("%s counter reset", under.toString())));
                Messenger.send(placer, res);
            }
        }
    }

    @Nullable
    public static DyeColor getWoolColorAtPosition(Level worldIn, BlockPos pos) {
        BlockState state = worldIn.m_8055_(pos);
        return WOOL_BLOCK_TO_DYE.get(state.m_60734_());
    }
}

