/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.EntityInterface;
import carpet.fakes.PortalProcessorInterface;
import carpet.script.EntityEventsGroup;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PortalProcessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={Entity.class})
public abstract class Entity_scarpetEventsMixin
implements EntityInterface {
    @Shadow
    private int portalCooldown;
    @Shadow
    private Vec3 position;
    @Shadow
    private Vec3 deltaMovement;
    @Shadow
    @Nullable
    public PortalProcessor portalProcess;
    private boolean permanentVehicle;
    private final EntityEventsGroup events = new EntityEventsGroup((Entity)this);
    private Vec3 pos1;
    private Vec3 motion;

    @Shadow
    public abstract boolean isRemoved();

    @Override
    public EntityEventsGroup getEventContainer() {
        return this.events;
    }

    @Override
    public boolean isPermanentVehicle() {
        return this.permanentVehicle;
    }

    @Override
    public void setPermanentVehicle(boolean permanent) {
        this.permanentVehicle = permanent;
    }

    @Override
    public int getPublicNetherPortalCooldown() {
        return this.portalCooldown;
    }

    @Override
    public void setPublicNetherPortalCooldown(int what) {
        this.portalCooldown = what;
    }

    @Override
    public int getPortalTimer() {
        return this.portalProcess.getPortalTime();
    }

    @Override
    public void setPortalTimer(int amount) {
        ((PortalProcessorInterface)this.portalProcess).setPortalTime(amount);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTickCall(CallbackInfo ci) {
        this.events.onEvent(EntityEventsGroup.Event.ON_TICK, new Object[0]);
    }

    @Inject(method={"remove"}, at={@At(value="HEAD")})
    private void onRemove(CallbackInfo ci) {
        if (!this.isRemoved()) {
            this.events.onEvent(EntityEventsGroup.Event.ON_REMOVED, new Object[0]);
        }
    }

    @Inject(method={"setPosRaw"}, at={@At(value="HEAD")})
    private void firstPos(CallbackInfo ci) {
        this.pos1 = this.position;
        this.motion = this.deltaMovement;
    }

    @Inject(method={"setPosRaw"}, at={@At(value="TAIL")})
    private void secondPos(CallbackInfo ci) {
        if (this.pos1 != this.position) {
            this.events.onEvent(EntityEventsGroup.Event.ON_MOVE, this.motion, this.pos1, this.position);
        }
    }
}

