/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.CarpetEventServer;
import carpet.script.CarpetScriptHost;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.argument.FunctionArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class Entities {
    private static ListValue getPlayersFromWorldMatching(Context c, Predicate<ServerPlayer> condition) {
        ArrayList<Value> ret = new ArrayList<Value>();
        for (ServerPlayer player : ((CarpetContext)c).level().players()) {
            if (!condition.test(player)) continue;
            ret.add(new EntityValue((Entity)player));
        }
        return ListValue.wrap(ret);
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("player", -1, (c, t, lv) -> {
            String playerName;
            if (lv.isEmpty()) {
                CarpetContext cc = (CarpetContext)c;
                if (cc.host.user != null) {
                    ServerPlayer player = cc.server().getPlayerList().getPlayerByName(cc.host.user);
                    return EntityValue.of((Entity)player);
                }
                Entity callingEntity = cc.source().getEntity();
                if (callingEntity instanceof Player) {
                    return EntityValue.of(callingEntity);
                }
                Vec3 pos = ((CarpetContext)c).source().getPosition();
                Player closestPlayer = ((CarpetContext)c).level().getNearestPlayer(pos.x, pos.y, pos.z, -1.0, EntitySelector.ENTITY_STILL_ALIVE);
                return EntityValue.of((Entity)closestPlayer);
            }
            return switch (playerName = ((Value)lv.get(0)).getString()) {
                case "all" -> {
                    ArrayList<Value> ret = new ArrayList<Value>();
                    for (ServerPlayer player : ((CarpetContext)c).server().getPlayerList().getPlayers()) {
                        ret.add(new EntityValue((Entity)player));
                    }
                    yield ListValue.wrap(ret);
                }
                case "*" -> Entities.getPlayersFromWorldMatching(c, p -> true);
                case "survival" -> Entities.getPlayersFromWorldMatching(c, p -> p.gameMode.isSurvival());
                case "creative" -> Entities.getPlayersFromWorldMatching(c, ServerPlayer::isCreative);
                case "spectating" -> Entities.getPlayersFromWorldMatching(c, ServerPlayer::isSpectator);
                case "!spectating" -> Entities.getPlayersFromWorldMatching(c, p -> !p.isSpectator());
                default -> {
                    ServerPlayer player = ((CarpetContext)c).server().getPlayerList().getPlayerByName(playerName);
                    if (player != null) {
                        yield new EntityValue((Entity)player);
                    }
                    yield Value.NULL;
                }
            };
        });
        expression.addContextFunction("spawn", -1, (c, t, lv) -> {
            ResourceLocation entityId;
            CarpetContext cc = (CarpetContext)c;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'spawn' function takes mob name, and position to spawn");
            }
            String entityString = ((Value)lv.get(0)).getString();
            try {
                entityId = ResourceLocation.read((StringReader)new StringReader(entityString));
                EntityType type = cc.registry(Registries.ENTITY_TYPE).getOptional(entityId).orElse(null);
                if (type == null || !type.canSummon()) {
                    return Value.NULL;
                }
            }
            catch (CommandSyntaxException ignored) {
                return Value.NULL;
            }
            Vector3Argument position = Vector3Argument.findIn(lv, 1);
            if (position.fromBlock) {
                position.vec = position.vec.subtract(0.0, 0.5, 0.0);
            }
            CompoundTag tag = new CompoundTag();
            boolean hasTag = false;
            if (lv.size() > position.offset) {
                NBTSerializableValue nbtsv;
                Value nbt = (Value)lv.get(position.offset);
                NBTSerializableValue v = nbt instanceof NBTSerializableValue ? (nbtsv = (NBTSerializableValue)nbt) : NBTSerializableValue.parseStringOrFail(nbt.getString());
                hasTag = true;
                tag = v.getCompoundTag();
            }
            tag.putString("id", entityId.toString());
            Vec3 vec3d = position.vec;
            ServerLevel serverWorld = cc.level();
            Entity entity = EntityType.loadEntityRecursive((CompoundTag)tag, (Level)serverWorld, e -> {
                e.moveTo(vec3d.x, vec3d.y, vec3d.z, e.getYRot(), e.getXRot());
                return e;
            });
            if (entity == null) {
                return Value.NULL;
            }
            if (!hasTag && entity instanceof Mob) {
                Mob mob = (Mob)entity;
                mob.finalizeSpawn((ServerLevelAccessor)serverWorld, serverWorld.getCurrentDifficultyAt(entity.blockPosition()), MobSpawnType.COMMAND, null);
            }
            if (!serverWorld.tryAddFreshEntityWithPassengers(entity)) {
                entity.discard();
                return Value.NULL;
            }
            return new EntityValue(entity);
        });
        expression.addContextFunction("entity_id", 1, (c, t, lv) -> {
            Value who = (Value)lv.get(0);
            if (who instanceof NumericValue) {
                NumericValue numericValue = (NumericValue)who;
                return EntityValue.of(((CarpetContext)c).level().getEntity((int)numericValue.getLong()));
            }
            return EntityValue.of(((CarpetContext)c).level().getEntity(UUID.fromString(who.getString())));
        });
        expression.addContextFunction("entity_list", 1, (c, t, lv) -> {
            String who = ((Value)lv.get(0)).getString();
            CommandSourceStack source = ((CarpetContext)c).source();
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who, source.getServer());
            List entityList = source.getLevel().getEntities(eDesc.directType, eDesc.filteringPredicate);
            return ListValue.wrap(entityList.stream().map(EntityValue::new));
        });
        expression.addContextFunction("entity_area", -1, (c, t, lv) -> {
            AABB centerBox;
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_area' requires entity type, center and range arguments");
            }
            String who = ((Value)lv.get(0)).getString();
            CarpetContext cc = (CarpetContext)c;
            Vector3Argument centerLocator = Vector3Argument.findIn(lv, 1, false, true);
            if (centerLocator.entity != null) {
                centerBox = centerLocator.entity.getBoundingBox();
            } else {
                Vec3 center = centerLocator.vec;
                if (centerLocator.fromBlock) {
                    center.add(0.5, 0.5, 0.5);
                }
                centerBox = new AABB(center, center);
            }
            Vector3Argument rangeLocator = Vector3Argument.findIn(lv, centerLocator.offset);
            if (rangeLocator.fromBlock) {
                throw new InternalExpressionException("Range of 'entity_area' cannot come from a block argument");
            }
            Vec3 range = rangeLocator.vec;
            AABB area = centerBox.inflate(range.x, range.y, range.z);
            EntityValue.EntityClassDescriptor eDesc = EntityValue.getEntityDescriptor(who, cc.server());
            List entityList = cc.level().getEntities(eDesc.directType, area, eDesc.filteringPredicate);
            return ListValue.wrap(entityList.stream().map(EntityValue::new));
        });
        expression.addContextFunction("entity_selector", -1, (c, t, lv) -> {
            String selector = ((Value)lv.get(0)).getString();
            ArrayList<Value> retlist = new ArrayList<Value>();
            for (Entity entity : EntityValue.getEntitiesFromSelector(((CarpetContext)c).source(), selector)) {
                retlist.add(new EntityValue(entity));
            }
            return ListValue.wrap(retlist);
        });
        expression.addContextFunction("query", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'query' takes entity as a first argument, and queried feature as a second");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to query should be an entity");
            }
            EntityValue ev = (EntityValue)v;
            String what = ((Value)lv.get(1)).getString().toLowerCase(Locale.ROOT);
            if (what.equals("tags")) {
                c.host.issueDeprecation("'tags' for entity querying");
            }
            return switch (lv.size()) {
                case 2 -> ev.get(what, null);
                case 3 -> ev.get(what, (Value)lv.get(2));
                default -> ev.get(what, ListValue.wrap(lv.subList(2, lv.size())));
            };
        });
        expression.addContextFunction("modify", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'modify' takes entity as a first argument, and queried feature as a second");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to modify should be an entity");
            }
            EntityValue ev = (EntityValue)v;
            String what = ((Value)lv.get(1)).getString();
            switch (lv.size()) {
                case 2: {
                    ev.set(what, null);
                    break;
                }
                case 3: {
                    ev.set(what, (Value)lv.get(2));
                    break;
                }
                default: {
                    ev.set(what, ListValue.wrap(lv.subList(2, lv.size())));
                }
            }
            return v;
        });
        expression.addContextFunction("entity_types", -1, (c, t, lv) -> {
            if (lv.size() > 1) {
                throw new InternalExpressionException("'entity_types' requires one or no arguments");
            }
            String desc = lv.size() == 1 ? ((Value)lv.get(0)).getString() : "*";
            return EntityValue.getEntityDescriptor(desc, ((CarpetContext)c).server()).listValue(((CarpetContext)c).registryAccess());
        });
        expression.addContextFunction("entity_load_handler", -1, (c, t, lv) -> {
            List<String> list;
            if (lv.size() < 2) {
                throw new InternalExpressionException("'entity_load_handler' required the entity type, and a function to call");
            }
            Value entityValue = (Value)lv.get(0);
            if (entityValue instanceof ListValue) {
                ListValue list2 = (ListValue)entityValue;
                list = list2.getItems().stream().map(Value::getString).toList();
            } else {
                list = Collections.singletonList(entityValue.getString());
            }
            List<String> descriptors = list;
            HashSet types = new HashSet();
            descriptors.forEach(s -> types.addAll(EntityValue.getEntityDescriptor((String)s, (MinecraftServer)((CarpetContext)c).server()).types));
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 1, true, false);
            CarpetEventServer events = ((CarpetScriptHost)c.host).scriptServer().events;
            if (funArg.function == null) {
                types.forEach(et -> events.removeBuiltInEvent(CarpetEventServer.Event.getEntityLoadEventName((EntityType<? extends Entity>)et), (CarpetScriptHost)c.host));
                types.forEach(et -> events.removeBuiltInEvent(CarpetEventServer.Event.getEntityHandlerEventName((EntityType<? extends Entity>)et), (CarpetScriptHost)c.host));
            } else {
                int numberOfArguments = funArg.function.getArguments().size() - funArg.args.size();
                if (numberOfArguments == 1) {
                    c.host.issueDeprecation("entity_load_handler() with single argument callback");
                    types.forEach(et -> events.addBuiltInEvent(CarpetEventServer.Event.getEntityLoadEventName((EntityType<? extends Entity>)et), c.host, funArg.function, funArg.args));
                } else {
                    types.forEach(et -> events.addBuiltInEvent(CarpetEventServer.Event.getEntityHandlerEventName((EntityType<? extends Entity>)et), c.host, funArg.function, funArg.args));
                }
            }
            return new NumericValue(types.size());
        });
        expression.addContextFunction("entity_event", -1, (c, t, lv) -> {
            if (lv.size() < 3) {
                throw new InternalExpressionException("'entity_event' requires at least 3 arguments, entity, event to be handled, and function name, with optional arguments");
            }
            Value v = (Value)lv.get(0);
            if (!(v instanceof EntityValue)) {
                throw new InternalExpressionException("First argument to entity_event should be an entity");
            }
            EntityValue ev = (EntityValue)v;
            String what = ((Value)lv.get(1)).getString();
            FunctionArgument funArg = FunctionArgument.findIn(c, expression.module, lv, 2, true, false);
            ev.setEvent((CarpetContext)c, what, funArg.function, funArg.args);
            return Value.NULL;
        });
    }
}

