/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptHost;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import net.minecraft.SharedConstants;
import net.minecraft.server.packs.PackType;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.level.storage.LevelResource;
import net.minecraft.world.phys.Vec2;

public class SystemInfo {
    private static final Map<String, Function<CarpetContext, Value>> options = new HashMap<String, Function<CarpetContext, Value>>(){
        {
            this.put("app_name", c -> {
                String name = c.host.getName();
                return name == null ? Value.NULL : new StringValue(name);
            });
            this.put("app_list", c -> ListValue.wrap(((CarpetScriptHost)c.host).scriptServer().modules.keySet().stream().filter(Objects::nonNull).map(StringValue::new)));
            this.put("app_scope", c -> StringValue.of(c.host.isPerUser() ? "player" : "global"));
            this.put("app_players", c -> ListValue.wrap(c.host.getUserList().stream().map(StringValue::new)));
            this.put("world_name", c -> new StringValue(c.server().getWorldData().getLevelName()));
            this.put("world_seed", c -> new NumericValue(c.level().getSeed()));
            this.put("server_motd", c -> StringValue.of(c.server().getMotd()));
            this.put("world_path", c -> StringValue.of(c.server().getWorldPath(LevelResource.ROOT).toString()));
            this.put("world_folder", c -> {
                Path serverPath = c.server().getWorldPath(LevelResource.ROOT);
                int nodeCount = serverPath.getNameCount();
                if (nodeCount < 2) {
                    return Value.NULL;
                }
                String tlf = serverPath.getName(nodeCount - 2).toString();
                return StringValue.of(tlf);
            });
            this.put("world_dimensions", c -> ListValue.wrap(c.server().levelKeys().stream().map(k -> ValueConversions.of(k.location()))));
            this.put("world_spawn_point", c -> ValueConversions.of(c.server().overworld().getLevelData().getSpawnPos()));
            this.put("world_bottom", c -> new NumericValue(c.level().getMinBuildHeight()));
            this.put("world_top", c -> new NumericValue(c.level().getMaxBuildHeight()));
            this.put("world_center", c -> {
                WorldBorder worldBorder = c.level().getWorldBorder();
                return ListValue.fromTriple(worldBorder.getCenterX(), 0.0, worldBorder.getCenterZ());
            });
            this.put("world_size", c -> new NumericValue(c.level().getWorldBorder().getSize() / 2.0));
            this.put("world_max_size", c -> new NumericValue(c.level().getWorldBorder().getAbsoluteMaxSize()));
            this.put("world_time", c -> new NumericValue(c.level().getGameTime()));
            this.put("game_difficulty", c -> StringValue.of(c.server().getWorldData().getDifficulty().getKey()));
            this.put("game_hardcore", c -> BooleanValue.of(c.server().getWorldData().isHardcore()));
            this.put("game_storage_format", c -> StringValue.of(c.server().getWorldData().getStorageVersionName(c.server().getWorldData().getVersion())));
            this.put("game_default_gamemode", c -> StringValue.of(c.server().getDefaultGameType().getName()));
            this.put("game_max_players", c -> new NumericValue(c.server().getMaxPlayers()));
            this.put("game_view_distance", c -> new NumericValue(c.server().getPlayerList().getViewDistance()));
            this.put("game_mod_name", c -> StringValue.of(c.server().getServerModName()));
            this.put("game_version", c -> StringValue.of(c.server().getServerVersion()));
            this.put("game_target", c -> StringValue.of(String.format("1.%d.%d", Vanilla.MinecraftServer_getReleaseTarget(c.server())[0], Vanilla.MinecraftServer_getReleaseTarget(c.server())[1])));
            this.put("game_protocol", c -> NumericValue.of(SharedConstants.getProtocolVersion()));
            this.put("game_major_target", c -> NumericValue.of(Vanilla.MinecraftServer_getReleaseTarget(c.server())[0]));
            this.put("game_minor_target", c -> NumericValue.of(Vanilla.MinecraftServer_getReleaseTarget(c.server())[1]));
            this.put("game_stable", c -> BooleanValue.of(SharedConstants.getCurrentVersion().isStable()));
            this.put("game_data_version", c -> NumericValue.of(SharedConstants.getCurrentVersion().getDataVersion().getVersion()));
            this.put("game_pack_version", c -> NumericValue.of(SharedConstants.getCurrentVersion().getPackVersion(PackType.SERVER_DATA)));
            this.put("server_ip", c -> StringValue.of(c.server().getLocalIp()));
            this.put("server_whitelisted", c -> BooleanValue.of(c.server().isEnforceWhitelist()));
            this.put("server_whitelist", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.server().getPlayerList().getWhiteListNames()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_players", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.server().getPlayerList().getBans().getUserList()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_banned_ips", c -> {
                MapValue whitelist = new MapValue(Collections.emptyList());
                for (String s : c.server().getPlayerList().getIpBans().getUserList()) {
                    whitelist.append(StringValue.of(s));
                }
                return whitelist;
            });
            this.put("server_dev_environment", c -> BooleanValue.of(Vanilla.isDevelopmentEnvironment()));
            this.put("server_mods", c -> Vanilla.getServerMods(c.server()));
            this.put("server_last_tick_times", c -> {
                int currentReportedTick = c.server().getTickCount() - 1;
                ArrayList<Value> ticks = new ArrayList<Value>(100);
                long[] tickArray = c.server().getTickTimesNanos();
                for (int i = currentReportedTick + 100; i > currentReportedTick; --i) {
                    ticks.add(new NumericValue((double)tickArray[i % 100] / 1000000.0));
                }
                return ListValue.wrap(ticks);
            });
            this.put("java_max_memory", c -> new NumericValue(Runtime.getRuntime().maxMemory()));
            this.put("java_allocated_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory()));
            this.put("java_used_memory", c -> new NumericValue(Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()));
            this.put("java_cpu_count", c -> new NumericValue(Runtime.getRuntime().availableProcessors()));
            this.put("java_version", c -> StringValue.of(System.getProperty("java.version")));
            this.put("java_bits", c -> {
                for (String property : new String[]{"sun.arch.data.model", "com.ibm.vm.bitmode", "os.arch"}) {
                    String value = System.getProperty(property);
                    if (value == null || !value.contains("64")) continue;
                    return new NumericValue(64L);
                }
                return new NumericValue(32L);
            });
            this.put("java_system_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getCpuLoad());
            });
            this.put("java_process_cpu_load", c -> {
                OperatingSystemMXBean osBean = ManagementFactory.getPlatformMXBean(OperatingSystemMXBean.class);
                return new NumericValue(osBean.getProcessCpuLoad());
            });
            this.put("world_carpet_rules", c -> Carpet.getAllCarpetRules());
            this.put("world_gamerules", c -> {
                final HashMap<Value, Value> rules = new HashMap<Value, Value>();
                final GameRules gameRules = c.level().getGameRules();
                GameRules.visitGameRuleTypes((GameRules.GameRuleTypeVisitor)new GameRules.GameRuleTypeVisitor(){

                    public <T extends GameRules.Value<T>> void visit(GameRules.Key<T> key, GameRules.Type<T> type) {
                        rules.put(StringValue.of(key.getId()), StringValue.of(gameRules.getRule(key).toString()));
                    }
                });
                return MapValue.wrap(rules);
            });
            this.put("world_min_spawning_light", c -> NumericValue.of(c.level().dimensionType().monsterSpawnBlockLightLimit()));
            this.put("source_entity", c -> EntityValue.of(c.source().getEntity()));
            this.put("source_position", c -> ValueConversions.of(c.source().getPosition()));
            this.put("source_dimension", c -> ValueConversions.of(c.level()));
            this.put("source_rotation", c -> {
                Vec2 rotation = c.source().getRotation();
                return ListValue.of(new NumericValue(rotation.x), new NumericValue(rotation.y));
            });
            this.put("scarpet_version", c -> StringValue.of(Carpet.getCarpetVersion()));
        }
    };

    public static Value get(String what, CarpetContext cc) {
        return options.getOrDefault(what, c -> null).apply(cc);
    }

    public static Value getAll() {
        return ListValue.wrap(options.keySet().stream().map(StringValue::of));
    }
}

