/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ambient.AmbientCreature;
import net.minecraft.world.entity.animal.WaterAnimal;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.biome.MobSpawnSettings;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;

public class PerimeterDiagnostics {
    private MobSpawnSettings.SpawnerData sle = null;
    private ServerLevel worldServer;
    private MobCategory ctype;
    private Mob el;

    private PerimeterDiagnostics(ServerLevel server, MobCategory ctype, Mob el) {
        this.worldServer = server;
        this.ctype = ctype;
        this.el = el;
    }

    public static Result countSpots(ServerLevel worldserver, BlockPos epos, Mob el) {
        int eY = epos.getY();
        int eX = epos.getX();
        int eZ = epos.getZ();
        Result result = new Result();
        boolean add_water = false;
        boolean add_ground = false;
        MobCategory ctype = null;
        if (el != null) {
            if (el instanceof WaterAnimal) {
                add_water = true;
                ctype = MobCategory.WATER_CREATURE;
            } else if (el instanceof AgeableMob) {
                add_ground = true;
                ctype = MobCategory.CREATURE;
            } else if (el instanceof Enemy) {
                add_ground = true;
                ctype = MobCategory.MONSTER;
            } else if (el instanceof AmbientCreature) {
                ctype = MobCategory.AMBIENT;
            }
        }
        PerimeterDiagnostics diagnostic = new PerimeterDiagnostics(worldserver, ctype, el);
        EntityType type = EntityType.ZOMBIE;
        if (el != null) {
            type = el.getType();
        }
        int minY = worldserver.getMinBuildHeight();
        int maxY = worldserver.getMaxBuildHeight();
        for (int x = -128; x <= 128; ++x) {
            for (int z = -128; z <= 128; ++z) {
                if (x * x + z * z > 16384) continue;
                for (int y = minY; y < maxY; ++y) {
                    boolean flag;
                    int distsq;
                    if (Math.abs(y - eY) > 128 || (distsq = x * x + (eY - y) * (eY - y) + z * z) > 16384 || distsq < 576) continue;
                    BlockPos pos = new BlockPos(eX + x, y, eZ + z);
                    BlockState iblockstate = worldserver.getBlockState(pos);
                    BlockState iblockstate_down = worldserver.getBlockState(pos.below());
                    BlockState iblockstate_up = worldserver.getBlockState(pos.above());
                    if (iblockstate.getFluidState().is(FluidTags.WATER) && !iblockstate_up.isRedstoneConductor((BlockGetter)worldserver, pos)) {
                        ++result.liquid;
                        if (!add_water || !diagnostic.check_entity_spawn(pos)) continue;
                        ++result.specific;
                        if (result.samples.size() >= 10) continue;
                        result.samples.add(pos);
                        continue;
                    }
                    if (!iblockstate_down.isRedstoneConductor((BlockGetter)worldserver, pos)) continue;
                    Block block = iblockstate_down.getBlock();
                    boolean bl = flag = block != Blocks.BEDROCK && block != Blocks.BARRIER;
                    if (!flag || !NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)worldserver, (BlockPos)pos, (BlockState)iblockstate, (FluidState)iblockstate.getFluidState(), (EntityType)type) || !NaturalSpawner.isValidEmptySpawnBlock((BlockGetter)worldserver, (BlockPos)pos.above(), (BlockState)iblockstate_up, (FluidState)iblockstate_up.getFluidState(), (EntityType)type)) continue;
                    ++result.ground;
                    if (!add_ground || !diagnostic.check_entity_spawn(pos)) continue;
                    ++result.specific;
                    if (result.samples.size() >= 10) continue;
                    result.samples.add(pos);
                }
            }
        }
        return result;
    }

    private boolean check_entity_spawn(BlockPos pos) {
        if (this.sle == null || !this.worldServer.getChunkSource().getGenerator().getMobsAt(this.worldServer.getBiome(pos), this.worldServer.structureManager(), this.ctype, pos).unwrap().contains(this.sle)) {
            this.sle = null;
            for (MobSpawnSettings.SpawnerData sle : this.worldServer.getChunkSource().getGenerator().getMobsAt(this.worldServer.getBiome(pos), this.worldServer.structureManager(), this.ctype, pos).unwrap()) {
                if (this.el.getType() != sle.type) continue;
                this.sle = sle;
                break;
            }
            if (this.sle == null || !this.worldServer.getChunkSource().getGenerator().getMobsAt(this.worldServer.getBiome(pos), this.worldServer.structureManager(), this.ctype, pos).unwrap().contains(this.sle)) {
                return false;
            }
        }
        if (SpawnPlacements.isSpawnPositionOk((EntityType)this.sle.type, (LevelReader)this.worldServer, (BlockPos)pos)) {
            this.el.moveTo((double)((float)pos.getX() + 0.5f), (double)pos.getY(), (double)((float)pos.getZ() + 0.5f), 0.0f, 0.0f);
            return this.el.checkSpawnObstruction((LevelReader)this.worldServer) && this.el.checkSpawnRules((LevelAccessor)this.worldServer, MobSpawnType.NATURAL) && SpawnPlacements.checkSpawnRules((EntityType)this.el.getType(), (ServerLevelAccessor)((ServerLevel)this.el.getCommandSenderWorld()), (MobSpawnType)MobSpawnType.NATURAL, (BlockPos)this.el.blockPosition(), (RandomSource)this.el.getCommandSenderWorld().random) && this.worldServer.noCollision((Entity)this.el);
        }
        return false;
    }

    public static class Result {
        public int liquid;
        public int ground;
        public int specific;
        public List<BlockPos> samples = new ArrayList<BlockPos>();

        Result() {
        }
    }
}

