/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.CarpetSettings;
import carpet.helpers.HopperCounter;
import carpet.utils.BlockInfo;
import carpet.utils.DistanceCalculator;
import carpet.utils.Messenger;
import carpet.utils.SpawnReporter;
import java.util.ArrayList;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;

public class WoolTool {
    private static final Map<Block, DyeColor> WOOL_BLOCK_TO_DYE = Map.ofEntries(Map.entry(Blocks.WHITE_WOOL, DyeColor.WHITE), Map.entry(Blocks.ORANGE_WOOL, DyeColor.ORANGE), Map.entry(Blocks.MAGENTA_WOOL, DyeColor.MAGENTA), Map.entry(Blocks.LIGHT_BLUE_WOOL, DyeColor.LIGHT_BLUE), Map.entry(Blocks.YELLOW_WOOL, DyeColor.YELLOW), Map.entry(Blocks.LIME_WOOL, DyeColor.LIME), Map.entry(Blocks.PINK_WOOL, DyeColor.PINK), Map.entry(Blocks.GRAY_WOOL, DyeColor.GRAY), Map.entry(Blocks.LIGHT_GRAY_WOOL, DyeColor.LIGHT_GRAY), Map.entry(Blocks.CYAN_WOOL, DyeColor.CYAN), Map.entry(Blocks.PURPLE_WOOL, DyeColor.PURPLE), Map.entry(Blocks.BLUE_WOOL, DyeColor.BLUE), Map.entry(Blocks.BROWN_WOOL, DyeColor.BROWN), Map.entry(Blocks.GREEN_WOOL, DyeColor.GREEN), Map.entry(Blocks.RED_WOOL, DyeColor.RED), Map.entry(Blocks.BLACK_WOOL, DyeColor.BLACK));

    public static void carpetPlacedAction(DyeColor color, Player placer, BlockPos pos, ServerLevel worldIn) {
        if (!CarpetSettings.carpets) {
            return;
        }
        switch (color) {
            case PINK: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.report(pos, worldIn));
                break;
            }
            case BLACK: {
                if ("false".equals(CarpetSettings.commandSpawn)) break;
                Messenger.send(placer, SpawnReporter.handleWoolAction(pos, worldIn));
                break;
            }
            case BROWN: {
                if ("false".equals(CarpetSettings.commandDistance)) break;
                CommandSourceStack source = placer.createCommandSourceStack();
                if (!DistanceCalculator.hasStartingPoint(source) || placer.isShiftKeyDown()) {
                    DistanceCalculator.setStart(source, Vec3.atLowerCornerOf((Vec3i)pos));
                    break;
                }
                DistanceCalculator.setEnd(source, Vec3.atLowerCornerOf((Vec3i)pos));
                break;
            }
            case GRAY: {
                if ("false".equals(CarpetSettings.commandInfo)) break;
                Messenger.send(placer, BlockInfo.blockInfo(pos.below(), worldIn));
                break;
            }
            case GREEN: {
                if (!CarpetSettings.hopperCounters) break;
                DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.below());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                Messenger.send(placer, counter.format(worldIn.getServer(), false, false));
                break;
            }
            case RED: {
                if (!CarpetSettings.hopperCounters) break;
                DyeColor under = WoolTool.getWoolColorAtPosition((Level)worldIn, pos.below());
                if (under == null) {
                    return;
                }
                HopperCounter counter = HopperCounter.getCounter(under);
                counter.reset(placer.getServer());
                ArrayList<Component> res = new ArrayList<Component>();
                res.add(Messenger.s(String.format("%s counter reset", under.toString())));
                Messenger.send(placer, res);
            }
        }
    }

    @Nullable
    public static DyeColor getWoolColorAtPosition(Level worldIn, BlockPos pos) {
        BlockState state = worldIn.getBlockState(pos);
        return WOOL_BLOCK_TO_DYE.get(state.getBlock());
    }
}

