/*
 * Decompiled with CFR 0.152.
 */
package carpet;

import carpet.CarpetServer;
import carpet.script.CarpetExpression;
import carpet.settings.SettingsManager;
import com.mojang.brigadier.CommandDispatcher;
import java.util.Collections;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;

public interface CarpetExtension {
    default public void onGameStarted() {
    }

    default public void onServerLoaded(MinecraftServer server) {
    }

    default public void onServerLoadedWorlds(MinecraftServer server) {
    }

    default public void onTick(MinecraftServer server) {
    }

    @Deprecated(forRemoval=true)
    default public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher) {
    }

    default public void registerCommands(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        this.registerCommands(dispatcher);
    }

    @Deprecated(forRemoval=true)
    default public SettingsManager customSettingsManager() {
        return null;
    }

    default public carpet.api.settings.SettingsManager extensionSettingsManager() {
        SettingsManager deprecatedManager = this.customSettingsManager();
        if (deprecatedManager != null) {
            CarpetServer.warnOutdatedManager(this);
        }
        return this.customSettingsManager();
    }

    default public void onPlayerLoggedIn(ServerPlayer player) {
    }

    default public void onPlayerLoggedOut(ServerPlayer player) {
    }

    default public void onServerClosed(MinecraftServer server) {
    }

    default public void onReload(MinecraftServer server) {
    }

    default public String version() {
        return null;
    }

    default public void registerLoggers() {
    }

    default public Map<String, String> canHasTranslations(String lang) {
        return Collections.emptyMap();
    }

    default public void scarpetApi(CarpetExpression expression) {
    }
}

