/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.logging.Logger;
import carpet.logging.LoggerRegistry;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class LogCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder literalargumentbuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"log").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandLog))).executes(context -> LogCommand.listLogs((CommandSourceStack)context.getSource()))).then(((LiteralArgumentBuilder)Commands.literal((String)"clear").executes(c -> LogCommand.unsubFromAll((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getTextName()))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)c.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)b)).executes(c -> LogCommand.unsubFromAll((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"player")))));
        literalargumentbuilder.then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.argument((String)"log name", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest(LoggerRegistry.getLoggerNames(), (SuggestionsBuilder)b)).executes(c -> LogCommand.toggleSubscription((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getTextName(), StringArgumentType.getString((CommandContext)c, (String)"log name")))).then(Commands.literal((String)"clear").executes(c -> LogCommand.unsubFromLogger((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getTextName(), StringArgumentType.getString((CommandContext)c, (String)"log name"))))).then(((RequiredArgumentBuilder)Commands.argument((String)"option", (ArgumentType)StringArgumentType.string()).suggests((c, b) -> SharedSuggestionProvider.suggest((String[])(LoggerRegistry.getLogger(StringArgumentType.getString((CommandContext)c, (String)"log name")) == null ? new String[]{} : LoggerRegistry.getLogger(StringArgumentType.getString((CommandContext)c, (String)"log name")).getOptions()), (SuggestionsBuilder)b)).executes(c -> LogCommand.subscribePlayer((CommandSourceStack)c.getSource(), ((CommandSourceStack)c.getSource()).getTextName(), StringArgumentType.getString((CommandContext)c, (String)"log name"), StringArgumentType.getString((CommandContext)c, (String)"option")))).then(Commands.argument((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> SharedSuggestionProvider.suggest((Iterable)((CommandSourceStack)c.getSource()).getOnlinePlayerNames(), (SuggestionsBuilder)b)).executes(c -> LogCommand.subscribePlayer((CommandSourceStack)c.getSource(), StringArgumentType.getString((CommandContext)c, (String)"player"), StringArgumentType.getString((CommandContext)c, (String)"log name"), StringArgumentType.getString((CommandContext)c, (String)"option"))))));
        dispatcher.register(literalargumentbuilder);
    }

    private static int listLogs(CommandSourceStack source) {
        ServerPlayer player;
        try {
            player = source.getPlayerOrException();
        }
        catch (CommandSyntaxException e) {
            Messenger.m(source, "For players only");
            return 0;
        }
        Map<String, String> subs = LoggerRegistry.getPlayerSubscriptions(source.getTextName());
        if (subs == null) {
            subs = new HashMap<String, String>();
        }
        ArrayList<String> all_logs = new ArrayList<String>(LoggerRegistry.getLoggerNames());
        Collections.sort(all_logs);
        Messenger.m((Player)player, "w _____________________");
        Messenger.m((Player)player, "w Available logging options:");
        for (String lname : all_logs) {
            ArrayList<Object> comp = new ArrayList<Object>();
            String color = subs.containsKey(lname) ? "w" : "g";
            comp.add("w  - " + lname + ": ");
            Logger logger = LoggerRegistry.getLogger(lname);
            String[] options = logger.getOptions();
            if (options.length == 0) {
                if (subs.containsKey(lname)) {
                    comp.add("l Subscribed ");
                } else {
                    comp.add(color + " [Subscribe] ");
                    comp.add("^w subscribe to " + lname);
                    comp.add("!/log " + lname);
                }
            } else {
                for (String option : logger.getOptions()) {
                    if (subs.containsKey(lname) && subs.get(lname).equalsIgnoreCase(option)) {
                        comp.add("l [" + option + "] ");
                        continue;
                    }
                    comp.add(color + " [" + option + "] ");
                    comp.add("^w subscribe to " + lname + " " + option);
                    comp.add("!/log " + lname + " " + option);
                }
            }
            if (subs.containsKey(lname)) {
                comp.add("nb [X]");
                comp.add("^w Click to unsubscribe");
                comp.add("!/log " + lname);
            }
            Messenger.m((Player)player, comp.toArray(new Object[0]));
        }
        return 1;
    }

    private static int unsubFromAll(CommandSourceStack source, String player_name) {
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        for (String logname : LoggerRegistry.getLoggerNames()) {
            LoggerRegistry.unsubscribePlayer(player_name, logname);
        }
        Messenger.m(source, "gi Unsubscribed from all logs");
        return 1;
    }

    private static int unsubFromLogger(CommandSourceStack source, String player_name, String logname) {
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logname) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logname);
            return 0;
        }
        LoggerRegistry.unsubscribePlayer(player_name, logname);
        Messenger.m(source, "gi Unsubscribed from " + logname);
        return 1;
    }

    private static int toggleSubscription(CommandSourceStack source, String player_name, String logName) {
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logName) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logName);
            return 0;
        }
        boolean subscribed = LoggerRegistry.togglePlayerSubscription(player_name, logName);
        if (subscribed) {
            Messenger.m(source, "gi " + player_name + " subscribed to " + logName + ".");
        } else {
            Messenger.m(source, "gi " + player_name + " unsubscribed from " + logName + ".");
        }
        return 1;
    }

    private static int subscribePlayer(CommandSourceStack source, String player_name, String logname, String option) {
        ServerPlayer player = source.getServer().getPlayerList().getPlayerByName(player_name);
        if (player == null) {
            Messenger.m(source, "r No player specified");
            return 0;
        }
        if (LoggerRegistry.getLogger(logname) == null) {
            Messenger.m(source, "r Unknown logger: ", "rb " + logname);
            return 0;
        }
        if (!LoggerRegistry.getLogger(logname).isOptionValid(option)) {
            Messenger.m(source, "r Invalid option: ", "rb " + option);
            return 0;
        }
        LoggerRegistry.subscribePlayer(player_name, logname, option);
        if (option != null) {
            Messenger.m(source, "gi Subscribed to " + logname + "(" + option + ")");
        } else {
            Messenger.m(source, "gi Subscribed to " + logname);
        }
        return 1;
    }
}

