/*
 * Decompiled with CFR 0.152.
 */
package carpet.commands;

import carpet.CarpetSettings;
import carpet.utils.CommandHelper;
import carpet.utils.Messenger;
import carpet.utils.PerimeterDiagnostics;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.ResourceArgument;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.commands.synchronization.SuggestionProviders;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.Level;

public class PerimeterInfoCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher, CommandBuildContext commandBuildContext) {
        LiteralArgumentBuilder command = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"perimeterinfo").requires(player -> CommandHelper.canUseCommand(player, CarpetSettings.commandPerimeterInfo))).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPos.containing((Position)((CommandSourceStack)c.getSource()).getPosition()), null))).then(((RequiredArgumentBuilder)Commands.argument((String)"center position", (ArgumentType)BlockPosArgument.blockPos()).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"center position"), null))).then(Commands.argument((String)"mob", (ArgumentType)ResourceArgument.resource((CommandBuildContext)commandBuildContext, (ResourceKey)Registries.ENTITY_TYPE)).suggests(SuggestionProviders.SUMMONABLE_ENTITIES).executes(c -> PerimeterInfoCommand.perimeterDiagnose((CommandSourceStack)c.getSource(), BlockPosArgument.getSpawnablePos((CommandContext)c, (String)"center position"), ResourceArgument.getSummonableEntityType((CommandContext)c, (String)"mob").key().location().toString()))));
        dispatcher.register(command);
    }

    private static int perimeterDiagnose(CommandSourceStack source, BlockPos pos, String mobId) {
        CompoundTag nbttagcompound = new CompoundTag();
        Mob entityliving = null;
        if (mobId != null) {
            nbttagcompound.putString("id", mobId);
            Entity baseEntity = EntityType.loadEntityRecursive((CompoundTag)nbttagcompound, (Level)source.getLevel(), entity_1x -> {
                entity_1x.moveTo(new BlockPos(pos.getX(), source.getLevel().getMinBuildHeight() - 10, pos.getZ()), entity_1x.getYRot(), entity_1x.getXRot());
                return !source.getLevel().addWithUUID(entity_1x) ? null : entity_1x;
            });
            if (!(baseEntity instanceof Mob)) {
                Messenger.m(source, "r /perimeterinfo requires a mob entity to test against.");
                if (baseEntity != null) {
                    baseEntity.discard();
                }
                return 0;
            }
            entityliving = (Mob)baseEntity;
        }
        PerimeterDiagnostics.Result res = PerimeterDiagnostics.countSpots(source.getLevel(), pos, entityliving);
        Messenger.m(source, "w Spawning spaces around ", Messenger.tp("c", pos), "w :");
        Messenger.m(source, "w   potential in-liquid: ", "wb " + res.liquid);
        Messenger.m(source, "w   potential on-ground: ", "wb " + res.ground);
        if (entityliving != null) {
            Messenger.m(source, "w   ", entityliving.getDisplayName(), "w : ", "wb " + res.specific);
            res.samples.forEach(bp -> Messenger.m(source, "w   ", Messenger.tp("c", bp)));
            entityliving.discard();
        }
        return 1;
    }
}

