/*
 * Decompiled with CFR 0.152.
 */
package carpet.helpers;

import carpet.CarpetSettings;
import carpet.fakes.PistonBlockInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.dispenser.BlockSource;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.core.dispenser.OptionalDispenseItemBehavior;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseRailBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.DirectionalBlock;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.ObserverBlock;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SlabType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class BlockRotator {
    public static boolean flipBlockWithCactus(BlockState state, Level world, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!(player.getAbilities().mayBuild && CarpetSettings.flippinCactus && BlockRotator.playerHoldsCactusMainhand(player))) {
            return false;
        }
        CarpetSettings.impendingFillSkipUpdates.set(true);
        boolean retval = BlockRotator.flipBlock(state, world, player, hand, hit);
        CarpetSettings.impendingFillSkipUpdates.set(false);
        return retval;
    }

    public static ItemStack dispenserRotate(BlockSource source, ItemStack stack) {
        Direction face;
        BlockPos blockpos;
        Direction sourceFace = (Direction)source.state().getValue((Property)DispenserBlock.FACING);
        ServerLevel world = source.level();
        BlockState blockstate = world.getBlockState(blockpos = source.pos().relative(sourceFace));
        Block block = blockstate.getBlock();
        if (block instanceof DirectionalBlock || block instanceof DispenserBlock) {
            Direction face2 = (Direction)blockstate.getValue((Property)DirectionalBlock.FACING);
            if (block instanceof PistonBaseBlock && (((Boolean)blockstate.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue() || ((PistonBlockInterface)block).publicShouldExtend((Level)world, blockpos, face2) && new PistonStructureResolver((Level)world, blockpos, face2, true).resolve())) {
                return stack;
            }
            Direction rotatedFace = face2.getClockWise(sourceFace.getAxis());
            if (sourceFace.get3DDataValue() % 2 == 0 || rotatedFace == face2) {
                rotatedFace = rotatedFace.getOpposite();
            }
            world.setBlock(blockpos, (BlockState)blockstate.setValue((Property)DirectionalBlock.FACING, (Comparable)rotatedFace), 3);
        } else if (block instanceof HorizontalDirectionalBlock) {
            if (block instanceof BedBlock) {
                return stack;
            }
            Direction face3 = ((Direction)blockstate.getValue((Property)HorizontalDirectionalBlock.FACING)).getClockWise(Direction.Axis.Y);
            if (sourceFace == Direction.DOWN) {
                face3 = face3.getOpposite();
            }
            world.setBlock(blockpos, (BlockState)blockstate.setValue((Property)HorizontalDirectionalBlock.FACING, (Comparable)face3), 3);
        } else if (block == Blocks.HOPPER && (face = (Direction)blockstate.getValue((Property)HopperBlock.FACING)) != Direction.DOWN) {
            face = face.getClockWise(Direction.Axis.Y);
            world.setBlock(blockpos, (BlockState)blockstate.setValue((Property)HopperBlock.FACING, (Comparable)face), 3);
        }
        world.neighborChanged(blockpos, block, source.pos());
        return stack;
    }

    public static boolean flipBlock(BlockState state, Level world, Player player, InteractionHand hand, BlockHitResult hit) {
        Block block = state.getBlock();
        BlockPos pos = hit.getBlockPos();
        Vec3 hitVec = hit.getLocation().subtract((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        Direction facing = hit.getDirection();
        BlockState newState = null;
        if ((block instanceof HorizontalDirectionalBlock || block instanceof BaseRailBlock) && !(block instanceof BedBlock)) {
            newState = state.rotate(Rotation.CLOCKWISE_90);
        } else if (block instanceof ObserverBlock || block instanceof EndRodBlock) {
            newState = (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite());
        } else if (block instanceof DispenserBlock) {
            newState = (BlockState)state.setValue((Property)DispenserBlock.FACING, (Comparable)((Direction)state.getValue((Property)DispenserBlock.FACING)).getOpposite());
        } else if (block instanceof PistonBaseBlock) {
            if (!((Boolean)state.getValue((Property)PistonBaseBlock.EXTENDED)).booleanValue()) {
                newState = (BlockState)state.setValue((Property)DirectionalBlock.FACING, (Comparable)((Direction)state.getValue((Property)DirectionalBlock.FACING)).getOpposite());
            }
        } else if (block instanceof SlabBlock) {
            if (state.getValue((Property)SlabBlock.TYPE) != SlabType.DOUBLE) {
                newState = (BlockState)state.setValue((Property)SlabBlock.TYPE, (Comparable)(state.getValue((Property)SlabBlock.TYPE) == SlabType.TOP ? SlabType.BOTTOM : SlabType.TOP));
            }
        } else if (block instanceof HopperBlock) {
            if (state.getValue((Property)HopperBlock.FACING) != Direction.DOWN) {
                newState = (BlockState)state.setValue((Property)HopperBlock.FACING, (Comparable)((Direction)state.getValue((Property)HopperBlock.FACING)).getClockWise());
            }
        } else if (block instanceof StairBlock) {
            if (facing == Direction.UP && hitVec.y == 1.0 || facing == Direction.DOWN && hitVec.y == 0.0) {
                newState = (BlockState)state.setValue((Property)StairBlock.HALF, (Comparable)(state.getValue((Property)StairBlock.HALF) == Half.TOP ? Half.BOTTOM : Half.TOP));
            } else {
                boolean turnCounterClockwise = switch (facing) {
                    case Direction.NORTH -> {
                        if (hitVec.x <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.SOUTH -> {
                        if (!(hitVec.x <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.EAST -> {
                        if (hitVec.z <= 0.5) {
                            yield true;
                        }
                        yield false;
                    }
                    case Direction.WEST -> {
                        if (!(hitVec.z <= 0.5)) {
                            yield true;
                        }
                        yield false;
                    }
                    default -> false;
                };
                newState = state.rotate(turnCounterClockwise ? Rotation.COUNTERCLOCKWISE_90 : Rotation.CLOCKWISE_90);
            }
        } else if (block instanceof RotatedPillarBlock) {
            newState = (BlockState)state.setValue((Property)RotatedPillarBlock.AXIS, (Comparable)(switch ((Direction.Axis)state.getValue((Property)RotatedPillarBlock.AXIS)) {
                default -> throw new MatchException(null, null);
                case Direction.Axis.X -> Direction.Axis.Z;
                case Direction.Axis.Y -> Direction.Axis.X;
                case Direction.Axis.Z -> Direction.Axis.Y;
            }));
        }
        if (newState != null) {
            world.setBlock(pos, newState, 1026);
            world.setBlocksDirty(pos, state, newState);
            return true;
        }
        return false;
    }

    private static boolean playerHoldsCactusMainhand(Player playerIn) {
        return playerIn.getMainHandItem().getItem() == Items.CACTUS;
    }

    public static boolean flippinEligibility(Entity entity) {
        Player p;
        return CarpetSettings.flippinCactus && entity instanceof Player && (p = (Player)entity).getOffhandItem().getItem() == Items.CACTUS;
    }

    public static class CactusDispenserBehaviour
    extends OptionalDispenseItemBehavior
    implements DispenseItemBehavior {
        protected ItemStack execute(BlockSource source, ItemStack stack) {
            if (CarpetSettings.rotatorBlock) {
                return BlockRotator.dispenserRotate(source, stack);
            }
            return super.execute(source, stack);
        }
    }
}

