/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.AbstractContainerMenuInterface;
import carpet.script.value.ScreenValue;
import java.util.List;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.DataSlot;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={AbstractContainerMenu.class})
public abstract class AbstractContainerMenu_scarpetMixin
implements AbstractContainerMenuInterface {
    @Shadow
    @Final
    private List<ContainerListener> containerListeners;
    @Shadow
    @Final
    private List<DataSlot> dataSlots;

    @Shadow
    public abstract void sendAllDataToRemote();

    @Inject(method={"doClick"}, at={@At(value="HEAD")}, cancellable=true)
    private void callSlotClickListener(int slotIndex, int button, ClickType actionType, Player player, CallbackInfo ci) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        for (ContainerListener screenHandlerListener : this.containerListeners) {
            ScreenValue.ScarpetScreenHandlerListener scarpetScreenHandlerListener;
            if (!(screenHandlerListener instanceof ScreenValue.ScarpetScreenHandlerListener) || !(scarpetScreenHandlerListener = (ScreenValue.ScarpetScreenHandlerListener)screenHandlerListener).onSlotClick(serverPlayerEntity, actionType, slotIndex, button)) continue;
            ci.cancel();
            this.sendAllDataToRemote();
        }
    }

    @Inject(method={"removed"}, at={@At(value="HEAD")}, cancellable=true)
    private void callCloseListener(Player player, CallbackInfo ci) {
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        for (ContainerListener screenHandlerListener : this.containerListeners) {
            if (!(screenHandlerListener instanceof ScreenValue.ScarpetScreenHandlerListener)) continue;
            ScreenValue.ScarpetScreenHandlerListener scarpetScreenHandlerListener = (ScreenValue.ScarpetScreenHandlerListener)screenHandlerListener;
            scarpetScreenHandlerListener.onClose(serverPlayerEntity);
        }
    }

    @Override
    public boolean callButtonClickListener(int button, Player player) {
        if (!(player instanceof ServerPlayer)) {
            return false;
        }
        ServerPlayer serverPlayerEntity = (ServerPlayer)player;
        for (ContainerListener screenHandlerListener : this.containerListeners) {
            ScreenValue.ScarpetScreenHandlerListener scarpetScreenHandlerListener;
            if (!(screenHandlerListener instanceof ScreenValue.ScarpetScreenHandlerListener) || !(scarpetScreenHandlerListener = (ScreenValue.ScarpetScreenHandlerListener)screenHandlerListener).onButtonClick(serverPlayerEntity, button)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean callSelectRecipeListener(ServerPlayer player, RecipeHolder<?> recipe, boolean craftAll) {
        for (ContainerListener screenHandlerListener : this.containerListeners) {
            ScreenValue.ScarpetScreenHandlerListener scarpetScreenHandlerListener;
            if (!(screenHandlerListener instanceof ScreenValue.ScarpetScreenHandlerListener) || !(scarpetScreenHandlerListener = (ScreenValue.ScarpetScreenHandlerListener)screenHandlerListener).onSelectRecipe(player, recipe, craftAll)) continue;
            return true;
        }
        return false;
    }

    @Override
    public DataSlot getDataSlot(int index) {
        return this.dataSlots.get(index);
    }
}

