/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.LevelInterface;
import carpet.mixins.CollectingNeighborUpdaterAccessor;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BarrierBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.PoweredRailBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.redstone.NeighborUpdater;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={BarrierBlock.class})
public class BarrierBlock_updateSuppressionBlockMixin
extends Block {
    private boolean shouldPower = false;

    public BarrierBlock_updateSuppressionBlockMixin(BlockBehaviour.Properties settings) {
        super(settings);
    }

    public int getSignal(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return this.shouldPower && direction == Direction.DOWN ? 15 : 0;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block block, BlockPos fromPos, boolean notify) {
        BlockState stateAbove;
        if (CarpetSettings.updateSuppressionBlock != -1 && fromPos.equals((Object)pos.above()) && (stateAbove = level.getBlockState(fromPos)).is(Blocks.ACTIVATOR_RAIL) && !((Boolean)stateAbove.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            level.scheduleTick(pos, (Block)this, 1);
            NeighborUpdater updater = ((LevelInterface)level).getNeighborUpdater();
            if (updater instanceof CollectingNeighborUpdaterAccessor) {
                CollectingNeighborUpdaterAccessor cnua = (CollectingNeighborUpdaterAccessor)updater;
                cnua.setCount(cnua.getMaxChainedNeighborUpdates() - CarpetSettings.updateSuppressionBlock);
            }
        }
        super.neighborChanged(state, level, pos, block, fromPos, notify);
    }

    public void tick(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        BlockPos posAbove = pos.above();
        BlockState stateAbove = level.getBlockState(posAbove);
        if (stateAbove.is(Blocks.ACTIVATOR_RAIL) && !((Boolean)stateAbove.getValue((Property)PoweredRailBlock.POWERED)).booleanValue()) {
            this.shouldPower = true;
            level.setBlock(posAbove, (BlockState)stateAbove.setValue((Property)PoweredRailBlock.POWERED, (Comparable)Boolean.valueOf(true)), 6);
            this.shouldPower = false;
        }
    }
}

