/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.BlockPistonBehaviourInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.ChainBlock;
import net.minecraft.world.level.block.EndRodBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;

@Mixin(value={ChainBlock.class})
public class ChainBlock_customStickyMixin
implements BlockPistonBehaviourInterface {
    @Override
    public boolean isSticky(BlockState state) {
        return CarpetSettings.chainStone.enabled();
    }

    @Override
    public boolean isStickyToNeighbor(Level level, BlockPos pos, BlockState state, BlockPos neighborPos, BlockState neighborState, Direction dir, Direction moveDir) {
        Direction.Axis axis = (Direction.Axis)state.getValue((Property)ChainBlock.AXIS);
        if (axis != dir.getAxis()) {
            return false;
        }
        if (CarpetSettings.chainStone == CarpetSettings.ChainStoneMode.STICK_TO_ALL) {
            return true;
        }
        if (neighborState.is((Block)this)) {
            return axis == neighborState.getValue((Property)ChainBlock.AXIS);
        }
        if (neighborState.is(Blocks.END_ROD)) {
            return axis == ((Direction)neighborState.getValue((Property)EndRodBlock.FACING)).getAxis();
        }
        return Block.canSupportCenter((LevelReader)level, (BlockPos)neighborPos, (Direction)dir.getOpposite());
    }
}

