/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.BlockEntityInterface;
import carpet.fakes.LevelInterface;
import carpet.fakes.PistonBlockEntityInterface;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.piston.PistonMovingBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={PistonMovingBlockEntity.class})
public abstract class PistonMovingBlockEntity_movableBEMixin
extends BlockEntity
implements PistonBlockEntityInterface {
    @Shadow
    private boolean isSourcePiston;
    @Shadow
    private BlockState movedState;
    private BlockEntity carriedBlockEntity;
    private boolean renderCarriedBlockEntity = false;
    private boolean renderSet = false;

    public PistonMovingBlockEntity_movableBEMixin(BlockEntityType<?> blockEntityType, BlockPos blockPos, BlockState blockState) {
        super(blockEntityType, blockPos, blockState);
    }

    @Override
    public BlockEntity getCarriedBlockEntity() {
        return this.carriedBlockEntity;
    }

    public void setLevel(Level world) {
        super.setLevel(world);
        if (this.carriedBlockEntity != null) {
            this.carriedBlockEntity.setLevel(world);
        }
    }

    @Override
    public void setCarriedBlockEntity(BlockEntity blockEntity) {
        this.carriedBlockEntity = blockEntity;
        if (this.carriedBlockEntity != null) {
            ((BlockEntityInterface)this.carriedBlockEntity).setCMPos(this.worldPosition);
            if (this.level != null) {
                this.carriedBlockEntity.setLevel(this.level);
            }
        }
    }

    @Override
    public boolean isRenderModeSet() {
        return this.renderSet;
    }

    @Override
    public boolean getRenderCarriedBlockEntity() {
        return this.renderCarriedBlockEntity;
    }

    @Override
    public void setRenderCarriedBlockEntity(boolean b) {
        this.renderCarriedBlockEntity = b;
        this.renderSet = true;
    }

    @Redirect(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"))
    private static boolean movableTEsetBlockState0(Level world, BlockPos blockPos_1, BlockState blockAState_2, int int_1, Level world2, BlockPos blockPos, BlockState blockState, PistonMovingBlockEntity pistonBlockEntity) {
        if (!CarpetSettings.movableBlockEntities) {
            return world.setBlock(blockPos_1, blockAState_2, int_1);
        }
        return ((LevelInterface)world).setBlockStateWithBlockEntity(blockPos_1, blockAState_2, ((PistonBlockEntityInterface)pistonBlockEntity).getCarriedBlockEntity(), int_1);
    }

    @Redirect(method={"finalTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;setBlock(Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;I)Z"))
    private boolean movableTEsetBlockState1(Level world, BlockPos blockPos_1, BlockState blockState_2, int int_1) {
        if (!CarpetSettings.movableBlockEntities) {
            return world.setBlock(blockPos_1, blockState_2, int_1);
        }
        boolean ret = ((LevelInterface)world).setBlockStateWithBlockEntity(blockPos_1, blockState_2, this.carriedBlockEntity, int_1);
        this.carriedBlockEntity = null;
        return ret;
    }

    @Inject(method={"finalTick"}, at={@At(value="RETURN")})
    private void finishHandleBroken(CallbackInfo cir) {
        if (CarpetSettings.movableBlockEntities && this.carriedBlockEntity != null && !this.level.isClientSide && this.level.getBlockState(this.worldPosition).getBlock() == Blocks.AIR) {
            BlockState blockState_2 = this.isSourcePiston ? Blocks.AIR.defaultBlockState() : Block.updateFromNeighbourShapes((BlockState)this.movedState, (LevelAccessor)this.level, (BlockPos)this.worldPosition);
            ((LevelInterface)this.level).setBlockStateWithBlockEntity(this.worldPosition, blockState_2, this.carriedBlockEntity, 3);
            this.level.destroyBlock(this.worldPosition, false, null);
        }
    }

    @Inject(method={"loadAdditional"}, at={@At(value="TAIL")})
    private void onFromTag(CompoundTag NbtCompound_1, HolderLookup.Provider registries, CallbackInfo ci) {
        if (CarpetSettings.movableBlockEntities && NbtCompound_1.contains("carriedTileEntityCM", 10)) {
            if (this.movedState.getBlock() instanceof EntityBlock) {
                this.carriedBlockEntity = ((EntityBlock)this.movedState.getBlock()).newBlockEntity(this.worldPosition, this.movedState);
            }
            if (this.carriedBlockEntity != null) {
                this.carriedBlockEntity.loadWithComponents(NbtCompound_1.getCompound("carriedTileEntityCM"), registries);
            }
            this.setCarriedBlockEntity(this.carriedBlockEntity);
        }
    }

    @Inject(method={"saveAdditional"}, at={@At(value="RETURN", shift=At.Shift.BEFORE)})
    private void onToTag(CompoundTag NbtCompound_1, HolderLookup.Provider registries, CallbackInfo ci) {
        if (CarpetSettings.movableBlockEntities && this.carriedBlockEntity != null) {
            NbtCompound_1.put("carriedTileEntityCM", (Tag)this.carriedBlockEntity.saveWithoutMetadata(registries));
        }
    }
}

