/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.BlockPistonBehaviourInterface;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.piston.PistonStructureResolver;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(value={PistonStructureResolver.class})
public class PistonStructureResolver_customStickyMixin {
    @Shadow
    @Final
    private Level level;
    @Shadow
    @Final
    private Direction pushDirection;

    @WrapOperation(method={"addBlockLine"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=0)})
    private boolean onAddBlockLineCanStickToEachOther(BlockState state, BlockState behindState, Operation<Boolean> original, @Local(ordinal=1) BlockPos behindPos) {
        Block block = state.getBlock();
        if (block instanceof BlockPistonBehaviourInterface) {
            BlockPistonBehaviourInterface behaviourInterface = (BlockPistonBehaviourInterface)block;
            return behaviourInterface.isStickyToNeighbor(this.level, behindPos.relative(this.pushDirection), state, behindPos, behindState, this.pushDirection.getOpposite(), this.pushDirection);
        }
        return (Boolean)original.call(new Object[]{state, behindState});
    }

    @WrapOperation(method={"addBlockLine"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=1)})
    private boolean removeSecondBlockLineCheck(BlockState state, BlockState behindState, Operation<Boolean> original) {
        return true;
    }

    @WrapOperation(method={"addBranchingBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=0)})
    private boolean onAddBranchingBlocksCanStickToEachOther(BlockState neighborState, BlockState state, Operation<Boolean> original, @Local(argsOnly=true) BlockPos pos, @Local(ordinal=1) BlockPos neighborPos, @Local Direction direction) {
        Block block = state.getBlock();
        if (block instanceof BlockPistonBehaviourInterface) {
            BlockPistonBehaviourInterface behaviourInterface = (BlockPistonBehaviourInterface)block;
            return behaviourInterface.isStickyToNeighbor(this.level, pos, state, neighborPos, neighborState, direction, this.pushDirection);
        }
        return (Boolean)original.call(new Object[]{neighborState, state});
    }

    @WrapOperation(method={"addBranchingBlocks"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;canStickTo(Lnet/minecraft/world/level/block/state/BlockState;)Z", ordinal=1)})
    private boolean removeSecondBranchingBlockCheck(BlockState neighborState, BlockState state, Operation<Boolean> original) {
        return true;
    }
}

