/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.fakes.RecipeManagerInterface;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={RecipeManager.class})
public class RecipeManager_scarpetMixin
implements RecipeManagerInterface {
    @Shadow
    private Multimap<RecipeType<?>, RecipeHolder<?>> byType;
    @Shadow
    private Map<ResourceLocation, RecipeHolder<?>> byName;

    @Override
    public List<Recipe<?>> getAllMatching(RecipeType<?> type, ResourceLocation itemId, RegistryAccess registryAccess) {
        RecipeHolder<?> recipe = this.byName.get(itemId);
        if (recipe != null && recipe.value().getType().equals(type)) {
            return List.of(recipe.value());
        }
        if (!this.byType.containsKey(type)) {
            return List.of();
        }
        Collection typeRecipes = this.byType.get(type);
        Registry regs = registryAccess.registryOrThrow(Registries.ITEM);
        Item item = (Item)regs.get(itemId);
        return typeRecipes.stream().map(RecipeHolder::value).filter(r -> r.getResultItem((HolderLookup.Provider)registryAccess).getItem() == item).toList();
    }
}

