/*
 * Decompiled with CFR 0.152.
 */
package carpet.mixins;

import carpet.CarpetSettings;
import carpet.fakes.RedstoneWireBlockInterface;
import carpet.helpers.RedstoneWireTurbo;
import com.google.common.collect.Sets;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import java.util.HashSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.RedStoneWireBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.gen.Accessor;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={RedStoneWireBlock.class})
public abstract class RedstoneWireBlock_fastMixin
implements RedstoneWireBlockInterface {
    private RedstoneWireTurbo wireTurbo = null;

    @Shadow
    private int calculateTargetStrength(Level world, BlockPos pos) {
        return 0;
    }

    @Override
    @Accessor(value="shouldSignal")
    public abstract void setWiresGivePower(boolean var1);

    @Override
    @Accessor(value="shouldSignal")
    public abstract boolean getWiresGivePower();

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onRedstoneWireBlockCTOR(BlockBehaviour.Properties settings, CallbackInfo ci) {
        this.wireTurbo = new RedstoneWireTurbo((RedStoneWireBlock)this);
    }

    public boolean fastUpdate(Level world, BlockPos pos, BlockState state, BlockPos source) {
        if (!CarpetSettings.fastRedstoneDust) {
            return false;
        }
        this.wireTurbo.updateSurroundingRedstone(world, pos, state, source);
        return true;
    }

    @Inject(method={"updatePowerStrength"}, at={@At(value="HEAD")}, cancellable=true)
    private void updateLogicAlternative(Level world, BlockPos pos, BlockState state, CallbackInfo cir) {
        if (CarpetSettings.fastRedstoneDust) {
            this.updateLogicPublic(world, pos, state);
            cir.cancel();
        }
    }

    @Override
    public BlockState updateLogicPublic(Level world_1, BlockPos blockPos_1, BlockState blockState_1) {
        int i = this.calculateTargetStrength(world_1, blockPos_1);
        BlockState blockState = blockState_1;
        if ((Integer)blockState_1.getValue((Property)RedStoneWireBlock.POWER) != i) {
            blockState_1 = (BlockState)blockState_1.setValue((Property)RedStoneWireBlock.POWER, (Comparable)Integer.valueOf(i));
            if (world_1.getBlockState(blockPos_1) == blockState && world_1.setBlock(blockPos_1, blockState_1, 18)) {
                this.wireTurbo.updateNeighborShapes(world_1, blockPos_1, blockState_1);
            }
            if (!CarpetSettings.fastRedstoneDust) {
                HashSet set = Sets.newHashSet();
                set.add(blockPos_1);
                for (Direction direction : Direction.values()) {
                    set.add(blockPos_1.relative(direction));
                }
                for (BlockPos blockPos : set) {
                    world_1.updateNeighborsAt(blockPos, blockState_1.getBlock());
                }
            }
        }
        return blockState_1;
    }

    @WrapOperation(method={"onPlace"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void redirectOnBlockAddedUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1, Operation<Void> original) {
        if (!this.fastUpdate(world_1, blockPos_1, blockState_1, null)) {
            original.call(new Object[]{self, world_1, blockPos_1, blockState_1});
        }
    }

    @WrapOperation(method={"onRemove"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void redirectOnStateReplacedUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1, Operation<Void> original) {
        if (!this.fastUpdate(world_1, blockPos_1, blockState_1, null)) {
            original.call(new Object[]{self, world_1, blockPos_1, blockState_1});
        }
    }

    @WrapOperation(method={"neighborChanged"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/RedStoneWireBlock;updatePowerStrength(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/block/state/BlockState;)V")})
    private void redirectNeighborUpdateUpdate(RedStoneWireBlock self, Level world_1, BlockPos blockPos_1, BlockState blockState_1, Operation<Void> original, @Local(argsOnly=true, ordinal=1) BlockPos blockPos_3) {
        if (!this.fastUpdate(world_1, blockPos_1, blockState_1, blockPos_3)) {
            original.call(new Object[]{self, world_1, blockPos_1, blockState_1});
        }
    }
}

