/*
 * Decompiled with CFR 0.152.
 */
package carpet.patches;

import carpet.CarpetServer;
import java.util.Objects;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.ServerTickRateManager;
import net.minecraft.util.Mth;
import net.minecraft.util.TimeUtil;
import net.minecraft.world.level.border.BorderChangeListener;
import net.minecraft.world.level.border.BorderStatus;
import net.minecraft.world.level.border.WorldBorder;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class TickSyncedBorderExtent
implements WorldBorder.BorderExtent {
    private final WorldBorder border;
    private final long realDuration;
    private final double tickDuration;
    private final double from;
    private final double to;
    private int ticks;

    public TickSyncedBorderExtent(WorldBorder border, long realDuration, double from, double to) {
        this.border = border;
        this.realDuration = realDuration;
        this.tickDuration = (double)realDuration / 50.0;
        this.from = from;
        this.to = to;
        this.ticks = 0;
    }

    public double getMinX() {
        int maxSize = this.border.getAbsoluteMaxSize();
        return Mth.clamp((double)(this.border.getCenterX() - this.getSize() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double getMaxX() {
        int maxSize = this.border.getAbsoluteMaxSize();
        return Mth.clamp((double)(this.border.getCenterX() + this.getSize() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double getMinZ() {
        int maxSize = this.border.getAbsoluteMaxSize();
        return Mth.clamp((double)(this.border.getCenterZ() - this.getSize() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double getMaxZ() {
        int maxSize = this.border.getAbsoluteMaxSize();
        return Mth.clamp((double)(this.border.getCenterZ() + this.getSize() / 2.0), (double)(-maxSize), (double)maxSize);
    }

    public double getSize() {
        double progress = (double)this.ticks / this.tickDuration;
        return progress < 1.0 ? Mth.lerp((double)progress, (double)this.from, (double)this.to) : this.to;
    }

    public double getLerpSpeed() {
        return Math.abs(this.from - this.to) / (double)this.realDuration;
    }

    public long getLerpRemainingTime() {
        double ms;
        MinecraftServer server = CarpetServer.minecraft_server;
        if (server == null) {
            ms = 50.0;
        } else {
            ms = (double)server.getAverageTickTimeNanos() / (double)TimeUtil.NANOSECONDS_PER_MILLISECOND;
            ServerTickRateManager trm = server.tickRateManager();
            if (!trm.isSprinting()) {
                ms = Math.max(ms, (double)trm.millisecondsPerTick());
            }
        }
        double tps = 1000.0 / ms;
        return (long)((this.tickDuration - (double)this.ticks) / tps * 1000.0);
    }

    public double getLerpTarget() {
        return this.to;
    }

    @NotNull
    public BorderStatus getStatus() {
        return this.to < this.from ? BorderStatus.SHRINKING : BorderStatus.GROWING;
    }

    public void onAbsoluteMaxSizeChange() {
    }

    public void onCenterChange() {
    }

    @NotNull
    public WorldBorder.BorderExtent update() {
        TickSyncedBorderExtent tickSyncedBorderExtent;
        if (this.ticks++ % 20 == 0) {
            for (BorderChangeListener listener : this.border.getListeners()) {
                if (listener instanceof BorderChangeListener.DelegateBorderChangeListener) continue;
                listener.onBorderSizeLerping(this.border, this.from, this.to, this.realDuration);
            }
        }
        if ((double)this.ticks >= this.tickDuration) {
            WorldBorder worldBorder = this.border;
            Objects.requireNonNull(worldBorder);
            tickSyncedBorderExtent = new WorldBorder.StaticBorderExtent(worldBorder, this.to);
        } else {
            tickSyncedBorderExtent = this;
        }
        return tickSyncedBorderExtent;
    }

    @NotNull
    public VoxelShape getCollisionShape() {
        return Shapes.join((VoxelShape)Shapes.INFINITY, (VoxelShape)Shapes.box((double)Math.floor(this.getMinX()), (double)Double.NEGATIVE_INFINITY, (double)Math.floor(this.getMinZ()), (double)Math.ceil(this.getMaxX()), (double)Double.POSITIVE_INFINITY, (double)Math.ceil(this.getMaxZ())), (BooleanOp)BooleanOp.ONLY_FIRST);
    }
}

