/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.api;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Fluff;
import carpet.script.LazyValue;
import carpet.script.argument.BlockArgument;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.BiomeInfo;
import carpet.script.utils.Colors;
import carpet.script.utils.FeatureGenerator;
import carpet.script.utils.InputValidator;
import carpet.script.utils.WorldTools;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import it.unimi.dsi.fastutil.longs.Long2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.longs.LongIterator;
import it.unimi.dsi.fastutil.longs.LongSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.QuartPos;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.DistanceManager;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.level.Ticket;
import net.minecraft.server.level.TicketType;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.util.SortedArraySet;
import net.minecraft.world.Clearable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiRecord;
import net.minecraft.world.entity.ai.village.poi.PoiType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.BiomeSource;
import net.minecraft.world.level.biome.Climate;
import net.minecraft.world.level.biome.MultiNoiseBiomeSource;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.levelgen.DensityFunction;
import net.minecraft.world.level.levelgen.DensityFunctions;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.NoiseBasedChunkGenerator;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.NoiseRouter;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.phys.Vec3;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.apache.commons.lang3.tuple.Pair;

public class WorldAccess {
    private static final Map<String, Direction> DIRECTION_MAP = Arrays.stream(Direction.values()).collect(Collectors.toMap(Direction::getName, Function.identity()));
    private static final Map<String, TicketType<?>> ticketTypes;
    private static FallingBlockEntity DUMMY_ENTITY;
    public static final Function<Pair<ServerLevel, String>, DensityFunction> stupidWorldgenNoiseCacheGetter;

    private static Value booleanStateTest(Context c, String name, List<Value> params, BiPredicate<BlockState, BlockPos> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            return BooleanValue.of(test.test(bv.getBlockState(), bv.getPos()));
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return BooleanValue.of(test.test(block.getBlockState(), block.getPos()));
    }

    private static Value stateStringQuery(Context c, String name, List<Value> params, BiFunction<BlockState, BlockPos, String> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            return StringValue.of(test.apply(bv.getBlockState(), bv.getPos()));
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return StringValue.of(test.apply(block.getBlockState(), block.getPos()));
    }

    private static Value genericStateTest(Context c, String name, List<Value> params, Fluff.TriFunction<BlockState, BlockPos, Level, Value> test) {
        CarpetContext cc = (CarpetContext)c;
        if (params.isEmpty()) {
            throw new InternalExpressionException("'" + name + "' requires at least one parameter");
        }
        Value value = params.get(0);
        if (value instanceof BlockValue) {
            BlockValue bv = (BlockValue)value;
            try {
                return test.apply(bv.getBlockState(), bv.getPos(), (Level)cc.level());
            }
            catch (NullPointerException ignored) {
                throw new InternalExpressionException("'" + name + "' function requires a block that is positioned in the world");
            }
        }
        BlockValue block = BlockArgument.findIn((CarpetContext)cc, params, (int)0).block;
        return test.apply(block.getBlockState(), block.getPos(), (Level)cc.level());
    }

    private static <T extends Comparable<T>> BlockState setProperty(Property<T> property, String name, String value, BlockState bs) {
        Optional optional = property.getValue(value);
        if (optional.isEmpty()) {
            throw new InternalExpressionException(value + " is not a valid value for property " + name);
        }
        return (BlockState)bs.setValue(property, (Comparable)optional.get());
    }

    private static void nullCheck(Value v, String name) {
        if (v.isNull()) {
            throw new IllegalArgumentException(name + " cannot be null");
        }
    }

    private static float numberGetOrThrow(Value v) {
        double num = v.readDoubleNumber();
        if (Double.isNaN(num)) {
            throw new IllegalArgumentException(v.getString() + " needs to be a numeric value");
        }
        return (float)num;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void theBooYah(ServerLevel level) {
        ServerLevel serverLevel = level;
        synchronized (serverLevel) {
            level.getChunkSource().getGeneratorState().ensureStructuresGenerated();
        }
    }

    public static void apply(Expression expression) {
        expression.addContextFunction("block", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            BlockValue retval = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0, (boolean)true).block;
            retval.getBlockState();
            retval.getData();
            return retval;
        });
        expression.addContextFunction("block_data", -1, (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("Block requires at least one parameter");
            }
            return NBTSerializableValue.of((Tag)BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0, (boolean)true).block.getData());
        });
        expression.addContextFunction("poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            BlockPos pos = locator.block.getPos();
            PoiManager store = cc.level().getPoiManager();
            Registry poiReg = cc.registry(Registries.POINT_OF_INTEREST_TYPE);
            if (lv.size() == locator.offset) {
                Optional foo = store.getType(pos);
                if (foo.isEmpty()) {
                    return Value.NULL;
                }
                PoiType poiType = (PoiType)((Holder)foo.get()).value();
                PoiRecord poi = store.getInRange(type -> type.value() == poiType, pos, 1, PoiManager.Occupancy.ANY).filter(p -> p.getPos().equals((Object)pos)).findFirst().orElse(null);
                return poi == null ? Value.NULL : ListValue.of(ValueConversions.of(poiReg.getKey((Object)((PoiType)poi.getPoiType().value()))), new NumericValue(poiType.maxTickets() - Vanilla.PoiRecord_getFreeTickets(poi)));
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset)).getInt();
            if (radius < 0) {
                return ListValue.of(new Value[0]);
            }
            Predicate<Holder> condition = p -> true;
            PoiManager.Occupancy status = PoiManager.Occupancy.ANY;
            boolean inColumn = false;
            if (locator.offset + 1 < lv.size()) {
                String poiType = ((Value)lv.get(locator.offset + 1)).getString().toLowerCase(Locale.ROOT);
                if (!"any".equals(poiType)) {
                    PoiType type2 = (PoiType)poiReg.getOptional(InputValidator.identifierOf(poiType)).orElseThrow(() -> new ThrowStatement(poiType, Throwables.UNKNOWN_POI));
                    condition = tt -> tt.value() == type2;
                }
                if (locator.offset + 2 < lv.size()) {
                    String statusString = ((Value)lv.get(locator.offset + 2)).getString().toLowerCase(Locale.ROOT);
                    if ("occupied".equals(statusString)) {
                        status = PoiManager.Occupancy.IS_OCCUPIED;
                    } else if ("available".equals(statusString)) {
                        status = PoiManager.Occupancy.HAS_SPACE;
                    } else if (!"any".equals(statusString)) {
                        throw new InternalExpressionException("Incorrect POI occupation status " + String.valueOf(status) + " use `any`, `occupied` or `available`");
                    }
                    if (locator.offset + 3 < lv.size()) {
                        inColumn = ((Value)lv.get(locator.offset + 3)).getBoolean();
                    }
                }
            }
            Stream pois = inColumn ? store.getInSquare(condition, pos, radius, status) : store.getInRange(condition, pos, radius, status);
            return ListValue.wrap(pois.sorted(Comparator.comparingDouble(p -> p.getPos().distSqr((Vec3i)pos))).map(p -> ListValue.of(ValueConversions.of(poiReg.getKey((Object)((PoiType)p.getPoiType().value()))), new NumericValue(((PoiType)p.getPoiType().value()).maxTickets() - Vanilla.PoiRecord_getFreeTickets(p)), ValueConversions.of(p.getPos()))));
        });
        expression.addContextFunction("set_poi", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'set_poi' requires at least one parameter");
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false);
            BlockPos pos = locator.block.getPos();
            if (lv.size() < locator.offset) {
                throw new InternalExpressionException("'set_poi' requires the new poi type or null, after position argument");
            }
            Value poi = (Value)lv.get(locator.offset);
            PoiManager store = cc.level().getPoiManager();
            if (poi.isNull()) {
                if (store.getType(pos).isEmpty()) {
                    return Value.FALSE;
                }
                store.remove(pos);
                return Value.TRUE;
            }
            String poiTypeString = poi.getString().toLowerCase(Locale.ROOT);
            ResourceLocation resource = InputValidator.identifierOf(poiTypeString);
            Registry poiReg = cc.registry(Registries.POINT_OF_INTEREST_TYPE);
            PoiType type = (PoiType)poiReg.getOptional(resource).orElseThrow(() -> new ThrowStatement(poiTypeString, Throwables.UNKNOWN_POI));
            Holder.Reference holder = poiReg.getHolderOrThrow(ResourceKey.create((ResourceKey)Registries.POINT_OF_INTEREST_TYPE, (ResourceLocation)resource));
            int occupancy = 0;
            if (locator.offset + 1 < lv.size() && (occupancy = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong()) < 0) {
                throw new InternalExpressionException("Occupancy cannot be negative");
            }
            if (store.getType(pos).isPresent()) {
                store.remove(pos);
            }
            store.add(pos, (Holder)holder);
            if (occupancy > 0) {
                int finalO = occupancy;
                store.getInSquare(tt -> tt.value() == type, pos, 1, PoiManager.Occupancy.ANY).filter(p -> p.getPos().equals((Object)pos)).findFirst().ifPresent(p -> {
                    for (int i = 0; i < finalO; ++i) {
                        Vanilla.PoiRecord_callAcquireTicket(p);
                    }
                });
            }
            return Value.TRUE;
        });
        expression.addContextFunction("weather", -1, (c, t, lv) -> {
            ServerLevel world = ((CarpetContext)c).level();
            if (lv.isEmpty()) {
                return new StringValue(world.isThundering() ? "thunder" : (world.isRaining() ? "rain" : "clear"));
            }
            Value weather = (Value)lv.get(0);
            ServerLevelData worldProperties = Vanilla.ServerLevel_getWorldProperties(world);
            if (lv.size() == 1) {
                return new NumericValue(switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear" -> worldProperties.getClearWeatherTime();
                    case "rain" -> {
                        if (world.isRaining()) {
                            yield worldProperties.getRainTime();
                        }
                        yield 0L;
                    }
                    case "thunder" -> {
                        if (world.isThundering()) {
                            yield worldProperties.getThunderTime();
                        }
                        yield 0L;
                    }
                    default -> throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                });
            }
            if (lv.size() == 2) {
                int ticks = NumericValue.asNumber((Value)lv.get(1), "tick_time in 'weather'").getInt();
                switch (weather.getString().toLowerCase(Locale.ROOT)) {
                    case "clear": {
                        world.setWeatherParameters(ticks, 0, false, false);
                        break;
                    }
                    case "rain": {
                        world.setWeatherParameters(0, ticks, true, false);
                        break;
                    }
                    case "thunder": {
                        world.setWeatherParameters(0, ticks, true, true);
                        break;
                    }
                    default: {
                        throw new InternalExpressionException("Weather can only be 'clear', 'rain' or 'thunder'");
                    }
                }
                return NumericValue.of(ticks);
            }
            throw new InternalExpressionException("'weather' requires 0, 1 or 2 arguments");
        });
        expression.addUnaryFunction("pos", v -> {
            if (v instanceof BlockValue) {
                BlockValue bv = (BlockValue)v;
                BlockPos pos = bv.getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Cannot fetch position of an unrealized block");
                }
                return ValueConversions.of(pos);
            }
            if (v instanceof EntityValue) {
                EntityValue ev = (EntityValue)v;
                Entity e = ev.getEntity();
                if (e == null) {
                    throw new InternalExpressionException("Null entity");
                }
                return ValueConversions.of(e.position());
            }
            throw new InternalExpressionException("'pos' works only with a block or an entity type");
        });
        expression.addContextFunction("pos_offset", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = locator.block.getPos();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'pos_offset' needs at least position, and direction");
            }
            String directionString = ((Value)lv.get(locator.offset)).getString();
            Direction dir = DIRECTION_MAP.get(directionString);
            if (dir == null) {
                throw new InternalExpressionException("Unknown direction: " + directionString);
            }
            int howMuch = 1;
            if (lv.size() > locator.offset + 1) {
                howMuch = (int)NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getLong();
            }
            return ValueConversions.of(pos.relative(dir, howMuch));
        });
        expression.addContextFunction("solid", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "solid", lv, (s, p, w) -> BooleanValue.of(s.isRedstoneConductor((BlockGetter)w, p))));
        expression.addContextFunction("air", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "air", lv, (s, p) -> s.isAir()));
        expression.addContextFunction("liquid", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "liquid", lv, (s, p) -> !s.getFluidState().isEmpty()));
        expression.addContextFunction("flammable", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "flammable", lv, (s, p) -> s.ignitedByLava()));
        expression.addContextFunction("transparent", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "transparent", lv, (s, p) -> !s.isSolid()));
        expression.addContextFunction("emitted_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "emitted_light", lv, (s, p, w) -> new NumericValue(s.getLightEmission())));
        expression.addContextFunction("light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "light", lv, (s, p, w) -> new NumericValue(Math.max(w.getBrightness(LightLayer.BLOCK, p), w.getBrightness(LightLayer.SKY, p)))));
        expression.addContextFunction("block_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "block_light", lv, (s, p, w) -> new NumericValue(w.getBrightness(LightLayer.BLOCK, p))));
        expression.addContextFunction("sky_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "sky_light", lv, (s, p, w) -> new NumericValue(w.getBrightness(LightLayer.SKY, p))));
        expression.addContextFunction("effective_light", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "effective_light", lv, (s, p, w) -> new NumericValue(w.getMaxLocalRawBrightness(p))));
        expression.addContextFunction("see_sky", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "see_sky", lv, (s, p, w) -> BooleanValue.of(w.canSeeSky(p))));
        expression.addContextFunction("brightness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "brightness", lv, (s, p, w) -> new NumericValue(w.getLightLevelDependentMagicValue(p))));
        expression.addContextFunction("hardness", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "hardness", lv, (s, p, w) -> new NumericValue(s.getDestroySpeed((BlockGetter)w, p))));
        expression.addContextFunction("blast_resistance", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "blast_resistance", lv, (s, p, w) -> new NumericValue(s.getBlock().getExplosionResistance())));
        expression.addContextFunction("in_slime_chunk", -1, (c, t, lv) -> {
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            ChunkPos chunkPos = new ChunkPos(pos);
            return BooleanValue.of(WorldgenRandom.seedSlimeChunk((int)chunkPos.x, (int)chunkPos.z, (long)((CarpetContext)c).level().getSeed(), (long)987234911L).nextInt(10) == 0);
        });
        expression.addContextFunction("top", -1, (c, t, lv) -> {
            String type;
            Heightmap.Types htype = switch (type = ((Value)lv.get(0)).getString().toLowerCase(Locale.ROOT)) {
                case "motion" -> Heightmap.Types.MOTION_BLOCKING;
                case "terrain" -> Heightmap.Types.MOTION_BLOCKING_NO_LEAVES;
                case "ocean_floor" -> Heightmap.Types.OCEAN_FLOOR;
                case "surface" -> Heightmap.Types.WORLD_SURFACE;
                default -> throw new InternalExpressionException("Unknown heightmap type: " + type);
            };
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 1);
            BlockPos pos = locator.block.getPos();
            int x = pos.getX();
            int z = pos.getZ();
            return new NumericValue(((CarpetContext)c).level().getChunk(x >> 4, z >> 4).getHeight(htype, x & 0xF, z & 0xF) + 1);
        });
        expression.addContextFunction("loaded", -1, (c, t, lv) -> BooleanValue.of(((CarpetContext)c).level().hasChunkAt(BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos())));
        expression.addContextFunction("loaded_ep", -1, (c, t, lv) -> {
            c.host.issueDeprecation("loaded_ep(...)");
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            return BooleanValue.of(((CarpetContext)c).level().isPositionEntityTicking(pos));
        });
        expression.addContextFunction("loaded_status", -1, (c, t, lv) -> {
            BlockPos pos = BlockArgument.findIn((CarpetContext)((CarpetContext)c), (List<Value>)lv, (int)0).block.getPos();
            LevelChunk chunk = ((CarpetContext)c).level().getChunkSource().getChunk(pos.getX() >> 4, pos.getZ() >> 4, false);
            return chunk == null ? Value.ZERO : new NumericValue(chunk.getFullStatus().ordinal());
        });
        expression.addContextFunction("is_chunk_generated", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = locator.block.getPos();
            boolean force = false;
            if (lv.size() > locator.offset) {
                force = ((Value)lv.get(locator.offset)).getBoolean();
            }
            return BooleanValue.of(WorldTools.canHasChunk(((CarpetContext)c).level(), new ChunkPos(pos), null, force));
        });
        expression.addContextFunction("generation_status", -1, (c, t, lv) -> {
            ChunkAccess chunk;
            BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockPos pos = blockArgument.block.getPos();
            boolean forceLoad = false;
            if (lv.size() > blockArgument.offset) {
                forceLoad = ((Value)lv.get(blockArgument.offset)).getBoolean();
            }
            return (chunk = ((CarpetContext)c).level().getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.EMPTY, forceLoad)) == null ? Value.NULL : ValueConversions.of(BuiltInRegistries.CHUNK_STATUS.getKey((Object)chunk.getPersistedStatus()));
        });
        expression.addContextFunction("chunk_tickets", -1, (c, t, lv) -> {
            ServerLevel world = ((CarpetContext)c).level();
            DistanceManager foo = world.getChunkSource().chunkMap.getDistanceManager();
            Long2ObjectOpenHashMap<SortedArraySet<Ticket<?>>> levelTickets = Vanilla.ChunkTicketManager_getTicketsByPosition(foo);
            ArrayList<Value> res = new ArrayList<Value>();
            if (lv.isEmpty()) {
                LongIterator longIterator = levelTickets.keySet().iterator();
                while (longIterator.hasNext()) {
                    long key = (Long)longIterator.next();
                    ChunkPos chpos = new ChunkPos(key);
                    for (Ticket ticket : (SortedArraySet)levelTickets.get(key)) {
                        res.add(ListValue.of(new StringValue(ticket.getType().toString()), new NumericValue(33 - ticket.getTicketLevel()), new NumericValue(chpos.x), new NumericValue(chpos.z)));
                    }
                }
            } else {
                BlockArgument blockArgument = BlockArgument.findIn((CarpetContext)c, lv, 0);
                BlockPos pos = blockArgument.block.getPos();
                SortedArraySet tickets = (SortedArraySet)levelTickets.get(new ChunkPos(pos).toLong());
                if (tickets != null) {
                    for (Ticket ticket : tickets) {
                        res.add(ListValue.of(new StringValue(ticket.getType().toString()), new NumericValue(33 - ticket.getTicketLevel())));
                    }
                }
            }
            res.sort(Comparator.comparing(e -> ((ListValue)e).getItems().get(1)).reversed());
            return ListValue.wrap(res);
        });
        expression.addContextFunction("suffocates", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "suffocates", lv, (s, p, w) -> BooleanValue.of(s.isSuffocating((BlockGetter)w, p))));
        expression.addContextFunction("power", -1, (c, t, lv) -> WorldAccess.genericStateTest(c, "power", lv, (s, p, w) -> new NumericValue(w.getBestNeighborSignal(p))));
        expression.addContextFunction("ticks_randomly", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "ticks_randomly", lv, (s, p) -> s.isRandomlyTicking()));
        expression.addContextFunction("update", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "update", lv, (s, p) -> {
            ((CarpetContext)c).level().neighborChanged(p, s.getBlock(), p);
            return true;
        }));
        expression.addContextFunction("block_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "block_tick", lv, (s, p) -> {
            ServerLevel w = ((CarpetContext)c).level();
            s.randomTick(w, p, w.random);
            return true;
        }));
        expression.addContextFunction("random_tick", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "random_tick", lv, (s, p) -> {
            ServerLevel w = ((CarpetContext)c).level();
            if (s.isRandomlyTicking() || s.getFluidState().isRandomlyTicking()) {
                s.randomTick(w, p, w.random);
            }
            return true;
        }));
        expression.addLazyFunction("without_updates", 1, (c, t, lv) -> {
            if (Carpet.getImpendingFillSkipUpdates().get().booleanValue()) {
                return (LazyValue)lv.get(0);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).server().executeBlocking(() -> {
                ThreadLocal<Boolean> skipUpdates = Carpet.getImpendingFillSkipUpdates();
                boolean previous = skipUpdates.get();
                try {
                    skipUpdates.set(true);
                    result[0] = ((LazyValue)lv.get(0)).evalValue((Context)c, (Context.Type)((Object)t));
                }
                finally {
                    skipUpdates.set(previous);
                }
            });
            return (cc, tt) -> result[0];
        });
        expression.addContextFunction("set", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            BlockArgument targetLocator = BlockArgument.findIn(cc, lv, 0);
            BlockArgument sourceLocator = BlockArgument.findIn(cc, lv, targetLocator.offset, true);
            BlockState sourceBlockState = sourceLocator.block.getBlockState();
            BlockState targetBlockState = world.getBlockState(targetLocator.block.getPos());
            CompoundTag data = null;
            if (lv.size() > sourceLocator.offset) {
                List<Object> args = new ArrayList<Value>();
                int m = lv.size();
                for (int i = sourceLocator.offset; i < m; ++i) {
                    args.add((Value)lv.get(i));
                }
                Object patt0$temp = args.get(0);
                if (patt0$temp instanceof ListValue) {
                    Value patt1$temp;
                    ListValue list = (ListValue)patt0$temp;
                    if (args.size() == 2 && (patt1$temp = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                        nbtsv = (NBTSerializableValue)patt1$temp;
                        data = nbtsv.getCompoundTag();
                    }
                    args = list.getItems();
                } else {
                    Value patt2$temp;
                    Object patt1$temp = args.get(0);
                    if (patt1$temp instanceof MapValue) {
                        MapValue map = (MapValue)patt1$temp;
                        if (args.size() == 2 && (patt2$temp = NBTSerializableValue.fromValue((Value)args.get(1))) instanceof NBTSerializableValue) {
                            nbtsv = (NBTSerializableValue)patt2$temp;
                            data = nbtsv.getCompoundTag();
                        }
                        Map<Value, Value> state = map.getMap();
                        ArrayList mapargs = new ArrayList();
                        state.forEach((k, v) -> {
                            mapargs.add(k);
                            mapargs.add(v);
                        });
                        args = mapargs;
                    } else if ((args.size() & 1) == 1 && (patt2$temp = NBTSerializableValue.fromValue((Value)args.get(args.size() - 1))) instanceof NBTSerializableValue) {
                        nbtsv = (NBTSerializableValue)patt2$temp;
                        data = nbtsv.getCompoundTag();
                    }
                }
                StateDefinition states = sourceBlockState.getBlock().getStateDefinition();
                for (int i = 0; i < args.size() - 1; i += 2) {
                    String paramString = ((Value)args.get(i)).getString();
                    Property property = states.getProperty(paramString);
                    if (property == null) {
                        throw new InternalExpressionException("Property " + paramString + " doesn't apply to " + sourceLocator.block.getString());
                    }
                    String paramValue = ((Value)args.get(i + 1)).getString();
                    sourceBlockState = WorldAccess.setProperty(property, paramString, paramValue, sourceBlockState);
                }
            }
            if (data == null) {
                data = sourceLocator.block.getData();
            }
            CompoundTag finalData = data;
            if (sourceBlockState == targetBlockState && data == null) {
                return Value.FALSE;
            }
            BlockState finalSourceBlockState = sourceBlockState;
            BlockPos targetPos = targetLocator.block.getPos();
            Boolean[] result = new Boolean[]{true};
            cc.server().executeBlocking(() -> {
                BlockEntity be;
                Clearable.tryClear((Object)world.getBlockEntity(targetPos));
                boolean success = world.setBlock(targetPos, finalSourceBlockState, 2);
                if (finalData != null && (be = world.getBlockEntity(targetPos)) != null) {
                    CompoundTag destTag = finalData.copy();
                    destTag.putInt("x", targetPos.getX());
                    destTag.putInt("y", targetPos.getY());
                    destTag.putInt("z", targetPos.getZ());
                    be.loadWithComponents(destTag, (HolderLookup.Provider)world.registryAccess());
                    be.setChanged();
                    success = true;
                }
                result[0] = success;
            });
            return result[0] == false ? Value.FALSE : new BlockValue(finalSourceBlockState, world, targetLocator.block.getPos());
        });
        expression.addContextFunction("destroy", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            RegistryAccess regs = cc.registryAccess();
            ServerLevel world = cc.level();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockState state = locator.block.getBlockState();
            if (state.isAir()) {
                return Value.FALSE;
            }
            BlockPos where = locator.block.getPos();
            BlockEntity be = world.getBlockEntity(where);
            long how = 0L;
            Item item = Items.DIAMOND_PICKAXE;
            boolean playerBreak = false;
            if (lv.size() > locator.offset) {
                Value val = (Value)lv.get(locator.offset);
                if (val instanceof NumericValue) {
                    NumericValue number = (NumericValue)val;
                    how = number.getLong();
                } else {
                    playerBreak = true;
                    String itemString = val.getString();
                    item = (Item)cc.registry(Registries.ITEM).getOptional(InputValidator.identifierOf(itemString)).orElseThrow(() -> new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM));
                }
            }
            CompoundTag tag = null;
            if (lv.size() > locator.offset + 1) {
                if (!playerBreak) {
                    throw new InternalExpressionException("tag is not necessary with 'destroy' with no item");
                }
                Value tagValue = (Value)lv.get(locator.offset + 1);
                if (!tagValue.isNull()) {
                    CompoundTag compoundTag;
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        compoundTag = nbtsv.getCompoundTag();
                    } else {
                        compoundTag = NBTSerializableValue.parseStringOrFail(tagValue.getString()).getCompoundTag();
                    }
                    tag = compoundTag;
                }
            }
            ItemStack tool = tag != null ? ItemStack.parseOptional((HolderLookup.Provider)regs, tag) : new ItemStack((ItemLike)item, 1);
            if (playerBreak && (double)state.getDestroySpeed((BlockGetter)world, where) < 0.0) {
                return Value.FALSE;
            }
            boolean removed = world.removeBlock(where, false);
            if (!removed) {
                return Value.FALSE;
            }
            world.levelEvent(null, 2001, where, Block.getId((BlockState)state));
            MutableBoolean toolBroke = new MutableBoolean(false);
            boolean dropLoot = true;
            if (playerBreak) {
                boolean isUsingEffectiveTool = !state.requiresCorrectToolForDrops() || tool.isCorrectToolForDrops(state);
                float hardness = state.getDestroySpeed((BlockGetter)world, where);
                int damageAmount = 0;
                if (item instanceof DiggerItem && (double)hardness > 0.0 || item instanceof ShearsItem) {
                    damageAmount = 1;
                } else if (item instanceof TridentItem || item instanceof SwordItem) {
                    damageAmount = 2;
                }
                int finalDamageAmount = damageAmount;
                tool.hurtAndBreak(damageAmount, world, null, i -> {
                    if (finalDamageAmount > 0) {
                        toolBroke.setTrue();
                    }
                });
                if (!isUsingEffectiveTool) {
                    dropLoot = false;
                }
            }
            if (dropLoot) {
                if (how < 0L || tag != null && EnchantmentHelper.getItemEnchantmentLevel((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.SILK_TOUCH), (ItemStack)tool) > 0) {
                    Block.popResource((Level)world, (BlockPos)where, (ItemStack)new ItemStack((ItemLike)state.getBlock()));
                } else {
                    if (how > 0L) {
                        tool.enchant((Holder)world.registryAccess().registryOrThrow(Registries.ENCHANTMENT).getHolderOrThrow(Enchantments.FORTUNE), (int)how);
                    }
                    if (DUMMY_ENTITY == null) {
                        DUMMY_ENTITY = new FallingBlockEntity(EntityType.FALLING_BLOCK, null);
                    }
                    Block.dropResources((BlockState)state, (Level)world, (BlockPos)where, (BlockEntity)be, (Entity)DUMMY_ENTITY, (ItemStack)tool);
                }
            }
            if (!playerBreak) {
                return Value.TRUE;
            }
            if (toolBroke.booleanValue()) {
                return Value.NULL;
            }
            return new NBTSerializableValue(() -> tool.saveOptional((HolderLookup.Provider)regs));
        });
        expression.addContextFunction("harvest", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'harvest' takes at least 2 parameters: entity and block, or position, to harvest");
            }
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            Value entityValue = (Value)lv.get(0);
            if (!(entityValue instanceof EntityValue)) {
                return Value.FALSE;
            }
            EntityValue ev = (EntityValue)entityValue;
            Entity e = ev.getEntity();
            if (!(e instanceof ServerPlayer)) {
                return Value.FALSE;
            }
            ServerPlayer player = (ServerPlayer)e;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 1);
            BlockPos where = locator.block.getPos();
            BlockState state = locator.block.getBlockState();
            Block block = state.getBlock();
            boolean success = false;
            if (block != Blocks.BEDROCK && block != Blocks.BARRIER || !player.gameMode.isSurvival()) {
                success = player.gameMode.destroyBlock(where);
            }
            if (success) {
                world.levelEvent(null, 2001, where, Block.getId((BlockState)state));
            }
            return BooleanValue.of(success);
        });
        expression.addContextFunction("create_explosion", -1, (c, t, lv) -> {
            if (lv.isEmpty()) {
                throw new InternalExpressionException("'create_explosion' requires at least a position to explode");
            }
            CarpetContext cc = (CarpetContext)c;
            float powah = 4.0f;
            Explosion.BlockInteraction mode = Explosion.BlockInteraction.DESTROY;
            boolean createFire = false;
            Entity source = null;
            LivingEntity attacker = null;
            Vector3Argument location = Vector3Argument.findIn(lv, 0, false, true);
            Vec3 pos = location.vec;
            if (lv.size() > location.offset) {
                powah = NumericValue.asNumber((Value)lv.get(location.offset), "explosion power").getFloat();
                if (powah < 0.0f) {
                    throw new InternalExpressionException("Explosion power cannot be negative");
                }
                if (lv.size() > location.offset + 1) {
                    String strval = ((Value)lv.get(location.offset + 1)).getString();
                    try {
                        mode = Explosion.BlockInteraction.valueOf((String)strval.toUpperCase(Locale.ROOT));
                    }
                    catch (IllegalArgumentException ile) {
                        throw new InternalExpressionException("Illegal explosions block behaviour: " + strval);
                    }
                    if (lv.size() > location.offset + 2) {
                        createFire = ((Value)lv.get(location.offset + 2)).getBoolean();
                        if (lv.size() > location.offset + 3) {
                            EntityValue ev;
                            Value enVal = (Value)lv.get(location.offset + 3);
                            if (!enVal.isNull()) {
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fourth parameter of the explosion has to be an entity, not " + enVal.getTypeString());
                                ev = (EntityValue)enVal;
                                source = ev.getEntity();
                            }
                            if (lv.size() > location.offset + 4 && !(enVal = (Value)lv.get(location.offset + 4)).isNull()) {
                                LivingEntity le;
                                if (!(enVal instanceof EntityValue)) throw new InternalExpressionException("Fifth parameter of the explosion has to be a living entity, not " + enVal.getTypeString());
                                ev = (EntityValue)enVal;
                                Entity attackingEntity = ev.getEntity();
                                if (!(attackingEntity instanceof LivingEntity)) throw new InternalExpressionException("Attacking entity needs to be a living thing, " + ValueConversions.of(cc.registry(Registries.ENTITY_TYPE).getKey((Object)attackingEntity.getType())).getString() + " ain't it.");
                                attacker = le = (LivingEntity)attackingEntity;
                            }
                        }
                    }
                }
            }
            final LivingEntity theAttacker = attacker;
            float thePowah = powah;
            Explosion explosion = new Explosion((Level)cc.level(), source, null, null, pos.x, pos.y, pos.z, powah, createFire, mode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE){

                @Nullable
                public LivingEntity getIndirectSourceEntity() {
                    return theAttacker;
                }
            };
            explosion.explode();
            explosion.finalizeExplosion(false);
            if (mode == Explosion.BlockInteraction.KEEP) {
                explosion.clearToBlow();
            }
            Explosion.BlockInteraction finalMode = mode;
            cc.level().players().forEach(spe -> {
                if (spe.distanceToSqr(pos) < 4096.0) {
                    spe.connection.send((Packet)new ClientboundExplodePacket(pos.x, pos.y, pos.z, thePowah, explosion.getToBlow(), (Vec3)explosion.getHitPlayers().get(spe), finalMode, (ParticleOptions)ParticleTypes.EXPLOSION, (ParticleOptions)ParticleTypes.EXPLOSION_EMITTER, (Holder)SoundEvents.GENERIC_EXPLODE));
                }
            });
            return Value.TRUE;
        });
        expression.addContextFunction("place_item", -1, (c, t, lv) -> {
            if (lv.size() < 2) {
                throw new InternalExpressionException("'place_item' takes at least 2 parameters: item and block, or position, to place onto");
            }
            CarpetContext cc = (CarpetContext)c;
            String itemString = ((Value)lv.get(0)).getString();
            Vector3Argument locator = Vector3Argument.findIn(lv, 1);
            ItemStack stackArg = NBTSerializableValue.parseItem(itemString, cc.registryAccess());
            BlockPos where = BlockPos.containing((Position)locator.vec);
            String facing = lv.size() > locator.offset ? ((Value)lv.get(locator.offset)).getString() : (stackArg.getItem() != Items.PAINTING ? "up" : "north");
            boolean sneakPlace = false;
            if (lv.size() > locator.offset + 1) {
                sneakPlace = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            BlockValue.PlacementContext ctx = BlockValue.PlacementContext.from((Level)cc.level(), where, facing, sneakPlace, stackArg);
            Item patt0$temp = stackArg.getItem();
            if (!(patt0$temp instanceof BlockItem)) {
                InteractionResult useResult = ctx.getItemInHand().useOn((UseOnContext)ctx);
                if (useResult == InteractionResult.CONSUME || useResult == InteractionResult.SUCCESS) {
                    return Value.TRUE;
                }
            } else {
                Level level;
                BlockItem blockItem = (BlockItem)patt0$temp;
                if (!ctx.canPlace()) {
                    return Value.FALSE;
                }
                BlockState placementState = blockItem.getBlock().getStateForPlacement((BlockPlaceContext)ctx);
                if (placementState != null && placementState.canSurvive((LevelReader)(level = ctx.getLevel()), where)) {
                    level.setBlock(where, placementState, 2);
                    SoundType blockSoundGroup = placementState.getSoundType();
                    level.playSound(null, where, blockSoundGroup.getPlaceSound(), SoundSource.BLOCKS, (blockSoundGroup.getVolume() + 1.0f) / 2.0f, blockSoundGroup.getPitch() * 0.8f);
                    return Value.TRUE;
                }
            }
            return Value.FALSE;
        });
        expression.addContextFunction("blocks_movement", -1, (c, t, lv) -> WorldAccess.booleanStateTest(c, "blocks_movement", lv, (s, p) -> !s.isPathfindable(PathComputationType.LAND)));
        expression.addContextFunction("block_sound", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "block_sound", lv, (s, p) -> Colors.soundName.get(s.getSoundType())));
        expression.addContextFunction("material", -1, (c, t, lv) -> {
            c.host.issueDeprecation("material(...)");
            return StringValue.of("unknown");
        });
        expression.addContextFunction("map_colour", -1, (c, t, lv) -> WorldAccess.stateStringQuery(c, "map_colour", lv, (s, p) -> Colors.mapColourName.get(s.getMapColor((BlockGetter)((CarpetContext)c).level(), p))));
        expression.addContextFunction("property", -1, (c, t, lv) -> {
            c.host.issueDeprecation("property(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockState state = locator.block.getBlockState();
            if (lv.size() <= locator.offset) {
                throw new InternalExpressionException("'property' requires to specify a property to query");
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            StateDefinition states = state.getBlock().getStateDefinition();
            Property property = states.getProperty(tag);
            return property == null ? Value.NULL : new StringValue(state.getValue(property).toString().toLowerCase(Locale.ROOT));
        });
        expression.addContextFunction("block_properties", -1, (c, t, lv) -> {
            c.host.issueDeprecation("block_properties(...)");
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0);
            BlockState state = locator.block.getBlockState();
            StateDefinition states = state.getBlock().getStateDefinition();
            return ListValue.wrap(states.getProperties().stream().map(p -> new StringValue(p.getName())));
        });
        expression.addContextFunction("block_state", -1, (c, t, lv) -> {
            BlockArgument locator = BlockArgument.findIn((CarpetContext)c, lv, 0, true);
            BlockState state = locator.block.getBlockState();
            StateDefinition states = state.getBlock().getStateDefinition();
            if (locator.offset == lv.size()) {
                HashMap<Value, Value> properties = new HashMap<Value, Value>();
                for (Property p : states.getProperties()) {
                    properties.put(StringValue.of(p.getName()), ValueConversions.fromProperty(state, p));
                }
                return MapValue.wrap(properties);
            }
            String tag = ((Value)lv.get(locator.offset)).getString();
            Property property = states.getProperty(tag);
            return property == null ? Value.NULL : ValueConversions.fromProperty(state, property);
        });
        expression.addContextFunction("block_list", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.BLOCK);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.holders().map(blockReference -> ValueConversions.of(blockReference.key().location())));
            }
            ResourceLocation tag = InputValidator.identifierOf(((Value)lv.get(0)).getString());
            Optional tagset = blocks.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)tag));
            return tagset.isEmpty() ? Value.NULL : ListValue.wrap(((HolderSet.Named)tagset.get()).stream().map(b -> ValueConversions.of(blocks.getKey((Object)((Block)b.value())))));
        });
        expression.addContextFunction("block_tags", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            Registry blocks = cc.registry(Registries.BLOCK);
            if (lv.isEmpty()) {
                return ListValue.wrap(blocks.getTagNames().map(ValueConversions::of));
            }
            BlockArgument blockLocator = BlockArgument.findIn(cc, lv, 0, true);
            if (blockLocator.offset == lv.size()) {
                Block target = blockLocator.block.getBlockState().getBlock();
                return ListValue.wrap(blocks.getTags().filter(e -> ((HolderSet.Named)e.getSecond()).stream().anyMatch(h -> h.value() == target)).map(e -> ValueConversions.of((TagKey)e.getFirst())));
            }
            String tag = ((Value)lv.get(blockLocator.offset)).getString();
            Optional tagSet = blocks.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)InputValidator.identifierOf(tag)));
            return tagSet.isEmpty() ? Value.NULL : BooleanValue.of(blockLocator.block.getBlockState().is((HolderSet)tagSet.get()));
        });
        expression.addContextFunction("biome", -1, (c, t, lv) -> {
            Biome biome;
            Object patt0$temp;
            CarpetContext cc = (CarpetContext)c;
            ServerLevel world = cc.level();
            if (lv.isEmpty()) {
                return ListValue.wrap(cc.registry(Registries.BIOME).holders().map(biomeReference -> ValueConversions.of(biomeReference.key().location())));
            }
            BiomeSource biomeSource = world.getChunkSource().getGenerator().getBiomeSource();
            if (lv.size() == 1 && (patt0$temp = lv.get(0)) instanceof MapValue) {
                MapValue map = (MapValue)patt0$temp;
                if (biomeSource instanceof MultiNoiseBiomeSource) {
                    MultiNoiseBiomeSource mnbs = (MultiNoiseBiomeSource)biomeSource;
                    Value temperature = map.get(new StringValue("temperature"));
                    WorldAccess.nullCheck(temperature, "temperature");
                    Value humidity = map.get(new StringValue("humidity"));
                    WorldAccess.nullCheck(humidity, "humidity");
                    Value continentalness = map.get(new StringValue("continentalness"));
                    WorldAccess.nullCheck(continentalness, "continentalness");
                    Value erosion = map.get(new StringValue("erosion"));
                    WorldAccess.nullCheck(erosion, "erosion");
                    Value depth = map.get(new StringValue("depth"));
                    WorldAccess.nullCheck(depth, "depth");
                    Value weirdness = map.get(new StringValue("weirdness"));
                    WorldAccess.nullCheck(weirdness, "weirdness");
                    Climate.TargetPoint point = new Climate.TargetPoint(Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(temperature)), Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(humidity)), Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(continentalness)), Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(erosion)), Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(depth)), Climate.quantizeCoord((float)WorldAccess.numberGetOrThrow(weirdness)));
                    Biome biome2 = (Biome)mnbs.getNoiseBiome(point).value();
                    ResourceLocation biomeId = cc.registry(Registries.BIOME).getKey((Object)biome2);
                    return NBTSerializableValue.nameFromRegistryId(biomeId);
                }
            }
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0, false, false, true);
            if (locator.replacement != null) {
                biome = (Biome)world.registryAccess().registryOrThrow(Registries.BIOME).get(InputValidator.identifierOf(locator.replacement));
                if (biome == null) {
                    throw new ThrowStatement(locator.replacement, Throwables.UNKNOWN_BIOME);
                }
            } else {
                biome = (Biome)world.getBiome(locator.block.getPos()).value();
            }
            if (locator.offset == lv.size()) {
                ResourceLocation biomeId = cc.registry(Registries.BIOME).getKey((Object)biome);
                return NBTSerializableValue.nameFromRegistryId(biomeId);
            }
            String biomeFeature = ((Value)lv.get(locator.offset)).getString();
            BiFunction<ServerLevel, Biome, Value> featureProvider = BiomeInfo.biomeFeatures.get(biomeFeature);
            if (featureProvider == null) {
                throw new InternalExpressionException("Unknown biome feature: " + biomeFeature);
            }
            return featureProvider.apply(world, biome);
        });
        expression.addContextFunction("set_biome", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_biome' needs a biome name as an argument");
            }
            String biomeName = ((Value)lv.get(locator.offset)).getString();
            Holder biome = (Holder)cc.registry(Registries.BIOME).getHolder(ResourceKey.create((ResourceKey)Registries.BIOME, (ResourceLocation)InputValidator.identifierOf(biomeName))).orElseThrow(() -> new ThrowStatement(biomeName, Throwables.UNKNOWN_BIOME));
            boolean doImmediateUpdate = true;
            if (lv.size() > locator.offset + 1) {
                doImmediateUpdate = ((Value)lv.get(locator.offset + 1)).getBoolean();
            }
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            ChunkAccess chunk = world.getChunk(pos);
            int biomeX = QuartPos.fromBlock((int)pos.getX());
            int biomeY = QuartPos.fromBlock((int)pos.getY());
            int biomeZ = QuartPos.fromBlock((int)pos.getZ());
            try {
                int i = QuartPos.fromBlock((int)chunk.getMinBuildHeight());
                int j = i + QuartPos.fromBlock((int)chunk.getHeight()) - 1;
                int k = Mth.clamp((int)biomeY, (int)i, (int)j);
                int l = chunk.getSectionIndex(QuartPos.toBlock((int)k));
                ((PalettedContainer)chunk.getSection(l).getBiomes()).set(biomeX & 3, k & 3, biomeZ & 3, (Object)biome);
            }
            catch (Throwable var8) {
                return Value.FALSE;
            }
            if (doImmediateUpdate) {
                WorldTools.forceChunkUpdate(pos, world);
            }
            chunk.setUnsaved(true);
            return Value.TRUE;
        });
        expression.addContextFunction("reload_chunk", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockPos pos = BlockArgument.findIn((CarpetContext)cc, (List<Value>)lv, (int)0).block.getPos();
            ServerLevel world = cc.level();
            cc.server().executeBlocking(() -> WorldTools.forceChunkUpdate(pos, world));
            return Value.TRUE;
        });
        expression.addContextFunction("structure_references", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            Map references = world.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.STRUCTURE_REFERENCES).getAllReferences();
            Registry reg = cc.registry(Registries.STRUCTURE);
            if (lv.size() == locator.offset) {
                return ListValue.wrap(references.entrySet().stream().filter(e -> e.getValue() != null && !((LongSet)e.getValue()).isEmpty()).map(e -> NBTSerializableValue.nameFromRegistryId(reg.getKey((Object)((Structure)e.getKey())))));
            }
            String simpleStructureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            Structure structureName = (Structure)reg.get(InputValidator.identifierOf(simpleStructureName));
            if (structureName == null) {
                return Value.NULL;
            }
            LongSet structureReferences = (LongSet)references.get(structureName);
            if (structureReferences == null || structureReferences.isEmpty()) {
                return ListValue.of(new Value[0]);
            }
            return ListValue.wrap(structureReferences.longStream().mapToObj(l -> ListValue.of(new NumericValue(16L * (long)ChunkPos.getX((long)l)), Value.ZERO, new NumericValue(16L * (long)ChunkPos.getZ((long)l)))));
        });
        expression.addContextFunction("structure_eligibility", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            WorldAccess.theBooYah(world);
            BlockPos pos = locator.block.getPos();
            ArrayList<Structure> structure = new ArrayList<Structure>();
            boolean needSize = false;
            boolean singleOutput = false;
            Registry reg = cc.registry(Registries.STRUCTURE);
            if (lv.size() > locator.offset) {
                Value requested = (Value)lv.get(locator.offset);
                if (!requested.isNull()) {
                    String reqString = requested.getString();
                    ResourceLocation id = InputValidator.identifierOf(reqString);
                    Structure requestedStructure = (Structure)reg.get(id);
                    if (requestedStructure != null) {
                        singleOutput = true;
                        structure.add(requestedStructure);
                    } else {
                        StructureType sss = (StructureType)cc.registry(Registries.STRUCTURE_TYPE).get(id);
                        reg.entrySet().stream().filter(e -> ((Structure)e.getValue()).type() == sss).forEach(e -> structure.add((Structure)e.getValue()));
                    }
                    if (structure.isEmpty()) {
                        throw new ThrowStatement(reqString, Throwables.UNKNOWN_STRUCTURE);
                    }
                } else {
                    structure.addAll(reg.entrySet().stream().map(Map.Entry::getValue).toList());
                }
                if (lv.size() > locator.offset + 1) {
                    needSize = ((Value)lv.get(locator.offset + 1)).getBoolean();
                }
            } else {
                structure.addAll(reg.entrySet().stream().map(Map.Entry::getValue).toList());
            }
            if (singleOutput) {
                StructureStart start = FeatureGenerator.shouldStructureStartAt(world, pos, (Structure)structure.get(0), needSize);
                return start == null ? Value.NULL : (!needSize ? Value.TRUE : ValueConversions.of(start, cc.registryAccess()));
            }
            HashMap<Value, Value> ret = new HashMap<Value, Value>();
            for (Structure str : structure) {
                StructureStart start;
                try {
                    start = FeatureGenerator.shouldStructureStartAt(world, pos, str, needSize);
                }
                catch (NullPointerException npe) {
                    CarpetScriptServer.LOG.error("Failed to detect structure: " + String.valueOf(reg.getKey((Object)str)));
                    start = null;
                }
                if (start == null) continue;
                Value key = NBTSerializableValue.nameFromRegistryId(reg.getKey((Object)str));
                ret.put(key, !needSize ? Value.NULL : ValueConversions.of(start, cc.registryAccess()));
            }
            return MapValue.wrap(ret);
        });
        expression.addContextFunction("structures", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            Map structures = world.getChunk(pos.getX() >> 4, pos.getZ() >> 4, ChunkStatus.STRUCTURE_STARTS).getAllStarts();
            Registry reg = cc.registry(Registries.STRUCTURE);
            if (lv.size() == locator.offset) {
                HashMap<Value, Value> structureList = new HashMap<Value, Value>();
                for (Map.Entry entry : structures.entrySet()) {
                    StructureStart start = (StructureStart)entry.getValue();
                    if (start == StructureStart.INVALID_START) continue;
                    BoundingBox box = start.getBoundingBox();
                    structureList.put(NBTSerializableValue.nameFromRegistryId(reg.getKey((Object)((Structure)entry.getKey()))), ValueConversions.of(box));
                }
                return MapValue.wrap(structureList);
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            return ValueConversions.of((StructureStart)structures.get(reg.get(InputValidator.identifierOf(structureName))), cc.registryAccess());
        });
        expression.addContextFunction("set_structure", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            ServerLevel world = cc.level();
            BlockPos pos = locator.block.getPos();
            if (lv.size() == locator.offset) {
                throw new InternalExpressionException("'set_structure requires at least position and a structure name");
            }
            String structureName = ((Value)lv.get(locator.offset)).getString().toLowerCase(Locale.ROOT);
            Structure configuredStructure = FeatureGenerator.resolveConfiguredStructure(structureName, world, pos);
            if (configuredStructure == null) {
                throw new ThrowStatement(structureName, Throwables.UNKNOWN_STRUCTURE);
            }
            Value[] result = new Value[]{Value.NULL};
            ((CarpetContext)c).server().executeBlocking(() -> {
                Map structures = world.getChunk(pos).getAllStarts();
                if (lv.size() == locator.offset + 1) {
                    boolean res = FeatureGenerator.plopGrid(configuredStructure, ((CarpetContext)c).level(), locator.block.getPos());
                    result[0] = res ? Value.TRUE : Value.FALSE;
                    return;
                }
                Value newValue = (Value)lv.get(locator.offset + 1);
                if (newValue.isNull()) {
                    if (!structures.containsKey(configuredStructure)) {
                        return;
                    }
                    StructureStart start = (StructureStart)structures.get(configuredStructure);
                    ChunkPos structureChunkPos = start.getChunkPos();
                    BoundingBox box = start.getBoundingBox();
                    for (int chx = box.minX() / 16; chx <= box.maxX() / 16; ++chx) {
                        for (int chz = box.minZ() / 16; chz <= box.maxZ() / 16; ++chz) {
                            ChunkPos chpos = new ChunkPos(chx, chz);
                            Map references = world.getChunk(chpos.getWorldPosition()).getAllReferences();
                            if (!references.containsKey(configuredStructure) || references.get(configuredStructure) == null) continue;
                            ((LongSet)references.get(configuredStructure)).remove(structureChunkPos.toLong());
                        }
                    }
                    structures.remove(configuredStructure);
                    result[0] = Value.TRUE;
                }
            });
            return result[0];
        });
        expression.addContextFunction("reset_chunk", -1, (c, t, lv) -> Value.NULL);
        expression.addContextFunction("inhabited_time", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            return new NumericValue(cc.level().getChunk(pos).getInhabitedTime());
        });
        expression.addContextFunction("spawn_potential", -1, (c, t, lv) -> {
            NaturalSpawner.SpawnState charger;
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            double requiredCharge = 1.0;
            if (lv.size() > locator.offset) {
                requiredCharge = NumericValue.asNumber((Value)lv.get(locator.offset)).getDouble();
            }
            return (charger = cc.level().getChunkSource().getLastSpawnState()) == null ? Value.NULL : new NumericValue(Vanilla.SpawnState_getPotentialCalculator(charger).getPotentialEnergyChange(pos, requiredCharge));
        });
        expression.addContextFunction("add_chunk_ticket", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            if (lv.size() != locator.offset + 2) {
                throw new InternalExpressionException("'add_chunk_ticket' requires block position, ticket type and radius");
            }
            String type = ((Value)lv.get(locator.offset)).getString();
            TicketType<?> ticket = ticketTypes.get(type.toLowerCase(Locale.ROOT));
            if (ticket == null) {
                throw new InternalExpressionException("Unknown ticket type: " + type);
            }
            int radius = NumericValue.asNumber((Value)lv.get(locator.offset + 1)).getInt();
            if (radius < 1 || radius > 32) {
                throw new InternalExpressionException("Ticket radius should be between 1 and 32 chunks");
            }
            ChunkPos target = new ChunkPos(pos);
            if (ticket == TicketType.PORTAL) {
                cc.level().getChunkSource().addRegionTicket(TicketType.PORTAL, target, radius, (Object)pos);
            } else if (ticket == TicketType.POST_TELEPORT) {
                cc.level().getChunkSource().addRegionTicket(TicketType.POST_TELEPORT, target, radius, (Object)1);
            } else {
                cc.level().getChunkSource().addRegionTicket(TicketType.UNKNOWN, target, radius, (Object)target);
            }
            return new NumericValue(ticket.timeout());
        });
        expression.addContextFunction("sample_noise", -1, (c, t, lv) -> {
            CarpetContext cc = (CarpetContext)c;
            if (lv.isEmpty()) {
                return ListValue.wrap(cc.registry(Registries.DENSITY_FUNCTION).keySet().stream().map(ValueConversions::of));
            }
            ServerLevel level = cc.level();
            BlockArgument locator = BlockArgument.findIn(cc, lv, 0);
            BlockPos pos = locator.block.getPos();
            String[] densityFunctionQueries = (String[])lv.stream().skip(locator.offset).map(Value::getString).toArray(String[]::new);
            if (densityFunctionQueries.length == 0) {
                return ListValue.wrap(cc.registry(Registries.DENSITY_FUNCTION).keySet().stream().map(ValueConversions::of));
            }
            NoiseRouter router = level.getChunkSource().randomState().router();
            return densityFunctionQueries.length == 1 ? NumericValue.of(WorldAccess.sampleNoise(router, level, densityFunctionQueries[0], pos)) : ListValue.wrap(Arrays.stream(densityFunctionQueries).map(s -> NumericValue.of(WorldAccess.sampleNoise(router, level, s, pos))));
        });
    }

    public static double sampleNoise(NoiseRouter router, ServerLevel level, String what, BlockPos pos) {
        DensityFunction densityFunction = switch (what) {
            case "barrier_noise" -> router.barrierNoise();
            case "fluid_level_floodedness_noise" -> router.fluidLevelFloodednessNoise();
            case "fluid_level_spread_noise" -> router.fluidLevelSpreadNoise();
            case "lava_noise" -> router.lavaNoise();
            case "temperature" -> router.temperature();
            case "vegetation" -> router.vegetation();
            case "continents" -> router.continents();
            case "erosion" -> router.erosion();
            case "depth" -> router.depth();
            case "ridges" -> router.ridges();
            case "initial_density_without_jaggedness" -> router.initialDensityWithoutJaggedness();
            case "final_density" -> router.finalDensity();
            case "vein_toggle" -> router.veinToggle();
            case "vein_ridged" -> router.veinRidged();
            case "vein_gap" -> router.veinGap();
            default -> stupidWorldgenNoiseCacheGetter.apply((Pair<ServerLevel, String>)Pair.of((Object)level, (Object)what));
        };
        return densityFunction.compute((DensityFunction.FunctionContext)new DensityFunction.SinglePointContext(pos.getX(), pos.getY(), pos.getZ()));
    }

    static {
        DIRECTION_MAP.put("y", Direction.UP);
        DIRECTION_MAP.put("z", Direction.SOUTH);
        DIRECTION_MAP.put("x", Direction.EAST);
        ticketTypes = Map.of("portal", TicketType.PORTAL, "teleport", TicketType.POST_TELEPORT, "unknown", TicketType.UNKNOWN);
        DUMMY_ENTITY = null;
        stupidWorldgenNoiseCacheGetter = Util.memoize(pair -> {
            ServerLevel level = (ServerLevel)pair.getKey();
            String densityFunctionQuery = (String)pair.getValue();
            ChunkGenerator generator = level.getChunkSource().getGenerator();
            if (generator instanceof NoiseBasedChunkGenerator) {
                NoiseBasedChunkGenerator noiseBasedChunkGenerator = (NoiseBasedChunkGenerator)generator;
                Registry densityFunctionRegistry = level.registryAccess().registryOrThrow(Registries.DENSITY_FUNCTION);
                NoiseRouter router = ((NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value()).noiseRouter();
                DensityFunction densityFunction = switch (densityFunctionQuery) {
                    case "barrier_noise" -> router.barrierNoise();
                    case "fluid_level_floodedness_noise" -> router.fluidLevelFloodednessNoise();
                    case "fluid_level_spread_noise" -> router.fluidLevelSpreadNoise();
                    case "lava_noise" -> router.lavaNoise();
                    case "temperature" -> router.temperature();
                    case "vegetation" -> router.vegetation();
                    case "continents" -> router.continents();
                    case "erosion" -> router.erosion();
                    case "depth" -> router.depth();
                    case "ridges" -> router.ridges();
                    case "initial_density_without_jaggedness" -> router.initialDensityWithoutJaggedness();
                    case "final_density" -> router.finalDensity();
                    case "vein_toggle" -> router.veinToggle();
                    case "vein_ridged" -> router.veinRidged();
                    case "vein_gap" -> router.veinGap();
                    default -> {
                        DensityFunction result = (DensityFunction)densityFunctionRegistry.get(InputValidator.identifierOf(densityFunctionQuery));
                        if (result == null) {
                            throw new InternalExpressionException("Density function '" + densityFunctionQuery + "' is not defined in the registies.");
                        }
                        yield result;
                    }
                };
                RandomState randomState = RandomState.create((NoiseGeneratorSettings)((NoiseGeneratorSettings)noiseBasedChunkGenerator.generatorSettings().value()), (HolderGetter)level.registryAccess().lookupOrThrow(Registries.NOISE), (long)level.getSeed());
                DensityFunction.Visitor visitor = Vanilla.RandomState_getVisitor(randomState);
                return densityFunction.mapAll(visitor);
            }
            return DensityFunctions.zero();
        });
    }
}

