/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import carpet.script.value.ListValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;

public class BiomeInfo {
    public static final Map<String, BiFunction<ServerLevel, Biome, Value>> biomeFeatures = new HashMap<String, BiFunction<ServerLevel, Biome, Value>>(){
        {
            this.put("tags", (w, b) -> ListValue.wrap(w.registryAccess().registryOrThrow(Registries.BIOME).getTags().filter(p -> ((HolderSet.Named)p.getSecond()).stream().anyMatch(h -> h.value() == b)).map(p -> ((TagKey)p.getFirst()).location()).map(ValueConversions::of)));
            this.put("temperature", (w, b) -> NumericValue.of(Float.valueOf(b.getBaseTemperature())));
            this.put("fog_color", (w, b) -> ValueConversions.ofRGB(b.getSpecialEffects().getFogColor()));
            this.put("foliage_color", (w, b) -> ValueConversions.ofRGB(b.getSpecialEffects().getFoliageColorOverride().orElse(4764952)));
            this.put("sky_color", (w, b) -> ValueConversions.ofRGB(b.getSpecialEffects().getSkyColor()));
            this.put("water_color", (w, b) -> ValueConversions.ofRGB(b.getSpecialEffects().getWaterColor()));
            this.put("water_fog_color", (w, b) -> ValueConversions.ofRGB(b.getSpecialEffects().getWaterFogColor()));
            this.put("humidity", (w, b) -> NumericValue.of(Float.valueOf(Vanilla.Biome_getClimateSettings(b).downfall())));
            this.put("precipitation", (w, b) -> StringValue.of(b.getPrecipitationAt(new BlockPos(0, w.getSeaLevel(), 0)).name().toLowerCase(Locale.ROOT)));
            this.put("features", (w, b) -> {
                Registry registry = w.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE);
                return ListValue.wrap(b.getGenerationSettings().features().stream().map(step -> ListValue.wrap(step.stream().map(cfp -> ValueConversions.of(registry.getKey((Object)((ConfiguredFeature)((PlacedFeature)cfp.value()).feature().value())))))));
            });
        }
    };
}

