/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import java.util.List;
import net.minecraft.world.Container;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;

public class EquipmentInventory
implements Container {
    private static final List<EquipmentSlot> slotToSlot = List.of(EquipmentSlot.MAINHAND, EquipmentSlot.FEET, EquipmentSlot.LEGS, EquipmentSlot.CHEST, EquipmentSlot.HEAD, EquipmentSlot.OFFHAND);
    LivingEntity mob;

    public EquipmentInventory(LivingEntity mob) {
        this.mob = mob;
    }

    public int getContainerSize() {
        return 6;
    }

    public boolean isEmpty() {
        for (EquipmentSlot slot : slotToSlot) {
            if (this.mob.getItemBySlot(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public ItemStack getItem(int slot) {
        EquipmentSlot slotSlot;
        try {
            slotSlot = slotToSlot.get(slot);
        }
        catch (IndexOutOfBoundsException ignored) {
            return ItemStack.EMPTY;
        }
        return this.mob.getItemBySlot(slotSlot);
    }

    public ItemStack removeItem(int slot, int amount) {
        EquipmentSlot slotSlot;
        try {
            slotSlot = slotToSlot.get(slot);
        }
        catch (IndexOutOfBoundsException ignored) {
            return ItemStack.EMPTY;
        }
        return this.mob.getItemBySlot(slotSlot).split(amount);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        EquipmentSlot slotSlot;
        try {
            slotSlot = slotToSlot.get(slot);
        }
        catch (IndexOutOfBoundsException ignored) {
            return ItemStack.EMPTY;
        }
        ItemStack previous = this.mob.getItemBySlot(slotSlot);
        this.mob.setItemSlot(slotSlot, ItemStack.EMPTY);
        return previous;
    }

    public void setItem(int slot, ItemStack stack) {
        EquipmentSlot slotSlot;
        try {
            slotSlot = slotToSlot.get(slot);
        }
        catch (IndexOutOfBoundsException ignored) {
            return;
        }
        this.mob.setItemSlot(slotSlot, stack);
    }

    public void setChanged() {
    }

    public boolean stillValid(Player player) {
        return false;
    }

    public void clearContent() {
        for (EquipmentSlot slot : slotToSlot) {
            this.mob.setItemSlot(slot, ItemStack.EMPTY);
        }
    }
}

