/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.CarpetScriptServer;
import carpet.script.external.Vanilla;
import com.google.common.collect.ImmutableList;
import com.mojang.datafixers.util.Pair;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.Pools;
import net.minecraft.data.worldgen.ProcessorLists;
import net.minecraft.data.worldgen.placement.PlacementUtils;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerChunkCache;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BiomeTags;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.ConstantInt;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.chunk.ChunkGeneratorStructureState;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.RandomState;
import net.minecraft.world.level.levelgen.VerticalAnchor;
import net.minecraft.world.level.levelgen.feature.ConfiguredFeature;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.configurations.FeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.SimpleRandomFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.featuresize.FeatureSize;
import net.minecraft.world.level.levelgen.feature.featuresize.TwoLayersFeatureSize;
import net.minecraft.world.level.levelgen.feature.foliageplacers.BlobFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FancyFoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.stateproviders.BlockStateProvider;
import net.minecraft.world.level.levelgen.feature.treedecorators.BeehiveDecorator;
import net.minecraft.world.level.levelgen.feature.trunkplacers.FancyTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.StraightTrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.heightproviders.ConstantHeight;
import net.minecraft.world.level.levelgen.heightproviders.HeightProvider;
import net.minecraft.world.level.levelgen.placement.PlacedFeature;
import net.minecraft.world.level.levelgen.placement.PlacementModifier;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.Structure;
import net.minecraft.world.level.levelgen.structure.StructureStart;
import net.minecraft.world.level.levelgen.structure.StructureType;
import net.minecraft.world.level.levelgen.structure.TerrainAdjustment;
import net.minecraft.world.level.levelgen.structure.pools.StructurePoolElement;
import net.minecraft.world.level.levelgen.structure.pools.StructureTemplatePool;
import net.minecraft.world.level.levelgen.structure.structures.JigsawStructure;

public class FeatureGenerator {
    public static final Map<String, Function<ServerLevel, Thing>> featureMap = new HashMap<String, Function<ServerLevel, Thing>>(){
        {
            this.put("oak_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(Blocks.OAK_LOG, Blocks.OAK_LEAVES, 4, 2, 0, 2).ignoreVines().decorators(List.of(new BeehiveDecorator(1.0f))).build()));
            this.put("fancy_oak_bees", l -> FeatureGenerator.simpleTree(new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LOG), (TrunkPlacer)new FancyTrunkPlacer(3, 11, 0), (BlockStateProvider)BlockStateProvider.simple((Block)Blocks.OAK_LEAVES), (FoliagePlacer)new FancyFoliagePlacer((IntProvider)ConstantInt.of((int)2), (IntProvider)ConstantInt.of((int)4), 4), (FeatureSize)new TwoLayersFeatureSize(0, 0, 0, OptionalInt.of(4))).ignoreVines().decorators(List.of(new BeehiveDecorator(1.0f))).build()));
            this.put("birch_bees", l -> FeatureGenerator.simpleTree(FeatureGenerator.createTree(Blocks.BIRCH_LOG, Blocks.BIRCH_LEAVES, 5, 2, 0, 2).ignoreVines().decorators(List.of(new BeehiveDecorator(1.0f))).build()));
            this.put("coral_tree", l -> FeatureGenerator.simplePlop(Feature.CORAL_TREE, FeatureConfiguration.NONE));
            this.put("coral_claw", l -> FeatureGenerator.simplePlop(Feature.CORAL_CLAW, FeatureConfiguration.NONE));
            this.put("coral_mushroom", l -> FeatureGenerator.simplePlop(Feature.CORAL_MUSHROOM, FeatureConfiguration.NONE));
            this.put("coral", l -> FeatureGenerator.simplePlop(Feature.SIMPLE_RANDOM_SELECTOR, new SimpleRandomFeatureConfiguration((HolderSet)HolderSet.direct((Holder[])new Holder[]{PlacementUtils.inlinePlaced((Feature)Feature.CORAL_TREE, (FeatureConfiguration)FeatureConfiguration.NONE, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.CORAL_CLAW, (FeatureConfiguration)FeatureConfiguration.NONE, (PlacementModifier[])new PlacementModifier[0]), PlacementUtils.inlinePlaced((Feature)Feature.CORAL_MUSHROOM, (FeatureConfiguration)FeatureConfiguration.NONE, (PlacementModifier[])new PlacementModifier[0])}))));
            this.put("bastion_remnant_units", l -> {
                RegistryAccess regs = l.registryAccess();
                HolderLookup.RegistryLookup processorLists = regs.lookupOrThrow(Registries.PROCESSOR_LIST);
                Holder.Reference bastionGenericDegradation = processorLists.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
                HolderLookup.RegistryLookup pools = regs.lookupOrThrow(Registries.TEMPLATE_POOL);
                Holder.Reference empty = pools.getOrThrow(Pools.EMPTY);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.registryAccess().registryOrThrow(Registries.BIOME).getOrCreateTag(BiomeTags.HAS_BASTION_REMNANT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.direct((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"bastion/units/air_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)33)), false));
            });
            this.put("bastion_remnant_hoglin_stable", l -> {
                RegistryAccess regs = l.registryAccess();
                HolderLookup.RegistryLookup processorLists = regs.lookupOrThrow(Registries.PROCESSOR_LIST);
                Holder.Reference bastionGenericDegradation = processorLists.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
                HolderLookup.RegistryLookup pools = regs.lookupOrThrow(Registries.TEMPLATE_POOL);
                Holder.Reference empty = pools.getOrThrow(Pools.EMPTY);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.registryAccess().registryOrThrow(Registries.BIOME).getOrCreateTag(BiomeTags.HAS_BASTION_REMNANT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.direct((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"bastion/hoglin_stable/air_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)33)), false));
            });
            this.put("bastion_remnant_treasure", l -> {
                RegistryAccess regs = l.registryAccess();
                HolderLookup.RegistryLookup processorLists = regs.lookupOrThrow(Registries.PROCESSOR_LIST);
                Holder.Reference bastionGenericDegradation = processorLists.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
                HolderLookup.RegistryLookup pools = regs.lookupOrThrow(Registries.TEMPLATE_POOL);
                Holder.Reference empty = pools.getOrThrow(Pools.EMPTY);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.registryAccess().registryOrThrow(Registries.BIOME).getOrCreateTag(BiomeTags.HAS_BASTION_REMNANT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.direct((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"bastion/treasure/big_air_full", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)33)), false));
            });
            this.put("bastion_remnant_bridge", l -> {
                RegistryAccess regs = l.registryAccess();
                HolderLookup.RegistryLookup processorLists = regs.lookupOrThrow(Registries.PROCESSOR_LIST);
                Holder.Reference bastionGenericDegradation = processorLists.getOrThrow(ProcessorLists.BASTION_GENERIC_DEGRADATION);
                HolderLookup.RegistryLookup pools = regs.lookupOrThrow(Registries.TEMPLATE_POOL);
                Holder.Reference empty = pools.getOrThrow(Pools.EMPTY);
                return FeatureGenerator.spawnCustomStructure((Structure)new JigsawStructure(new Structure.StructureSettings((HolderSet)l.registryAccess().registryOrThrow(Registries.BIOME).getOrCreateTag(BiomeTags.HAS_BASTION_REMNANT), Map.of(), GenerationStep.Decoration.SURFACE_STRUCTURES, TerrainAdjustment.NONE), Holder.direct((Object)new StructureTemplatePool((Holder)empty, (List)ImmutableList.of((Object)Pair.of((Object)StructurePoolElement.single((String)"bastion/bridge/starting_pieces/entrance_base", (Holder)bastionGenericDegradation), (Object)1)), StructureTemplatePool.Projection.RIGID)), 6, (HeightProvider)ConstantHeight.of((VerticalAnchor)VerticalAnchor.absolute((int)33)), false));
            });
        }
    };

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static synchronized Boolean plop(String featureName, ServerLevel world, BlockPos pos) {
        ConfiguredFeature<?, ?> configuredStandard;
        Structure configuredStandard2;
        Function<ServerLevel, Thing> custom = featureMap.get(featureName);
        if (custom != null) {
            return custom.apply(world).plop(world, pos);
        }
        ResourceLocation id = ResourceLocation.parse((String)featureName);
        Structure structure = (Structure)world.registryAccess().registryOrThrow(Registries.STRUCTURE).get(id);
        if (structure != null) {
            return FeatureGenerator.plopAnywhere(structure, world, pos, world.getChunkSource().getGenerator(), false);
        }
        ConfiguredFeature configuredFeature = (ConfiguredFeature)world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).get(id);
        if (configuredFeature != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredFeature.place((WorldGenLevel)world, world.getChunkSource().getGenerator(), world.random, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        Optional structureType = world.registryAccess().registryOrThrow(Registries.STRUCTURE_TYPE).getOptional(id);
        if (structureType.isPresent() && (configuredStandard2 = FeatureGenerator.getDefaultFeature((StructureType)structureType.get(), world, pos)) != null) {
            return FeatureGenerator.plopAnywhere(configuredStandard2, world, pos, world.getChunkSource().getGenerator(), false);
        }
        Feature feature = (Feature)world.registryAccess().registryOrThrow(Registries.FEATURE).get(id);
        if (feature != null && (configuredStandard = FeatureGenerator.getDefaultFeature(feature, world, pos, true)) != null) {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
            checks.set(true);
            try {
                Boolean bl = configuredStandard.place((WorldGenLevel)world, world.getChunkSource().getGenerator(), world.random, pos);
                return bl;
            }
            finally {
                checks.set(false);
            }
        }
        return null;
    }

    @Nullable
    public static Structure resolveConfiguredStructure(String name, ServerLevel world, BlockPos pos) {
        ResourceLocation id = ResourceLocation.parse((String)name);
        Structure configuredStructureFeature = (Structure)world.registryAccess().registryOrThrow(Registries.STRUCTURE).get(id);
        if (configuredStructureFeature != null) {
            return configuredStructureFeature;
        }
        StructureType structureFeature = (StructureType)world.registryAccess().registryOrThrow(Registries.STRUCTURE_TYPE).get(id);
        if (structureFeature == null) {
            return null;
        }
        return FeatureGenerator.getDefaultFeature(structureFeature, world, pos);
    }

    public static synchronized boolean plopGrid(Structure structureFeature, ServerLevel world, BlockPos pos) {
        return FeatureGenerator.plopAnywhere(structureFeature, world, pos, world.getChunkSource().getGenerator(), true);
    }

    private static Thing simplePlop(ConfiguredFeature<?, ?> feature) {
        return (w, p) -> {
            ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(w);
            checks.set(true);
            try {
                Boolean bl = feature.place((WorldGenLevel)w, w.getChunkSource().getGenerator(), w.random, p);
                return bl;
            }
            finally {
                checks.set(false);
            }
        };
    }

    private static <FC extends FeatureConfiguration, F extends Feature<FC>> Thing simplePlop(F feature, FC config) {
        return FeatureGenerator.simplePlop(new ConfiguredFeature(feature, config));
    }

    private static Thing simpleTree(TreeConfiguration config) {
        return FeatureGenerator.simplePlop(new ConfiguredFeature(Feature.TREE, (FeatureConfiguration)config));
    }

    private static Thing spawnCustomStructure(Structure structure) {
        return FeatureGenerator.setupCustomStructure(structure, false);
    }

    private static Thing setupCustomStructure(Structure structure, boolean wireOnly) {
        return (w, p) -> FeatureGenerator.plopAnywhere(structure, w, p, w.getChunkSource().getGenerator(), wireOnly);
    }

    private static Structure getDefaultFeature(StructureType<?> structure, ServerLevel world, BlockPos pos) {
        Holder existingBiome = world.getBiome(pos);
        Structure result = null;
        Iterator<Structure> iterator = world.registryAccess().registryOrThrow(Registries.STRUCTURE).entrySet().stream().filter(cS -> ((Structure)cS.getValue()).type() == structure).map(Map.Entry::getValue).toList().iterator();
        while (iterator.hasNext()) {
            Structure confstr;
            result = confstr = iterator.next();
            if (!confstr.biomes().contains(existingBiome)) continue;
            return result;
        }
        return result;
    }

    private static ConfiguredFeature<?, ?> getDefaultFeature(Feature<?> feature, ServerLevel world, BlockPos pos, boolean tryHard) {
        List configuredStepFeatures = ((Biome)world.getBiome(pos).value()).getGenerationSettings().features();
        for (HolderSet step : configuredStepFeatures) {
            for (Holder provider : step) {
                if (((ConfiguredFeature)((PlacedFeature)provider.value()).feature().value()).feature() != feature) continue;
                return (ConfiguredFeature)((PlacedFeature)provider.value()).feature().value();
            }
        }
        if (!tryHard) {
            return null;
        }
        return world.registryAccess().registryOrThrow(Registries.CONFIGURED_FEATURE).entrySet().stream().filter(cS -> ((ConfiguredFeature)cS.getValue()).feature() == feature).findFirst().map(Map.Entry::getValue).orElse(null);
    }

    public static <T extends FeatureConfiguration> StructureStart shouldStructureStartAt(ServerLevel world, BlockPos pos, Structure structure, boolean computeBox) {
        ServerChunkCache chunkSource = world.getChunkSource();
        RandomState seed = chunkSource.randomState();
        ChunkGenerator generator = chunkSource.getGenerator();
        ChunkGeneratorStructureState structureState = chunkSource.getGeneratorState();
        List structureConfig = structureState.getPlacementsForStructure(Holder.direct((Object)structure));
        ChunkPos chunkPos = new ChunkPos(pos);
        boolean couldPlace = structureConfig.stream().anyMatch(p -> p.isStructureChunk(structureState, chunkPos.x, chunkPos.z));
        if (!couldPlace) {
            return null;
        }
        HolderSet structureBiomes = structure.biomes();
        if (!computeBox) {
            if (structure.findValidGenerationPoint(new Structure.GenerationContext(world.registryAccess(), generator, generator.getBiomeSource(), seed, world.getStructureManager(), world.getSeed(), chunkPos, (LevelHeightAccessor)world, arg_0 -> ((HolderSet)structureBiomes).contains(arg_0))).isPresent()) {
                return StructureStart.INVALID_START;
            }
        } else {
            StructureStart filledStructure = structure.generate(world.registryAccess(), generator, generator.getBiomeSource(), seed, world.getStructureManager(), world.getSeed(), chunkPos, 0, (LevelHeightAccessor)world, arg_0 -> ((HolderSet)structureBiomes).contains(arg_0));
            if (filledStructure != null && filledStructure.isValid()) {
                return filledStructure;
            }
        }
        return null;
    }

    private static TreeConfiguration.TreeConfigurationBuilder createTree(Block block, Block block2, int i, int j, int k, int l) {
        return new TreeConfiguration.TreeConfigurationBuilder((BlockStateProvider)BlockStateProvider.simple((Block)block), (TrunkPlacer)new StraightTrunkPlacer(i, j, k), (BlockStateProvider)BlockStateProvider.simple((Block)block2), (FoliagePlacer)new BlobFoliagePlacer((IntProvider)ConstantInt.of((int)l), (IntProvider)ConstantInt.of((int)0), 3), (FeatureSize)new TwoLayersFeatureSize(1, 0, 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean plopAnywhere(Structure structure, ServerLevel world, BlockPos pos, ChunkGenerator generator, boolean wireOnly) {
        ThreadLocal<Boolean> checks = Vanilla.skipGenerationChecks(world);
        checks.set(true);
        try {
            StructureStart start = structure.generate(world.registryAccess(), generator, generator.getBiomeSource(), world.getChunkSource().randomState(), world.getStructureManager(), world.getSeed(), new ChunkPos(pos), 0, (LevelHeightAccessor)world, b -> true);
            if (start == StructureStart.INVALID_START) {
                boolean bl = false;
                return bl;
            }
            RandomSource rand = RandomSource.create((long)world.getRandom().nextInt());
            int j = pos.getX() >> 4;
            int k = pos.getZ() >> 4;
            long chId = ChunkPos.asLong((int)j, (int)k);
            world.getChunk(j, k).setStartForStructure(structure, start);
            world.getChunk(j, k).addReferenceForStructure(structure, chId);
            BoundingBox box = start.getBoundingBox();
            if (!wireOnly) {
                Registry registry3 = world.registryAccess().registryOrThrow(Registries.STRUCTURE);
                world.setCurrentlyGenerating(() -> {
                    Objects.requireNonNull(structure);
                    return registry3.getResourceKey((Object)structure).map(Object::toString).orElseGet(structure::toString);
                });
                start.placeInChunk((WorldGenLevel)world, world.structureManager(), generator, rand, box, new ChunkPos(j, k));
            }
            int i = Math.max(box.getXSpan(), box.getZSpan()) / 16 + 1;
            for (int k1 = j - i; k1 <= j + i; ++k1) {
                for (int l1 = k - i; l1 <= k + i; ++l1) {
                    if (k1 == j && l1 == k || !box.intersects(k1 << 4, l1 << 4, (k1 << 4) + 15, (l1 << 4) + 15)) continue;
                    world.getChunk(k1, l1).addReferenceForStructure(structure, chId);
                }
            }
        }
        catch (Exception booboo) {
            CarpetScriptServer.LOG.error("Unknown Exception while plopping structure: " + String.valueOf(booboo), (Throwable)booboo);
            boolean bl = false;
            return bl;
        }
        finally {
            checks.set(false);
        }
        return true;
    }

    @FunctionalInterface
    private static interface Thing {
        public Boolean plop(ServerLevel var1, BlockPos var2);
    }
}

