/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import java.util.List;
import java.util.concurrent.Executor;
import java.util.function.BinaryOperator;
import java.util.function.Supplier;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.CommandSigningContext;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.TaskChainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SnoopyCommandSource
extends CommandSourceStack {
    private final CommandSource output;
    private final Vec3 position;
    private final ServerLevel world;
    private final int level;
    private final String simpleName;
    private final Component name;
    private final MinecraftServer server;
    private final Entity entity;
    private final CommandResultCallback resultConsumer;
    private final EntityAnchorArgument.Anchor entityAnchor;
    private final Vec2 rotation;
    private final Component[] error;
    private final List<Component> chatOutput;
    private final CommandSigningContext signingContext;
    private final TaskChainer taskChainer;

    public SnoopyCommandSource(CommandSourceStack original, Component[] error, List<Component> chatOutput) {
        super(CommandSource.NULL, original.getPosition(), original.getRotation(), original.getLevel(), Vanilla.MinecraftServer_getRunPermissionLevel(original.getServer()), original.getTextName(), original.getDisplayName(), original.getServer(), original.getEntity(), false, CommandResultCallback.EMPTY, EntityAnchorArgument.Anchor.FEET, CommandSigningContext.ANONYMOUS, TaskChainer.immediate((Executor)original.getServer()));
        this.output = CommandSource.NULL;
        this.position = original.getPosition();
        this.world = original.getLevel();
        this.level = Vanilla.MinecraftServer_getRunPermissionLevel(original.getServer());
        this.simpleName = original.getTextName();
        this.name = original.getDisplayName();
        this.server = original.getServer();
        this.entity = original.getEntity();
        this.resultConsumer = CommandResultCallback.EMPTY;
        this.entityAnchor = original.getAnchor();
        this.rotation = original.getRotation();
        this.error = error;
        this.chatOutput = chatOutput;
        this.signingContext = original.getSigningContext();
        this.taskChainer = TaskChainer.immediate((Executor)original.getServer());
    }

    public SnoopyCommandSource(ServerPlayer player, Component[] error, List<Component> output) {
        super((CommandSource)player, player.position(), player.getRotationVector(), (level = player.level()) instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null, player.server.getProfilePermissions(player.getGameProfile()), player.getName().getString(), player.getDisplayName(), player.level().getServer(), (Entity)player);
        ServerLevel serverLevel;
        Level level;
        this.output = player;
        this.position = player.position();
        level = player.level();
        this.world = level instanceof ServerLevel ? (serverLevel = (ServerLevel)level) : null;
        this.level = player.server.getProfilePermissions(player.getGameProfile());
        this.simpleName = player.getName().getString();
        this.name = player.getDisplayName();
        this.server = player.level().getServer();
        this.entity = player;
        this.resultConsumer = CommandResultCallback.EMPTY;
        this.entityAnchor = EntityAnchorArgument.Anchor.FEET;
        this.rotation = player.getRotationVector();
        this.error = error;
        this.chatOutput = output;
        this.signingContext = CommandSigningContext.ANONYMOUS;
        this.taskChainer = TaskChainer.immediate((Executor)player.server);
    }

    private SnoopyCommandSource(CommandSource output, Vec3 pos, Vec2 rot, ServerLevel world, int level, String simpleName, Component name, MinecraftServer server, @Nullable Entity entity, CommandResultCallback consumer, EntityAnchorArgument.Anchor entityAnchor, CommandSigningContext context, TaskChainer chainer, Component[] error, List<Component> chatOutput) {
        super(output, pos, rot, world, level, simpleName, name, server, entity, false, consumer, entityAnchor, context, chainer);
        this.output = output;
        this.position = pos;
        this.rotation = rot;
        this.world = world;
        this.level = level;
        this.simpleName = simpleName;
        this.name = name;
        this.server = server;
        this.entity = entity;
        this.resultConsumer = consumer;
        this.entityAnchor = entityAnchor;
        this.error = error;
        this.chatOutput = chatOutput;
        this.signingContext = context;
        this.taskChainer = chainer;
    }

    public CommandSourceStack withEntity(Entity entity) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, entity.getName().getString(), entity.getDisplayName(), this.server, entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withPosition(Vec3 position) {
        return new SnoopyCommandSource(this.output, position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withRotation(Vec2 rotation) {
        return new SnoopyCommandSource(this.output, this.position, rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withCallback(CommandResultCallback consumer) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, consumer, this.entityAnchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withCallback(CommandResultCallback consumer, BinaryOperator<CommandResultCallback> binaryOperator) {
        CommandResultCallback resultConsumer = (CommandResultCallback)binaryOperator.apply(this.resultConsumer, consumer);
        return this.withCallback(resultConsumer);
    }

    public CommandSourceStack withPermission(int level) {
        return this;
    }

    public CommandSourceStack withMaximumPermission(int level) {
        return this;
    }

    public CommandSourceStack withAnchor(EntityAnchorArgument.Anchor anchor) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, anchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withSigningContext(CommandSigningContext commandSigningContext, TaskChainer taskChainer) {
        return new SnoopyCommandSource(this.output, this.position, this.rotation, this.world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, commandSigningContext, taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack withLevel(ServerLevel world) {
        double d = DimensionType.getTeleportationScale((DimensionType)this.world.dimensionType(), (DimensionType)world.dimensionType());
        Vec3 position = new Vec3(this.position.x * d, this.position.y, this.position.z * d);
        return new SnoopyCommandSource(this.output, position, this.rotation, world, this.level, this.simpleName, this.name, this.server, this.entity, this.resultConsumer, this.entityAnchor, this.signingContext, this.taskChainer, this.error, this.chatOutput);
    }

    public CommandSourceStack facing(Vec3 position) {
        Vec3 vec3d = this.entityAnchor.apply((CommandSourceStack)this);
        double d = position.x - vec3d.x;
        double e = position.y - vec3d.y;
        double f = position.z - vec3d.z;
        double g = Math.sqrt(d * d + f * f);
        float h = Mth.wrapDegrees((float)((float)(-(Mth.atan2((double)e, (double)g) * 57.2957763671875))));
        float i = Mth.wrapDegrees((float)((float)(Mth.atan2((double)f, (double)d) * 57.2957763671875) - 90.0f));
        return this.withRotation(new Vec2(h, i));
    }

    public void sendFailure(Component message) {
        this.error[0] = message;
    }

    public void sendSuccess(Supplier<Component> message, boolean broadcastToOps) {
        this.chatOutput.add(message.get());
    }
}

