/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.utils;

import carpet.script.external.Vanilla;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundLevelChunkWithLightPacket;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import net.minecraft.world.level.chunk.storage.RegionFile;
import net.minecraft.world.level.chunk.storage.RegionStorageInfo;

public class WorldTools {
    public static boolean canHasChunk(ServerLevel world, ChunkPos chpos, @Nullable Map<String, RegionFile> regionCache, boolean deepcheck) {
        if (world.getChunk(chpos.x, chpos.z, ChunkStatus.STRUCTURE_STARTS, false) != null) {
            return true;
        }
        String currentRegionName = "r." + chpos.getRegionX() + "." + chpos.getRegionZ() + ".mca";
        if (regionCache != null && regionCache.containsKey(currentRegionName)) {
            RegionFile region = regionCache.get(currentRegionName);
            if (region == null) {
                return false;
            }
            return region.hasChunk(chpos);
        }
        Path regionsFolder = Vanilla.MinecraftServer_storageSource(world.getServer()).getDimensionPath(world.dimension()).resolve("region");
        Path regionPath = regionsFolder.resolve(currentRegionName);
        if (!regionPath.toFile().exists()) {
            if (regionCache != null) {
                regionCache.put(currentRegionName, null);
            }
            return false;
        }
        if (!deepcheck) {
            return true;
        }
        try {
            RegionStorageInfo levelStorageInfo = new RegionStorageInfo(Vanilla.MinecraftServer_storageSource(world.getServer()).getLevelId(), world.dimension(), "chunk");
            RegionFile region = new RegionFile(levelStorageInfo, regionPath, regionsFolder, true);
            if (regionCache != null) {
                regionCache.put(currentRegionName, region);
            }
            return region.hasChunk(chpos);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public static void forceChunkUpdate(BlockPos pos, ServerLevel world) {
        List players;
        ChunkPos chunkPos = new ChunkPos(pos);
        LevelChunk worldChunk = world.getChunkSource().getChunk(chunkPos.x, chunkPos.z, false);
        if (worldChunk != null && !(players = world.getChunkSource().chunkMap.getPlayers(chunkPos, false)).isEmpty()) {
            ClientboundLevelChunkWithLightPacket packet = new ClientboundLevelChunkWithLightPacket(worldChunk, world.getLightEngine(), null, null);
            players.forEach(p -> p.connection.send((Packet)packet));
        }
    }
}

