/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.CarpetScriptServer;
import carpet.script.EntityEventsGroup;
import carpet.script.argument.Vector3Argument;
import carpet.script.exception.InternalExpressionException;
import carpet.script.external.Carpet;
import carpet.script.external.Vanilla;
import carpet.script.utils.EntityTools;
import carpet.script.utils.InputValidator;
import carpet.script.utils.Tracer;
import carpet.script.value.BlockValue;
import carpet.script.value.BooleanValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.FunctionValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import carpet.script.value.ValueConversions;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.arguments.selector.EntitySelectorParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Position;
import net.minecraft.core.Registry;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundSetCarriedItemPacket;
import net.minecraft.network.protocol.game.ClientboundSetExperiencePacket;
import net.minecraft.network.protocol.game.ClientboundSetPassengersPacket;
import net.minecraft.network.protocol.game.ClientboundTeleportEntityPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.RelativeMovement;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.AttributeMap;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.memory.ExpirableValue;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.entity.projectile.WitherSkull;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameType;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;

public class EntityValue
extends Value {
    private Entity entity;
    private static final Map<String, net.minecraft.commands.arguments.selector.EntitySelector> selectorCache = new HashMap<String, net.minecraft.commands.arguments.selector.EntitySelector>();
    public static final EntityTypeTest<Entity, ?> ANY = EntityTypeTest.forClass(Entity.class);
    private static final Map<String, EquipmentSlot> inventorySlots = Map.of("mainhand", EquipmentSlot.MAINHAND, "offhand", EquipmentSlot.OFFHAND, "head", EquipmentSlot.HEAD, "chest", EquipmentSlot.CHEST, "legs", EquipmentSlot.LEGS, "feet", EquipmentSlot.FEET);
    private static final Map<String, BiFunction<Entity, Value, Value>> featureAccessors = new HashMap<String, BiFunction<Entity, Value, Value>>(){
        {
            this.put("removed", (entity, arg) -> BooleanValue.of(entity.isRemoved()));
            this.put("uuid", (e, a) -> new StringValue(e.getStringUUID()));
            this.put("id", (e, a) -> new NumericValue(e.getId()));
            this.put("pos", (e, a) -> ListValue.of(new NumericValue(e.getX()), new NumericValue(e.getY()), new NumericValue(e.getZ())));
            this.put("location", (e, a) -> ListValue.of(new NumericValue(e.getX()), new NumericValue(e.getY()), new NumericValue(e.getZ()), new NumericValue(e.getYRot()), new NumericValue(e.getXRot())));
            this.put("x", (e, a) -> new NumericValue(e.getX()));
            this.put("y", (e, a) -> new NumericValue(e.getY()));
            this.put("z", (e, a) -> new NumericValue(e.getZ()));
            this.put("motion", (e, a) -> {
                Vec3 velocity = e.getDeltaMovement();
                return ListValue.of(new NumericValue(velocity.x), new NumericValue(velocity.y), new NumericValue(velocity.z));
            });
            this.put("motion_x", (e, a) -> new NumericValue(e.getDeltaMovement().x));
            this.put("motion_y", (e, a) -> new NumericValue(e.getDeltaMovement().y));
            this.put("motion_z", (e, a) -> new NumericValue(e.getDeltaMovement().z));
            this.put("on_ground", (e, a) -> BooleanValue.of(e.onGround()));
            this.put("name", (e, a) -> new StringValue(e.getName().getString()));
            this.put("display_name", (e, a) -> new FormattedTextValue(e.getDisplayName()));
            this.put("command_name", (e, a) -> new StringValue(e.getScoreboardName()));
            this.put("custom_name", (e, a) -> e.hasCustomName() ? new StringValue(e.getCustomName().getString()) : Value.NULL);
            this.put("type", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.level().registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getKey((Object)e.getType())));
            this.put("is_riding", (e, a) -> BooleanValue.of(e.isPassenger()));
            this.put("is_ridden", (e, a) -> BooleanValue.of(e.isVehicle()));
            this.put("passengers", (e, a) -> ListValue.wrap(e.getPassengers().stream().map(EntityValue::new)));
            this.put("mount", (e, a) -> e.getVehicle() != null ? new EntityValue(e.getVehicle()) : Value.NULL);
            this.put("unmountable", (e, a) -> BooleanValue.of(Vanilla.Entity_isPermanentVehicle(e)));
            this.put("tags", (e, a) -> ListValue.wrap(e.getTags().stream().map(StringValue::new)));
            this.put("scoreboard_tags", (e, a) -> ListValue.wrap(e.getTags().stream().map(StringValue::new)));
            this.put("entity_tags", (e, a) -> {
                EntityType type = e.getType();
                return ListValue.wrap(e.getServer().registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getTags().filter(entry -> ((HolderSet.Named)entry.getSecond()).stream().anyMatch(h -> h.value() == type)).map(entry -> ValueConversions.of((TagKey)entry.getFirst())));
            });
            this.put("has_tag", (e, a) -> BooleanValue.of(e.getTags().contains(a.getString())));
            this.put("has_scoreboard_tag", (e, a) -> BooleanValue.of(e.getTags().contains(a.getString())));
            this.put("has_entity_tag", (e, a) -> {
                Optional tag = e.getServer().registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)InputValidator.identifierOf(a.getString())));
                if (tag.isEmpty()) {
                    return Value.NULL;
                }
                EntityType type = e.getType();
                return BooleanValue.of(((HolderSet.Named)tag.get()).stream().anyMatch(h -> h.value() == type));
            });
            this.put("yaw", (e, a) -> new NumericValue(e.getYRot()));
            this.put("head_yaw", (e, a) -> e instanceof LivingEntity ? new NumericValue(e.getYHeadRot()) : Value.NULL);
            this.put("body_yaw", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.yBodyRot);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pitch", (e, a) -> new NumericValue(e.getXRot()));
            this.put("look", (e, a) -> {
                Vec3 look = e.getLookAngle();
                return ListValue.of(new NumericValue(look.x), new NumericValue(look.y), new NumericValue(look.z));
            });
            this.put("is_burning", (e, a) -> BooleanValue.of(e.isOnFire()));
            this.put("fire", (e, a) -> new NumericValue(e.getRemainingFireTicks()));
            this.put("is_freezing", (e, a) -> BooleanValue.of(e.isFullyFrozen()));
            this.put("frost", (e, a) -> new NumericValue(e.getTicksFrozen()));
            this.put("silent", (e, a) -> BooleanValue.of(e.isSilent()));
            this.put("gravity", (e, a) -> BooleanValue.of(!e.isNoGravity()));
            this.put("immune_to_fire", (e, a) -> BooleanValue.of(e.fireImmune()));
            this.put("immune_to_frost", (e, a) -> BooleanValue.of(!e.canFreeze()));
            this.put("invulnerable", (e, a) -> BooleanValue.of(e.isInvulnerable()));
            this.put("dimension", (e, a) -> NBTSerializableValue.nameFromRegistryId(e.level().dimension().location()));
            this.put("height", (e, a) -> new NumericValue(e.getDimensions(Pose.STANDING).height()));
            this.put("width", (e, a) -> new NumericValue(e.getDimensions(Pose.STANDING).width()));
            this.put("eye_height", (e, a) -> new NumericValue(e.getEyeHeight()));
            this.put("age", (e, a) -> new NumericValue(e.tickCount));
            this.put("breeding_age", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof AgeableMob) {
                    AgeableMob am = (AgeableMob)e;
                    numericValue = new NumericValue(am.getAge());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("despawn_timer", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.getNoActionTime());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("blue_skull", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof WitherSkull) {
                    WitherSkull w = (WitherSkull)e;
                    numericValue = BooleanValue.of(w.isDangerous());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("offering_flower", (e, a) -> {
                IronGolem ig;
                return e instanceof IronGolem ? BooleanValue.of((ig = (IronGolem)e).getOfferFlowerTick() > 0) : Value.NULL;
            });
            this.put("item", (e, a) -> {
                Value value;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    value = ValueConversions.of(ie.getItem(), (RegistryAccess)e.getServer().registryAccess());
                } else if (e instanceof ItemFrame) {
                    ItemFrame frame = (ItemFrame)e;
                    value = ValueConversions.of(frame.getItem(), (RegistryAccess)e.getServer().registryAccess());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("count", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    numericValue = new NumericValue(ie.getItem().getCount());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("pickup_delay", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    numericValue = new NumericValue(Vanilla.ItemEntity_getPickupDelay(ie));
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("portal_cooldown", (e, a) -> new NumericValue(Vanilla.Entity_getPublicNetherPortalCooldown(e)));
            this.put("portal_timer", (e, a) -> new NumericValue(Vanilla.Entity_getPortalTimer(e)));
            this.put("is_baby", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = BooleanValue.of(le.isBaby());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("target", (e, a) -> {
                Mob mob;
                LivingEntity target;
                if (e instanceof Mob && (target = (mob = (Mob)e).getTarget()) != null) {
                    return new EntityValue((Entity)target);
                }
                return Value.NULL;
            });
            this.put("home", (e, a) -> {
                Mob mob;
                return e instanceof Mob ? ((mob = (Mob)e).getRestrictRadius() > 0.0f ? new BlockValue(null, (ServerLevel)e.level(), mob.getRestrictCenter()) : Value.FALSE) : Value.NULL;
            });
            this.put("spawn_point", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer spe = (ServerPlayer)e;
                    if (spe.getRespawnPosition() == null) {
                        return Value.FALSE;
                    }
                    return ListValue.of(ValueConversions.of(spe.getRespawnPosition()), ValueConversions.of(spe.getRespawnDimension()), new NumericValue(spe.getRespawnAngle()), BooleanValue.of(spe.isRespawnForced()));
                }
                return Value.NULL;
            });
            this.put("pose", (e, a) -> new StringValue(e.getPose().name().toLowerCase(Locale.ROOT)));
            this.put("sneaking", (e, a) -> e.isShiftKeyDown() ? Value.TRUE : Value.FALSE);
            this.put("sprinting", (e, a) -> e.isSprinting() ? Value.TRUE : Value.FALSE);
            this.put("swimming", (e, a) -> e.isSwimming() ? Value.TRUE : Value.FALSE);
            this.put("swinging", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = BooleanValue.of(le.swinging);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("air", (e, a) -> new NumericValue(e.getAirSupply()));
            this.put("language", (e, a) -> {
                Value value;
                if (!(e instanceof ServerPlayer)) {
                    value = Value.NULL;
                } else {
                    ServerPlayer p = (ServerPlayer)e;
                    value = StringValue.of(Vanilla.ServerPlayer_getLanguage(p));
                }
                return value;
            });
            this.put("persistence", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    numericValue = BooleanValue.of(mob.isPersistenceRequired());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("hunger", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.getFoodData().getFoodLevel());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("saturation", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.getFoodData().getSaturationLevel());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("exhaustion", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.getFoodData().getExhaustionLevel());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("absorption", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.getAbsorptionAmount());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.totalExperience);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_level", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.experienceLevel);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("xp_progress", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.experienceProgress);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("score", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player player = (Player)e;
                    numericValue = new NumericValue(player.getScore());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("jumping", (e, a) -> {
                LivingEntity le;
                return e instanceof LivingEntity ? (Vanilla.LivingEntity_isJumping(le = (LivingEntity)e) ? Value.TRUE : Value.FALSE) : Value.NULL;
            });
            this.put("gamemode", (e, a) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    value = new StringValue(sp.gameMode.getGameModeForPlayer().getName());
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("path", (e, a) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    Path path = mob.getNavigation().getPath();
                    if (path == null) {
                        return Value.NULL;
                    }
                    return ValueConversions.fromPath((ServerLevel)e.getCommandSenderWorld(), path);
                }
                return Value.NULL;
            });
            this.put("brain", (e, a) -> {
                String module = a.getString();
                MemoryModuleType moduleType = (MemoryModuleType)e.level().registryAccess().registryOrThrow(Registries.MEMORY_MODULE_TYPE).get(InputValidator.identifierOf(module));
                if (moduleType == MemoryModuleType.DUMMY) {
                    return Value.NULL;
                }
                if (e instanceof LivingEntity) {
                    LivingEntity livingEntity = (LivingEntity)e;
                    Brain brain = livingEntity.getBrain();
                    Map memories = brain.getMemories();
                    Optional optmemory = (Optional)memories.get(moduleType);
                    if (optmemory == null || !optmemory.isPresent()) {
                        return Value.NULL;
                    }
                    ExpirableValue memory = (ExpirableValue)optmemory.get();
                    return ValueConversions.fromTimedMemory(e, memory.getTimeToLive(), memory.getValue());
                }
                return Value.NULL;
            });
            this.put("gamemode_id", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    numericValue = new NumericValue(sp.gameMode.getGameModeForPlayer().getId());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("permission_level", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer spe = (ServerPlayer)e;
                    for (int i = 4; i >= 0; --i) {
                        if (!spe.hasPermissions(i)) continue;
                        return new NumericValue(i);
                    }
                    return new NumericValue(0L);
                }
                return Value.NULL;
            });
            this.put("player_type", (e, a) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    String moddedType = Carpet.isModdedPlayer(p);
                    if (moddedType != null) {
                        return StringValue.of(moddedType);
                    }
                    MinecraftServer server = p.getCommandSenderWorld().getServer();
                    if (server.isDedicatedServer()) {
                        return new StringValue("multiplayer");
                    }
                    boolean runningLan = server.isPublished();
                    if (!runningLan) {
                        return new StringValue("singleplayer");
                    }
                    boolean isowner = server.isSingleplayerOwner(p.getGameProfile());
                    if (isowner) {
                        return new StringValue("lan_host");
                    }
                    return new StringValue("lan player");
                }
                return Value.NULL;
            });
            this.put("client_brand", (e, a) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    value = StringValue.of(Carpet.getPlayerStatus(sp));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("team", (e, a) -> e.getTeam() == null ? Value.NULL : new StringValue(e.getTeam().getName()));
            this.put("ping", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    numericValue = new NumericValue(sp.connection.latency());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("effect", (e, a) -> {
                if (!(e instanceof LivingEntity)) {
                    return Value.NULL;
                }
                LivingEntity le = (LivingEntity)e;
                if (a == null) {
                    ArrayList<Value> effects = new ArrayList<Value>();
                    for (MobEffectInstance p : le.getActiveEffects()) {
                        effects.add(ListValue.of(new StringValue(p.getDescriptionId().replaceFirst("^effect\\.minecraft\\.", "")), new NumericValue(p.getAmplifier()), new NumericValue(p.getDuration())));
                    }
                    return ListValue.wrap(effects);
                }
                String effectName = a.getString();
                Holder potion = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(ResourceKey.create((ResourceKey)Registries.MOB_EFFECT, (ResourceLocation)InputValidator.identifierOf(effectName))).orElseThrow(() -> new InternalExpressionException("No such an effect: " + effectName));
                if (!le.hasEffect(potion)) {
                    return Value.NULL;
                }
                MobEffectInstance pe = le.getEffect(potion);
                return ListValue.of(new NumericValue(pe.getAmplifier()), new NumericValue(pe.getDuration()));
            });
            this.put("health", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    numericValue = new NumericValue(le.getHealth());
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_fly", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.getAbilities().mayfly);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("flying", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.getAbilities().flying);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("may_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.getAbilities().mayBuild);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("insta_build", (e, v) -> {
                NumericValue numericValue;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    numericValue = BooleanValue.of(player.getAbilities().instabuild);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("fly_speed", (e, v) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    value = NumericValue.of(Float.valueOf(player.getAbilities().getFlyingSpeed()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("walk_speed", (e, v) -> {
                Value value;
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    value = NumericValue.of(Float.valueOf(player.getAbilities().getWalkingSpeed()));
                } else {
                    value = Value.NULL;
                }
                return value;
            });
            this.put("holds", (e, a) -> {
                EquipmentSlot where = EquipmentSlot.MAINHAND;
                if (a != null) {
                    where = inventorySlots.get(a.getString());
                }
                if (where == null) {
                    throw new InternalExpressionException("Unknown inventory slot: " + a.getString());
                }
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    return ValueConversions.of(le.getItemBySlot(where), (RegistryAccess)e.getServer().registryAccess());
                }
                return Value.NULL;
            });
            this.put("selected_slot", (e, a) -> {
                NumericValue numericValue;
                if (e instanceof Player) {
                    Player p = (Player)e;
                    numericValue = new NumericValue(p.getInventory().selected);
                } else {
                    numericValue = Value.NULL;
                }
                return numericValue;
            });
            this.put("active_block", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    BlockPos pos = Vanilla.ServerPlayerGameMode_getCurrentBlockPosition(sp.gameMode);
                    if (pos == null) {
                        return Value.NULL;
                    }
                    return new BlockValue(null, sp.serverLevel(), pos);
                }
                return Value.NULL;
            });
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    int progress = Vanilla.ServerPlayerGameMode_getCurrentBlockBreakingProgress(sp.gameMode);
                    return progress < 0 ? Value.NULL : new NumericValue(progress);
                }
                return Value.NULL;
            });
            this.put("facing", (e, a) -> {
                int index = 0;
                if (a != null) {
                    index = (6 + (int)NumericValue.asNumber(a).getLong()) % 6;
                }
                if (index < 0 || index > 5) {
                    throw new InternalExpressionException("Facing order should be between -6 and 5");
                }
                return new StringValue(Direction.orderedByNearest((Entity)e)[index].getSerializedName());
            });
            this.put("trace", (e, a) -> {
                Object hitres;
                float reach = 4.5f;
                boolean entities = true;
                boolean liquids = false;
                boolean blocks = true;
                boolean exact = false;
                if (a != null) {
                    if (!(a instanceof ListValue)) {
                        reach = (float)NumericValue.asNumber(a).getDouble();
                    } else {
                        ListValue lv = (ListValue)a;
                        List<Value> args = lv.getItems();
                        if (args.size() == 0) {
                            throw new InternalExpressionException("'trace' needs more arguments");
                        }
                        reach = (float)NumericValue.asNumber(args.get(0)).getDouble();
                        if (args.size() > 1) {
                            entities = false;
                            blocks = false;
                            for (int i = 1; i < args.size(); ++i) {
                                String what = args.get(i).getString();
                                if (what.equalsIgnoreCase("entities")) {
                                    entities = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("blocks")) {
                                    blocks = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("liquids")) {
                                    liquids = true;
                                    continue;
                                }
                                if (what.equalsIgnoreCase("exact")) {
                                    exact = true;
                                    continue;
                                }
                                throw new InternalExpressionException("Incorrect tracing: " + what);
                            }
                        }
                    }
                } else if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    if (sp.gameMode.isCreative()) {
                        reach = 5.0f;
                    }
                }
                if ((hitres = entities && !blocks ? Tracer.rayTraceEntities(e, 1.0f, reach, reach * reach) : (entities ? Tracer.rayTrace(e, 1.0f, reach, liquids) : Tracer.rayTraceBlocks(e, 1.0f, reach, liquids))) == null) {
                    return Value.NULL;
                }
                if (exact && hitres.getType() != HitResult.Type.MISS) {
                    return ValueConversions.of(hitres.getLocation());
                }
                switch (hitres.getType()) {
                    case MISS: {
                        return Value.NULL;
                    }
                    case BLOCK: {
                        return new BlockValue((ServerLevel)e.getCommandSenderWorld(), ((BlockHitResult)hitres).getBlockPos());
                    }
                    case ENTITY: {
                        return new EntityValue(((EntityHitResult)hitres).getEntity());
                    }
                }
                return Value.NULL;
            });
            this.put("attribute", (e, a) -> {
                if (!(e instanceof LivingEntity)) {
                    return Value.NULL;
                }
                LivingEntity el = (LivingEntity)e;
                Registry attributes = e.level().registryAccess().registryOrThrow(Registries.ATTRIBUTE);
                if (a == null) {
                    AttributeMap container = el.getAttributes();
                    return MapValue.wrap(attributes.holders().filter(arg_0 -> ((AttributeMap)container).hasAttribute(arg_0)).collect(Collectors.toMap(aa -> ValueConversions.of(aa.key()), aa -> NumericValue.of(container.getValue((Holder)aa)))));
                }
                ResourceLocation id = InputValidator.identifierOf(a.getString());
                Holder attrib = (Holder)attributes.getHolder(id).orElseThrow(() -> new InternalExpressionException("Unknown attribute: " + a.getString()));
                if (!el.getAttributes().hasAttribute(attrib)) {
                    return Value.NULL;
                }
                return NumericValue.of(el.getAttributeValue(attrib));
            });
            this.put("nbt", (e, a) -> {
                CompoundTag nbttagcompound = e.saveWithoutId(new CompoundTag());
                if (a == null) {
                    return new NBTSerializableValue((Tag)nbttagcompound);
                }
                return new NBTSerializableValue((Tag)nbttagcompound).get((Value)a);
            });
            this.put("category", (e, a) -> new StringValue(e.getType().getCategory().toString().toLowerCase(Locale.ROOT)));
        }
    };
    private static final Map<String, BiConsumer<Entity, Value>> featureModifiers = new HashMap<String, BiConsumer<Entity, Value>>(){
        {
            this.put("remove", (entity, value) -> entity.discard());
            this.put("age", (e, v) -> {
                e.tickCount = Math.abs((int)NumericValue.asNumber(v).getLong());
            });
            this.put("health", (e, v) -> {
                float health = (float)NumericValue.asNumber(v).getDouble();
                if (health <= 0.0f && e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    if (player.containerMenu != null) {
                        player.closeContainer();
                    }
                    ((LivingEntity)e).setHealth(health);
                }
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.setHealth(health);
                }
            });
            this.put("may_fly", (e, v) -> {
                boolean mayFly = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().mayfly = mayFly;
                    if (!mayFly && player.getAbilities().flying) {
                        player.getAbilities().flying = false;
                    }
                    player.onUpdateAbilities();
                }
            });
            this.put("flying", (e, v) -> {
                boolean flying = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().flying = flying;
                    player.onUpdateAbilities();
                }
            });
            this.put("may_build", (e, v) -> {
                boolean mayBuild = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().mayBuild = mayBuild;
                    player.onUpdateAbilities();
                }
            });
            this.put("insta_build", (e, v) -> {
                boolean instaBuild = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().instabuild = instaBuild;
                    player.onUpdateAbilities();
                }
            });
            this.put("fly_speed", (e, v) -> {
                float flySpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().setFlyingSpeed(flySpeed);
                    player.onUpdateAbilities();
                }
            });
            this.put("walk_speed", (e, v) -> {
                float walkSpeed = NumericValue.asNumber(v).getFloat();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().setWalkingSpeed(walkSpeed);
                    player.onUpdateAbilities();
                }
            });
            this.put("selected_slot", (e, v) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    int slot = NumericValue.asNumber(v).getInt();
                    player.connection.send((Packet)new ClientboundSetCarriedItemPacket(slot));
                }
            });
            this.put("kill", (e, v) -> e.kill());
            this.put("location", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 5 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), (float)NumericValue.asNumber(coords.get(3)).getDouble(), (float)NumericValue.asNumber(coords.get(4)).getDouble());
            });
            this.put("pos", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble(), e.getYRot(), e.getXRot());
            });
            this.put("x", (e, v) -> EntityValue.updatePosition(e, NumericValue.asNumber(v).getDouble(), e.getY(), e.getZ(), e.getYRot(), e.getXRot()));
            this.put("y", (e, v) -> EntityValue.updatePosition(e, e.getX(), NumericValue.asNumber(v).getDouble(), e.getZ(), e.getYRot(), e.getXRot()));
            this.put("z", (e, v) -> EntityValue.updatePosition(e, e.getX(), e.getY(), NumericValue.asNumber(v).getDouble(), e.getYRot(), e.getXRot()));
            this.put("yaw", (e, v) -> EntityValue.updatePosition(e, e.getX(), e.getY(), e.getZ(), (float)NumericValue.asNumber(v).getDouble() % 360.0f, e.getXRot()));
            this.put("head_yaw", (e, v) -> {
                if (e instanceof LivingEntity) {
                    e.setYHeadRot((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("body_yaw", (e, v) -> {
                if (e instanceof LivingEntity) {
                    e.setYRot((float)NumericValue.asNumber(v).getDouble() % 360.0f);
                }
            });
            this.put("pitch", (e, v) -> EntityValue.updatePosition(e, e.getX(), e.getY(), e.getZ(), e.getYRot(), Mth.clamp((float)((float)NumericValue.asNumber(v).getDouble()), (float)-90.0f, (float)90.0f)));
            this.put("look", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> vec = lv.getItems();
                float x = NumericValue.asNumber(vec.get(0)).getFloat();
                float y = NumericValue.asNumber(vec.get(1)).getFloat();
                float z = NumericValue.asNumber(vec.get(2)).getFloat();
                float l = Mth.sqrt((float)(x * x + y * y + z * z));
                if (l == 0.0f) {
                    return;
                }
                float pitch = (float)(-Math.asin(y /= l)) / ((float)Math.PI / 180);
                float yaw = (float)((x /= l) == 0.0f && z == 0.0f ? (double)e.getYRot() : Mth.atan2((double)(-x), (double)(z /= l)) / 0.01745329238474369);
                EntityValue.updatePosition(e, e.getX(), e.getY(), e.getZ(), yaw, pitch);
            });
            this.put("move", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                EntityValue.updatePosition(e, e.getX() + NumericValue.asNumber(coords.get(0)).getDouble(), e.getY() + NumericValue.asNumber(coords.get(1)).getDouble(), e.getZ() + NumericValue.asNumber(coords.get(2)).getDouble(), e.getYRot(), e.getXRot());
            });
            this.put("motion", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                double dx = NumericValue.asNumber(coords.get(0)).getDouble();
                double dy = NumericValue.asNumber(coords.get(1)).getDouble();
                double dz = NumericValue.asNumber(coords.get(2)).getDouble();
                e.setDeltaMovement(dx, dy, dz);
                EntityValue.updateVelocity(e, Mth.absMax((double)Mth.absMax((double)dx, (double)dy), (double)dz));
            });
            this.put("motion_x", (e, v) -> {
                Vec3 velocity = e.getDeltaMovement();
                double dv = NumericValue.asNumber(v).getDouble();
                e.setDeltaMovement(dv, velocity.y, velocity.z);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_y", (e, v) -> {
                Vec3 velocity = e.getDeltaMovement();
                double dv = NumericValue.asNumber(v).getDouble();
                e.setDeltaMovement(velocity.x, dv, velocity.z);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("motion_z", (e, v) -> {
                Vec3 velocity = e.getDeltaMovement();
                double dv = NumericValue.asNumber(v).getDouble();
                e.setDeltaMovement(velocity.x, velocity.y, dv);
                EntityValue.updateVelocity(e, dv);
            });
            this.put("accelerate", (e, v) -> {
                if (!(v instanceof ListValue)) {
                    throw new InternalExpressionException("Expected a list of 3 parameters as a second argument");
                }
                ListValue lv = (ListValue)v;
                List<Value> coords = lv.getItems();
                e.push(NumericValue.asNumber(coords.get(0)).getDouble(), NumericValue.asNumber(coords.get(1)).getDouble(), NumericValue.asNumber(coords.get(2)).getDouble());
                EntityValue.updateVelocity(e, e.getDeltaMovement().length());
            });
            this.put("custom_name", (e, v) -> {
                if (v.isNull()) {
                    e.setCustomNameVisible(false);
                    e.setCustomName(null);
                    return;
                }
                boolean showName = false;
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    showName = lv.getItems().get(1).getBoolean();
                    v = lv.getItems().get(0);
                }
                e.setCustomNameVisible(showName);
                e.setCustomName(FormattedTextValue.getTextByValue(v));
            });
            this.put("persistence", (e, v) -> {
                if (!(e instanceof Mob)) {
                    return;
                }
                Mob mob = (Mob)e;
                if (v == null) {
                    v = Value.TRUE;
                }
                Vanilla.Mob_setPersistence(mob, v.getBoolean());
            });
            this.put("dismount", (e, v) -> e.stopRiding());
            this.put("mount", (e, v) -> {
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    e.startRiding(ev.getEntity(), true);
                }
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    sp.connection.send((Packet)new ClientboundSetPassengersPacket(e));
                }
            });
            this.put("unmountable", (e, v) -> Vanilla.Entity_setPermanentVehicle(e, v == null || v.getBoolean()));
            this.put("drop_passengers", (e, v) -> e.ejectPassengers());
            this.put("mount_passengers", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'mount_passengers' needs entities to ride");
                }
                if (v instanceof EntityValue) {
                    EntityValue ev = (EntityValue)v;
                    ev.getEntity().startRiding(e);
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        if (!(element instanceof EntityValue)) continue;
                        EntityValue ev = (EntityValue)element;
                        ev.getEntity().startRiding(e);
                    }
                }
            });
            this.put("tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.addTag(element.getString());
                    }
                } else {
                    e.addTag(v.getString());
                }
            });
            this.put("clear_tag", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'clear_tag' requires parameters");
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    for (Value element : lv.getItems()) {
                        e.removeTag(element.getString());
                    }
                } else {
                    e.removeTag(v.getString());
                }
            });
            this.put("breeding_age", (e, v) -> {
                if (e instanceof AgeableMob) {
                    AgeableMob am = (AgeableMob)e;
                    am.setAge((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("talk", (e, v) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.playAmbientSound();
                }
            });
            this.put("home", (e, v) -> {
                BlockPos pos;
                if (!(e instanceof PathfinderMob)) {
                    return;
                }
                PathfinderMob ec = (PathfinderMob)e;
                if (v == null) {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance, or null to cancel");
                }
                if (v.isNull()) {
                    ec.restrictTo(BlockPos.ZERO, -1);
                    Map<String, Goal> tasks = Vanilla.Mob_getTemporaryTasks((Mob)ec);
                    Vanilla.Mob_getAI((Mob)ec, false).removeGoal(tasks.get("home"));
                    tasks.remove("home");
                    return;
                }
                int distance = 16;
                if (v instanceof BlockValue) {
                    BlockValue bv = (BlockValue)v;
                    pos = bv.getPos();
                    if (pos == null) {
                        throw new InternalExpressionException("Block is not positioned in the world");
                    }
                } else if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    Vector3Argument locator = Vector3Argument.findIn(list, 0, false, false);
                    pos = BlockPos.containing((double)locator.vec.x, (double)locator.vec.y, (double)locator.vec.z);
                    if (list.size() > locator.offset) {
                        distance = (int)NumericValue.asNumber(list.get(locator.offset)).getLong();
                    }
                } else {
                    throw new InternalExpressionException("'home' requires at least one position argument, and optional distance");
                }
                ec.restrictTo(pos, distance);
                Map<String, Goal> tasks = Vanilla.Mob_getTemporaryTasks((Mob)ec);
                if (!tasks.containsKey("home")) {
                    MoveTowardsRestrictionGoal task = new MoveTowardsRestrictionGoal(ec, 1.0);
                    tasks.put("home", (Goal)task);
                    Vanilla.Mob_getAI((Mob)ec, false).addGoal(10, (Goal)task);
                }
            });
            this.put("spawn_point", (e, a) -> {
                if (!(e instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer spe = (ServerPlayer)e;
                if (a == null) {
                    spe.setRespawnPosition(null, null, 0.0f, false, false);
                } else if (a instanceof ListValue) {
                    ListValue lv = (ListValue)a;
                    List<Value> params = lv.getItems();
                    Vector3Argument blockLocator = Vector3Argument.findIn(params, 0, false, false);
                    BlockPos pos = BlockPos.containing((Position)blockLocator.vec);
                    ResourceKey world = spe.getCommandSenderWorld().dimension();
                    float angle = spe.getYHeadRot();
                    boolean forced = false;
                    if (params.size() > blockLocator.offset) {
                        Value worldValue = params.get(blockLocator.offset);
                        world = ValueConversions.dimFromValue(worldValue, spe.getServer()).dimension();
                        if (params.size() > blockLocator.offset + 1) {
                            angle = NumericValue.asNumber(params.get(blockLocator.offset + 1), "angle").getFloat();
                            if (params.size() > blockLocator.offset + 2) {
                                forced = params.get(blockLocator.offset + 2).getBoolean();
                            }
                        }
                    }
                    spe.setRespawnPosition(world, pos, angle, forced, false);
                } else if (a instanceof BlockValue) {
                    BlockValue bv = (BlockValue)a;
                    if (bv.getPos() == null || bv.getWorld() == null) {
                        throw new InternalExpressionException("block for spawn modification should be localised in the world");
                    }
                    spe.setRespawnPosition(bv.getWorld().dimension(), bv.getPos(), e.getYRot(), true, false);
                } else if (a.isNull()) {
                    spe.setRespawnPosition(null, null, 0.0f, false, false);
                } else {
                    throw new InternalExpressionException("modifying player respawn point requires a block position, optional world, optional angle, and optional force");
                }
            });
            this.put("pickup_delay", (e, v) -> {
                if (e instanceof ItemEntity) {
                    ItemEntity ie = (ItemEntity)e;
                    ie.setPickUpDelay((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("despawn_timer", (e, v) -> {
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    le.setNoActionTime((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("portal_cooldown", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_cooldown' requires a value to set");
                }
                Vanilla.Entity_setPublicNetherPortalCooldown(e, NumericValue.asNumber(v).getInt());
            });
            this.put("portal_timer", (e, v) -> {
                if (v == null) {
                    throw new InternalExpressionException("'portal_timer' requires a value to set");
                }
                Vanilla.Entity_setPortalTimer(e, NumericValue.asNumber(v).getInt());
            });
            this.put("ai", (e, v) -> {
                if (e instanceof Mob) {
                    Mob mob = (Mob)e;
                    mob.setNoAi(!v.getBoolean());
                }
            });
            this.put("no_clip", (e, v) -> {
                e.noPhysics = v == null ? true : v.getBoolean();
            });
            this.put("effect", (e, v) -> {
                if (!(e instanceof LivingEntity)) {
                    return;
                }
                LivingEntity le = (LivingEntity)e;
                if (v == null) {
                    le.removeAllEffects();
                    return;
                }
                if (v instanceof ListValue) {
                    ListValue lv = (ListValue)v;
                    List<Value> list = lv.getItems();
                    if (list.size() >= 1 && list.size() <= 6) {
                        String effectName = list.get(0).getString();
                        Holder effect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(InputValidator.identifierOf(effectName)).orElseThrow(() -> new InternalExpressionException("No such an effect: " + effectName));
                        if (list.size() == 1) {
                            le.removeEffect(effect);
                            return;
                        }
                        int duration = (int)NumericValue.asNumber(list.get(1)).getLong();
                        if (duration == 0) {
                            le.removeEffect(effect);
                            return;
                        }
                        if (duration < 0) {
                            duration = -1;
                        }
                        int amplifier = 0;
                        if (list.size() > 2) {
                            amplifier = (int)NumericValue.asNumber(list.get(2)).getLong();
                        }
                        boolean showParticles = true;
                        if (list.size() > 3) {
                            showParticles = list.get(3).getBoolean();
                        }
                        boolean showIcon = true;
                        if (list.size() > 4) {
                            showIcon = list.get(4).getBoolean();
                        }
                        boolean ambient = false;
                        if (list.size() > 5) {
                            ambient = list.get(5).getBoolean();
                        }
                        le.addEffect(new MobEffectInstance(effect, duration, amplifier, ambient, showParticles, showIcon));
                        return;
                    }
                } else {
                    String effectName = v.getString();
                    Holder effect = (Holder)BuiltInRegistries.MOB_EFFECT.getHolder(InputValidator.identifierOf(effectName)).orElseThrow(() -> new InternalExpressionException("No such an effect: " + effectName));
                    le.removeEffect(effect);
                    return;
                }
                throw new InternalExpressionException("'effect' needs either no arguments (clear) or effect name, duration, and optional amplifier, show particles, show icon and ambient");
            });
            this.put("gamemode", (e, v) -> {
                GameType toSet;
                if (!(e instanceof ServerPlayer)) {
                    return;
                }
                ServerPlayer sp = (ServerPlayer)e;
                GameType gameType = toSet = v instanceof NumericValue ? GameType.byId((int)((NumericValue)v).getInt()) : GameType.byName((String)v.getString().toLowerCase(Locale.ROOT), null);
                if (toSet != null) {
                    sp.setGameMode(toSet);
                }
            });
            this.put("jumping", (e, v) -> {
                if (!(e instanceof LivingEntity)) {
                    return;
                }
                LivingEntity le = (LivingEntity)e;
                le.setJumping(v.getBoolean());
            });
            this.put("jump", (e, v) -> {
                if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    Vanilla.LivingEntity_setJumping(le);
                } else {
                    EntityTools.genericJump(e);
                }
            });
            this.put("swing", (e, v) -> {
                if (e instanceof LivingEntity) {
                    String handString;
                    LivingEntity le = (LivingEntity)e;
                    InteractionHand hand = InteractionHand.MAIN_HAND;
                    if (v != null && ((handString = v.getString().toLowerCase(Locale.ROOT)).equals("offhand") || handString.equals("off_hand"))) {
                        hand = InteractionHand.OFF_HAND;
                    }
                    le.swing(hand, true);
                }
            });
            this.put("silent", (e, v) -> e.setSilent(v.getBoolean()));
            this.put("gravity", (e, v) -> e.setNoGravity(!v.getBoolean()));
            this.put("invulnerable", (e, v) -> {
                boolean invulnerable = v.getBoolean();
                if (e instanceof ServerPlayer) {
                    ServerPlayer player = (ServerPlayer)e;
                    player.getAbilities().invulnerable = invulnerable;
                    player.onUpdateAbilities();
                } else {
                    e.setInvulnerable(invulnerable);
                }
            });
            this.put("fire", (e, v) -> e.setRemainingFireTicks((int)NumericValue.asNumber(v).getLong()));
            this.put("frost", (e, v) -> e.setTicksFrozen((int)NumericValue.asNumber(v).getLong()));
            this.put("hunger", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.getFoodData().setFoodLevel((int)NumericValue.asNumber(v).getLong());
                }
            });
            this.put("exhaustion", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.getFoodData().setExhaustion(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("add_exhaustion", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.getFoodData().addExhaustion(NumericValue.asNumber(v).getFloat());
                }
            });
            this.put("absorption", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.setAbsorptionAmount(NumericValue.asNumber(v, "absorbtion").getFloat());
                }
            });
            this.put("add_xp", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.giveExperiencePoints(NumericValue.asNumber(v, "add_xp").getInt());
                }
            });
            this.put("xp_level", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.giveExperienceLevels(NumericValue.asNumber(v, "xp_level").getInt() - p.experienceLevel);
                }
            });
            this.put("xp_progress", (e, v) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer p = (ServerPlayer)e;
                    p.experienceProgress = NumericValue.asNumber(v, "xp_progress").getFloat();
                    p.connection.send((Packet)new ClientboundSetExperiencePacket(p.experienceProgress, p.totalExperience, p.experienceLevel));
                }
            });
            this.put("xp_score", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.setScore(NumericValue.asNumber(v, "xp_score").getInt());
                }
            });
            this.put("saturation", (e, v) -> {
                if (e instanceof Player) {
                    Player p = (Player)e;
                    p.getFoodData().setSaturation(NumericValue.asNumber(v, "saturation").getFloat());
                }
            });
            this.put("air", (e, v) -> e.setAirSupply(NumericValue.asNumber(v, "air").getInt()));
            this.put("breaking_progress", (e, a) -> {
                if (e instanceof ServerPlayer) {
                    ServerPlayer sp = (ServerPlayer)e;
                    int progress = a == null || a.isNull() ? -1 : NumericValue.asNumber(a).getInt();
                    Vanilla.ServerPlayerGameMode_setBlockBreakingProgress(sp.gameMode, progress);
                }
            });
            this.put("nbt", (e, v) -> {
                if (!(e instanceof Player)) {
                    UUID uUID = e.getUUID();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        e.load(nbtsv.getCompoundTag());
                        e.setUUID(uUID);
                    }
                }
            });
            this.put("nbt_merge", (e, v) -> {
                if (!(e instanceof Player)) {
                    UUID uUID = e.getUUID();
                    Value tagValue = NBTSerializableValue.fromValue(v);
                    if (tagValue instanceof NBTSerializableValue) {
                        NBTSerializableValue nbtsv = (NBTSerializableValue)tagValue;
                        CompoundTag nbttagcompound = e.saveWithoutId(new CompoundTag());
                        nbttagcompound.merge(nbtsv.getCompoundTag());
                        e.load(nbttagcompound);
                        e.setUUID(uUID);
                    }
                }
            });
            this.put("blue_skull", (e, v) -> {
                if (e instanceof WitherSkull) {
                    WitherSkull w = (WitherSkull)e;
                    w.setDangerous(v.getBoolean());
                }
            });
            this.put("offering_flower", (e, v) -> {
                if (e instanceof IronGolem) {
                    IronGolem ig = (IronGolem)e;
                    ig.offerFlower(v.getBoolean());
                }
            });
            this.put("item", (e, v) -> {
                ItemStack item = ValueConversions.getItemStackFromValue(v, true, e.level().registryAccess());
                if (e instanceof ItemEntity) {
                    ItemEntity itementity = (ItemEntity)e;
                    itementity.setItem(item);
                }
                if (e instanceof ItemFrame) {
                    ItemFrame itemframe = (ItemFrame)e;
                    itemframe.setItem(item);
                }
            });
        }
    };

    public EntityValue(Entity e) {
        this.entity = e;
    }

    public static Value of(@Nullable Entity e) {
        return e == null ? Value.NULL : new EntityValue(e);
    }

    public static Collection<? extends Entity> getEntitiesFromSelector(CommandSourceStack source, String selector) {
        try {
            net.minecraft.commands.arguments.selector.EntitySelector entitySelector = selectorCache.get(selector);
            if (entitySelector != null) {
                return entitySelector.findEntities(source.withMaximumPermission(4));
            }
            entitySelector = new EntitySelectorParser(new StringReader(selector), true).parse();
            selectorCache.put(selector, entitySelector);
            return entitySelector.findEntities(source.withMaximumPermission(4));
        }
        catch (CommandSyntaxException e) {
            throw new InternalExpressionException("Cannot select entities from " + selector);
        }
    }

    public Entity getEntity() {
        ServerPlayer newPlayer;
        ServerPlayer serverPlayer;
        Entity entity = this.entity;
        if (entity instanceof ServerPlayer && Vanilla.ServerPlayer_isInvalidEntityObject(serverPlayer = (ServerPlayer)entity) && (newPlayer = this.entity.getServer().getPlayerList().getPlayer(this.entity.getUUID())) != null) {
            this.entity = newPlayer;
        }
        return this.entity;
    }

    public static ServerPlayer getPlayerByValue(MinecraftServer server, Value value) {
        EntityValue ev;
        Entity entity;
        if (value instanceof EntityValue && (entity = (ev = (EntityValue)value).getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp;
        }
        if (value.isNull()) {
            return null;
        }
        String playerName = value.getString();
        return server.getPlayerList().getPlayerByName(playerName);
    }

    public static String getPlayerNameByValue(Value value) {
        EntityValue ev;
        Entity entity;
        if (value instanceof EntityValue && (entity = (ev = (EntityValue)value).getEntity()) instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)entity;
            return sp.getScoreboardName();
        }
        if (value.isNull()) {
            return null;
        }
        return value.getString();
    }

    @Override
    public String getString() {
        return this.getEntity().getName().getString();
    }

    @Override
    public boolean getBoolean() {
        return true;
    }

    @Override
    public boolean equals(Object v) {
        if (v instanceof EntityValue) {
            EntityValue ev = (EntityValue)v;
            return this.getEntity().getId() == ev.getEntity().getId();
        }
        return super.equals(v);
    }

    @Override
    public Value in(Value v) {
        if (v instanceof ListValue) {
            ListValue lv = (ListValue)v;
            List<Value> values = lv.getItems();
            String what = values.get(0).getString();
            Value arg = null;
            if (values.size() == 2) {
                arg = values.get(1);
            } else if (values.size() > 2) {
                arg = ListValue.wrap(values.subList(1, values.size()));
            }
            return this.get(what, arg);
        }
        String what = v.getString();
        return this.get(what, null);
    }

    @Override
    public String getTypeString() {
        return "entity";
    }

    @Override
    public int hashCode() {
        return this.getEntity().hashCode();
    }

    public static EntityClassDescriptor getEntityDescriptor(String who, MinecraftServer server) {
        EntityClassDescriptor eDesc = EntityClassDescriptor.byName.get(who);
        if (eDesc == null) {
            boolean positive = true;
            if (who.startsWith("!")) {
                positive = false;
                who = who.substring(1);
            }
            String booWho = who;
            HolderSet.Named eTagValue = (HolderSet.Named)server.registryAccess().registryOrThrow(Registries.ENTITY_TYPE).getTag(TagKey.create((ResourceKey)Registries.ENTITY_TYPE, (ResourceLocation)InputValidator.identifierOf(who))).orElseThrow(() -> new InternalExpressionException(booWho + " is not a valid entity descriptor"));
            Set eTag = eTagValue.stream().map(Holder::value).collect(Collectors.toUnmodifiableSet());
            if (positive) {
                if (eTag.size() == 1) {
                    EntityType type = (EntityType)eTag.iterator().next();
                    return new EntityClassDescriptor((EntityTypeTest<Entity, ?>)type, (Predicate<? super Entity>)((Predicate<Entity>)Entity::isAlive), eTag.stream());
                }
                return new EntityClassDescriptor(ANY, e -> eTag.contains(e.getType()) && e.isAlive(), eTag.stream());
            }
            return new EntityClassDescriptor(ANY, e -> !eTag.contains(e.getType()) && e.isAlive(), server.registryAccess().registryOrThrow(Registries.ENTITY_TYPE).stream().filter(et -> !eTag.contains(et)));
        }
        return eDesc;
    }

    public Value get(String what, @Nullable Value arg) {
        if (!featureAccessors.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity feature: " + what);
        }
        try {
            return featureAccessors.get(what).apply(this.getEntity(), arg);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("Cannot fetch '" + what + "' with these arguments");
        }
    }

    public void set(String what, @Nullable Value toWhat) {
        if (!featureModifiers.containsKey(what)) {
            throw new InternalExpressionException("Unknown entity action: " + what);
        }
        try {
            featureModifiers.get(what).accept(this.getEntity(), toWhat);
        }
        catch (NullPointerException npe) {
            throw new InternalExpressionException("'modify' for '" + what + "' expects a value");
        }
        catch (IndexOutOfBoundsException ind) {
            throw new InternalExpressionException("Wrong number of arguments for `modify` option: " + what);
        }
    }

    private static void updatePosition(Entity e, double x, double y, double z, float yaw, float pitch) {
        if (!Double.isFinite(x) || Double.isNaN(x) || !Double.isFinite(y) || Double.isNaN(y) || !Double.isFinite(z) || Double.isNaN(z) || !Float.isFinite(yaw) || Float.isNaN(yaw) || !Float.isFinite(pitch) || Float.isNaN(pitch)) {
            return;
        }
        if (e instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)e;
            EnumSet<RelativeMovement> set = EnumSet.noneOf(RelativeMovement.class);
            set.add(RelativeMovement.X_ROT);
            set.add(RelativeMovement.Y_ROT);
            sp.connection.teleport(x, y, z, yaw, pitch, set);
        } else {
            e.moveTo(x, y, z, yaw, pitch);
            if (e instanceof LivingEntity) {
                LivingEntity le = (LivingEntity)e;
                le.yBodyRotO = le.yRotO = yaw;
                le.yHeadRotO = le.yHeadRot = yaw;
            } else {
                ((ServerLevel)e.getCommandSenderWorld()).getChunkSource().broadcastAndSend(e, (Packet)new ClientboundTeleportEntityPacket(e));
            }
        }
    }

    private static void updateVelocity(Entity e, double scale) {
        e.hurtMarked = true;
        if (Math.abs(scale) > 10000.0) {
            CarpetScriptServer.LOG.warn("Moved entity " + e.getScoreboardName() + " " + String.valueOf(e.getName()) + " at " + String.valueOf(e.position()) + " extremely fast: " + String.valueOf(e.getDeltaMovement()));
        }
    }

    public void setEvent(CarpetContext cc, String eventName, FunctionValue fun, List<Value> args) {
        EntityEventsGroup.Event event = EntityEventsGroup.Event.byName.get(eventName);
        if (event == null) {
            throw new InternalExpressionException("Unknown entity event: " + eventName);
        }
        Vanilla.Entity_getEventContainer(this.getEntity()).addEvent(event, cc.host, fun, args);
    }

    @Override
    public Tag toTag(boolean force, RegistryAccess regs) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        CompoundTag tag = new CompoundTag();
        tag.put("Data", (Tag)this.getEntity().saveWithoutId(new CompoundTag()));
        Registry reg = this.getEntity().level().registryAccess().registryOrThrow(Registries.ENTITY_TYPE);
        tag.put("Name", (Tag)StringTag.valueOf((String)reg.getKey((Object)this.getEntity().getType()).toString()));
        return tag;
    }

    public static class EntityClassDescriptor {
        public final EntityTypeTest<Entity, ? extends Entity> directType;
        public final Predicate<? super Entity> filteringPredicate;
        public final List<EntityType<? extends Entity>> types;
        public static final Map<String, EntityClassDescriptor> byName = new HashMap<String, EntityClassDescriptor>(){
            {
                List<EntityType<?>> allTypes = BuiltInRegistries.ENTITY_TYPE.stream().toList();
                Set<EntityType> projectiles = Set.of(EntityType.ARROW, EntityType.DRAGON_FIREBALL, EntityType.FIREWORK_ROCKET, EntityType.FIREBALL, EntityType.LLAMA_SPIT, EntityType.SMALL_FIREBALL, EntityType.SNOWBALL, EntityType.SPECTRAL_ARROW, EntityType.EGG, EntityType.ENDER_PEARL, EntityType.EXPERIENCE_BOTTLE, EntityType.POTION, EntityType.TRIDENT, EntityType.WITHER_SKULL, EntityType.FISHING_BOBBER, EntityType.SHULKER_BULLET);
                Set<EntityType> deads = Set.of(EntityType.AREA_EFFECT_CLOUD, EntityType.MARKER, EntityType.BOAT, EntityType.END_CRYSTAL, EntityType.EVOKER_FANGS, EntityType.EXPERIENCE_ORB, EntityType.EYE_OF_ENDER, EntityType.FALLING_BLOCK, EntityType.ITEM, EntityType.ITEM_FRAME, EntityType.GLOW_ITEM_FRAME, EntityType.LEASH_KNOT, EntityType.LIGHTNING_BOLT, EntityType.PAINTING, EntityType.TNT, EntityType.ARMOR_STAND, EntityType.CHEST_BOAT);
                Set<EntityType> minecarts = Set.of(EntityType.MINECART, EntityType.CHEST_MINECART, EntityType.COMMAND_BLOCK_MINECART, EntityType.FURNACE_MINECART, EntityType.HOPPER_MINECART, EntityType.SPAWNER_MINECART, EntityType.TNT_MINECART);
                Set<EntityType> undeads = Set.of(EntityType.STRAY, EntityType.SKELETON, EntityType.WITHER_SKELETON, EntityType.ZOMBIE, EntityType.DROWNED, EntityType.ZOMBIE_VILLAGER, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE, EntityType.PHANTOM, EntityType.WITHER, EntityType.ZOGLIN, EntityType.HUSK, EntityType.ZOMBIFIED_PIGLIN);
                Set<EntityType> arthropods = Set.of(EntityType.BEE, EntityType.ENDERMITE, EntityType.SILVERFISH, EntityType.SPIDER, EntityType.CAVE_SPIDER);
                Set<EntityType> aquatique = Set.of(EntityType.GUARDIAN, EntityType.TURTLE, EntityType.COD, EntityType.DOLPHIN, EntityType.PUFFERFISH, EntityType.SALMON, EntityType.SQUID, EntityType.TROPICAL_FISH);
                Set<EntityType> illagers = Set.of(EntityType.PILLAGER, EntityType.ILLUSIONER, EntityType.VINDICATOR, EntityType.EVOKER, EntityType.RAVAGER, EntityType.WITCH);
                Set living = allTypes.stream().filter(et -> !deads.contains(et) && !projectiles.contains(et) && !minecarts.contains(et)).collect(Collectors.toSet());
                Set regular = allTypes.stream().filter(et -> living.contains(et) && !undeads.contains(et) && !arthropods.contains(et) && !aquatique.contains(et) && !illagers.contains(et)).collect(Collectors.toSet());
                this.put("*", new EntityClassDescriptor(ANY, e -> true, allTypes));
                this.put("valid", new EntityClassDescriptor(ANY, (Predicate<? super Entity>)EntitySelector.ENTITY_STILL_ALIVE, allTypes));
                this.put("!valid", new EntityClassDescriptor(ANY, e -> !e.isAlive(), allTypes));
                this.put("living", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), (Predicate<? super Entity>)EntitySelector.ENTITY_STILL_ALIVE, allTypes.stream().filter(living::contains)));
                this.put("!living", new EntityClassDescriptor(ANY, e -> !(e instanceof LivingEntity) && e.isAlive(), allTypes.stream().filter(et -> !living.contains(et))));
                this.put("projectile", new EntityClassDescriptor(EntityTypeTest.forClass(Projectile.class), (Predicate<? super Entity>)EntitySelector.ENTITY_STILL_ALIVE, allTypes.stream().filter(projectiles::contains)));
                this.put("!projectile", new EntityClassDescriptor(ANY, e -> !(e instanceof Projectile) && e.isAlive(), allTypes.stream().filter(et -> !projectiles.contains(et) && !living.contains(et))));
                this.put("minecarts", new EntityClassDescriptor(EntityTypeTest.forClass(AbstractMinecart.class), (Predicate<? super Entity>)EntitySelector.ENTITY_STILL_ALIVE, allTypes.stream().filter(minecarts::contains)));
                this.put("!minecarts", new EntityClassDescriptor(ANY, e -> !(e instanceof AbstractMinecart) && e.isAlive(), allTypes.stream().filter(et -> !minecarts.contains(et) && !living.contains(et))));
                this.put("arthropod", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> e.getType().is(EntityTypeTags.ARTHROPOD) && e.isAlive(), allTypes.stream().filter(arthropods::contains)));
                this.put("!arthropod", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> !e.getType().is(EntityTypeTags.ARTHROPOD) && e.isAlive(), allTypes.stream().filter(et -> !arthropods.contains(et) && living.contains(et))));
                this.put("undead", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> e.getType().is(EntityTypeTags.UNDEAD) && e.isAlive(), allTypes.stream().filter(undeads::contains)));
                this.put("!undead", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> !e.getType().is(EntityTypeTags.UNDEAD) && e.isAlive(), allTypes.stream().filter(et -> !undeads.contains(et) && living.contains(et))));
                this.put("aquatic", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> e.getType().is(EntityTypeTags.AQUATIC) && e.isAlive(), allTypes.stream().filter(aquatique::contains)));
                this.put("!aquatic", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> !e.getType().is(EntityTypeTags.AQUATIC) && e.isAlive(), allTypes.stream().filter(et -> !aquatique.contains(et) && living.contains(et))));
                this.put("illager", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> e.getType().is(EntityTypeTags.ILLAGER) && e.isAlive(), allTypes.stream().filter(illagers::contains)));
                this.put("!illager", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> !e.getType().is(EntityTypeTags.ILLAGER) && e.isAlive(), allTypes.stream().filter(et -> !illagers.contains(et) && living.contains(et))));
                this.put("regular", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> {
                    EntityType type = e.getType();
                    return !illagers.contains(type) && !arthropods.contains(type) && !undeads.contains(type) && !aquatique.contains(type) && living.contains(type) && e.isAlive();
                }, allTypes.stream().filter(regular::contains)));
                this.put("!regular", new EntityClassDescriptor(EntityTypeTest.forClass(LivingEntity.class), e -> {
                    EntityType type = e.getType();
                    return (illagers.contains(type) || arthropods.contains(type) || undeads.contains(type) || aquatique.contains(type)) && e.isAlive();
                }, allTypes.stream().filter(et -> !regular.contains(et) && living.contains(et))));
                for (ResourceLocation typeId : BuiltInRegistries.ENTITY_TYPE.keySet()) {
                    EntityType type = (EntityType)BuiltInRegistries.ENTITY_TYPE.get(typeId);
                    String mobType = ValueConversions.simplify(typeId);
                    this.put(mobType, new EntityClassDescriptor((EntityTypeTest<Entity, ?>)type, (Predicate<? super Entity>)EntitySelector.ENTITY_STILL_ALIVE, Stream.of(type)));
                    this.put("!" + mobType, new EntityClassDescriptor(ANY, e -> e.getType() != type && e.isAlive(), allTypes.stream().filter(et -> et != type)));
                }
                for (MobCategory catId : MobCategory.values()) {
                    String catStr = catId.getName();
                    this.put(catStr, new EntityClassDescriptor(ANY, e -> e.getType().getCategory() == catId && e.isAlive(), allTypes.stream().filter(et -> et.getCategory() == catId)));
                    this.put("!" + catStr, new EntityClassDescriptor(ANY, e -> e.getType().getCategory() != catId && e.isAlive(), allTypes.stream().filter(et -> et.getCategory() != catId)));
                }
            }
        };

        EntityClassDescriptor(EntityTypeTest<Entity, ?> type, Predicate<? super Entity> predicate, List<EntityType<?>> types) {
            this.directType = type;
            this.filteringPredicate = predicate;
            this.types = types;
        }

        EntityClassDescriptor(EntityTypeTest<Entity, ?> type, Predicate<? super Entity> predicate, Stream<EntityType<?>> types) {
            this(type, predicate, types.toList());
        }

        public Value listValue(RegistryAccess regs) {
            Registry entityRegs = regs.registryOrThrow(Registries.ENTITY_TYPE);
            return ListValue.wrap(this.types.stream().map(et -> NBTSerializableValue.nameFromRegistryId(entityRegs.getKey(et))));
        }
    }
}

