/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.value.NBTSerializableValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;

public class FormattedTextValue
extends StringValue {
    Component text;

    public FormattedTextValue(Component text) {
        super(null);
        this.text = text;
    }

    public static Value combine(Value left, Value right) {
        MutableComponent text;
        FormattedTextValue ftv;
        if (left instanceof FormattedTextValue) {
            ftv = (FormattedTextValue)left;
            text = ftv.getText().copy();
        } else {
            if (left.isNull()) {
                return right;
            }
            text = Component.literal((String)left.getString());
        }
        if (right instanceof FormattedTextValue) {
            ftv = (FormattedTextValue)right;
            text.append((Component)ftv.getText().copy());
            return new FormattedTextValue((Component)text);
        }
        if (right.isNull()) {
            return left;
        }
        text.append(right.getString());
        return new FormattedTextValue((Component)text);
    }

    public static Value of(Component text) {
        return text == null ? Value.NULL : new FormattedTextValue(text);
    }

    @Override
    public String getString() {
        return this.text.getString();
    }

    @Override
    public boolean getBoolean() {
        return !this.text.getString().isEmpty();
    }

    @Override
    public Value clone() {
        return new FormattedTextValue(this.text);
    }

    @Override
    public String getTypeString() {
        return "text";
    }

    public Component getText() {
        return this.text;
    }

    @Override
    public Tag toTag(boolean force, RegistryAccess regs) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return StringTag.valueOf((String)Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)regs));
    }

    @Override
    public Value add(Value o) {
        return FormattedTextValue.combine(this, o);
    }

    public String serialize(RegistryAccess regs) {
        return Component.Serializer.toJson((Component)this.text, (HolderLookup.Provider)regs);
    }

    public static FormattedTextValue deserialize(String serialized, RegistryAccess regs) {
        return new FormattedTextValue((Component)Component.Serializer.fromJson((String)serialized, (HolderLookup.Provider)regs));
    }

    public static Component getTextByValue(Value value) {
        MutableComponent mutableComponent;
        if (value instanceof FormattedTextValue) {
            FormattedTextValue ftv = (FormattedTextValue)value;
            mutableComponent = ftv.getText();
        } else {
            mutableComponent = Component.literal((String)value.getString());
        }
        return mutableComponent;
    }
}

