/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetContext;
import carpet.script.exception.InternalExpressionException;
import carpet.script.exception.ThrowStatement;
import carpet.script.exception.Throwables;
import carpet.script.external.Vanilla;
import carpet.script.utils.EquipmentInventory;
import carpet.script.value.BlockValue;
import carpet.script.value.ContainerValueInterface;
import carpet.script.value.EntityValue;
import carpet.script.value.ListValue;
import carpet.script.value.MapValue;
import carpet.script.value.NumericValue;
import carpet.script.value.ScreenValue;
import carpet.script.value.StringValue;
import carpet.script.value.Value;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.NbtPathArgument;
import net.minecraft.commands.arguments.item.ItemInput;
import net.minecraft.commands.arguments.item.ItemParser;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CollectionTag;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.EndTag;
import net.minecraft.nbt.IntTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.WorldlyContainerHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.npc.InventoryCarrier;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;

public class NBTSerializableValue
extends Value
implements ContainerValueInterface {
    private String nbtString = null;
    private Tag nbtTag = null;
    private Supplier<Tag> nbtSupplier = null;
    private boolean owned = false;
    private static final Map<String, ItemInput> itemCache = new HashMap<String, ItemInput>();
    private static final Map<String, NbtPathArgument.NbtPath> pathCache = new HashMap<String, NbtPathArgument.NbtPath>();

    private NBTSerializableValue() {
    }

    public NBTSerializableValue(String nbtString) {
        this.nbtSupplier = () -> {
            try {
                return new TagParser(new StringReader(nbtString)).readValue();
            }
            catch (CommandSyntaxException e) {
                throw new InternalExpressionException("Incorrect NBT data: " + nbtString);
            }
        };
        this.owned = true;
    }

    public NBTSerializableValue(Tag tag) {
        this.nbtTag = tag;
        this.owned = true;
    }

    public static Value of(Tag tag) {
        if (tag == null) {
            return Value.NULL;
        }
        return new NBTSerializableValue(tag);
    }

    public NBTSerializableValue(Supplier<Tag> tagSupplier) {
        this.nbtSupplier = tagSupplier;
    }

    public static Value fromStack(ItemStack stack, RegistryAccess regs) {
        NBTSerializableValue value = new NBTSerializableValue();
        value.nbtSupplier = () -> stack.saveOptional((HolderLookup.Provider)regs);
        return value;
    }

    public static Value nameFromRegistryId(@Nullable ResourceLocation id) {
        return StringValue.of(NBTSerializableValue.nameFromResource(id));
    }

    @Nullable
    public static String nameFromResource(@Nullable ResourceLocation id) {
        return id == null ? null : (id.getNamespace().equals("minecraft") ? id.getPath() : id.toString());
    }

    @Nullable
    public static NBTSerializableValue parseString(String nbtString) {
        try {
            Tag tag = new TagParser(new StringReader(nbtString)).readValue();
            NBTSerializableValue value = new NBTSerializableValue(tag);
            value.nbtString = null;
            return value;
        }
        catch (CommandSyntaxException e) {
            return null;
        }
    }

    public static NBTSerializableValue parseStringOrFail(String nbtString) {
        NBTSerializableValue result = NBTSerializableValue.parseString(nbtString);
        if (result == null) {
            throw new InternalExpressionException("Incorrect NBT tag: " + nbtString);
        }
        return result;
    }

    public Value clone() {
        NBTSerializableValue copy = new NBTSerializableValue(this.nbtTag);
        copy.nbtSupplier = this.nbtSupplier;
        copy.nbtString = this.nbtString;
        copy.owned = this.owned;
        return copy;
    }

    @Override
    public Value deepcopy() {
        NBTSerializableValue copy = (NBTSerializableValue)this.clone();
        copy.owned = false;
        this.ensureOwnership();
        return copy;
    }

    @Override
    public Value fromConstant() {
        return this.deepcopy();
    }

    public static Container getInventoryAt(ServerLevel world, BlockPos blockPos) {
        List list;
        Container inventoryHolder;
        BlockEntity blockEntity;
        WorldlyContainer inventory = null;
        BlockState blockState = world.getBlockState(blockPos);
        Block block = blockState.getBlock();
        if (block instanceof WorldlyContainerHolder) {
            WorldlyContainerHolder containerHolder = (WorldlyContainerHolder)block;
            inventory = containerHolder.getContainer(blockState, (LevelAccessor)world, blockPos);
        } else if (blockState.hasBlockEntity() && (blockEntity = BlockValue.getBlockEntity((Level)world, blockPos)) instanceof Container && (inventory = (inventoryHolder = (Container)blockEntity)) instanceof ChestBlockEntity && block instanceof ChestBlock) {
            ChestBlock chestBlock = (ChestBlock)block;
            inventory = ChestBlock.getContainer((ChestBlock)chestBlock, (BlockState)blockState, (Level)world, (BlockPos)blockPos, (boolean)true);
        }
        if (inventory == null && !(list = world.getEntities((Entity)null, new AABB((double)blockPos.getX() - 0.5, (double)blockPos.getY() - 0.5, (double)blockPos.getZ() - 0.5, (double)blockPos.getX() + 0.5, (double)blockPos.getY() + 0.5, (double)blockPos.getZ() + 0.5), EntitySelector.CONTAINER_ENTITY_SELECTOR)).isEmpty()) {
            inventory = (Container)list.get(world.random.nextInt(list.size()));
        }
        return inventory;
    }

    public static InventoryLocator locateInventory(CarpetContext c, List<Value> params, int offset) {
        try {
            Value v1 = params.get(offset);
            if (v1.isNull()) {
                v1 = params.get(++offset);
            } else if (v1 instanceof StringValue) {
                ServerPlayer player;
                String strVal = v1.getString().toLowerCase(Locale.ROOT);
                if (strVal.equals("enderchest")) {
                    Value v2 = params.get(1 + offset);
                    ServerPlayer player2 = EntityValue.getPlayerByValue(c.server(), v2);
                    if (player2 == null) {
                        throw new InternalExpressionException("enderchest inventory requires player argument");
                    }
                    return new InventoryLocator(player2, player2.blockPosition(), (Container)player2.getEnderChestInventory(), offset + 2, true);
                }
                if (strVal.equals("equipment")) {
                    Value v2 = params.get(1 + offset);
                    if (!(v2 instanceof EntityValue)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    EntityValue ev = (EntityValue)v2;
                    Entity e = ev.getEntity();
                    if (!(e instanceof LivingEntity)) {
                        throw new InternalExpressionException("Equipment inventory requires a living entity argument");
                    }
                    LivingEntity le = (LivingEntity)e;
                    return new InventoryLocator(e, e.blockPosition(), new EquipmentInventory(le), offset + 2);
                }
                boolean isEnder = strVal.startsWith("enderchest_");
                if (isEnder) {
                    strVal = strVal.substring(11);
                }
                if ((player = c.server().getPlayerList().getPlayerByName(strVal)) == null) {
                    throw new InternalExpressionException("String description of an inventory should either denote a player or player's enderchest");
                }
                return new InventoryLocator(player, player.blockPosition(), (Container)(isEnder ? player.getEnderChestInventory() : player.getInventory()), offset + 1, isEnder);
            }
            if (v1 instanceof EntityValue) {
                EntityValue ev = (EntityValue)v1;
                Inventory inv = null;
                Entity e = ev.getEntity();
                if (e instanceof Player) {
                    Player pe = (Player)e;
                    inv = pe.getInventory();
                } else if (e instanceof Container) {
                    Container container = (Container)e;
                    inv = container;
                } else if (e instanceof InventoryCarrier) {
                    InventoryCarrier io = (InventoryCarrier)e;
                    inv = io.getInventory();
                } else if (e instanceof AbstractHorse) {
                    AbstractHorse ibi = (AbstractHorse)e;
                    inv = Vanilla.AbstractHorse_getInventory(ibi);
                } else if (e instanceof LivingEntity) {
                    LivingEntity le = (LivingEntity)e;
                    return new InventoryLocator(e, e.blockPosition(), new EquipmentInventory(le), offset + 1);
                }
                return inv == null ? null : new InventoryLocator(e, e.blockPosition(), (Container)inv, offset + 1);
            }
            if (v1 instanceof BlockValue) {
                BlockValue bv = (BlockValue)v1;
                BlockPos pos = bv.getPos();
                if (pos == null) {
                    throw new InternalExpressionException("Block to access inventory needs to be positioned in the world");
                }
                Container inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
                return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ListValue) {
                ListValue lv = (ListValue)v1;
                List<Value> args = lv.getItems();
                BlockPos pos = BlockPos.containing((double)NumericValue.asNumber(args.get(0)).getDouble(), (double)NumericValue.asNumber(args.get(1)).getDouble(), (double)NumericValue.asNumber(args.get(2)).getDouble());
                Container inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
                return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 1);
            }
            if (v1 instanceof ScreenValue) {
                ScreenValue screenValue = (ScreenValue)v1;
                return !screenValue.isOpen() ? null : new InventoryLocator(screenValue.getPlayer(), screenValue.getPlayer().blockPosition(), screenValue.getInventory(), offset + 1);
            }
            BlockPos pos = BlockPos.containing((double)NumericValue.asNumber(v1).getDouble(), (double)NumericValue.asNumber(params.get(1 + offset)).getDouble(), (double)NumericValue.asNumber(params.get(2 + offset)).getDouble());
            Container inv = NBTSerializableValue.getInventoryAt(c.level(), pos);
            return inv == null ? null : new InventoryLocator(pos, pos, inv, offset + 3);
        }
        catch (IndexOutOfBoundsException e) {
            throw new InternalExpressionException("Inventory should be defined either by three coordinates, a block value, an entity, or a screen");
        }
    }

    public static ItemStack parseItem(String itemString, RegistryAccess regs) {
        return NBTSerializableValue.parseItem(itemString, null, regs);
    }

    public static ItemStack parseItem(String itemString, @Nullable CompoundTag customTag, RegistryAccess regs) {
        if (customTag != null) {
            return ItemStack.parseOptional((HolderLookup.Provider)regs, (CompoundTag)customTag);
        }
        try {
            ItemInput res = itemCache.get(itemString);
            if (res != null) {
                return res.createItemStack(1, false);
            }
            ItemParser.ItemResult parser = new ItemParser((HolderLookup.Provider)regs).parse(new StringReader(itemString));
            res = new ItemInput(parser.item(), parser.components());
            itemCache.put(itemString, res);
            if (itemCache.size() > 64000) {
                itemCache.clear();
            }
            return res.createItemStack(1, false);
        }
        catch (CommandSyntaxException e) {
            throw new ThrowStatement(itemString, Throwables.UNKNOWN_ITEM);
        }
    }

    public static int validateSlot(int slot, Container inv) {
        int invSize = inv.getContainerSize();
        if (slot < 0) {
            slot = invSize + slot;
        }
        return slot < 0 || slot >= invSize ? inv.getContainerSize() : slot;
    }

    private static Value decodeSimpleTag(Tag t) {
        if (t instanceof NumericTag) {
            NumericTag number = (NumericTag)t;
            return t instanceof LongTag || t instanceof IntTag ? NumericValue.of(number.getAsLong()) : NumericValue.of(number.getAsNumber());
        }
        if (t instanceof StringTag) {
            return StringValue.of(t.getAsString());
        }
        if (t instanceof EndTag) {
            return Value.NULL;
        }
        throw new InternalExpressionException("How did we get here: Unknown nbt element class: " + t.getType().getName());
    }

    private static Value decodeTag(Tag t) {
        return t instanceof CompoundTag || t instanceof CollectionTag ? new NBTSerializableValue(() -> t) : NBTSerializableValue.decodeSimpleTag(t);
    }

    private static Value decodeTagDeep(Tag t) {
        if (t instanceof CompoundTag) {
            CompoundTag ctag = (CompoundTag)t;
            HashMap<Value, Value> pairs = new HashMap<Value, Value>();
            for (String key : ctag.getAllKeys()) {
                pairs.put(new StringValue(key), NBTSerializableValue.decodeTagDeep(ctag.get(key)));
            }
            return MapValue.wrap(pairs);
        }
        if (t instanceof CollectionTag) {
            CollectionTag ltag = (CollectionTag)t;
            ArrayList<Value> elems = new ArrayList<Value>();
            for (Tag elem : ltag) {
                elems.add(NBTSerializableValue.decodeTagDeep(elem));
            }
            return ListValue.wrap(elems);
        }
        return NBTSerializableValue.decodeSimpleTag(t);
    }

    public Value toValue() {
        return NBTSerializableValue.decodeTagDeep(this.getTag());
    }

    public static Value fromValue(Value v) {
        if (v instanceof NBTSerializableValue) {
            return v;
        }
        if (v.isNull()) {
            return Value.NULL;
        }
        return NBTSerializableValue.parseStringOrFail(v.getString());
    }

    public Tag getTag() {
        if (this.nbtTag == null) {
            this.nbtTag = this.nbtSupplier.get();
        }
        return this.nbtTag;
    }

    @Override
    public boolean equals(Object o) {
        boolean bl;
        if (o instanceof NBTSerializableValue) {
            NBTSerializableValue nbtsv = (NBTSerializableValue)o;
            bl = this.getTag().equals((Object)nbtsv.getTag());
        } else {
            bl = super.equals(o);
        }
        return bl;
    }

    @Override
    public String getString() {
        if (this.nbtString == null) {
            this.nbtString = this.getTag().toString();
        }
        return this.nbtString;
    }

    @Override
    public boolean getBoolean() {
        Tag tag = this.getTag();
        if (tag instanceof CompoundTag) {
            CompoundTag ctag = (CompoundTag)tag;
            return !ctag.isEmpty();
        }
        if (tag instanceof CollectionTag) {
            CollectionTag ltag = (CollectionTag)tag;
            return !ltag.isEmpty();
        }
        if (tag instanceof NumericTag) {
            NumericTag number = (NumericTag)tag;
            return number.getAsDouble() != 0.0;
        }
        if (tag instanceof StringTag) {
            return !tag.getAsString().isEmpty();
        }
        return true;
    }

    public CompoundTag getCompoundTag() {
        try {
            this.ensureOwnership();
            return (CompoundTag)this.getTag();
        }
        catch (ClassCastException e) {
            throw new InternalExpressionException(this.getString() + " is not a valid compound tag");
        }
    }

    @Override
    public boolean put(Value where, Value value) {
        return this.put(where, value, new StringValue("replace"));
    }

    @Override
    public boolean put(Value where, Value value, Value conditions) {
        boolean modifiedTag;
        Tag tagToInsert;
        this.ensureOwnership();
        NbtPathArgument.NbtPath path = NBTSerializableValue.cachePath(where.getString());
        if (value instanceof NBTSerializableValue) {
            NBTSerializableValue nbtsv = (NBTSerializableValue)value;
            v0 = nbtsv.getTag();
        } else {
            v0 = tagToInsert = new NBTSerializableValue(value.getString()).getTag();
        }
        if (conditions instanceof NumericValue) {
            NumericValue number = (NumericValue)conditions;
            modifiedTag = this.modifyInsert((int)number.getLong(), path, tagToInsert);
        } else {
            String ops = conditions.getString();
            if (ops.equalsIgnoreCase("merge")) {
                modifiedTag = this.modifyMerge(path, tagToInsert);
            } else if (ops.equalsIgnoreCase("replace")) {
                modifiedTag = this.modifyReplace(path, tagToInsert);
            } else {
                return false;
            }
        }
        if (modifiedTag) {
            this.dirty();
        }
        return modifiedTag;
    }

    private boolean modifyInsert(int index, NbtPathArgument.NbtPath nbtPath, Tag newElement) {
        return this.modifyInsert(index, nbtPath, newElement, this.getTag());
    }

    private boolean modifyInsert(int index, NbtPathArgument.NbtPath nbtPath, Tag newElement, Tag currentTag) {
        List targets;
        try {
            targets = nbtPath.getOrCreate(currentTag, ListTag::new);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        boolean modified = false;
        for (Tag target : targets) {
            if (!(target instanceof CollectionTag)) continue;
            CollectionTag targetList = (CollectionTag)target;
            try {
                if (!targetList.addTag(index < 0 ? targetList.size() + index + 1 : index, newElement.copy())) {
                    return false;
                }
                modified = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        }
        return modified;
    }

    private boolean modifyMerge(NbtPathArgument.NbtPath nbtPath, Tag replacement) {
        if (!(replacement instanceof CompoundTag)) {
            return false;
        }
        CompoundTag replacementCompound = (CompoundTag)replacement;
        Tag ownTag = this.getTag();
        try {
            for (Tag target : nbtPath.getOrCreate(ownTag, CompoundTag::new)) {
                if (!(target instanceof CompoundTag)) continue;
                CompoundTag targetCompound = (CompoundTag)target;
                targetCompound.merge(replacementCompound);
            }
        }
        catch (CommandSyntaxException ignored) {
            return false;
        }
        return true;
    }

    private boolean modifyReplace(NbtPathArgument.NbtPath nbtPath, Tag replacement) {
        Tag tag = this.getTag();
        String pathText = nbtPath.toString();
        if (pathText.endsWith("]")) {
            int pos;
            if (nbtPath.remove(tag) == 0) {
                return false;
            }
            Pattern pattern = Pattern.compile("\\[[^\\[]*]$");
            Matcher matcher = pattern.matcher(pathText);
            if (!matcher.find()) {
                return false;
            }
            String arrAccess = matcher.group();
            if (arrAccess.length() == 2) {
                pos = 0;
            } else {
                try {
                    pos = Integer.parseInt(arrAccess.substring(1, arrAccess.length() - 1));
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            NbtPathArgument.NbtPath newPath = NBTSerializableValue.cachePath(pathText.substring(0, pathText.length() - arrAccess.length()));
            return this.modifyInsert(pos, newPath, replacement, tag);
        }
        try {
            nbtPath.set(tag, replacement);
        }
        catch (CommandSyntaxException e) {
            return false;
        }
        return true;
    }

    @Override
    public Value get(Value value) {
        String valString = value.getString();
        NbtPathArgument.NbtPath path = NBTSerializableValue.cachePath(valString);
        try {
            List tags = path.get(this.getTag());
            if (tags.isEmpty()) {
                return Value.NULL;
            }
            if (tags.size() == 1 && !valString.endsWith("[]")) {
                return NBTSerializableValue.decodeTag((Tag)tags.get(0));
            }
            return ListValue.wrap(tags.stream().map(NBTSerializableValue::decodeTag));
        }
        catch (CommandSyntaxException commandSyntaxException) {
            return Value.NULL;
        }
    }

    @Override
    public boolean has(Value where) {
        return NBTSerializableValue.cachePath(where.getString()).countMatching(this.getTag()) > 0;
    }

    private void ensureOwnership() {
        if (!this.owned) {
            this.nbtTag = this.getTag().copy();
            this.nbtString = null;
            this.nbtSupplier = null;
            this.owned = true;
        }
    }

    private void dirty() {
        this.nbtString = null;
    }

    @Override
    public boolean delete(Value where) {
        NbtPathArgument.NbtPath path = NBTSerializableValue.cachePath(where.getString());
        this.ensureOwnership();
        int removed = path.remove(this.getTag());
        if (removed > 0) {
            this.dirty();
            return true;
        }
        return false;
    }

    private static NbtPathArgument.NbtPath cachePath(String arg) {
        NbtPathArgument.NbtPath res = pathCache.get(arg);
        if (res != null) {
            return res;
        }
        try {
            res = NbtPathArgument.nbtPath().parse(new StringReader(arg));
        }
        catch (CommandSyntaxException exc) {
            throw new InternalExpressionException("Incorrect nbt path: " + arg);
        }
        if (pathCache.size() > 1024) {
            pathCache.clear();
        }
        pathCache.put(arg, res);
        return res;
    }

    @Override
    public String getTypeString() {
        return "nbt";
    }

    @Override
    public Tag toTag(boolean force, RegistryAccess regs) {
        if (!force) {
            throw new IncompatibleTypeException(this);
        }
        this.ensureOwnership();
        return this.getTag();
    }

    public record InventoryLocator(Object owner, BlockPos position, Container inventory, int offset, boolean isEnder) {
        InventoryLocator(Object owner, BlockPos pos, Container i, int o) {
            this(owner, pos, i, o, false);
        }
    }

    public static class IncompatibleTypeException
    extends RuntimeException {
        public final Value val;

        public IncompatibleTypeException(Value val) {
            this.val = val;
        }
    }
}

