/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.Context;
import carpet.script.Expression;
import carpet.script.Tokenizer;
import carpet.script.exception.ExitStatement;
import carpet.script.exception.ExpressionException;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.FunctionValue;
import carpet.script.value.LazyListValue;
import carpet.script.value.NBTSerializableValue;
import carpet.script.value.UndefValue;
import carpet.script.value.Value;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicReference;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;

public class ThreadValue
extends LazyListValue {
    private final CompletableFuture<Value> taskFuture;
    private final long id;
    private static long sequence = 0L;
    private final Deque<Value> coState = new ArrayDeque<Value>();
    private final AtomicReference<Value> coLock = new AtomicReference<UndefValue>(Value.EOL);
    public final boolean isCoroutine;

    public ThreadValue(Value pool, FunctionValue function, Expression expr, Tokenizer.Token token, Context ctx, List<Value> args) {
        this.id = sequence++;
        this.isCoroutine = ctx.host.canSynchronouslyExecute();
        this.taskFuture = this.getCompletableFutureFromFunction(pool, function, expr, token, ctx, args);
        Thread.yield();
    }

    public CompletableFuture<Value> getCompletableFutureFromFunction(Value pool, FunctionValue function, Expression expr, Tokenizer.Token token, Context ctx, List<Value> args) {
        ThreadValue callingThread;
        ThreadPoolExecutor executor = ctx.host.getExecutor(pool);
        ThreadValue threadValue = callingThread = this.isCoroutine ? this : null;
        if (executor == null) {
            return CompletableFuture.completedFuture(Value.NULL);
        }
        return CompletableFuture.supplyAsync(() -> {
            try {
                return function.execute(ctx, Context.NONE, expr, token, args, callingThread).evalValue(ctx);
            }
            catch (ExitStatement exit) {
                return exit.retval;
            }
            catch (ExpressionException exc) {
                ctx.host.handleExpressionException("Thread failed\n", exc);
                return Value.NULL;
            }
        }, ctx.host.getExecutor(pool));
    }

    @Override
    public String getString() {
        return this.taskFuture.getNow(Value.NULL).getString();
    }

    public Value getValue() {
        return this.taskFuture.getNow(Value.NULL);
    }

    @Override
    public boolean getBoolean() {
        return this.taskFuture.getNow(Value.NULL).getBoolean();
    }

    public Value join() {
        try {
            return this.taskFuture.get();
        }
        catch (ExitStatement exit) {
            this.taskFuture.complete(exit.retval);
            return exit.retval;
        }
        catch (InterruptedException | ExecutionException e) {
            return Value.NULL;
        }
    }

    public boolean isFinished() {
        return this.taskFuture.isDone();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        if (!(o instanceof ThreadValue)) return false;
        ThreadValue tv = (ThreadValue)o;
        if (tv.id != this.id) return false;
        return true;
    }

    @Override
    public int compareTo(Value o) {
        if (!(o instanceof ThreadValue)) {
            throw new InternalExpressionException("Cannot compare tasks to other types");
        }
        ThreadValue tv = (ThreadValue)o;
        return (int)(this.id - tv.id);
    }

    @Override
    public int hashCode() {
        return Long.hashCode(this.id);
    }

    @Override
    public Tag toTag(boolean force, RegistryAccess regs) {
        if (!force) {
            throw new NBTSerializableValue.IncompatibleTypeException(this);
        }
        return this.getValue().toTag(true, regs);
    }

    @Override
    public String getTypeString() {
        return "task";
    }

    @Override
    public void fatality() {
    }

    @Override
    public void reset() {
    }

    @Override
    public Iterator<Value> iterator() {
        if (!this.isCoroutine) {
            throw new InternalExpressionException("Cannot iterate over this task");
        }
        return this;
    }

    @Override
    public boolean hasNext() {
        return !this.coState.isEmpty() || !this.taskFuture.isDone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Value next() {
        Value popped = null;
        Deque<Value> deque = this.coState;
        synchronized (deque) {
            while (true) {
                if (!this.coState.isEmpty()) {
                    popped = this.coState.pop();
                } else if (this.taskFuture.isDone()) {
                    popped = Value.EOL;
                }
                if (popped != null) break;
                try {
                    this.coState.wait(1L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.coState.notifyAll();
        }
        return popped;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void send(Value value) {
        AtomicReference<Value> atomicReference = this.coLock;
        synchronized (atomicReference) {
            this.coLock.set(value);
            this.coLock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Value ping(Value value, boolean lock) {
        var3_3 = this.coState;
        synchronized (var3_3) {
            try {
                if (!lock) {
                    this.coState.add(value);
                    var4_4 = Value.NULL;
                    return var4_4;
                }
                while (true) {
                    if (this.coState.isEmpty()) {
                        this.coState.add(value);
                        break;
                    }
                    try {
                        this.coState.wait(1L);
                    }
                    catch (InterruptedException var4_5) {}
                }
            }
            finally {
                this.coState.notifyAll();
            }
        }
        var3_3 = this.coLock;
        synchronized (var3_3) {
            block21: {
                while (true) lbl-1000:
                // 3 sources

                {
                    if ((current = this.coLock.get()) != Value.EOL) {
                        ret = current;
                        this.coLock.set(Value.EOL);
                        break block21;
                    }
                    try {
                        this.coLock.wait(1L);
                    }
                    catch (InterruptedException var6_9) {
                        continue;
                    }
                    break;
                }
                ** GOTO lbl-1000
                finally {
                    this.coLock.notifyAll();
                }
            }
            return ret;
        }
    }
}

