/*
 * Decompiled with CFR 0.152.
 */
package carpet.script.value;

import carpet.script.CarpetScriptServer;
import carpet.script.exception.InternalExpressionException;
import carpet.script.value.BooleanValue;
import carpet.script.value.FormattedTextValue;
import carpet.script.value.ListValue;
import carpet.script.value.NullValue;
import carpet.script.value.NumericValue;
import carpet.script.value.StringValue;
import carpet.script.value.ThreadValue;
import carpet.script.value.UndefValue;
import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.annotation.Nullable;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.Tag;

public abstract class Value
implements Comparable<Value>,
Cloneable {
    public static final NumericValue FALSE = BooleanValue.FALSE;
    public static final NumericValue TRUE = BooleanValue.TRUE;
    public static final NumericValue ZERO = new NumericValue(0L);
    public static final NumericValue ONE = new NumericValue(1L);
    public static final NullValue NULL = NullValue.NULL;
    public static final UndefValue UNDEF = UndefValue.UNDEF;
    public static final UndefValue EOL = UndefValue.EOL;
    public String boundVariable = null;

    public boolean isBound() {
        return this.boundVariable != null;
    }

    public String getVariable() {
        return this.boundVariable;
    }

    public Value reboundedTo(String value) {
        Value copy;
        try {
            copy = (Value)this.clone();
        }
        catch (CloneNotSupportedException e) {
            CarpetScriptServer.LOG.error("Failed to clone variable", (Throwable)e);
            throw new InternalExpressionException("Variable of type " + this.getTypeString() + " is not cloneable. Tell gnembon about it, this shoudn't happen");
        }
        copy.boundVariable = value;
        return copy;
    }

    public Value bindTo(String value) {
        this.boundVariable = value;
        return this;
    }

    public abstract String getString();

    public String getPrettyString() {
        return this.getString();
    }

    public abstract boolean getBoolean();

    public Value add(Value o) {
        if (o instanceof FormattedTextValue) {
            return FormattedTextValue.combine(this, o);
        }
        String leftStr = this.getString();
        String rightStr = o.getString();
        return new StringValue(leftStr + rightStr);
    }

    public Value subtract(Value v) {
        return new StringValue(this.getString().replace(v.getString(), ""));
    }

    public Value multiply(Value v) {
        return v instanceof NumericValue || v instanceof ListValue ? v.multiply(this) : new StringValue(this.getString() + "." + v.getString());
    }

    public Value divide(Value v) {
        if (v instanceof NumericValue) {
            NumericValue number = (NumericValue)v;
            String lstr = this.getString();
            return new StringValue(lstr.substring(0, (int)((double)lstr.length() / number.getDouble())));
        }
        return new StringValue(this.getString() + "/" + v.getString());
    }

    @Override
    public int compareTo(Value o) {
        return o instanceof NumericValue || o instanceof ListValue || o instanceof ThreadValue ? -o.compareTo(this) : this.getString().compareTo(o.getString());
    }

    public boolean equals(Object o) {
        if (o instanceof Value) {
            Value v = (Value)o;
            return this.compareTo(v) == 0;
        }
        return false;
    }

    public void assertAssignable() {
        if (this.boundVariable == null) {
            throw new InternalExpressionException(this.getString() + " is not a variable");
        }
    }

    public Value in(Value value1) {
        Pattern p;
        try {
            p = Pattern.compile(value1.getString());
        }
        catch (PatternSyntaxException pse) {
            throw new InternalExpressionException("Incorrect matching pattern: " + pse.getMessage());
        }
        Matcher m = p.matcher(this.getString());
        if (!m.find()) {
            return NULL;
        }
        int gc = m.groupCount();
        if (gc == 0) {
            return new StringValue(m.group());
        }
        if (gc == 1) {
            return StringValue.of(m.group(1));
        }
        ArrayList<Value> groups = new ArrayList<Value>(gc);
        for (int i = 1; i <= gc; ++i) {
            groups.add(StringValue.of(m.group(i)));
        }
        return ListValue.wrap(groups);
    }

    public int length() {
        return this.getString().length();
    }

    public Value slice(long fromDesc, @Nullable Long toDesc) {
        String value = this.getString();
        int size = value.length();
        int from = ListValue.normalizeIndex(fromDesc, size);
        if (toDesc == null) {
            return new StringValue(value.substring(from));
        }
        int to = ListValue.normalizeIndex(toDesc, size + 1);
        if (from > to) {
            return StringValue.EMPTY;
        }
        return new StringValue(value.substring(from, to));
    }

    public Value split(@Nullable Value delimiter) {
        if (delimiter == null) {
            delimiter = StringValue.EMPTY;
        }
        try {
            return ListValue.wrap(Arrays.stream(this.getString().split(delimiter.getString())).map(StringValue::new));
        }
        catch (PatternSyntaxException pse) {
            throw new InternalExpressionException("Incorrect pattern for 'split': " + pse.getMessage());
        }
    }

    public double readDoubleNumber() {
        String s = this.getString();
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException e) {
            return Double.NaN;
        }
    }

    public long readInteger() {
        return (long)this.readDoubleNumber();
    }

    public String getTypeString() {
        throw new InternalExpressionException("How did you get here? Cannot get type of an intenal type.");
    }

    public int hashCode() {
        String stringVal = this.getString();
        return stringVal.isEmpty() ? 0 : ("s" + stringVal).hashCode();
    }

    public Value deepcopy() {
        try {
            return (Value)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalExpressionException("Cannot make a copy of value: " + String.valueOf(this));
        }
    }

    public abstract Tag toTag(boolean var1, RegistryAccess var2);

    public JsonElement toJson() {
        return new JsonPrimitive(this.getString());
    }

    public boolean isNull() {
        return false;
    }

    public Value fromConstant() {
        return this;
    }
}

