/*
 * Decompiled with CFR 0.152.
 */
package carpet.utils;

import carpet.script.utils.Colors;
import carpet.utils.Messenger;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.monster.ZombifiedPiglin;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.Vec3;

public class BlockInfo {
    public static List<Component> blockInfo(BlockPos pos, ServerLevel world) {
        BlockState state = world.getBlockState(pos);
        Block block = state.getBlock();
        Object metastring = "";
        Registry blocks = world.registryAccess().registryOrThrow(Registries.BLOCK);
        for (Property iproperty : state.getProperties()) {
            metastring = (String)metastring + ", " + iproperty.getName() + "=" + String.valueOf(state.getValue(iproperty));
        }
        ArrayList<Component> lst = new ArrayList<Component>();
        lst.add(Messenger.s(""));
        lst.add(Messenger.s("====================================="));
        lst.add(Messenger.s(String.format("Block info for %s%s (id %d%s):", blocks.getKey((Object)block), metastring, blocks.getId((Object)block), metastring)));
        lst.add(Messenger.s(String.format(" - Map colour: %s", Colors.mapColourName.get(state.getMapColor((BlockGetter)world, pos)))));
        lst.add(Messenger.s(String.format(" - Sound type: %s", Colors.soundName.get(state.getSoundType()))));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Full block: %s", state.isCollisionShapeFullBlock((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Normal cube: %s", state.isRedstoneConductor((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Is liquid: %s", state.is(Blocks.WATER) || state.is(Blocks.LAVA))));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Light in: %d, above: %d", Math.max(world.getBrightness(LightLayer.BLOCK, pos), world.getBrightness(LightLayer.SKY, pos)), Math.max(world.getBrightness(LightLayer.BLOCK, pos.above()), world.getBrightness(LightLayer.SKY, pos.above())))));
        lst.add(Messenger.s(String.format(" - Brightness in: %.2f, above: %.2f", Float.valueOf(world.getLightLevelDependentMagicValue(pos)), Float.valueOf(world.getLightLevelDependentMagicValue(pos.above())))));
        lst.add(Messenger.s(String.format(" - Is opaque: %s", state.isSolid())));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Causes suffocation: %s", state.isSuffocating((BlockGetter)world, pos))));
        lst.add(Messenger.s(String.format(" - Blocks movement on land: %s", !state.isPathfindable(PathComputationType.LAND))));
        lst.add(Messenger.s(String.format(" - Blocks movement in air: %s", !state.isPathfindable(PathComputationType.AIR))));
        lst.add(Messenger.s(String.format(" - Blocks movement in liquids: %s", !state.isPathfindable(PathComputationType.WATER))));
        lst.add(Messenger.s(String.format(" - Can burn: %s", state.ignitedByLava())));
        lst.add(Messenger.s(String.format(" - Hardness: %.2f", Float.valueOf(state.getDestroySpeed((BlockGetter)world, pos)))));
        lst.add(Messenger.s(String.format(" - Blast resistance: %.2f", Float.valueOf(block.getExplosionResistance()))));
        lst.add(Messenger.s(String.format(" - Ticks randomly: %s", state.isRandomlyTicking())));
        lst.add(Messenger.s(""));
        lst.add(Messenger.s(String.format(" - Can provide power: %s", state.isSignalSource())));
        lst.add(Messenger.s(String.format(" - Strong power level: %d", world.getDirectSignalTo(pos))));
        lst.add(Messenger.s(String.format(" - Redstone power level: %d", world.getBestNeighborSignal(pos))));
        lst.add(Messenger.s(""));
        lst.add(BlockInfo.wander_chances(pos.above(), world));
        return lst;
    }

    private static Component wander_chances(BlockPos pos, ServerLevel worldIn) {
        ZombifiedPiglin creature = new ZombifiedPiglin(EntityType.ZOMBIFIED_PIGLIN, (Level)worldIn);
        creature.finalizeSpawn((ServerLevelAccessor)worldIn, worldIn.getCurrentDifficultyAt(pos), MobSpawnType.NATURAL, null);
        creature.moveTo(pos, 0.0f, 0.0f);
        RandomStrollGoal wander = new RandomStrollGoal((PathfinderMob)creature, 0.8);
        int success = 0;
        for (int i = 0; i < 1000; ++i) {
            Vec3 vec = DefaultRandomPos.getPos((PathfinderMob)creature, (int)10, (int)7);
            if (vec == null) continue;
            ++success;
        }
        long total_ticks = 0L;
        for (int trie = 0; trie < 1000; ++trie) {
            int i;
            for (i = 1; i < 36000 && !wander.canUse(); ++i) {
            }
            total_ticks += (long)(3 * i);
        }
        creature.discard();
        long total_time = total_ticks / 1000L / 20L;
        return Messenger.s(String.format(" - Wander chance above: %.1f%%\n - Average standby above: %s", Float.valueOf(100.0f * (float)success / 1000.0f), total_time > 5000L ? "INFINITY" : total_time + " s"));
    }
}

