/*
 * Decompiled with CFR 0.152.
 */
package net.mcreator.thebrookhavenscript.network;

import java.util.function.Supplier;
import net.mcreator.thebrookhavenscript.TheBrookhavenScriptMod;
import net.mcreator.thebrookhavenscript.init.TheBrookhavenScriptModMenus;
import net.mcreator.thebrookhavenscript.init.TheBrookhavenScriptModScreens;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.network.NetworkEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class MenuStateUpdateMessage {
    private final int elementType;
    private final String name;
    private final Object elementState;

    public MenuStateUpdateMessage(int elementType, String name, Object elementState) {
        this.elementType = elementType;
        this.name = name;
        this.elementState = elementState;
    }

    public MenuStateUpdateMessage(FriendlyByteBuf buffer) {
        this.elementType = buffer.readInt();
        this.name = buffer.m_130277_();
        Object elementState = null;
        if (this.elementType == 0) {
            elementState = buffer.m_130277_();
        } else if (this.elementType == 1) {
            elementState = buffer.readBoolean();
        } else if (this.elementType == 2) {
            elementState = buffer.readDouble();
        }
        this.elementState = elementState;
    }

    public static void buffer(MenuStateUpdateMessage message, FriendlyByteBuf buffer) {
        Object object;
        buffer.writeInt(message.elementType);
        buffer.m_130070_(message.name);
        if (message.elementType == 0) {
            buffer.m_130070_((String)message.elementState);
        } else if (message.elementType == 1) {
            buffer.writeBoolean(((Boolean)message.elementState).booleanValue());
        } else if (message.elementType == 2 && (object = message.elementState) instanceof Number) {
            Number n = (Number)object;
            buffer.writeDouble(n.doubleValue());
        }
    }

    public static void handler(MenuStateUpdateMessage message, Supplier<NetworkEvent.Context> contextSupplier) {
        String string;
        Object object;
        if (message.name.length() > 256 || (object = message.elementState) instanceof String && (string = (String)object).length() > 8192) {
            return;
        }
        NetworkEvent.Context context = contextSupplier.get();
        context.enqueueWork(() -> {
            AbstractContainerMenu patt2276$temp = context.getSender().f_36096_;
            if (patt2276$temp instanceof TheBrookhavenScriptModMenus.MenuAccessor) {
                Screen patt2527$temp;
                TheBrookhavenScriptModMenus.MenuAccessor menu = (TheBrookhavenScriptModMenus.MenuAccessor)patt2276$temp;
                menu.getMenuState().put(message.elementType + ":" + message.name, message.elementState);
                if (!context.getDirection().getReceptionSide().isServer() && (patt2527$temp = Minecraft.m_91087_().f_91080_) instanceof TheBrookhavenScriptModScreens.ScreenAccessor) {
                    TheBrookhavenScriptModScreens.ScreenAccessor accessor = (TheBrookhavenScriptModScreens.ScreenAccessor)patt2527$temp;
                    accessor.updateMenuState(message.elementType, message.name, message.elementState);
                }
            }
        });
        context.setPacketHandled(true);
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        TheBrookhavenScriptMod.addNetworkMessage(MenuStateUpdateMessage.class, MenuStateUpdateMessage::buffer, MenuStateUpdateMessage::new, MenuStateUpdateMessage::handler);
    }
}

