/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.api;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.cufufy.pronouns.api.set.PronounSet;
import net.cufufy.pronouns.api.set.SpecialPronounSet;
import net.cufufy.pronouns.api.supplier.PronounSupplier;
import org.jetbrains.annotations.NotNull;

public class PronounParser {
    private final Map<String, PronounSet> predefinedLookup = new HashMap<String, PronounSet>();

    private void addToMap(String key, PronounSet set) {
        if (key != null && !key.isBlank()) {
            this.predefinedLookup.put(key.toLowerCase(Locale.ROOT), set);
        }
    }

    private void addToMapIfAbsent(String key, PronounSet set) {
        if (key != null && !key.isBlank()) {
            this.predefinedLookup.putIfAbsent(key.toLowerCase(Locale.ROOT), set);
        }
    }

    public PronounParser(PronounSupplier predefinedSupplier) {
        Set allPredefinedSets = (Set)predefinedSupplier.get();
        this.predefinedLookup.put("he/him/his/his/himself", PronounSet.Builtins.HE);
        this.addToMap(PronounSet.Builtins.HE.toString(), PronounSet.Builtins.HE);
        this.addToMap(PronounSet.Builtins.SHE.toFullString(), PronounSet.Builtins.SHE);
        this.addToMap(PronounSet.Builtins.SHE.toString(), PronounSet.Builtins.SHE);
        this.addToMap(PronounSet.Builtins.THEY.toFullString(), PronounSet.Builtins.THEY);
        this.addToMap(PronounSet.Builtins.THEY.toString(), PronounSet.Builtins.THEY);
        this.addToMap(PronounSet.Builtins.ASK.toFullString(), PronounSet.Builtins.ASK);
        this.addToMap(PronounSet.Builtins.ASK.toString(), PronounSet.Builtins.ASK);
        this.addToMap(PronounSet.Builtins.UNSET.toFullString(), PronounSet.Builtins.UNSET);
        this.addToMap(PronounSet.Builtins.UNSET.toString(), PronounSet.Builtins.UNSET);
        this.addToMap(PronounSet.Builtins.ANY.toFullString(), PronounSet.Builtins.ANY);
        this.addToMap(PronounSet.Builtins.ANY.toString(), PronounSet.Builtins.ANY);
        for (PronounSet predef : allPredefinedSets) {
            this.addToMapIfAbsent(predef.toFullString(), predef);
            this.addToMapIfAbsent(predef.toString(), predef);
            if (predef instanceof SpecialPronounSet) continue;
            this.addToMapIfAbsent(predef.subjective(), predef);
            this.addToMapIfAbsent(predef.objective(), predef);
            this.addToMapIfAbsent(predef.possessiveAdj(), predef);
            this.addToMapIfAbsent(predef.possessive(), predef);
            this.addToMapIfAbsent(predef.reflexive(), predef);
        }
    }

    @NotNull
    public List<PronounSet> parse(@NotNull String input) {
        String[] parts;
        if (input == null || input.isBlank()) {
            return Collections.emptyList();
        }
        LinkedHashSet<PronounSet> resultSet = new LinkedHashSet<PronounSet>();
        for (String part : parts = input.split(";")) {
            String[] components;
            String trimmedPart = part.trim();
            if (trimmedPart.isEmpty()) continue;
            PronounSet foundSet = this.predefinedLookup.get(trimmedPart.toLowerCase(Locale.ROOT));
            if (foundSet != null) {
                PronounSet canonicalSet = foundSet;
                if (foundSet.toString().equalsIgnoreCase(PronounSet.Builtins.ASK.toString())) {
                    canonicalSet = PronounSet.Builtins.ASK;
                } else if (foundSet.toString().equalsIgnoreCase(PronounSet.Builtins.ANY.toString())) {
                    canonicalSet = PronounSet.Builtins.ANY;
                } else if (foundSet.toString().equalsIgnoreCase(PronounSet.Builtins.UNSET.toString())) {
                    canonicalSet = PronounSet.Builtins.UNSET;
                } else if (foundSet.subjective().equalsIgnoreCase(PronounSet.Builtins.HE.subjective()) && foundSet.objective().equalsIgnoreCase(PronounSet.Builtins.HE.objective()) && foundSet.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.HE.possessiveAdj()) && foundSet.possessive().equalsIgnoreCase(PronounSet.Builtins.HE.possessive()) && foundSet.reflexive().equalsIgnoreCase(PronounSet.Builtins.HE.reflexive()) && foundSet.plural() == PronounSet.Builtins.HE.plural()) {
                    canonicalSet = PronounSet.Builtins.HE;
                } else if (foundSet.subjective().equalsIgnoreCase(PronounSet.Builtins.SHE.subjective()) && foundSet.objective().equalsIgnoreCase(PronounSet.Builtins.SHE.objective()) && foundSet.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.SHE.possessiveAdj()) && foundSet.possessive().equalsIgnoreCase(PronounSet.Builtins.SHE.possessive()) && foundSet.reflexive().equalsIgnoreCase(PronounSet.Builtins.SHE.reflexive()) && foundSet.plural() == PronounSet.Builtins.SHE.plural()) {
                    canonicalSet = PronounSet.Builtins.SHE;
                } else if (foundSet.subjective().equalsIgnoreCase(PronounSet.Builtins.THEY.subjective()) && foundSet.objective().equalsIgnoreCase(PronounSet.Builtins.THEY.objective()) && foundSet.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.THEY.possessiveAdj()) && foundSet.possessive().equalsIgnoreCase(PronounSet.Builtins.THEY.possessive()) && foundSet.reflexive().equalsIgnoreCase(PronounSet.Builtins.THEY.reflexive()) && foundSet.plural() == PronounSet.Builtins.THEY.plural()) {
                    canonicalSet = PronounSet.Builtins.THEY;
                } else if (foundSet.subjective().equalsIgnoreCase(PronounSet.Builtins.IT.subjective()) && foundSet.objective().equalsIgnoreCase(PronounSet.Builtins.IT.objective()) && foundSet.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.IT.possessiveAdj()) && foundSet.possessive().equalsIgnoreCase(PronounSet.Builtins.IT.possessive()) && foundSet.reflexive().equalsIgnoreCase(PronounSet.Builtins.IT.reflexive()) && foundSet.plural() == PronounSet.Builtins.IT.plural()) {
                    canonicalSet = PronounSet.Builtins.IT;
                }
                resultSet.add(canonicalSet);
                continue;
            }
            String[] shorthandComponents = trimmedPart.split("/");
            if (shorthandComponents.length == 2) {
                String key1 = shorthandComponents[0].trim().toLowerCase(Locale.ROOT);
                String key2 = shorthandComponents[1].trim().toLowerCase(Locale.ROOT);
                PronounSet set1 = this.findPredefinedBySubjectiveOrShortform(key1);
                PronounSet set2 = this.findPredefinedBySubjectiveOrShortform(key2);
                if (set1 != null && set2 != null && !set1.equals(set2)) {
                    resultSet.add(this.canonicalize(set1));
                    resultSet.add(this.canonicalize(set2));
                    continue;
                }
            }
            if ((components = trimmedPart.split("/")).length != 5) continue;
            try {
                String[] finalComponents;
                String subjective = components[0].trim();
                String objective = components[1].trim();
                String possessiveAdj = components[2].trim();
                String possessive = components[3].trim();
                String reflexivePart = components[4].trim();
                boolean isPlural = false;
                if (reflexivePart.toLowerCase(Locale.ROOT).endsWith(":p")) {
                    isPlural = true;
                    reflexivePart = reflexivePart.length() > 2 ? reflexivePart.substring(0, reflexivePart.length() - 2).trim() : "";
                }
                boolean isActuallyInvalid = false;
                for (String comp : finalComponents = new String[]{subjective, objective, possessiveAdj, possessive, reflexivePart}) {
                    if (!comp.isBlank() && !comp.equalsIgnoreCase("INVALID")) continue;
                    isActuallyInvalid = true;
                    break;
                }
                if (isActuallyInvalid) continue;
                resultSet.add(PronounSet.from(subjective, objective, possessiveAdj, possessive, reflexivePart, isPlural));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return List.copyOf(resultSet);
    }

    public String toString(@NotNull List<PronounSet> pronounSets) {
        if (pronounSets == null || pronounSets.isEmpty()) {
            return "";
        }
        return pronounSets.stream().map(set -> {
            if (set instanceof SpecialPronounSet) {
                return set.toString();
            }
            return set.toFullString();
        }).collect(Collectors.joining(";"));
    }

    public List<String> getAvailablePronounNames() {
        LinkedHashSet<String> names = new LinkedHashSet<String>(this.predefinedLookup.keySet());
        names.add(PronounSet.Builtins.HE.toString());
        names.add(PronounSet.Builtins.SHE.toString());
        names.add(PronounSet.Builtins.THEY.toString());
        names.add(PronounSet.Builtins.IT.toString());
        names.add(PronounSet.Builtins.HE.toFullString());
        names.add(PronounSet.Builtins.SHE.toFullString());
        names.add(PronounSet.Builtins.THEY.toFullString());
        names.add(PronounSet.Builtins.IT.toFullString());
        names.add(PronounSet.Builtins.ASK.toString());
        names.add(PronounSet.Builtins.ANY.toString());
        names.add(PronounSet.Builtins.UNSET.toString());
        return names.stream().sorted().collect(Collectors.toList());
    }

    private PronounSet canonicalize(PronounSet set) {
        if (set == null) {
            return null;
        }
        if (set.toString().equalsIgnoreCase(PronounSet.Builtins.ASK.toString())) {
            return PronounSet.Builtins.ASK;
        }
        if (set.toString().equalsIgnoreCase(PronounSet.Builtins.ANY.toString())) {
            return PronounSet.Builtins.ANY;
        }
        if (set.toString().equalsIgnoreCase(PronounSet.Builtins.UNSET.toString())) {
            return PronounSet.Builtins.UNSET;
        }
        if (set.subjective().equalsIgnoreCase(PronounSet.Builtins.HE.subjective()) && set.objective().equalsIgnoreCase(PronounSet.Builtins.HE.objective()) && set.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.HE.possessiveAdj()) && set.possessive().equalsIgnoreCase(PronounSet.Builtins.HE.possessive()) && set.reflexive().equalsIgnoreCase(PronounSet.Builtins.HE.reflexive()) && set.plural() == PronounSet.Builtins.HE.plural()) {
            return PronounSet.Builtins.HE;
        }
        if (set.subjective().equalsIgnoreCase(PronounSet.Builtins.SHE.subjective()) && set.objective().equalsIgnoreCase(PronounSet.Builtins.SHE.objective()) && set.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.SHE.possessiveAdj()) && set.possessive().equalsIgnoreCase(PronounSet.Builtins.SHE.possessive()) && set.reflexive().equalsIgnoreCase(PronounSet.Builtins.SHE.reflexive()) && set.plural() == PronounSet.Builtins.SHE.plural()) {
            return PronounSet.Builtins.SHE;
        }
        if (set.subjective().equalsIgnoreCase(PronounSet.Builtins.THEY.subjective()) && set.objective().equalsIgnoreCase(PronounSet.Builtins.THEY.objective()) && set.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.THEY.possessiveAdj()) && set.possessive().equalsIgnoreCase(PronounSet.Builtins.THEY.possessive()) && set.reflexive().equalsIgnoreCase(PronounSet.Builtins.THEY.reflexive()) && set.plural() == PronounSet.Builtins.THEY.plural()) {
            return PronounSet.Builtins.THEY;
        }
        if (set.subjective().equalsIgnoreCase(PronounSet.Builtins.IT.subjective()) && set.objective().equalsIgnoreCase(PronounSet.Builtins.IT.objective()) && set.possessiveAdj().equalsIgnoreCase(PronounSet.Builtins.IT.possessiveAdj()) && set.possessive().equalsIgnoreCase(PronounSet.Builtins.IT.possessive()) && set.reflexive().equalsIgnoreCase(PronounSet.Builtins.IT.reflexive()) && set.plural() == PronounSet.Builtins.IT.plural()) {
            return PronounSet.Builtins.IT;
        }
        return set;
    }

    private PronounSet findPredefinedBySubjectiveOrShortform(String key) {
        String lowerKey = key.toLowerCase(Locale.ROOT);
        PronounSet directMatch = this.predefinedLookup.get(lowerKey);
        if (directMatch != null) {
            return directMatch;
        }
        for (PronounSet ps : this.predefinedLookup.values()) {
            if (ps.subjective().equalsIgnoreCase(lowerKey)) {
                return ps;
            }
            if (ps.toString().equalsIgnoreCase(lowerKey)) {
                return ps;
            }
            if (!ps.toFullString().equalsIgnoreCase(lowerKey)) continue;
            return ps;
        }
        return null;
    }
}

