/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.api.set;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.cufufy.pronouns.api.set.BuiltinPronounSet;
import net.cufufy.pronouns.api.set.SimplePronounSet;
import net.cufufy.pronouns.api.set.SpecialPronounSet;
import net.cufufy.pronouns.api.supplier.PronounSupplier;
import org.jetbrains.annotations.Contract;

public interface PronounSet {
    public static final PronounSupplier builtins = () -> Set.of(Builtins.THEY, Builtins.HE, Builtins.SHE, Builtins.IT, Builtins.ANY, Builtins.ASK);

    public String subjective();

    public String objective();

    public String possessiveAdj();

    public String possessive();

    public String reflexive();

    public boolean plural();

    public String toString();

    default public String toFullString() {
        StringBuilder out = new StringBuilder();
        out.append(this.subjective()).append("/").append(this.objective()).append("/").append(this.possessiveAdj()).append("/").append(this.possessive()).append("/").append(this.reflexive());
        if (this.plural()) {
            out.append(":p");
        }
        return out.toString();
    }

    default public boolean includesPronoun(String pronoun) {
        return this.subjective().equalsIgnoreCase(pronoun) || this.objective().equalsIgnoreCase(pronoun) || this.possessiveAdj().equalsIgnoreCase(pronoun) || this.possessive().equalsIgnoreCase(pronoun) || this.reflexive().equalsIgnoreCase(pronoun);
    }

    @Contract(value="_, _, _, _, _ -> new", pure=true)
    public static PronounSet from(String subjective, String objective, String possessiveAdj, String possessive, String reflexive) {
        return PronounSet.from(subjective, objective, possessiveAdj, possessive, reflexive, false);
    }

    @Contract(value="_, _, _, _, _, _ -> new", pure=true)
    public static PronounSet from(String subjective, String objective, String possessiveAdj, String possessive, String reflexive, boolean plural) {
        return new SimplePronounSet(subjective, objective, possessiveAdj, possessive, reflexive, plural);
    }

    public static String format(List<PronounSet> sets) {
        if (sets == null || sets.isEmpty()) {
            throw new IllegalArgumentException("A list of 0 pronouns, or a null list, cannot be formatted");
        }
        return switch (sets.size()) {
            case 1 -> sets.get(0).toString();
            default -> sets.stream().map(PronounSet::toString).collect(Collectors.joining(", "));
        };
    }

    public static class Builtins {
        public static final PronounSet THEY = new BuiltinPronounSet("they", "them", "their", "theirs", "themselves", true);
        public static final PronounSet HE = new BuiltinPronounSet("he", "him", "his", "his", "himself", false);
        public static final PronounSet SHE = new BuiltinPronounSet("she", "her", "her", "hers", "herself", false);
        public static final PronounSet ANY = new SpecialPronounSet(THEY, "Any");
        public static final PronounSet ASK = new SpecialPronounSet(THEY, "Ask");
        public static final PronounSet UNSET = new SpecialPronounSet(THEY, "Unset");
        public static final PronounSet IT = new BuiltinPronounSet("it", "it", "its", "its", "itself", false);

        private Builtins() {
        }
    }
}

