/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.cufufy.pronouns.api.PronounParser;
import net.cufufy.pronouns.api.set.PronounSet;
import org.yaml.snakeyaml.Yaml;

public class LegacyMigrator {
    private static final PronounParser parser = new PronounParser(PronounSet.builtins);
    private static final Yaml yaml = new Yaml();

    private LegacyMigrator() {
    }

    public static PronounSet fromLegacyString(String string) {
        String[] split = string.split("/");
        if (string.equals("they/them/they're/their/theirs/themself")) {
            return PronounSet.Builtins.THEY;
        }
        if (split.length == 1) {
            List<PronounSet> parsed = parser.parse(string);
            if (!parsed.isEmpty()) {
                return parsed.get(0);
            }
            throw new IllegalArgumentException("Failed to parse legacy set (single part, not a known alias): " + string);
        }
        List<PronounSet> parsedFirstPart = parser.parse(split[0]);
        if (!parsedFirstPart.isEmpty()) {
            PronounSet potentialMatch = parsedFirstPart.get(0);
            if (((Set)PronounSet.builtins.get()).contains(potentialMatch) && potentialMatch != PronounSet.Builtins.THEY) {
                return potentialMatch;
            }
        }
        if (split.length != 6) {
            throw new IllegalArgumentException("Failed to parse legacy set " + string + " (expected 6 parts for custom, or a known alias/predefined prefix like 'he/' or 'she/')");
        }
        return PronounSet.from(split[0], split[1], split[3], split[4], split[5], split[2].endsWith("re") || split[2].endsWith("\u2019re"));
    }

    public static Map<UUID, List<PronounSet>> fromYaml(Path path) {
        HashMap<UUID, List<PronounSet>> hashMap;
        block9: {
            InputStream file = Files.newInputStream(path, new OpenOption[0]);
            try {
                Map loaded = (Map)yaml.load(file);
                HashMap<UUID, List<PronounSet>> out = new HashMap<UUID, List<PronounSet>>();
                loaded.forEach((uuid, sets) -> out.put(UUID.fromString(uuid), Arrays.stream(sets).map(LegacyMigrator::fromLegacyString).toList()));
                file.close();
                Files.move(path, path.resolveSibling("legacy-datastore.yml"), new CopyOption[0]);
                hashMap = out;
                if (file == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (file != null) {
                        try {
                            file.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ClassCastException e) {
                    throw new MigrationException("Legacy datastore file is incorrectly formatted");
                }
                catch (IOException e) {
                    throw new MigrationException(e);
                }
            }
            file.close();
        }
        return hashMap;
    }

    public static final class MigrationException
    extends RuntimeException {
        public MigrationException(Throwable cause) {
            super(cause);
        }

        public MigrationException(String message) {
            super(message);
        }
    }
}

