/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Properties;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.util.PropertiesUtil;

public class PluginMeta {
    private final boolean isFirstRun;
    private final String lastPluginVersion;
    private final Platform platform;
    private final Path filePath;

    private void save() {
        try (OutputStream stream = Files.newOutputStream(this.filePath, new OpenOption[0]);){
            Properties props = new Properties();
            props.put("lastPluginVersion", this.platform.currentVersion());
            props.store(stream, "ProNouns meta file.\nDo not edit!\n");
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public PluginMeta(Platform platform) {
        this.platform = platform;
        this.filePath = platform.dataDir().resolve("pronouns-meta.cfg");
        try {
            if (Files.exists(this.filePath, new LinkOption[0])) {
                Properties fileData = PropertiesUtil.fromFile(this.filePath);
                String lastPluginVersion = (String)fileData.get("lastPluginVersion");
                if (lastPluginVersion == null) {
                    platform.logger().warn("Meta file has been tampered with!\npronouns-meta.cfg is not intended for editing.\nRecreating it now.");
                    this.lastPluginVersion = platform.currentVersion();
                    this.isFirstRun = true;
                    this.save();
                    return;
                }
                this.lastPluginVersion = lastPluginVersion;
                this.isFirstRun = false;
                if (!this.lastPluginVersion.equals(platform.currentVersion())) {
                    this.save();
                }
                return;
            }
            this.lastPluginVersion = platform.currentVersion();
            this.isFirstRun = true;
            this.save();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public String lastPluginVersion() {
        return this.lastPluginVersion;
    }

    public boolean isFirstRun() {
        return this.isFirstRun;
    }
}

