/*
 * Decompiled with CFR 0.152.
 */
package net.cufufy.pronouns.common;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.cufufy.pronouns.api.ProNounsPlugin;
import net.cufufy.pronouns.api.PronounParser;
import net.cufufy.pronouns.api.PronounStore;
import net.cufufy.pronouns.common.PluginMeta;
import net.cufufy.pronouns.common.UpdateChecker;
import net.cufufy.pronouns.common.cmd.ClearCommand;
import net.cufufy.pronouns.common.cmd.DebugCommand;
import net.cufufy.pronouns.common.cmd.DumpCommand;
import net.cufufy.pronouns.common.cmd.GetCommand;
import net.cufufy.pronouns.common.cmd.HelpCommand;
import net.cufufy.pronouns.common.cmd.ListCommand;
import net.cufufy.pronouns.common.cmd.MigrateCommand;
import net.cufufy.pronouns.common.cmd.ProNounsCommand;
import net.cufufy.pronouns.common.cmd.ReloadCommand;
import net.cufufy.pronouns.common.cmd.SetCommand;
import net.cufufy.pronouns.common.cmd.UpdateCommand;
import net.cufufy.pronouns.common.cmd.VersionCommand;
import net.cufufy.pronouns.common.message.Formatter;
import net.cufufy.pronouns.common.message.ProNounsTranslations;
import net.cufufy.pronouns.common.placeholder.Placeholders;
import net.cufufy.pronouns.common.platform.CommandSender;
import net.cufufy.pronouns.common.platform.Platform;
import net.cufufy.pronouns.common.store.StoreFactory;
import net.cufufy.pronouns.shadow.cloud.CommandManager;
import net.kyori.adventure.translation.GlobalTranslator;
import net.kyori.adventure.translation.Translator;
import org.jetbrains.annotations.Nullable;

public class ProNouns
implements ProNounsPlugin {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread thread = new Thread(r);
        thread.setName("ProNouns worker");
        return thread;
    });
    private PronounParser parser;
    private final Platform platform;
    private final PluginMeta meta;
    private final Placeholders placeholders = new Placeholders(this);
    private PronounStore store;
    @Nullable
    private final UpdateChecker checker;
    private Formatter formatter;

    public ProNouns(Platform platform) {
        this.platform = platform;
        this.formatter = new Formatter(platform);
        this.meta = new PluginMeta(platform);
        GlobalTranslator.translator().addSource((Translator)ProNounsTranslations.registry());
        CommandManager<CommandSender> commandManager = platform.commandManager();
        if (this.meta.isFirstRun()) {
            platform.logger().info(ProNounsTranslations.translate("pronouns.first-launch", new Object[0]));
        }
        HelpCommand helpCommand = new HelpCommand(this, commandManager);
        List<ProNounsCommand> commands = List.of(helpCommand, new GetCommand(this, platform), new SetCommand(this, platform), new ClearCommand(this, platform), new ListCommand(this, platform), new VersionCommand(this, platform), new DebugCommand(this, platform), new UpdateCommand(this), new ReloadCommand(this), new DumpCommand(this, platform), new MigrateCommand(this));
        String[] aliases = Arrays.copyOf(platform.commandAliases(), platform.commandAliases().length + 1);
        aliases[aliases.length - 1] = "pn";
        commandManager.commandBuilder("pronouns", aliases).apply(helpCommand::buildForRoot);
        for (ProNounsCommand command : commands) {
            if (!command.shouldRegister()) continue;
            commandManager.command(commandManager.commandBuilder("pronouns", aliases).apply(command::build));
        }
        boolean isDevelopmentVersion = platform.currentVersion().endsWith("-SNAPSHOT");
        if (!isDevelopmentVersion && platform.config().checkForUpdates()) {
            this.checker = new UpdateChecker(this, platform);
            this.checker.checkForUpdates(false);
            this.executorService.scheduleAtFixedRate(() -> this.checker.checkForUpdates(false), 0L, 6L, TimeUnit.HOURS);
        } else {
            this.checker = null;
            platform.logger().warn((String)(isDevelopmentVersion ? "Development version " + platform.currentVersion() + ", disabling update checker." : ProNounsTranslations.translate("pronouns.update.disabled", new Object[0])));
        }
    }

    public void createStore(StoreFactory factory) {
        this.store = factory.create(this.platform.config().store().toLowerCase(Locale.ROOT).trim(), this);
        this.parser = new PronounParser(() -> (Set)this.store.predefined().get());
    }

    public void reload() {
        this.platform.config().reload();
        this.formatter = new Formatter(this.platform);
    }

    public Platform platform() {
        return this.platform;
    }

    @Override
    public PronounStore store() {
        return this.store;
    }

    @Override
    public PronounParser parser() {
        return this.parser;
    }

    public Formatter formatter() {
        return this.formatter;
    }

    public Optional<UpdateChecker> updateChecker() {
        return Optional.ofNullable(this.checker);
    }

    public Placeholders placeholders() {
        return this.placeholders;
    }

    public PluginMeta meta() {
        return this.meta;
    }

    @Override
    public ScheduledExecutorService executorService() {
        return this.executorService;
    }
}

